C DATE.FOR

C Creates an RFC822/RFC1036/RFC977/RFC1123 compliant date/time.

C Format of a legal date:
C
C	dd mmm yyyy hh:mm shhmm
C
C preferred zones are in the format +/-HHMM.  Thus, Tucson, Arizona is
C always -0700 (measured from GMT).  Those of you with the weird desire
C to change your clocks twice a year will have to twiddle NNTP_TIMEZONE
C to tell VNEWS what timezome to put in the message.  It is preferable
C to pass the time in a meaningful "local time" rather than GMT,
C although there is a cabalistic move (see NNTP P-DRAFT) to require 
C GMT.  

C jms/921109
C I am informed by Per Iverson (Iversen@vsfys1.fi.uib.no) that the time
C zone can be as long as 9 characters, not the 5 characters I had
C originally allocated.  His suggestion is that the time zone might well
C be defined as "GMT+02:00" (i.e., he's putting in an explicit GMT as
C well as the colon).  Whether this is RFC compliant or not, I can't
C really tell.  However, I shall up the size of the buf here (and
C everywhere) to be 27 characters and hope for the best.
C Vnews 1.50A

	Subroutine RFC_Date(Date,Timezone)

	Implicit None

C Parameters.  NOTE: Date MUST be at least 27 characters!

	Character*(*) Date
	Character*(*) Timezone

C                          111111111122222222
C                 123456789012345678901234567
C	Date   = 'dd mmm yyyy hh:mm GMT+zo:ne'
C	VMSbuf = 'dd-MMM-yyyy hh:mm:ss.cc'

C Local variables

	Character*27 vmsbuf
	Character*36 upmon /'JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC'/
	Character*36 lowmon/'JanFebMarAprMayJunJulAugSepOctNovDec'/
	
	Integer*4 offset

C Begin RFC_DATE

	If (Len(Date) .LT. 27) GOTO 888

	Call  SYS$ASCTIM ( 	,		! length
	1			vmsbuf,		! VMS time buffer
	2			,		! input time
	3				)	! conversion flag

	Date(1:17) = vmsbuf(1:17)	! dd-mmm-yyyy hh:mm
	Date(3:3) = ' '			! clear out the dashes
	Date(7:7) = ' '			! ... from VMS
	Date(18:18) = ' '		! and put a space for the zone.

	offset = index(upmon,vmsbuf(4:6))

	If (offset .lt. 1) GOTO 888

	Date(4:6) = lowmon(offset:offset+2)

	Date(19:) = Timezone

	Return

888	Write (6,*) 'Invalid parameter/internal error in RFC_Date.'
	Date = '16 Jan 1964 19:31 -0700'
	Return

	End
