C
C This subroutine sends a mail message using callable mail (V5.0 only)
C Adapted from an example posted to INFO-VAX.
C
C JMH
C
C With modifications by Pat Rankin (rankin@eql.caltech.edu) for VNEWS 1.4
C Installed by jms/910325
C Updated jms/910705 to support CopySelf flags
C
	Integer *4 Function Send_Mail(Rcpt, FileNm, Subject, CopySelf)

	Implicit None

C Function Parameters:

        Character *(*)          Rcpt
        Character *(*)          FileNm
        Character *(*)          Subject
	Logical			CopySelf

	Include '($MailDef)'
	Include '($SSDef)'

	Include 'Itemlist.DEF'

        Record /Itmlst/ Mess_Info(2) , Null , Body(2) ,  Address(3)
	Record /Itmlst/ Copy_List(4)

	Integer *4 	Context,  Status,  UserLg,
	1		MAIL$SEND_BEGIN,  MAIL$SEND_ADD_ATTRIBUTE,
	1		MAIL$SEND_ADD_BODYPART,  MAIL$SEND_ADD_ADDRESS,
	1		MAIL$SEND_MESSAGE,  MAIL$SEND_END
c	Integer *4	MAIL$_SEND_COPY_REPLY, MAIL$_SEND_COPY_SEND,
c	1		MAIL$_SEND_USER
	Logical *4	MailCS, MailCR
	Character *254  User
	Integer *2	CC_Item_Code /MAIL$_CC/

        Call Setup (Address(1), MAIL$_SEND_USERNAME, Rcpt, )
	Address(2).end_list = 0
	Address(3).end_list = 0

        Call Setup (Mess_Info(1), MAIL$_SEND_SUBJECT, Subject, )
	Mess_Info(2).end_list = 0

        Call Setup (Body(1), MAIL$_SEND_FILENAME, FileNm, )
	Body(2).end_list = 0

	Copy_List(1).BufLen = 4 
	Copy_List(1).BufAddr = %Loc(MailCS)
	Copy_List(1).Code = MAIL$_SEND_COPY_SEND
	Copy_List(1).RetLenAdr = 0
	Copy_List(2).BufLen = 4 
	Copy_List(2).BufAddr = %Loc(MailCR)
	Copy_List(2).Code = MAIL$_SEND_COPY_REPLY
	Copy_List(2).RetLenAdr = 0
	Call Setup (Copy_List(3), MAIL$_SEND_USER, User, UserLg)
	Copy_List(4).end_list = 0

	Null.end_list = 0

	Call Enable_Installed_Privs()	! turn on privs for PMDF workaround

        Status = MAIL$SEND_BEGIN (Context, Null, Copy_List)

C
C For compatibility with VMS V4.7, we set up a magic cookie, the
C code -117, which indicates "this is 4.7 mail$send_begin."  In
C this case, we simply call MAIL$SEND_MESSAGE (which is a special
C compatibility mode version) with the file, receipient, and subject
C lines.  I know, I know, it's very, very ugly.  But that's the
C way it works.  You can thank Warren Massey (massey@travis.llnl.gov,
C a most speedy VAXstation 2000 I got to know and love) for the idea.
C jms/910619
C

	If (Status .EQ. -117) Then
	    Status = MAIL$SEND_MESSAGE (Rcpt, FileNm, Subject)
	    Call Disable_Installed_Privs()
	    Send_Mail = SS$_NORMAL
	    Return
	EndIf

	If (Status) Then
	    Status = MAIL$SEND_ADD_ATTRIBUTE (Context, Mess_Info, Null)
	    If (.NOT. Status) Call LIB$SIGNAL(%val(Status))

	    Status = MAIL$SEND_ADD_BODYPART (Context, Body, Null)
	    If (.NOT. Status) Call LIB$SIGNAL(%val(Status))

            Status = MAIL$SEND_ADD_ADDRESS (Context, Address, Null)
	    If (.NOT. Status) Call LIB$SIGNAL(%val(Status))

	    If (MailCR .OR. MailCS .OR. CopySelf) Then
		Address(1).BufLen = UserLg
		Address(1).BufAddr = %Loc(User)
		Address(1).Code = MAIL$_SEND_USERNAME
		Address(1).RetLenAdr = 0
		Address(2).BufLen = 2
		Address(2).BufAddr = %Loc(CC_Item_Code)
		Address(2).Code = MAIL$_SEND_USERNAME_TYPE
		Address(2).RetLenAdr = 0
		Status = MAIL$SEND_ADD_ADDRESS (Context, Address, Null)
		If (.NOT. Status) Call LIB$SIGNAL(%val(Status))
	    EndIf

	    Status = MAIL$SEND_MESSAGE (Context, Null, Null)
	    If (.NOT. Status) Call LIB$SIGNAL(%val(Status))

	    Status = MAIL$SEND_END (Context, Null, Null)
	    If (.NOT. Status) Call LIB$SIGNAL(%val(Status))
	Else
	    Call LIB$SIGNAL(%val(Status))
	EndIf


c
c	note:  we should use a condition handler to make sure that this
c	    gets done.  However callable mail doesn't seem to signal
c	    errors and VNEWS doesn't try to recover and continue anyway.
c
	call Disable_Installed_Privs()	!turn privs back off
	Send_Mail = Status

 	Return
	End !of Send_Mail


        Subroutine Setup (Item,Code,String,Ret_Len)

        Character * (*)         String
        Integer                 Ret_Len
        Integer                 Code

	Include 'Itemlist.DEF'			! itemlist data structure
        Record /Itmlst/ Item

        Item.BufLen = Len(String)
        Item.BufAddr = %Loc(String)
        Item.Code = Code
        Item.RetLenAdr = %Loc(Ret_Len)

        Return

        End ! of Setup

       subroutine  Disable_Installed_Privs ( )
c
c   Disable any privileges that this image has been installed
c   with that the user didn't already have.
C
C   This subroutine has two entry points, Disable and Enable. 
c

	Implicit None

C     2nd entry below:
*       subroutine      Enable_Installed_Privs

	include '($JPIdef)/nolist'              !job & process info
	include '($PRVdef)/nolist'              !privileges

	include 'Itemlist.Def'			! itemlist definitions
C+++
c assume that if we're installed with these privs, they should remain
c accessible (for spawn & broadcast trapping, nntp connection, &c)
C---

	parameter	Allowed_privs0 = PRV$M_TMPMBX .or. PRV$M_NETMBX,
	1		Allowed_privs1 = 0

C     local:
	record /itmlst/ priv_fetch(3)           !item list for $getjpi

	integer *4	imgprv(0:1) /0,0/,  prcprv(0:1),  privs(0:1)

	logical 	init_done /.false./

	save    init_done,  imgprv,  prcprv

	if ( .not. init_done ) then
	    priv_fetch(1).buflen 	= 8	!sizeof(prcprv)
	    priv_fetch(1).code   	= JPI$_PROCPRIV
	    priv_fetch(1).bufaddr 	= %LOC(prcprv)

	    priv_fetch(2).buflen 	= 8	!sizeof(imgprv)
	    priv_fetch(2).code   	= JPI$_IMAGPRIV
	    priv_fetch(2).bufaddr 	= %LOC(imgprv)

	    priv_fetch(3).end_list 	= 0	!end of list

	    call SYS$GETJPIW(,,, priv_fetch,,,)
	    init_done = .true.
	end if

	privs(0) = imgprv(0) .and. .not. (prcprv(0) .or. Allowed_privs0)
	privs(1) = imgprv(1) .and. .not. (prcprv(1) .or. Allowed_privs1)

	if ( privs(0) .ne. 0 .or. privs(1) .ne. 0 )
	1	call SYS$SETPRV( %VAL(0), privs, %VAL(0),)	!disable
	return
**
	entry  Enable_Installed_Privs ( )
C
C   Enable privileges which were disabled earlier.
C
	if ( init_done .and. (imgprv(0) .ne. 0 .or. imgprv(1) .ne. 0) )
	1	call SYS$SETPRV( %VAL(1), imgprv, %VAL(0),)	!enable
	return

	end ! of Disable_Installed_Privs & Enable_Installed_Privs
