C SMG.FOR - SMG$ routines

	Subroutine SMG_Broadcast_AST

	Implicit None

	Include 'SMG.Def'

C Description

C	AST Routine established by SMG_Initialize to trap and handle
C	broadcast messages.

C External Routines and Symbols

	External SMG$_No_MorMsg
	Integer  SMG$_No_MorMsg
	External SMG$Get_Broadcast_Message
	Integer  SMG$Get_Broadcast_Message
	External SMG$Cancel_Input
	Integer  SMG$Cancel_Input
	External TrimLg
	Integer  TrimLg

C Local definitions

	Integer			Status
	Character *132 		Msg
	Integer			I

C Begin SMG_Broadcast_AST

C Updated Vnews 1.4/paf/910326.  Changed to NOT print a message if
C the message is null.

c	Status = SMG$Cancel_Input (SMGKeyBdId)

	Status = 1

	Do While ((Status) .and. (Status .ne. %Loc(SMG$_No_MorMsg)))
	  Status = SMG$Get_Broadcast_Message (SMG_PBId, Msg)
	  If ((Status)  .and. (Status .ne. %Loc(SMG$_No_MorMsg))
	1		.and. (Msg .ne. ' ') ) Then
	    If (SMG_Broadcast_Count .GE. MaxBroads) Then
		SMG_Broadcast_Messages(MaxBroads) = 
	1	   '---Some Broadcasts Were Lost. Sorry---'
		SMG_Broadcast_Count = MaxBroads
	    Else
		SMG_Broadcast_Count = SMG_Broadcast_Count + 1
		SMG_Broadcast_Messages(SMG_Broadcast_Count) = Msg
	    EndIf
	  EndIf
	EndDo
          
	If (.NOT. SMG_Dont_Broadcast) Then
	    Do While (SMG_Broadcast_Count .GT. 0)
		I = TrimLg(SMG_Broadcast_Messages(SMG_Broadcast_Count))
		Call SMG_Print_X( 
	1		SMG_Broadcast_Messages(SMG_Broadcast_Count)(:I)
	2			)
		SMG_Broadcast_Count = SMG_Broadcast_Count - 1
	    End Do
	EndIf

	Return

	End ! of SMG_Broadcast_AST


	Subroutine SMG_Erase

	Implicit None

	Include 'SMG.Def'

C
C   Erase the display if appropriate
C

C External Definitions:

	External SMG$Erase_Pasteboard
	Integer  SMG$Erase_Pasteboard

C Local Definitions

	Integer Status

C Begin SMG_Erase

	If (SMG_Video) Then
	    Status = SMG$Erase_Pasteboard (SMG_PBId)
	    If (.not. Status) Then
		Call Lib$Stop (%Val(Status))
	    End If
	End If

	SMG_Line = 1

	End ! of SMG_Erase


	Subroutine SMG_Initialize

C
C Set up for SMG routines
C

	Implicit None

	Include 'SMG.Def'
	Include '($RMSDef)'
	Include '($SMGDef)/list'

C External definitions

	Integer  SMG$Create_Key_Table
	Integer  SMG$Create_PasteBoard
	Integer  SMG$Create_Virtual_Keyboard
	Integer  SMG$Define_Key
	Integer  SMG$Load_Key_Defs

	External SMG_Broadcast_Ast
	External DC$_Term

C Local Definitions

	Integer *4 Status

C	Record /SMGDef/ PB_Info

C Begin SMG_Initialize 

	Status = SMG$Create_PasteBoard
	1		(SMG_PBId , , SMG_PBRows , SMG_PBCols , 0)
	If (.not. Status) Then
	    Call Lib$Stop(%Val(Status))
	EndIf

	If (SMG_PBCols .eq. 0) Then
	    SMG_PBCols = 132
	EndIf

	SMG_Video = .true.
	SMG_Term = .true.

	SMG_Dont_Broadcast = .false.

	Status = SMG$Create_Key_Table (SMGKeyDefId)

	If (SMG_Term) Then

	    Call SMG_Handle_Broadcasts (.true.)

	    Status = SMG$Define_Key (SMGKeyDefId,
	1	'Define/Key PF1 ""/Echo/Set_State=Gold')

	    Status = SMG$Define_Key (SMGKeyDefId,
	1	'Define/Key PF2 "keypad"/Echo/Terminate')

	    Status = SMG$Define_Key (SMGKeyDefId,
	1	'Define/Key PF3 "d/g"/Echo/Terminate')

	    Status = SMG$Define_Key (SMGKeyDefId,
	1	'Define/Key PF4 "directory"/Echo/Terminate')

	    Status = SMG$Define_Key (SMGKeyDefId,
	1	'Define/Key KP0 "next"/Echo/Terminate')

	    Status = SMG$Define_Key (SMGKeyDefId,
	1	'Define/Key KP1 "b"/Echo/Terminate')

	    Status = SMG$Define_Key (SMGKeyDefId,
	1	'Define/Key KP4 "refresh"/Echo/Terminate')

	    Status = SMG$Define_Key (SMGKeyDefId,
	1	'Define/Key Enter "z"/Echo/Terminate')

	    Status = SMG$Define_Key (SMGKeyDefId,
	1	'Define/Key Minus "^"/Echo/Terminate')

	    Status = SMG$Define_Key (SMGKeyDefId,
	1	'Define/Key KP7 "c"/Echo/Terminate')

	    Status = SMG$Define_Key (SMGKeyDefId,
	1	'Define/Key KP8 "y"/Echo/Terminate')

	    Status = SMG$Load_Key_Defs
	1	(
	1	SMGKeyDefId,		! Table
	1	'MAIL$INIT',		! File
	1	'MAIL$INIT',		! Default file (so '.' is not used)
	1	1			! File spec is logical name
	1	)

	    If (.not. Status) Then
		If (Status .ne. RMS$_FNF) Call Lib$Signal (%Val(Status))
	    EndIf

C vnews 1.4.
C Revamped VNEWS to use a more reasonable DCL command line parsing
C routing, so we parse the command just BEFORE calling SMG_Initialize()
C pr/910325
C

	    EndIf ! (SMG_Term)

	Status = SMG$Create_Virtual_KeyBoard (SMGKeyBdId)

	End ! of SMG_Initialize


	Integer Function SMG_More_Print (Text)

	Implicit None

	Include 'SMG.Def'

C Description SMG_More_Print
C
C   Breaks Text down into CR/LF separated pieces of maximum size 
C   SMG_PBCols.  Calls more for each one.  Second and subsequent 
C   pieces are prefaced by Continuation.
C
C   Returns More status.
C

C Description SMG_Print
C
C   Same as above but More is not called.
C

	Integer	SMG_All_Print

C Parameter Definitions

	Character	*(*) 		Text

C External Routines

	External	More
	Integer		More
	External	TrimLg
	Integer		TrimLg

C Local Variables

	Integer		S	! Start of hunk in Text
	Integer		E	! End of hunk in Text
	Integer		L	! Length of Text
	Integer		X	! Length of extra stuff for current hunk
	Integer		FF	! Location of form feeds
	Character	*512	Buffer
	Character	*2	CRLF
	Integer		CR
	Integer		NE
	Logical		More_Flag

C Begin SMG_More_Print

	More_Flag = .true.
	Goto 1

C Begin SMG_Print

	Entry SMG_All_Print (Text)

	More_Flag = .false.

C Begin common SMG_More_Print - SMG_Print 

1	Continue

	SMG_Dont_Broadcast = .TRUE.

C First, check to see if there are any broadcasts we need to print.

	Do While (SMG_Broadcast_Count .GT. 0)
	    L = TrimLg(SMG_Broadcast_Messages(SMG_Broadcast_Count))
	    Call SMG_Print_X( 
	1	SMG_Broadcast_Messages(SMG_Broadcast_Count)(:L)
	2	)
	    SMG_Broadcast_Count = SMG_Broadcast_Count - 1
	End Do

	CRLF(1:1) = Char (13)	! <CR>
	CRLF(2:2) = Char (10)	! <LF>

	Call Expand_Tabs (Text, Buffer)
	L = TrimLg (Buffer)

C Replace any form feed characters with blanks

	FF = Index (Buffer,Char(12))
	Do While (FF .ne. 0)
	  Buffer(FF:FF) = ' '
	  SMG_Line = 999
	  FF = Index (Buffer,Char(12))
	End Do

	S  = 1
	L  = TrimLg(Buffer)
	X  = 0
	SMG_More_Print = .true.

	Do While (S .le. L)

C Attempt to print whatever is left

	  E = L
	  NE = E + 1

C But limit to SMG_PBCols

	  If ((E-S+1+X) .gt. SMG_PBCols) Then
	    E = S + SMG_PBCols - X - 1 
	    NE = E + 1
	  EndIf

C But also take into account CR LF separated hunks

	  CR = Index (Buffer(S:L), CRLF)
	  If (CR .ne. 0) Then
	    CR = S + CR - 1
	    If (CR .eq. S) Then
	      E = S
	      NE = S + 2
	      Buffer (CR:CR+1) = '  '
	    Else If (CR .le. (E+1)) Then
	      E = CR - 1
	      NE = CR + 2
	    Else
	      ! Don't care, this CR/LF outside of hunk
	    EndIf
	  EndIf

C Call more to see if this hunk fits on screen

	  If (More_Flag) Then
	    SMG_More_Print = More ()
	    If (.not. SMG_More_Print) Then
	      SMG_Dont_Broadcast = .FALSE.
	      Return
	    EndIf
	  Else
	    SMG_More_Print = 1
	  EndIf

C Now, print this hunk

C Check to see that S is less than E  (Vnews 1.4/jms/910430)
	  If (S .GT. E) Then
	    S = E
	  Endif

	  If (X .eq. 0) Then	  
	    Call SMG_Print_X (Buffer(S:E))
	  Else
	    Call SMG_Print_X ('|' // Buffer(S:E))
	  End If

C New start is end of last line ignoring any trailing CR/LF

	  S = NE

C Length of extra stuff now includes continuation characters

	  X = 1

	End Do

	SMG_Dont_Broadcast = .FALSE.

	Return

	End ! of SMG_Print and SMG_More_Print


	Subroutine SMG_Print_X (Buffer)

	Implicit None

	Include 'SMG.Def'
	Include '($IODef)'

C Parameter definitions

	Character *(*) Buffer

C External routines

	Integer		Sys$QIOW

C Local definitions

	Integer   *4	CC
	Integer   *4	L
	Integer   *4	IOSB(2)
	Integer   *4	Status

C Begin SMG_Print_X

	L = Len(Buffer)
	If (L .gt. SMG_PBCols) Then		! SMG_PBCols seems to be
	  L = SMG_PBCols			!  defined even if 
	EndIf					!   SMG_Video is .false.

	If (.not. SMG_Term) Then

	  Print '(x,A)', Buffer(1:L)

	Else

	  CC = '01000000'x

	  Status = Sys$QIOW
	1	(
	1	,			! efn
	1	%Val(TT_Chan),		! channel
	1	%Val(IO$_WriteVBlk),	! function
	1	IOSB,			! IO status block
	1	,			! astadr
	1	,			! astprm
	1	%Val(%Loc(Buffer)),	! p1 = buffer address
	1	%Val(L),		! p2 = character count
	1	,			! p3
	1	%Val(CC),		! p4 = carriage control
	1	,			! p5
	1				! p6
	1	)

	EndIf

	SMG_Line = SMG_Line + 1

	End ! of SMG_Print_X


	Integer Function SMG_Prompt 
	1	(Get_String, Prompt_String, Get_Length)

	Implicit None

	Include  'SMG.Def'
	Include  '($SSDef)'

C Parameter Definitions

	Character	*(*)		Get_String
	Character	*(*)		Prompt_String
	Integer		*4		Get_Length

C External Definitions

	External SMG$Read_Composed_Line
	Integer  SMG$Read_Composed_Line
	External TrimLg
	Integer  TrimLg

C Local Definitions

	Record 		/String_Def/	Init_Desc, Prompt_Desc
	Character	*128		Init_String
	Integer		*4		Get_String_Length

C Begin SMG_Prompt

	Prompt_Desc.DType   = 14
	Prompt_Desc.Class   = 1
	Prompt_Desc.Address = %Loc(Prompt_String)
	If (Prompt_String .eq. ' ') Then
	    Prompt_Desc.Length = 0
	Else
	    Prompt_Desc.Length = Len(Prompt_String)
	EndIf

	Init_Desc.DType     = 14
	Init_Desc.Class     = 1
	Init_Desc.Address   = %Loc(Init_String)
	Init_Desc.Length    = 0

1	SMG_Prompt = SMG$Read_Composed_Line
	1	(
	1	SMGKeyBdId,		! Keyboard Id
	1	SMGKeyDefId,		! Key Table Id
	1	Get_String,		! Received text
	1	Prompt_Desc,		! Prompt text
	1	Get_String_Length,	! received text length
	1	,			! display id
	1	,			! function key flags
	1	Init_Desc		! ini string
	1	)

	SMG_Line = SMG_Line + 1

	If ((SMG_Prompt .eq. SS$_Abort) .OR. 
	1   (SMG_Prompt .eq. SS$_Cancel)     ) Then
	    Init_String = Get_String
	    Init_Desc.Length = Get_String_Length
	    Goto 1
	EndIf

	If (Control_C) Then
	    Call SMG_All_Print (' ')
	EndIf

	If (%Loc(Get_Length) .ne. 0) Then
	    Get_Length = TrimLg(Get_String)
	EndIf

	End ! of SMG_Prompt

C SMG_Handle_Broadcasts - catch (for subsequent display) or ignore broadcast
C   messages.  [Extracted from other routines to eliminate duplications.]
C   Called by Spawn, Attach, and Edit routines.
C   (Pat Rankin, rankin@eql.Caltech.edu), vnews 1.4/910325
C   Added message queue, jms/910620

	Integer *4 Function SMG_Handle_Broadcasts( enable )

	Implicit None

	Include 'SMG.Def'

	Logical			enable          !on/off flag
	Integer *4		Status          !result
	Integer *4		Smg$Set_Broadcast_Trapping
	Integer *4		Smg$Disable_Broadcast_Trapping
	External		SMG_Broadcast_AST

	If ( enable ) Then

C+++
C         Enable broadcast trapping and empty out queue.
C---

	    SMG_Broadcast_Count = 0		! no msgs in queue

	    Status = SMG$Set_Broadcast_Trapping
	1	(SMG_PBId,             ! Pasteboard-Id
	1	 SMG_Broadcast_AST,    ! AST-Routine
	1	 %VAL(0)               ! AST-Argument
	1	)

	Else

C+++
C         Disable broadcast trapping (so that we can spawn subprocesses)
C---

	    Status = Smg$Disable_Broadcast_Trapping (SMG_PBId)

	End If

	If (.not. Status) Call Lib$Signal(%Val(Status))

	SMG_Handle_Broadcasts = Status

	Return

	End ! of SMG_Handle_Broadcasts
