C SRV.FOR
C
C Global change: added socket_perror() for 1.4/910430/McMahon@TGV.COM
C better support for DECnet. jms/910501/vnews 1.4

	Integer Function Srv_Cmd (Cmd, Rsp, Lg)

	Implicit None

	Include 'Network.Def'

C Description
C
C   Send Cmd to the news server and retrieve its response in Rsp
C
C   Returns
C
C     Srv_Cmd	Success or failure
C     Rsp 	Response text from server
C     Lg	Length of Rsp text

C Parameter definitions

	Character *(*)		Cmd
	Character *(*)		Rsp
	Integer	  *4		Lg

	Integer   *4		Status

C External Routines

	Integer			Srv_Send
	Integer			Srv_Recv
	Integer			decc$Shutdown 	! socket library
	Logical			Do_Auth		! do authorization

C Begin Srv_Cmd

1	Srv_Cmd = Srv_Send (Cmd)
	If (.not. Srv_Cmd) Then
	  Return
	EndIf

C Not all servers send back a response if we close the connection,
C so instead of waiting forever, we simply close our own connection
C first if the command is 'QUIT.'  Shutdown returns 0 for success,
C and -1 for failure. jms,others,pr/910325,910416  Vnews 1.4
C Certain IP implementations, notably UCX, return SS$_NORMAL instead
C of 0 for "success," so we need to test for both.

	If (Cmd .eq. 'quit' .or. Cmd .eq. 'QUIT') then 
	    Status = decc$Shutdown(%VAL(channel), %VAL(2))
	    Srv_Cmd = ((status .eq. 0) .or. (status .eq. 1))
	Else
	    Srv_Cmd = Srv_Recv (Rsp, Lg)
	EndIf

C+++
C Check to see if we need to do authorization here.
C If we have to do authorization, then retry command as well. 
C VNEWS 1.4/jms/910414
C pr,jms: bug fix, remove recursive call (damn Fortran!) and keep
C us out of infinite loop created by dumb servers.
C---
	If (Rsp(1:3) .eq. '480') Then
	  If (.NOT. Do_Auth()) Then
	    Srv_Cmd = .false.
	    Return
	  Endif
	  GoTo 1			! retry
	Endif

	Return

	End ! of Srv_Cmd


C************************************************************************

	Integer Function Srv_Connect

	Implicit None

	Include 'Network.Def'

C Description
C
C   Connects to the Remote News server.
C
C   Returns success or failure.
C

C Local Variables

	Integer     *4          I
	Record /Socket_IN_Def/  Server_Socket
	Integer     *4		Status
	Integer     *4		IP_Address
	Equivalence		(IP_Address, Server_IP_Number)

C External subroutines

	Integer	    *4		decc$Socket
	External		decc$Socket
	Integer	    *4		decc$Connect
	External		decc$Connect
	Integer	    *4		decc$HtoNS
	External		decc$HtoNS

C Empty Recv buffer

	Recv_BufS = 2
	Recv_BufE = 1

C Open a channel.  For TCP/IP, this is simply creates the socket. For
C DECnet, it actually opens the channel all the way to the remote
C object.

	Channel = decc$Socket
	1	(
	2	%Val(AF_INet),
	3	%Val(Sock_Stream),
	4	%Val(0)
	5	)

	If (Channel .eq. -1) Then
c	  Call socket_perror(%ref('srv_connect: socket'))
	  Srv_Connect = 2
	  Return
	EndIf


C Connect to remote machine.  This is only done for Transports which
C are NOT DECNET.  

	If (NNTP_Transport .NE. DECNET_Transport) Then

	    Server_Socket.SIN_Family  = AF_INet
	    Server_Socket.SIN_Port    = decc$HtoNS (%Val(119))
	    Server_Socket.SIN_Address = IP_Address 	! '111e6880'X

	    Do I = 1,8
		Server_Socket.SIN_Fill(I) = 0
	    EndDo

	    Status = decc$Connect
	1	(
	2	%Val(Channel),
	3	Server_Socket,
	4	%Val(16)
	5	)

	    If (Status .ne. 0) Then
c		Call socket_perror(%ref('srv_connect: connect'))
		Srv_Connect = 4
		Return
	    EndIf ! (Status .ne. 0) 

	EndIf ! (NNTP_Transport .NE. DECNET_Transport)

C Return success

	Srv_Connect = 1

	Return

	End ! of Srv_Connect	

C************************************************************************

	Subroutine Srv_CopyTxt (LU, Pre, Rotate_Flag)

	Implicit None

	Include 'Network.Def'

C Parameter definitions

	Integer   *4	LU
	Character *(*)	Pre
	Logical		Rotate_Flag

C External routines

	Integer		Srv_Recv

C Local definitions

	Character *1024	Buf
	Integer   *4	Buf_S, Buf_E	! Buf pointers
	Integer   *4	Lg
	Integer	  *4	MxLg		! Recl for LU_Save
	Integer	  *4	Pre_Lg
	Integer	  *4	X
	Integer   *4	Status		! add status return/alpha/jms/921026

C Begin Srv_CopyTxt

	If (Pre .eq. ' ') Then
	  Pre_Lg = 0
	Else
	  Pre_Lg = Len (Pre)
	EndIf

	Inquire (Unit = LU, Recl = MxLg)
	MxLg = MxLg - 4

	Buf = ' '
	Lg = 1

c alpha: had to unroll a nice .AND. statement because the Alpha Fortran
c	compiler won't guarantee that I can short circuit expression
c	evaluation.
c	jms/921026

	Do While ((Buf(1:Lg) .ne. '.') )
	  Status =  Srv_Recv(Buf,Lg)
	  If (.NOT. Status) Then
	    Buf = '.'
	    Lg  = 1
	  EndIf
	  If (Lg .eq. 0) Then
	    Lg = 1
	    Buf(1:1) = ' '
	  EndIf

	  If (Buf(1:lg) .ne. '.') Then
	    If (Rotate_Flag) Then
	      Call Rotate (Buf(1:Lg))
	    EndIf
	    Buf_S = 1
	    Do While (Buf_S .le. Lg)
	      Buf_E = Lg
	      X = Buf_E - Buf_S + 1 + Pre_Lg
	      If (X .gt. MxLg) Then
	        Buf_E = Buf_S + MxLg - 1 - Pre_Lg
	      EndIf
	      If (Pre_Lg .ne. 0) Then
	        Write (LU, '(A)') Pre // Buf(Buf_S:Buf_E)
	      Else
	        Write (LU, '(A)') Buf(Buf_S:Buf_E)
	      EndIf
	      Buf_S = Buf_E + 1
	    EndDo
	  EndIf
	EndDo

	End ! of Srv_CopyText


C************************************************************************

	Integer Function Srv_RdTxt (P, Rot, Checkit)

	Implicit None

C NOTE: These are also defined in NEWS.DEF, which I didn't want to include
C here for this little tiny routine.  So, DON'T CHANGE THE VALUES EVER!
C of the two following parameters. jms/920910
	Parameter		Srv_RdTxt_Check = 1
	Parameter		Srv_RdTxt_Dont  = 2
	Include 'Network.Def'

C Parameters

	Logical		P		! .true. means print
					! .false. means skip
	Logical		Rot		! .true. means rotate
	Integer		CheckIt

C External Routines

	Integer		Srv_Recv
	Logical		SMG_More_Print
	Logical		Header_Check

C Local definitions

	Character *512	Buf
	Integer	  *4	Lg
	Logical		Ok

C Begin Srv_RdTxt

	Buf = ' '
	Ok = P
	Do While (.true.)
	  Srv_RdTxt = Srv_Recv (Buf, Lg)
	  If (.not. Srv_RdTxt) Return
	  If (Buf (1:Lg) .eq. '.') GOTO 9000
	  If (Ok) Then
	   If (Rot) Call Rotate (Buf(1:Lg))
	    If (Buf (1:2) .eq. '..') Then
	      Buf = Buf(2:)
	      Lg = Lg - 1
	    End IF
	    If (CheckIt .eq. Srv_RdTxt_Dont) Then
	      OK = SMG_More_Print (Buf(1:Lg))
	    Else 
	      If (Header_Check(Buf(1:Lg))) Then
		OK = SMG_More_Print (Buf(1:Lg))
	      EndIf
	    EndIf
	  EndIf
	EndDo

9000	Continue

C All done, return

	Return

	End ! of Srv_RdTxt


C************************************************************************

	Integer Function Srv_Recv (Buf, Lg)

	Implicit None

	Include 'Network.Def'
	Include 'Debug.Def'

C Description
C
C   Read data form server to Buf.
C
C   Returns success or failure.

C Parameter Definitions

	Character *(*)		Buf
	Integer   *4		Lg

C Local definitions

	Integer   *4		Buf_Lg
	Character *2		CRLF
	Logical			CR
	Logical			Done
	Integer   *4		I
	Integer   *4		N
	Integer   *4		NN
	Integer   *4		Recv_Buf_Addr
	Integer   *4		Recv_Buf_Lg
	Logical			Skip

C External IP/DECnet subroutines
	Integer   *4		decc$Recv
	External		decc$Recv

C Begin Srv_Recv

	Buf_Lg = Len(Buf)

	Srv_Recv = 1		! alpha/jms/921026
	CRLF(1:1) = Char(13)
	CRLF(2:2) = Char(10)

	Lg = 0			! No bytes xferred so far

	Done = .false.
	CR = .false.

	Do While (.not. Done)

C If there is no data in the receive buffer, get some

	If (Recv_BufS .gt. Recv_BufE) Then

	    Recv_Buf_Addr = %Loc(Recv_Buf)
	    Recv_Buf_Lg   = Len(Recv_Buf)

	    I = decc$Recv
	1	(
	2	%Val(Channel),
	3	%Val(Recv_Buf_Addr),
	4	%Val(Recv_Buf_Lg),
	5	%Val(0)
	6	)

c
c Recv can return either 0 or -1; need to check for both. 910320/jms (1.4)
c Need to return if there is an error. 910320/jms (1.4)
c
	    If (I .eq. -1 .or. I .eq. 0) Then
C	      Call Socket_Perror(%ref('srv_recv: recv call'))
	      If (I .eq. -1) Then
		Call SMG_All_Print ('News Server failed.')
	      Else
		Call SMG_All_Print ('News Server failed (no data)')
	      EndIf
	      Srv_Recv = 0
	      Return
	    Else
	      Srv_Recv = 1
	    EndIf
            
	    Recv_BufS = 1
	    Recv_BufE = I

	  EndIf

C Now we have some data

C If we last saw a carriage return and the next character is a LF
C then we have found the end of the image and we are done

	  If (CR .and. (Recv_Buf(Recv_BufS:Recv_BufS) .eq. 
	1			CRLF(2:2))) Then
            
	    Done = .true.
	    Recv_BufS = Recv_BufS + 1

	  Else

C No terminator, look for the next hunk to transfer.

	    CR = .false.
	    I = Index (Recv_Buf(Recv_BufS:Recv_BufE), CRLF(1:1))

	    If (I .eq. 0) Then
	      N = Recv_BufE - Recv_BufS + 1
	      Skip = 0
	    Else
	      N = I - 1
	      Skip = 1
	      CR = .true.
	    EndIf

C Anything to tranfer?

	    If (N .gt. 0) Then

	      NN = Buf_Lg - Lg
	      If (NN .gt. N) Then
	        NN = N
	      EndIf
	      If (NN .gt. 0) Then
	        Buf(Lg+1:Lg+NN) = Recv_Buf(Recv_BufS:Recv_BufS+NN-1)
	        Lg = Lg + NN
	      EndIf

	    EndIf

	    Recv_BufS = Recv_BufS + N + Skip

	  EndIf

	EndDo

	If (Lg .le. 0) Then
	  Lg = 1
	  Buf(1:1) = ' '
	EndIf

	IF (debug) Then
	  WRITE (*,*) '<',Buf(:Lg)
	End if

	Return

	End ! of Srv_Recv


C************************************************************************

	Integer Function Srv_Send (Msg)

	Implicit None

	Include 'Network.Def'
	Include 'Debug.Def'

C Description
C
C   Send data from Buffer to News Server
C
C   Returns success or failure.

C Parameter Definitions

	Character *(*)		Msg

C Local definitions

	Character *512		Buf
	Integer	  *4		Buf_Addr
	Integer   *4		Buf_Lg
	Integer   *4		CC

C External network subroutines
	Integer   *4		decc$Send
	External		decc$Send

C Begin Srv_Send

	Buf_Lg   = Len(Msg)
	If (Msg(1:Buf_Lg) .eq. ' ') Then
	  IF (Debug) Then
	    write (*, *) '>'
	  END IF
	  Buf = Char(13) // Char(10)
	  Buf_Lg = 0
	Else
	  IF (Debug) THEN
	    Write (*,*) '>', Msg
	  End if
	  Buf = Msg(1:Buf_Lg) // Char(13) // Char(10)
	EndIf
	Buf_Addr = %Loc(Buf)
	Buf_Lg   = Buf_Lg+2

	CC = decc$Send
	1	(
	2	%Val(Channel),
	3	%Val(Buf_Addr),
	4	%Val(Buf_Lg),
	5	%Val(0)
	6	)

	If (CC .eq. -1) Then
C	  Call socket_perror(%ref('srv_send: send'))
	  Srv_Send = 0
	Else
	  Srv_Send = 1
	EndIf

	Return

	End ! of Srv_Send
