C STR_STRIP_RE.FOR

C	Str_Strip_Re --- Strips the 'RE:' out of the string.  Useful for
C			 kill subjects.  Works iteratively so things like
C			 RE:RE:RE:RE: don't make it through.  St is modfified
C			 in place, as is Lg.
C
C Parameters:
C	St -m- String to have the 'RE:' removed.
C	Lg -m- Length of the string, both before and after.
C
	SUBROUTINE Str_Strip_Re (St, Lg)

	IMPLICIT NONE

	CHARACTER *(*) St		! String to strip.
	INTEGER Lg			! Length of the string.

C+
C       Loop through the string, looking for 
C	[Rr][Ee][:>] plus one space
C       and then strip whatever we find off.
C-

	DO WHILE ((Lg .GE. 4) 
	1	.AND. 
	2	(St(1:2).EQ.'RE'.or.St(1:2).eq.'Re'.or.St(1:2).eq.'re') 
	3	.and.
	4	(St(3:3) .eq. ':' .or. St(3:3) .eq. '>') )
	    IF (St(4:4) .EQ. ' ') Then
		If (Lg .GE. 5) Then 
		    St = St(5:Lg)
		    Lg = Lg - 4
		Else
		    Return		! a subject of "RE: "?
		EndIf
	    Else 
		St = St(4:Lg)
		Lg = Lg - 3
	    EndIf
	EndDo

	Return

	End
