C TRANSLOG.FOR - Translate Logical Name

C vnews 1.4 - changed meaning of translation table names. pr/910325,
C		added comments and error message. jms/910325

	Integer Function TransLog (In, Out, Table)

	Implicit None

	Include '($PSLDef)'
	Include '($LNMDef)'

C Parameter definitions

	Character *(*) In		! name to be translated
	Character *(*) Out		! resulting translated name
	Integer *4 Table			! table 0 = User 'LNM$DCL_LOGICAL'
					! table 1 = Exec 'LNM$SYSTEM_TABLE'
					! table 2 = User 'LOG$PROCESS'

C LNM$DCL_LOGICAL is a logical name that is defined as LNM$FILE_DEV.  The
C logical name iteratively translates into the list of logical name tables
C searched and displayed by SHOW LOGICAL, SHOW TRANSLATION, and $TRNLNM.
C By default, these commands search and display the process, job, group,
C and system logical name tables in that order.
C
C LOG$PROCESS is a logical name in the LNM$SYSTEM_DIRECTORY logical name
C table which translates into LNM$PROCESS and LNM$JOB, in that order.
C You use LOG$PROCESS to search only the process/job logical name tables.
C
C The access mode given (AcMode) is a "minimum;" $TRNLNM will ignore all
C logical names at access modes LESS privileged.  Thus, a User AcMode
C means "accept all logical names."

C Local definitions

	Include 'ItemList.DEF'

	Integer *4       AcMode
	Integer *4       Attr
	Integer *4       InLg
	Record /ItmLst/  ItmList(2)
	Character *32    LogNameTable
	Integer *4       LogNameTableLg
	Integer *4       ResultLg

	Integer TrimLg, Sys$TrnLnm


C Begin

	Attr = LNM$M_Case_Blind

	If (Table .eq. 0) Then
	    LogNameTable = 'LNM$DCL_LOGICAL'
	    AcMode = PSL$C_User
	Else If (Table .eq. 1) Then
	    LogNameTable = 'LNM$SYSTEM_TABLE'
	    AcMode = PSL$C_Exec .or. PSL$C_Super
	Else If (Table .eq. 2) Then
	    LogNameTable = 'LOG$PROCESS'
	    AcMode = PSL$C_User
	Else
	    Write (6,*) 'Fatal Bug in VNEWS-TRANSLOG with bad table value.'
	    Call Lib$Stop (%Val(0))
	EndIf

	LogNameTableLg = TrimLg (LogNameTable)

	ItmList(1).Code = LNM$_String
	ItmList(1).BufLen = Len(Out)
	ItmList(1).BufAddr = %Loc (Out)
	ItmList(1).RetLenAdr = %Loc(ResultLg)

	ItmList(2).End_List = 0
	Out = ' '
	InLg = TrimLg (In)

	TransLog = Sys$TrnLnm (Attr,
	1			LogNameTable(1:LogNameTableLg),
	2			In(1:InLg),
	3			AcMode,
	4			ItmList
	5			)

	END ! of Translog
