C USER_OPEN.FOR

	Integer Function User_Open (Fab, Rab, Lun)

	Implicit None
 
	Include 'User_Open.DEF'
	Include '($IODef)/list'

C Parameter Definitions

	Record /FABDef/ Fab
	Record /RABDef/ Rab
	Integer         Lun

C Description

C 	User_Open is designed to be called from a Fortran Open statement
C 	through a UserOpen clause.  Since it must do several different
C 	things, calls on it must be preceded with calls on User_Open_Init
C 	and User_Open_Param to tell it what needs to be done.  These
C 	routines have the same calling sequence...
C
C   	Call User_Open_Init (What_String)
C
C 	What_String tells what kind of action User_Open should take while
C
C   	What_String		Explanation
C
C   	'Status_New'        File to be created 
C   	'Status_Old'        File exists
C   	'Status_Unknown'    Use old file or create
C   	'Exec_Log'          Don't use user logicals

C External Definitions

	External Sys$Open, Sys$Create, Sys$Connect
	Integer  Sys$Open, Sys$Create, Sys$Connect
	external Sys$put, Sys$Close
	integer  Sys$put, Sys$Close

C Local Definitions

	Integer	*4	X, Off, Byte, XAB_Addr, XAB_Last

C Begin User_Open

	Unit = Lun			! save unit in common 
	LUNFab(Lun) = %Loc(FAB)

C Set exec mode translate

	If (LogNames) Then
	  X = PSL$C_EXEC
	  Off = FAB$V_LNm_Mode
	  Byte = Fab.FAB$B_ACModes
	  Call MvBits (X,0,FAB$S_LNm_Mode,Byte,Off)
	  Fab.FAB$B_AcModes = Byte
	EndIf

C Wander through all of the XAB's doing whatever needs to be done

	XAB_Last = 0
	XAB_Addr = Fab.FAB$L_XAB
	Do While (XAB_Addr .ne. 0)
	    XAB_Last = XAB_Addr
	    Call User_Open_XAB(%Val(XAB_Addr), XAB_Addr)
	EndDo

C If any options were not handled, handle them now!

	Call User_Open_XAB_Last (%Val(XAB_Last), Fab)

C Open the file

	If ((Status_Value .eq. 2) .or. (Status_Value .eq. 3)) Then
	  User_Open = Sys$Open (Fab)
	  If (User_Open) Then
	    What_Happened = 1
	  EndIf ! (User_Open)
	EndIf

	If ((Status_Value .eq. 1) .or. 
	1	((Status_Value .eq. 3) .and. (.not. User_Open))
	2	) Then
	  User_Open = Sys$Create (Fab)
	  If (User_Open) Then
	    What_Happened = 2
	  EndIf
	EndIf

C If open worked, attach a record stream to it

	If (User_Open) Then
	  User_Open = Sys$Connect (RAB)
	  Call User_Open_Name (%Val(Fab.Fab$L_Nam))   ! Glom onto the name
	Else
	  What_Happened = 0
	EndIf

	User_Open_Status_Value = User_Open	! save status value for
						!  User_Open_Status

	End ! of User_Open


	Subroutine User_Open_Init (What)

	Implicit None

	Include 'User_Open.DEF/NOLIST'

C Description
C
C   Call User_Open_Init (What_String)
C
C What_String tells what kind of action User_Open should take while
C
C   What_String		Explanation
C
C   'Status_New'        File to be created 
C   'Status_Old'        File exists
C   'Status_Unknown'    Use old file or create
C   'Exec_Log'          Don't use user logicals
C
C Parameter Definition

	Character *(*) What

C Local Definitions

	Integer *4      LWord
	Integer *2      Word
	Equivalence     (Word, LWord)

C Begin User_Open_Init

	Status = 0
	LogNames = 0

C Begin User_open_Param

	Entry User_Open_Param (What)

	If      (What .eq. 'STATUS_NEW') Then
	  Status = 1
	  Status_Value = 1
	Else If (What .eq. 'STATUS_OLD') Then
	  Status = 1
	  Status_Value = 2
	Else If (What .eq. 'STATUS_UNKNOWN') Then
	  Status = 1
	  Status_Value = 3
	Else If (What .eq. 'EXEC_LOG') Then
	  LogNames = 1
	Else 
	  Print '(A)', ' Unknown User_Open_Parameter: ' // What
	  Call Lib$Stop (%Val(0))
	EndIf

	Return

	End ! of User_Open_Init and User_Open_Param


	Subroutine User_Open_Get_CDT (LUN, CDT)

	Implicit None

	Include 'User_Open.DEF/NOLIST'

C Parameter definitions

	Integer   *4 	LUN
	Character *(*)	CDT

C External routines

	Integer         Sys$AscTim

C Local definitions

	Integer   *4    XStatus, CDT_Lg

C Begin User_Open_Get_CDT

	CDT = ' '
	XStatus = Sys$AscTim 
     $    (CDT_Lg, CDT, LUNXABDat(LUN).XAB$Q_CDT, 0)

	End ! of User_Open_Get_CDT


	Integer Function User_Open_Get_What_Happened 

	Implicit None

	Include 'User_Open.DEF/NOLIST'

	User_Open_Get_What_Happened = What_Happened

	Return

	End ! of User_Open_Get_What_Happened


	Subroutine User_Open_NameX (A, L)

	Implicit None

	Include 'User_Open.DEF/NOLIST'

	Integer		I

	Byte		A(255)
	Integer		L

	If ((%Loc(A) .eq. 0) .or. (L .eq. 0)) Then
	  Esa_Name = ' '
	  Esa_Name_L = 0
	Else
	  Do I = 1,L
	    Esa_Name(I:I) = Char(A(I))
	  EndDo
	  Esa_Name_L = L
	End If

	Return
	
	End ! of User_Open_NameX


	Subroutine User_Open_Name (N)

	Implicit None

	Include '($NamDef)'

	Include 'User_Open.DEF/NOLIST'

	Record /NamDef/ N

	Integer		A
	Integer		L

	A = N.Nam$L_ESA
	L = N.Nam$B_ESL
	Call User_Open_NameX (%Val(A), L)

	Return

	End ! of User_Open_Name


	Subroutine User_Open_XAB (XAB, XAB_Ptr)

	Implicit None

	Include 'User_Open.DEF/NOLIST'

C Parameter Definitions

	Record /XABDef/      XAB
	Integer              XAB_Ptr

C Begin User_Open_XAB

	XAB_Ptr = XAB.XAB$L_Nxt

	End ! of User_Open_XAB


	Subroutine User_Open_XAB_Last (XAB, FAB)

	Implicit None

	Include 'User_Open.DEF/NOLIST'

C Parameter Definitions

	Record /XABDef/ XAB
	Record /FABDef/ FAB


	If (%Loc(XAB) .ne. 0) Then
	    XAB.XAB$L_Nxt = %Loc(LUNXABDat(Unit))
	Else
	    Fab.FAB$L_XAB = %Loc(LUNXABDat(Unit))
	EndIf

	Call Set_XAB_B_Cod (LUNXABDat(Unit), XAB$C_Dat)
	Call Set_XAB_B_BLn (LUNXABDat(Unit), XAB$C_DatLen)
	Call Set_XAB_L_Nxt (LUNXABDat(Unit), 0)
 
	Return

	End ! of User_Open_XAB_Last


	Subroutine Set_XAB_L_Nxt (XAB, V)

	Implicit None
	Include 'User_Open.DEF/NOLIST'

	Record /XABDef/	XAB
	Integer *4	V

	XAB.XAB$L_Nxt = V

	End ! of Set_XAB_L_Nxt



	Subroutine Set_XAB_B_Cod (XAB, V)

	Implicit None

	Include 'User_Open.DEF/NOLIST'

	Record /XABDef/ XAB
	Byte		V

	XAB.XAB$B_Cod = V

	Return

	End ! of Set_XAB_B_Cod


	Subroutine Set_XAB_B_BLn (XAB, V)

	Implicit None

	Include 'User_Open.DEF/NOLIST'

	Record /XABDef/	XAB
	Byte		V

	XAB.XAB$B_BLn = V

	Return

	End ! of Set_XAB_B_Bln
