c validate_headers.for

c this subroutine takes a news message and makes sure that it has
c headers which are required in the correct format.  This is the
c place to put any site-specific policy statements (like "this
c user is a jerk") in the headers.
c
c vnews 1.4/jms/910704

C Reminder: in an I/O statement, IOSTAT takes on the following
C values:
C	. if the value is 0, no error or end-of-file condition exists
C	. if the value is positive, an error condition exists
C	. if the value is negative, an eof condition exists
C

	Logical Function validate_headers(Filename,
	1	From,
	2	Followup,
	3	References,
	4	MessageId)
	
	Include 'NEWS.DEF/NOLIST'

C	Function parameters

	Character *(*)	Filename
	Character *(*)	From
	Logical		FollowUp
	Character *(*)	References
	Character *(*)	MessageID

C	External functions

	Integer		TrimLG

C 	Local storage

	Integer	FileLg				! length of file name
	Integer LineLg				! length of line
	Character *255	Line			! line of text from file.
	Logical HasFrom, HasNewsGroups, HasDate, HasSubject,
	1	HasMessageId, HasPath		! headers lines found
	Integer Status				! IO Status
	Integer I				! Do loop index
	Integer X				! another index
	Integer Last_Bracket			! used to search for MIDs
	Character *27 Date_Time			! Date/Time
	Character *27 Date_Time_No_Blanks 	! ... and to make MID
	Character*8 Version_Name 		! VNEWS version number


	FileLg = Trimlg(Filename)

	HasFrom = .FALSE.
	HasNewsGroups = .FALSE.
	HasDate = .FALSE.
	HasSubject = .FALSE.
	HasMessageId = .FALSE.
	HasPath = .FALSE.

c open files 

	Open
	1	(
	2	Unit		= LU_EditIn,
	3	File		= Filename(:FileLg),
	4	Status		= 'Old',
	5	Form		= 'Formatted',
	6	CarriageControl	= 'List',
	7	Recl 		= 1024,
	8	IOStat		= Status
	9	)

	If (Status .ne. 0) Then
	    Call SMG_All_Print
	1	(
	2	'Error opening file ' // Filename(:FileLg) //
	3	'.  Post aborted.'
	4	)
	    validate_headers = .FALSE.
	    Return
	EndIf

	Open
	1	(
	2	Unit		= LU_EditOut,
	3	File		= Filename(:FileLg),
	4	Status		= 'New',
	5	Form		= 'Formatted',
	6	CarriageControl	= 'List',
	7	Recl 		= 1024,
	8	IOStat		= Status
	9	)

	If (Status .ne. 0) Then
	    Call SMG_All_Print
	1	(
	2	'Error opening output file ' // Filename(:FileLg) //
	3	'.  Post aborted.'
	4	)
	    Close (LU_EditIn)
	    validate_headers = .FALSE.
	    Return
	EndIf

C Write out the first header line

C PATH:

	Write (LU_EditOut, '(A)') 'Path: '//
	1	SiteId(2:TrimLg(SiteId)) // '!' // 
	2	UserName(1:TrimLg(UserName)) 
	HasPath = .TRUE.

C Now, loop through all the header lines, either writing them
C or discarding them, or modifying them, until we find the
C first blank line, which signifies the beginning of the
C message text. 

	Status = 0
	Do While (Status .eq. 0)
	    Read (
	1	Unit   = LU_EditIn,
	2	Fmt    = '(Q,A)',
	3	IOStat = Status ) 
	4				LineLg, Line

	    If (Status .eq. 0 .and. LineLg .GE. 1) Then

C Discard Path:

		If (Line(:5) .eq. 'Path:') Then
		    Call Smg_All_Print ('Ignoring your Path: in header.')

C From:

		Else If (Line(:5) .eq. 'From:' .AND. 
	1		 (.NOT. HasFrom) ) Then
		    Write (LU_EditOut, '(A)') Line(:LineLg)
		    If (Line(7:LineLg) .ne. From(:LineLg-6)) Then
			Write (LU_EditOut, '(A)') 'Sender: ' //
	1			From(:TrimLg(From))
		    EndIf
		    HasFrom = .TRUE.

C Newsgroups:

		Else If (Line(:11) .eq. 'Newsgroups:' .AND.
	1		 (.NOT. HasNewsgroups) ) Then
		    Write (LU_EditOut, '(A)') Line(:LineLg)
		    HasNewsgroups = .TRUE.

C Subject:

		Else If (Line(:8) .eq. 'Subject:' .AND.
	1		 (.NOT. HasSubject) ) Then
		    Write (LU_EditOut, '(A)') Line(:LineLg)
		    HasSubject = .TRUE.

C Date: (simply replace)

		Else If (Line(:5) .eq. 'Date:' .AND.
	1		 (.NOT. HasDate) ) Then
		    Call RFC_Date(Date_Time,Timezone)
		    Write (LU_EditOut, '(A)') 'Date: ' // Date_Time
		    HasDate = .TRUE.

C Discard Message-ID:, References, Sender, Organization

		Else If (Line(:11) .eq. 'Message-ID:') Then
		    Call Smg_All_Print('Ignoring your Message-ID: in header.')

		Else If (Line(:11) .eq. 'References:') Then
		    Call Smg_All_Print ('Ignoring your References in header.')

		Else If (Line(:7) .eq. 'Sender:') Then
		    Call Smg_All_Print ('Ignoring your Sender in header.')

		Else If (Line(:13) .eq. 'Organization:') Then
		    Call Smg_All_Print ('Ignoring Organization: in header.')

C Blank line
		Else If (Line(1:1) .eq. ' ') Then
		    Status = -1

C If it doesn't match anything, write it out.
		Else
		    Write (LU_EditOut, '(A)') Line(:LineLg)
		EndIf ! for each line
	    Else If (Status .gt. 0) Then
		Call SMG_All_Print('Error reading your posting.')
	        Close (LU_EditIn)
		Close (LU_EditOut)
	        Validate_Headers = .FALSE.
		Return
	    Else
		Status = -1
	    EndIf ! status .eq. 0 .and. length .ge. 1
	EndDo ! for lines in file

C Now, add our special magic header lines

C	
C	Add Message-ID: per RFC1036 section 2.1.5. jms/900930
C	First, create a message ID by concatenating the Date and
C	Time, with the blanks and colons taken out, with the
C	site name, and putting it into the message header.
C
	Call SYS$ASCTIM (,Date_Time,,)
	X = 1
	Do I = 1, 27
	    If ( Index('- :.+',Date_Time(I:I)) .eq. 0) Then
		Date_Time_No_Blanks(X:X) = Date_Time(I:I)
		X = X + 1
	    EndIf
	EndDo
	Write (LU_EditOut, '(A)') 'Message-ID: <' // 
	1	Date_Time_No_Blanks(1:X-1) //
	2	SiteId(1:TrimLg(SiteId)) //
	3	'>'
	HasMessageId = .TRUE.

C
C	And Date.  Note that the user can edit the date, and we'll
C	still believe it.  Is this a bug?  I think not.
C
	If (.NOT. HasDate) Then
	    Call RFC_Date(Date_Time,Timezone)
	    Write (LU_EditOut, '(A)') 'Date: ' // Date_Time
	    HasDate = .TRUE.
	EndIf

C
C 	Add References
C
	
	If (Followup) Then

	    If (TrimLg(References) .eq. 1) Then	! article had no refs

		Write (LU_EditOut, '(A)') 'References: ' //
	1	 MessageID(1:TrimLg(MessageID)) 

	    Else	! article did have previous references

c	First find the last '>' in references.  This is to prevent chopping
c	a reference off in the middle.  Better to dump one partial
c	one than to leave it in. John McMahon - 28-FEB-1990

		Last_Bracket = TrimLg(References) ! Init to end of ref. string

		Do I = 1, TrimLg(References)
		   If (References(I:I) .eq. '>') Then
			Last_Bracket = I
		   End If
                EndDo 

		Write (LU_EditOut, '(A)') 'References: ' //
	1		References(1:Last_Bracket) //
	2		' ' // MessageID(1:TrimLg(MessageID)) 

	    EndIF ! If trimlg(ref...
	Endif ! if followup

C
C	Add Organization
C
	Write (LU_EditOut, '(A)') 'Organization: ' //
	1	Organization(1:TrimLg(Organization))


C
C	Add software version.
C
	  Call Provide_Version(Version_Name)
	  Write (LU_EditOut, '(A)') 'News-Software: VAX/VMS VNEWS ' // 
	1				Version_Name

C	
C	Now, we should have all of the valid headers in our article.
C	Let's check...

	If (HasFrom .AND. HasDate .AND. HasNewsgroups .AND.
	1   HasSubject .AND. HasMessageId .AND. HasPath ) Then
	    Continue
	Else
	    Call Smg_All_Print (
	1	' You seem to have deleted a vital header line.')
	    validate_headers = .false.
	    Close (LU_EditIn)
	    Close (LU_EditOut)
	    Return
	EndIf

C	Finally, copy over the blank line, and the rest of the article.

	Write (LU_EditOut, '(A)') ' '

	Status = 0
	Do While (Status .eq. 0)
	    Read (
	1	Unit   = LU_EditIn,
	2	Fmt    =  '(Q,A)',
	3	IOStat = Status)
	4			LineLg, Line
	    If (Status .eq. 0) Then
		If (LineLg .GE. 1) Then
		    Write (LU_EditOut, '(A)') Line(:LineLg)
		Else
		    Write (LU_EditOut, '(A)') ' '
		EndIf
	    Else If (Status .gt. 0) Then
		Call SMG_All_Print('Error reading your posting.')
		Close (LU_EditIn)
		Close (LU_EditOut)
		Validate_Headers = .FALSE.
		Return
	    Else
		Continue	! status .lt. 0, means EOF
	    EndIf
	End Do

	Close (LU_EditIn)
	Close (LU_EditOut)
	Validate_Headers = .TRUE.

	Return
	End
