  /*   *  P  *   ACRS Western Kentucky University  ACRS Western Kentucky University  ACRS WeP  *   stern Kentucky University  ACRS Western Kentucky University  ACRS Western KO  *   entucky University ACRS Western Kentucky University  ACRS Western Kentucky   *      */      #module QUEUE_MON "02-002"         /*  *  R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  *    *    *   Program Name:	QUE_MON)  *   Authors:		Brian Dickerson (original) /  * 			Baron L. Chandler (present version--2.0), .  *   Organization:	Western Kentucky University.  * 			Academic Computing and Research Services  *   Date:		April 5, 1992   *    *   Functional Description:  *  @  * 	QUE_MON is a print queue monitor.  It provides all essential@  * 	information regarding print queues on the system in a nicely?  * 	formatted (?) screen.  By using the keyboard, the user can  @  * 	manipulate queues and jobs.  They can also do the equivalent-  *  	of a SHOW QUEUE/FULL or SHOW ENTRY/FULL.   *    *   Statement of Copyright:  *  @  * 	This program is in the public domain.  It is, however, copy-@  * 	righted by the authors and the University.  It may be freely<  * 	distributed as long as the orignal header is left intactC  * 	without any modifications (this comment is the orignal header).   * 	  *   Building Instructions:   *    * 	$ CC QUE_MON  * 	$ MESSAGE QUE_MON_MSG 8  * 	$ LINK QUE_MON,QUE_MON_MSG,SYS$INPUT/OPTIONS/NOTRACE  * 	SYS$SHARE:VAXCRTL/SHARE   * 	R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  *    */      /*  *  R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  *  I  *   Global section.  Include statements, defines, and global structures. 1  *   External routine. Error message definitions.   *  S  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=,   *    */   G /*	    -=*( Include statements for system-level libraries )*=-	      */   8 # include <smg$routines.h> /* smg$ calls and routines */9 # include <lib$routines.h> /* lib$ calls and routines  */ C # include <jpidef.h>	   /* used in retrieving process privileges */ > # include <smgdef.h>	   /* smg$ code and symbol definitions */7 # include <prvdef.h>	   /* privilege bit definitions */   O /* The "QUIDEF.H" is required here because the VMS 5.5 headers have not been */ O /* made available yet.  The quidef.h here is constructed from the MACRO lib- */ O /* rary.  It should be replaced as soon as possible with the actual system   */ , /* library.	BLC   April 14, 1992					     */  A # include "quidef.h"	   /* getqui instruction code definitions */   > # include <jbcmsgdef.h>    /* job control code jdefinitions */= # include <descrip.h>	   /* string descriptors definitions */ : # include <sjcdef.h>	   /* send job control definitions */> # include <ssdef.h>	   /* system service definitions -- blc */F # include <libclidef.h>    /* used to trap ctrl-y and ctrl-t -- blc */B # include <lnmdef.h>	   /* used to define the stuff for $TRNLNM */B # include "list.h"	   /* used for linked list management -- blc */  P /*  -=*( ENDLIST is used to terminate an itemlist used in system calls )*=-   */  L # define ENDLIST(list)	*(int *)&list[sizeof(list) / sizeof(list[0]) - 1] = 0  E /*                 -=*( Defines for the protection bits)*=-		      */    # define PRO$M_READ 1  # define PRO$M_WRITE 2 # define PRO$M_EXECUTE 4 # define PRO$M_DELETE 8   P /*     -=*( Define which determines the required rights identifier )*=-       */   #define rid_str "QUEMON"r /*                           -=*( CALL macro )*=-			      *//*		       -=*( Global variable section )*=-		      */  > #define call(status) 	{if (!(status & 1)) lib$signal(status);}    < 	int		num_ques = 0,	   /* number of ques on entire system */B 		        JOBWINDSIZE= 8,	   /* Size of the DISPLAY_JOB window  */: 		        QUEROWS= 17,	   /* Size of queue window	      */2 			term;		   /* smg$ read_keystroke variable    */  9 	long		keyboard,	   /* global smg$ main variables      */ 	 			title,  			display,  			program_title,  			pasteboard;  : 	struct		que_info	 /* information stored for each queue */ 	{1 	  char	name[30],		/* Name of the queue		      */ 3 		form[30],		/* Mounted form for the queue	      */ 7 		device[30],		/* Associated device for the queue    */ 7 		status[15],		/* Queue's status                     */ 4 		job_count[4],		/* Number of jobs enqueued	      */; 		block_count[6]; 	/* Disk blocks used by enqueued jobs  */  	};   / 	struct cli$ctrl_fields controls, old_controls;   = 	struct listnode que_list, que_line_list, que_line_desc_list;    	union prvdef privis;  	char nodename[12]; 7 	globalvalue long que_mon_nooper, que_mon_scrntoosmall;   < 	struct		qui_item     /* itemlist used in sys$getqui call */ 	{8 	  short buflen; 	/* size of buffer to return item in */2 	  short itemcode;	/* which item to return 	    */1 	  char *buffer; 	/* where to return item 	    */ 7 	  long *retlen; 	/* where to return item length	    */  	} ;           struct iosb_block  	{ 	  unsigned long status; 	  short reserved; 	};   > /*                        -=*( Forward Routine )*=-			      */   chk_prot(char);  show_queues(char, int); 6 extern long int   scroll_view (unsigned long *, long);     main()   /*  *  R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  *    * Routine:	main()  .  * Authors:	Baron L. Chandler, Brian Dickerson7  * Date:	December 9, 1991  (Last update: April 5, 1992)   *    * Functional Description:  *  A  * 	This routine receives control from the system when QUE_MON is :  * 	executed.  It sets up the main display and handles theC  * 	queue manipulation and selection.  It determines the privileges ;  * 	of the executing process and allows or disallows access /  * 	according to a specific right or privilege.   *    * Formal Parameters:   *  	  * 	None.   *    * Implicit Inputs:   *  <  * 	Screen variables, lists for queue information, keyboard,  * 	miscellaneous constants.  *    * Calling Sequence:  *    * 	None necessary.   *    * Returns:   *    * 	SS$_NORMAL.   *  R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  *    */      /*  *  
  * 	main()  *    */    {   7 	char		line[80];	/* used for the header string	      */   $ 	struct		dsc$descriptor_s	line_desc;  ) 	struct		qui_item 	itmlst[2],translst[2];     	struct		que_info	*que_ptr, que;  5 	int necess_priv,	/* Necessary ID to do all stuff? */ = 	    delay=10,		/* length of delay between display updates */ * 	    current_row,	/* Current cursor row */# 	    numrows,		/* Number of rows */ ; 	    que_id = 0,		/* numeric id of the queue in the list */ 4 	    status,		/* used for general status purposes */, 	    lines;		/* Number of lines to scroll */   	void	*temp;  > 	short nodelen;		/* Receives length of SYS$NODE translation */    + 	$DESCRIPTOR(label_bord, " Print Queues "); $ 	$DESCRIPTOR(title_prog, "QUE_MON");' 	$DESCRIPTOR(table_name, "LNM$SYSTEM"); # 	$DESCRIPTOR(node_log, "SYS$NODE");   B   /* Set up to get the name of the node by translating SYS$NODE */     translst[0].buflen  =  255; %   translst[0].itemcode = LNM$_STRING; "   translst[0].buffer  = &nodename;!   translst[0].retlen  = &nodelen;       ENDLIST(translst);  #   /* Check the user's privileges */   A   lib$getjpi(&JPI$_PROCPRIV,0,0,&privis);	/* Get process privs */ <   /* See if user has either OPER or the QUEMON identifier */:   if ((privis.prv$v_oper != 1) && (!possess_id(rid_str))) 9        sys$exit(que_mon_nooper);	/* Neither, then exit */    if (privis.prv$v_oper == 1) 2 	necess_priv = 1;		/* Fully functioning program */   else1 	necess_priv = 0;		/* Start and stop only	     */      /* Determine node name */   6   sys$trnlnm(0, &table_name, &node_log, 0, &translst);4   nodename[nodelen-2] = 0;	/* -2 to get rid of :: */    E /*	     -=*( Deactivate the CTRL-Y and CTRL-T functions )*=-	      */      controls.lib$v_cli_ctrlt = 1;    controls.lib$v_cli_ctrly = 1; .   lib$disable_ctrl(&controls, &old_controls);   7 /*		      -=*( Zero out our global lists )*=-		      */        create_list(&que_list);       create_list(&que_line_list);%     create_list(&que_line_desc_list);   P /*    -=*( Create the pasteboard, keyboard, and main display; paste. )*=-     */  8   call(smg$create_pasteboard(&pasteboard, 0, &numrows));   if (numrows < 24) %       sys$exit(que_mon_scrntoosmall); 1   call(smg$begin_pasteboard_update(&pasteboard));    QUEROWS = numrows -7;    JOBWINDSIZE = QUEROWS/2;/   call(smg$create_virtual_keyboard(&keyboard)); G   call(smg$create_virtual_display(&255, &78, &display, &SMG$M_BORDER)); C   call(smg$create_virtual_display(&1, &78, &title, &SMG$M_BORDER)); =   call(smg$create_viewport(&display, &1, &1, &QUEROWS, &78)); <   call(smg$create_virtual_display(&2, &78, &program_title));U   call(smg$put_chars_highwide(&program_title, &title_prog, &1, &32, 0, &SMG$M_BOLD));   G   call(smg$paste_virtual_display(&program_title, &pasteboard, &1, &2)); A   call(smg$paste_virtual_display(&display, &pasteboard, &7, &2)); ?   call(smg$paste_virtual_display(&title, &pasteboard, &5, &2)); <   call(smg$set_cursor_mode(&pasteboard, &SMG$M_CURSOR_OFF));  I /*	 -=*( Set up the header line and paste it on the display (*=-	      */      strcpy(line, " Queue Name");"   strins(line, "Device Name", 17);    strins(line, "Form Name", 35);   strins(line, "Status", 53);    strins(line, "Jobs", 64);    strins(line, "Blocks", 72);   (   line_desc.dsc$w_length = strlen(line);"   line_desc.dsc$a_pointer = &line;(   line_desc.dsc$b_class = DSC$K_CLASS_S;(   line_desc.dsc$b_dtype = DSC$K_DTYPE_T;  I   call(smg$label_border(&title, &label_bord, &SMG$K_TOP,0, &SMG$M_BOLD)); 8   call(smg$put_chars(&title, &line_desc, &1, &1, 0, 0));/   call(smg$end_pasteboard_update(&pasteboard));   E /*	     -=*( Seek out all known queues and display them )*=-	      */      show_queues('r', que_id);   9 /*		   -=*( Get a keypress and take action )*=-		      */   B   while ((term != SMG$K_TRM_CTRLZ) && (term != SMG$K_TRM_CTRLC) && 	 (term != SMG$K_TRM_CTRLY))   {   4     temp = get_element(&que_line_desc_list, que_id);+     current_row = smg$cursor_row(&display); L     call(smg$put_chars(&display, temp, &current_row, &1,0, &SMG$M_REVERSE));9     call(smg$set_cursor_abs(&display, &current_row, &1));   =     status = smg$read_keystroke(&keyboard, &term, 0, &delay);   7     if ((status != SS$_NORMAL) && (status != SMG$_EOF))        show_queues('r', que_id);   4     temp = get_element(&que_line_desc_list, que_id);+     current_row = smg$cursor_row(&display); K     call(smg$put_chars(&display, temp, &current_row, &1,0, &SMG$M_NORMAL)); 9     call(smg$set_cursor_abs(&display, &current_row, &1));   &     lines = 0;				   /* Prev screen */  '     if (term == SMG$K_TRM_PREV_SCREEN)         lines = -QUEROWS;      elseD     if (term == SMG$K_TRM_NEXT_SCREEN) 	/* -=* ( NEXT SCREEN )*=- */       lines = QUEROWS;     else     if (term == SMG$K_TRM_UP)        lines = -1;      else<     if (term == SMG$K_TRM_DOWN) 		/* -=*( DOWN ARROW )*=- */       lines = 1;*     else					/* -=*( X: STOP QUEUE )*=- */,     if ((term == SMG$K_TRM_UPPERCASE_X)   ||" 	 (term == SMG$K_TRM_LOWERCASE_X))     { /       que_ptr = get_element(&que_list, que_id);        que     = *que_ptr; 2       if (verify(&"STOP\0", &"queue\0", que.name))       {   *       itmlst[0].buflen = strlen(que.name);&       itmlst[0].itemcode = SJC$_QUEUE;#       itmlst[0].buffer = &que.name;        itmlst[0].retlen = 0;          ENDLIST(itmlst);  -       /* -=*( Stop the selected queue )*=- */   @       call(sys$sndjbc(0, SJC$_STOP_QUEUE, 0, &itmlst, 0, 0, 0));       show_queues('r', que_id);        }      } ,     else					 /* -=*( S: START QUEUE )*=- */*     if ((term == SMG$K_TRM_UPPERCASE_S) ||! 	(term == SMG$K_TRM_LOWERCASE_S))      { /       que_ptr = get_element(&que_list, que_id);        que     = *que_ptr; 3       if (verify(&"START\0", &"queue\0", que.name))        { *       itmlst[0].buflen = strlen(que.name);&       itmlst[0].itemcode = SJC$_QUEUE;#       itmlst[0].buffer = &que.name;        itmlst[0].retlen = 0;          ENDLIST(itmlst);  %       /* -=*( Start the queue )*=- */   A       call(sys$sndjbc(0, SJC$_START_QUEUE, 0, &itmlst, 0, 0, 0));        show_queues('r', que_id);        }      }      elseI     if ((term == SMG$K_TRM_UPPERCASE_P) ||	/* -=*( P: PAUSE QUEUE )*=- */ ! 	(term == SMG$K_TRM_LOWERCASE_P))      {   B       if (!necess_priv) nopriv();		/* Must have OPER to do this */       else         { /       que_ptr = get_element(&que_list, que_id);        que     = *que_ptr; 3       if (verify(&"PAUSE\0", &"queue\0", que.name))        { *       itmlst[0].buflen = strlen(que.name);&       itmlst[0].itemcode = SJC$_QUEUE;#       itmlst[0].buffer = &que.name;        itmlst[0].retlen = 0;          ENDLIST(itmlst);  %       /* -=*( Pause the queue )*=- */   A       call(sys$sndjbc(0, SJC$_PAUSE_QUEUE, 0, &itmlst, 0, 0, 0));        show_queues('r', que_id);        }      }      } +     else					/* -=*( R: RESET QUEUE )*=- */ *     if ((term == SMG$K_TRM_UPPERCASE_R) ||! 	(term == SMG$K_TRM_LOWERCASE_R))      { ?       if (!necess_priv) nopriv();	/* Must have OPER for this */ 
       else       { /       que_ptr = get_element(&que_list, que_id);        que     = *que_ptr; 3       if (verify(&"RESET\0", &"queue\0", que.name))        { *       itmlst[0].buflen = strlen(que.name);&       itmlst[0].itemcode = SJC$_QUEUE;#       itmlst[0].buffer = &que.name;        itmlst[0].retlen = 0;          ENDLIST(itmlst);  #       /* -=*( Reset the que )*=- */   A       call(sys$sndjbc(0, SJC$_RESET_QUEUE, 0, &itmlst, 0, 0, 0));        show_queues('r', que_id);        }      }      } '     else				/* -=*( H: HELP ME! )*=- */ *     if ((term == SMG$K_TRM_UPPERCASE_H) ||# 	(term == SMG$K_TRM_LOWERCASE_H) ||  	(term == SMG$K_TRM_HELP))     {        help_screen();       show_queues('r', que_id);      }      elseC     if (term == SMG$K_TRM_CR)		/* -=*( RETURN: DISPLAY JOBS )*=- */      {   4     if (!necess_priv) nopriv();		/* Requires OPER */     else     {   7       /* -=*( display all the jobs for that que )*=- */   /       que_ptr = get_element(&que_list, que_id);        que     = *que_ptr; P       call(smg$label_border(&title, &label_bord, &SMG$K_TOP, 0, &SMG$M_NORMAL));&       term = display_jobs(que_id,que);M       call(smg$label_border(&title, &label_bord, &SMG$K_TOP,0, &SMG$M_BOLD));        show_queues('r', que_id);      }      }      else  *     if ((term == SMG$K_TRM_UPPERCASE_I) ||D 	(term == SMG$K_TRM_LOWERCASE_I)) 	/* -=*( I: SHOW QUEUE INFO)*=- */     {   G       /* -=*( display all important information about the queue )*=- */   P       call(smg$label_border(&title, &label_bord, &SMG$K_TOP, 0, &SMG$M_NORMAL));'       term = show_detail_queue(que_id); M       call(smg$label_border(&title, &label_bord, &SMG$K_TOP,0, &SMG$M_BOLD));        show_queues('r', que_id);      }      elseF     if (term == SMG$K_TRM_CTRLW)	/* -=*( CTRL-W: REDRAW SCREEN )*=- */     { # 	/* -=*( Re-draw the screen )*=- */   ! 	smg$repaint_screen(&pasteboard);      }        if (lines) {#       scroll_view(&display, lines); *       que_id=smg$cursor_row(&display) - 1;6       temp = get_element(&que_line_desc_list, que_id);       current_row=que_id+1; O       call(smg$put_chars(&display, temp, &current_row, &1, 0, &SMG$M_REVERSE));      }      }     F /*	    -=*( User must have hit CTRL-Z so we can now exit )*=-	      */  1   call(smg$begin_pasteboard_update(&pasteboard)); *   call(smg$erase_pasteboard(&pasteboard));-   call(smg$delete_virtual_display(&display)); +   call(smg$delete_virtual_display(&title)); 3   call(smg$delete_virtual_display(&program_title)); /   call(smg$end_pasteboard_update(&pasteboard));   D /*	       -=*( Restore the CTRL-Y and CTRL-T functions )*=-	      */  !   lib$enable_ctrl(&old_controls);    }   P /******************************************************************************/ /*									      */ , /*			 End of main program QUE_MON			      */ /*									      */ P /******************************************************************************/  % show_queues(char command, int que_id)    /*  * AR  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  * n  * Routine:  	show_queuese  * Author:	Brian Dickerson.  * Modified:	Baron L. Chandler (April 5, 1992)  * Date:	December 9, 1991W  * n  * Functional Description:  * d>  * 	Show_Queues finds all queues on the system and determines <  * 	status, form name, device, and the number of jobs within=  * 	it.  It then inserts this information into a linked list.D?  * 	Upon inserting the data in the list, the data are displayed.:  * 	on the screen in the context of the screen management.  * m  * Formal Parameters:c  * v1  * 	command		A character describing the routine'so%  * 			function.  A function code of Ra&  * 			indicates to recalculate before *  * 			displaying the information (code D).  * o0  *  	que_id		The number of the queue about which&  * 			you wish to display information.  * 	  * Implicit Inputs:	  *  <  * 	The standard stuff...  Displays, keyboards, queue lists,  * 	etc.  * L  * Calling Sequence:  *  "  * 	key=show_queues("R",queuenum);  * t  * Returns:a  * I;  * 	The key pressed to close the associated window and exite  * 	the routine.  * yR  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  * i  */t     /*  * t  * 	show_queues()   * 	  */   i {n  E 	static char	search_name = '*';          /* wildcard search char   */	  6 	struct que_info que;	    /* info for one queue     */  6 	char		que_name[30],		    /* queue name buffer      *// 			form_name[30],		    /* mounted form	      */=4 			device_name[30],	    /* associated device      */- 			num[4], 		    /* number of jobs enqueue */=1 			num_pend[6],		    /* blocks of pending jobs */d2 			que_line[80],		    /* line of text about que */2 			node_name[7];		    /* node where queue is    */  ; 	long		pend_job_count = 0,	   /* num of pending jobs     */=9 			pend_block_count = 0,	   /* num of pending blocks   */t7 			exec_job_count = 0,	   /* num of executing jobs   */n8 			total_job_count = 0,	   /* total number of jobs    */5 			blocks_total = 0,	   /* total number of blocks  */ 9 			blocks_completed = 0,	   /* num of blocks completed */l# 			i = 0,			   /* counter		      */s' 			row=0,			   /* row location	      */l' 			jflags= QUI$M_SEARCH_EXECUTING_JOBS,t  			qflags=QUI$M_SEARCH_ALL_JOBS,
 			num_lines;c  9 	struct		queue_status	que_stat;  /* queue status	      */ 7 	struct		queue_flags	que_flag;  /* queue flags	      */-  % 	struct		dsc$descriptor_s	count_desc,s 						que_line_desc; 	struct 		listnode 		*temp;b   	struct		iosb_block   iosb;   4 	struct		qui_item     que_itmlst[12], job_itmlst[3];  /         short		que_lengths[12], job_lengths[3];/  ( 	$DESCRIPTOR(log_name_desc,"SYS$PRINT");    ; /*		  -=*( Set up item list for $getqui call )*=-		      */      if (command == 'r')    {o    G /*	    -=*( Set up linked lists for the queue information )*=-	      */        destroy_list(&que_list);!     destroy_list(&que_line_list); &     destroy_list(&que_line_desc_list);       que_itmlst[0].buflen = 1;/.     que_itmlst[0].itemcode = QUI$_SEARCH_NAME;C     que_itmlst[0].buffer = &search_name;	/* a wildcard * is used */l     que_itmlst[0].retlen = 0;        que_itmlst[1].buflen = 31;-     que_itmlst[1].itemcode = QUI$_QUEUE_NAME;0%     que_itmlst[1].buffer = &que_name; +     que_itmlst[1].retlen = &que_lengths[1];e       que_itmlst[2].buflen = 4;I.     que_itmlst[2].itemcode = QUI$_QUEUE_FLAGS;%     que_itmlst[2].buffer = &que_flag;t     que_itmlst[2].retlen = 0;n       que_itmlst[3].buflen = 4;i4     que_itmlst[3].itemcode = QUI$_PENDING_JOB_COUNT;+     que_itmlst[3].buffer = &pend_job_count;v     que_itmlst[3].retlen = 0;        que_itmlst[4].buflen = 4;a6     que_itmlst[4].itemcode = QUI$_EXECUTING_JOB_COUNT;+     que_itmlst[4].buffer = &exec_job_count;      que_itmlst[4].retlen = 0;e       que_itmlst[5].buflen = 4;	/     que_itmlst[5].itemcode = QUI$_QUEUE_STATUS; %     que_itmlst[5].buffer = &que_stat;r     que_itmlst[5].retlen = 0;y       que_itmlst[6].buflen = 4;i:     que_itmlst[6].itemcode = QUI$_PENDING_JOB_BLOCK_COUNT;-     que_itmlst[6].buffer = &pend_block_count;m     que_itmlst[6].retlen = 0;        que_itmlst[7].buflen = 31;,     que_itmlst[7].itemcode = QUI$_FORM_NAME;&     que_itmlst[7].buffer = &form_name;+     que_itmlst[7].retlen = &que_lengths[7];        que_itmlst[8].buflen = 31;.     que_itmlst[8].itemcode = QUI$_DEVICE_NAME;(     que_itmlst[8].buffer = &device_name;+     que_itmlst[8].retlen = &que_lengths[8];        que_itmlst[9].buflen = 6;e/     que_itmlst[9].itemcode = QUI$_SCSNODE_NAME;q&     que_itmlst[9].buffer = &node_name;+     que_itmlst[9].retlen = &que_lengths[9];e       que_itmlst[10].buflen = 4;0     que_itmlst[10].itemcode = QUI$_SEARCH_FLAGS;$     que_itmlst[10].buffer = &qflags;     que_itmlst[10].retlen = 0;  5     ENDLIST(que_itmlst);			/* Terminate item list. *//       job_itmlst[0].buflen = 4; /     job_itmlst[0].itemcode = QUI$_SEARCH_FLAGS; #     job_itmlst[0].buffer = &jflags;i     job_itmlst[0].retlen = 0;        job_itmlst[1].buflen = 4;s+     job_itmlst[1].itemcode = QUI$_JOB_SIZE; )     job_itmlst[1].buffer = &blocks_total;u     job_itmlst[1].retlen = 0;t       ENDLIST(job_itmlst);    D     call(sys$getquiw(0,QUI$_DISPLAY_QUEUE,0,&que_itmlst,&iosb,0,0));  )     while (iosb.status != JBC$_NOMOREQUE)=     {=*       if (que_flag.qui$v_queue_batch != 1)       {*  E /*	      -=*( Set up the que information and data lines )*=-	      */t  =    	que_name[que_lengths[1]] = form_name[que_lengths[7]] = 0;t?   	device_name[que_lengths[8]] = node_name[que_lengths[9]] = 0;t 	s 	strcpy(que.name, que_name);( 	strcpy(que.status, chk_stat(que_stat)); 	strcpy(que.form, form_name);i! 	strcpy(que.device, device_name);e  3 	total_job_count = pend_job_count + exec_job_count;r   	count_desc.dsc$w_length = 4; ! 	count_desc.dsc$a_pointer = &num; ( 	count_desc.dsc$b_class = DSC$K_CLASS_S;( 	count_desc.dsc$b_dtype = DSC$K_DTYPE_T;  - 	ots$cvt_l_tu(&total_job_count, &count_desc);kB 	num[0] = num[1]; num[1] = num[2]; num[2] = num[3]; num[3] = '\0'; 	strcpy(que.job_count, num);  E 	call(sys$getquiw(0, QUI$_DISPLAY_JOB, 0, &job_itmlst, &iosb, 0, 0));= 			      	count_desc.dsc$w_length = 6;=& 	count_desc.dsc$a_pointer = &num_pend;( 	count_desc.dsc$b_class = DSC$K_CLASS_S;( 	count_desc.dsc$b_dtype = DSC$K_DTYPE_T;  . 	ots$cvt_l_tu(&pend_block_count, &count_desc);6 	num_pend[0] = num_pend[1]; num_pend[1] = num_pend[2];6 	num_pend[2] = num_pend[3]; num_pend[3] = num_pend[4];/ 	num_pend[4] = num_pend[5]; num_pend[5] = '\0';n# 	strcpy(que.block_count, num_pend);*  - 	/* Star the name if it is not on our node */   <         if (!strncmp(nodename, node_name, strlen(nodename))) 	    strcpy(que_line, " \0");  	elses 	    strcpy(que_line, "*\0");t   	strcat(que_line, que.name);" 	strins(que_line, que.device, 17);  	strins(que_line, que.form, 35);" 	strins(que_line, que.status, 53);% 	strins(que_line, que.job_count, 65);i' 	strins(que_line, que.block_count, 73);"  9 /*		    -=*( Insert an element in the list )*=-		      */I    5 	temp =	insert_element(&que_list, &que, sizeof(que));   E 	temp = insert_element(&que_line_list, que_line, strlen(que_line)+1);   $ 	que_line_desc.dsc$a_pointer = temp;- 	que_line_desc.dsc$w_length = strlen(temp)+1;0+ 	que_line_desc.dsc$b_class = DSC$K_CLASS_S;t+ 	que_line_desc.dsc$b_dtype = DSC$K_DTYPE_T;   L 	insert_element(&que_line_desc_list, &que_line_desc, sizeof(que_line_desc));  % 	blocks_total = blocks_completed = 0;f 	i++;        }i  F       call(sys$getquiw(0,QUI$_DISPLAY_QUEUE,0,&que_itmlst,&iosb,0,0));     };     num_ques = i;x   }   +   call(smg$begin_display_update(&display));=     temp = &que_line_desc_list;    i = 0;   while (temp->next) {       temp = temp->next;       row = i+1;>       call(smg$put_chars(&display, (temp -> data), &row, &1));       i = i+ 1;e   }n     num_lines = num_ques;   9   call(smg$change_virtual_display(&display, &num_lines));-   row = que_id+1; /   call(smg$set_cursor_abs(&display, &row, &1));t)   call(smg$end_display_update(&display));t   }o  P /******************************************************************************/ /*									      */q- /*			 End of procedure SHOW_QUEUES			      */  /*									      */nP /******************************************************************************/     =1 int display_jobs(int que_id, struct que_info que)d   /*  * wR  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  * e  * Routine:	display_jobs  * Author:	Brian Dickerson*  * Modified:	Hunter Goatley (July 5, 1993)  * Date:	December 9, 1991a  *    * Functional Description:  * a?  * 	This routine is responsible for generating the list of jobsa=  * 	which are enqueued within the selected queue and present _7  * 	the user with the ability to view specifics or killc  * 	that print job.(  * 7  * Formal Parameters:   * s*  * 	Display jobs requires two parameters:   * ,9  * 	que_id		The numeric index of the queue whose contentss&  * 			are to be shown by this routine.  *  5  * 	que		The data record for the queue represented by 
  * 			que_id.a  * g  * Implicit Inputs:y  * l  * 	The display, keyboard, etc.l  * s  * Calling Sequence:  *  +  * 	key = display_jobs(queue, info[queue]);e  * l  * Returns:   *  4  * 	The key pressed by the user to exit this return.  * ;R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  * t  */,     {      	struct		job_info) 	{ 	  char	user[13];c 	  char	entry_number[4]; 	  long	id;= 	  char	blocks_size[6];s 	  char	name[40];l 	  struct job_status status; 	} job, *job_ptr;   > 	char	que_name[31], user_name[13], job_name[40], job_line[80],2 		*job_line_ptr, line[80], Job_label_bord_str[80];  ; 	long	entry_number, blocks_total, blocks_completed, status;l   	struct		iosb_block   iosb;t  A 	struct		qui_item     que_itmlst[3],job_itmlst[8], del_itmlst[2];   & 	short que_lengths[3], job_lengths[8];  0 	static	long		job_disp, job_title_disp,job_view;  = 	int	jflags = QUI$M_SEARCH_ALL_JOBS, i=0, num_jobs, job_id=0,S 		row, current_row, lines;  4 	struct	dsc$descriptor_s	count_desc, job_line_desc, # 					*job_line_desc_ptr, line_desc;n  A 	struct listnode job_list,job_line_list,job_line_desc_list,*temp;t  1 	$DESCRIPTOR(Job_label_bord, Job_label_bord_str);s      '   /*-=( Establish a QUEUE context )=-*/      que_itmlst[0].buflen = 1;r,   que_itmlst[0].itemcode = QUI$_SEARCH_NAME;   que_itmlst[0].buffer = "*";u   que_itmlst[0].retlen = 0;q     que_itmlst[1].buflen = 31;+   que_itmlst[1].itemcode = QUI$_QUEUE_NAME; #   que_itmlst[1].buffer = &que_name;p)   que_itmlst[1].retlen = &que_lengths[1];m     ENDLIST(que_itmlst);   /*-=( Job information )=-*/t     job_itmlst[0].buflen = 4;r-   job_itmlst[0].itemcode = QUI$_SEARCH_FLAGS;e!   job_itmlst[0].buffer = &jflags;R   job_itmlst[0].retlen = 0;Q     job_itmlst[1].buflen = 12;)   job_itmlst[1].itemcode = QUI$_USERNAME;C$   job_itmlst[1].buffer = &user_name;)   job_itmlst[1].retlen = &job_lengths[1];      job_itmlst[2].buflen = 4; -   job_itmlst[2].itemcode = QUI$_ENTRY_NUMBER;W'   job_itmlst[2].buffer = &entry_number;/   job_itmlst[2].retlen = 0;      job_itmlst[3].buflen = 39;)   job_itmlst[3].itemcode = QUI$_JOB_NAME;E#   job_itmlst[3].buffer = &job_name;m)   job_itmlst[3].retlen = &job_lengths[3];q     job_itmlst[4].buflen = 4;O)   job_itmlst[4].itemcode = QUI$_JOB_SIZE; '   job_itmlst[4].buffer = &blocks_total;    job_itmlst[4].retlen = 0;C     job_itmlst[5].buflen = 4;r1   job_itmlst[5].itemcode = QUI$_COMPLETED_BLOCKS; +   job_itmlst[5].buffer = &blocks_completed;s   job_itmlst[5].retlen = 0;      job_itmlst[6].buflen = 4;Q+   job_itmlst[6].itemcode = QUI$_JOB_STATUS;e%   job_itmlst[6].buffer = &job.status;    job_itmlst[6].retlen = 0;E     ENDLIST(job_itmlst);  H   call(sys$getquiw(0, QUI$_DISPLAY_QUEUE, 0, &que_itmlst, &iosb, 0, 0));G   while ((iosb.status != JBC$_NOMOREQUE) && (strcmp(que_name, que.name) 	 	  != 0))(J     call(sys$getquiw(0, QUI$_DISPLAY_QUEUE, 0, &que_itmlst, &iosb, 0, 0));       create_list(&job_list);l   create_list(&job_line_list);#   create_list(&job_line_desc_list);   F   call(sys$getquiw(0, QUI$_DISPLAY_JOB, 0, &job_itmlst, &iosb, 0, 0));L   while ((iosb.status != JBC$_NOMOREJOB) && (iosb.status != JBC$_NOSUCHJOB))   {,"     user_name[job_lengths[1]] = 0;!     job_name[job_lengths[3]] = 0; !     que_name[que_lengths[1]] = 0;P     strcpy(job.name, job_name);*      strcpy(job.user, user_name);     job.id = entry_number;        count_desc.dsc$w_length = 4;1     count_desc.dsc$a_pointer = &job.entry_number;u+     count_desc.dsc$b_class = DSC$K_CLASS_S; +     count_desc.dsc$b_dtype = DSC$K_DTYPE_T;U  -     ots$cvt_l_tu(&entry_number, &count_desc);t.     job.entry_number[0] = job.entry_number[1];.     job.entry_number[1] = job.entry_number[2];.     job.entry_number[2] = job.entry_number[3];     job.entry_number[3] = '\0';   3     blocks_total = blocks_total - blocks_completed;b        count_desc.dsc$w_length = 6;0     count_desc.dsc$a_pointer = &job.blocks_size;+     count_desc.dsc$b_class = DSC$K_CLASS_S; +     count_desc.dsc$b_dtype = DSC$K_DTYPE_T;T  -     ots$cvt_l_tu(&blocks_total, &count_desc);_,     job.blocks_size[0] = job.blocks_size[1];,     job.blocks_size[1] = job.blocks_size[2];,     job.blocks_size[2] = job.blocks_size[3];,     job.blocks_size[3] = job.blocks_size[4];,     job.blocks_size[4] = job.blocks_size[5];     job.blocks_size[5] = '\0';       strcpy(job_line, job.user);l#     strins(job_line, job.name, 14);t+     strins(job_line, job.entry_number, 44);.*     strins(job_line, job.blocks_size, 65);  9 /*		    -=*( Insert an element in the list )*=-		      */,    5 	temp =	insert_element(&job_list, &job, sizeof(job));e  E 	temp = insert_element(&job_line_list, job_line, strlen(job_line)+1);E  $ 	job_line_desc.dsc$a_pointer = temp;- 	job_line_desc.dsc$w_length = strlen(temp)+1;)+ 	job_line_desc.dsc$b_class = DSC$K_CLASS_S; + 	job_line_desc.dsc$b_dtype = DSC$K_DTYPE_T;i  L 	insert_element(&job_line_desc_list, &job_line_desc, sizeof(job_line_desc));     i++;  H     call(sys$getquiw(0, QUI$_DISPLAY_JOB, 0, &job_itmlst, &iosb, 0, 0));   } =   call(sys$getquiw(0, QUI$_CANCEL_OPERATION, 0, 0, 0, 0, 0));      num_jobs = i;e     if (num_jobs == 0 )i 	return SS$_NORMAL;      if (num_jobs > 0)s   {b8     strcpy(Job_label_bord_str, " Print Jobs in Queue ");*     strcat(Job_label_bord_str, &que_name);%     strcat(Job_label_bord_str, &" ");l=     Job_label_bord.dsc$w_length = strlen(Job_label_bord_str);,  J     call(smg$create_virtual_display(&255, &70, &job_disp, &SMG$M_BORDER));N     call(smg$create_virtual_display(&1, &70, &job_title_disp, &SMG$M_BORDER));X     call(smg$label_border(&job_title_disp, &Job_label_bord, &SMG$K_TOP, 0,&SMG$M_BOLD));       strcpy(line, "User Name");!     strins(line, "Job Name", 14);)%     strins(line, "Entry Number", 44);i#     strins(line, "Block Size", 60);t  *     line_desc.dsc$w_length = strlen(line);$     line_desc.dsc$a_pointer = &line;*     line_desc.dsc$b_class = DSC$K_CLASS_S;*     line_desc.dsc$b_dtype = DSC$K_DTYPE_T;  N     call(smg$put_chars(&job_title_disp, &line_desc, &1, &1, 0, SMG$M_NORMAL));D     call(smg$create_viewport(&job_disp, &1, &1, &JOBWINDSIZE, &70));;     call(smg$change_virtual_display(&job_disp, &num_jobs));eJ     call(smg$paste_virtual_display(&job_title_disp, &pasteboard, &9, &8));E     call(smg$paste_virtual_display(&job_disp, &pasteboard, &11, &8));        temp = &job_line_desc_list;r   i = 0;
   job_id = 0;w   while (temp->next) {       temp = temp->next;       row = i + 1;?       call(smg$put_chars(&job_disp, (temp -> data), &row, &1));s       i = i+ 1;_   }a  2   temp = get_element(&job_line_desc_list, job_id);   row = job_id + 1;lD   call(smg$put_chars(&job_disp, temp, &row, &1, 0, &SMG$M_REVERSE));  2     status = smg$read_keystroke(&keyboard, &term);F     if (term == SMG$K_TRM_CTRLW)	/* -=*( CTRL-W: REDRAW SCREEN )*=- */     { # 	/* -=*( Re-draw the screen )*=- */*  ! 	smg$repaint_screen(&pasteboard);*     }/  M     while ((term != SMG$K_TRM_UPPERCASE_Q) && (term != SMG$K_TRM_LOWERCASE_Q) 9 	    && (status != SMG$_EOF) && (term != SMG$K_TRM_CTRLY)*1 	    && (term != SMG$K_TRM_CTRLC) && (num_jobs) )r     {d       lines = 0;4     temp = get_element(&job_line_desc_list, job_id);,     current_row = smg$cursor_row(&job_disp);L     call(smg$put_chars(&job_disp, temp, &current_row, &1,0, &SMG$M_NORMAL));:     call(smg$set_cursor_abs(&job_disp, &current_row, &1));  &     if (term == SMG$K_TRM_PREV_SCREEN)       lines = -JOBWINDSIZE;h     elseD     if (term == SMG$K_TRM_NEXT_SCREEN) 	/* -=* ( NEXT SCREEN )*=- */       lines = JOBWINDSIZE;     else     if (term == SMG$K_TRM_UP)D       lines = -1;g     else<     if (term == SMG$K_TRM_DOWN) 		/* -=*( DOWN ARROW )*=- */       lines = 1;     elseL       if ((term == SMG$K_TRM_UPPERCASE_H) || (term == SMG$K_TRM_LOWERCASE_H)! 	  || (term == SMG$K_TRM_HELP)) {AU 	call(smg$label_border(&job_title_disp, &Job_label_bord,&SMG$K_TOP,0,&SMG$M_NORMAL));r 	term = help_screen();S 	call(smg$label_border(&job_title_disp, &Job_label_bord,&SMG$K_TOP,0,&SMG$M_BOLD));o       } 
       elseF       if ((term == SMG$K_TRM_CR) || (term == SMG$K_TRM_UPPERCASE_I) ||% 	  (term == SMG$K_TRM_LOWERCASE_I)) {cU 	call(smg$label_border(&job_title_disp, &Job_label_bord,&SMG$K_TOP,0,&SMG$M_NORMAL));s1         job_ptr = get_element(&job_list, job_id);h 	job = *job_ptr;  	term = show_detail_job(job.id);S 	call(smg$label_border(&job_title_disp, &Job_label_bord,&SMG$K_TOP,0,&SMG$M_BOLD));w       } 
       elseM       if ((term == SMG$K_TRM_UPPERCASE_D) || (term == SMG$K_TRM_LOWERCASE_D))*       {rU 	call(smg$label_border(&job_title_disp, &Job_label_bord,&SMG$K_TOP,0,&SMG$M_NORMAL));e- 	if (verify(&"DELETE\0", &"job\0", job.name))  	{  * 	job_ptr = get_element(&job_list, job_id); 	job = *job_ptr; 	del_itmlst[0].buflen = 4;, 	del_itmlst[0].itemcode = SJC$_ENTRY_NUMBER;  	del_itmlst[0].buffer = &job.id; 	del_itmlst[0].retlen = 0;   	ENDLIST(del_itmlst);   ? 	call(sys$sndjbc(0, SJC$_DELETE_JOB, 0, &del_itmlst, 0, 0, 0));o  . 	delete_element(&job_list, &job, sizeof(job));  4 	job_line_ptr = get_element(&job_line_list, job_id);  	strcpy(job_line, job_line_ptr);< 	delete_element(&job_line_list, job_line, strlen(job_line));  > 	job_line_desc_ptr = get_element(&job_line_desc_list, job_id);$ 	job_line_desc = *job_line_desc_ptr;L 	delete_element(&job_line_desc_list, &job_line_desc, sizeof(job_line_desc));  8 	/* Okay we've deleted the job, now lets fix our mess */   	num_jobs = num_jobs - 1;U 	if (num_jobs) {  + 	call(smg$begin_display_update(&job_disp));_$ 	call(smg$erase_display(&job_disp));   	if (job_id >= num_jobs) { 	    job_id = num_jobs-1;s 	    i = job_id-JOBWINDSIZE+2; 	    i = ( (i<1) ? 1 : i);A 	    call(smg$change_viewport(&job_disp, &i, 0, &JOBWINDSIZE,0));r 	}  8 	call(smg$change_virtual_display(&job_disp, &num_jobs));   	temp = &job_line_desc_list; 	i = 0;$ 	while (temp->next) {c 	      temp = temp->next;= 	      row = i + 1;o@ 	      call(smg$put_chars(&job_disp, (temp -> data), &row, &1)); 	      i = i+ 1; 	  }     	if (job_id>num_jobs)o 	    job_id = 0;  1 	temp = get_element(&job_line_desc_list, job_id);t 	row = job_id + 1;C 	call(smg$put_chars(&job_disp, temp, &row, &1, 0, &SMG$M_REVERSE));1  ) 	call(smg$end_display_update(&job_disp));N   	}   	}  S 	call(smg$label_border(&job_title_disp, &Job_label_bord,&SMG$K_TOP,0,&SMG$M_BOLD));n         }       = 	/* If we moved our viewport, let's physically move it now */_       if (lines) { 	scroll_view(&job_disp, lines);u& 	job_id=smg$cursor_row(&job_disp) - 1;1 	temp = get_element(&job_line_desc_list, job_id);. 	current_row=job_id+1;K 	call(smg$put_chars(&job_disp, temp, &current_row, &1, 0, &SMG$M_REVERSE));      }u       if (num_jobs) {i6       temp = get_element(&job_line_desc_list, job_id);       row = job_id + 1;=H       call(smg$put_chars(&job_disp, temp, &row, &1, 0, &SMG$M_REVERSE));     }4  O     if ( (term != SMG$K_TRM_CTRLY) && (term != SMG$K_TRM_CTRLC) && (num_jobs) )r1 	  status = smg$read_keystroke(&keyboard, &term);eF     if (term == SMG$K_TRM_CTRLW)	/* -=*( CTRL-W: REDRAW SCREEN )*=- */     {T& 	   /* -=*( Re-draw the screen )*=- */  ! 	smg$repaint_screen(&pasteboard);        }_    }  8   smg$pop_virtual_display(&job_title_disp, &pasteboard);2   smg$pop_virtual_display(&job_disp, &pasteboard);     }u     destroy_list(&job_list);   destroy_list(&job_line_list);n$   destroy_list(&job_line_desc_list);  7   return ((term == SMG$K_TRM_CTRLY) * SMG$K_TRM_CTRLY);    }t  P /******************************************************************************/ /*									      */E. /*			 End of procedure DISPLAY_JOBS			      */ /*									      */8P /******************************************************************************/     e /*  * CR  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  * g  * Routine:  show_detail_job  * Author:   Baron L. Chandler  * Date:     March 3, 1992  *    * Functional Description:  * ;P  * SHOW_DETAIL_JOB shows a detailed description of a specific job in a window on  * the screen.  * t  * Formal Parameters:   * _G  * 	entry_number:  A long word value passed by value which is the entrya)  * 		       number of the job to display.   * t  * Implicit Inputs:   * oF  * 	Miscellaneous constants, the pasteboard, and the virtual keyboard.  * t  * Calling Sequence:  * l'  *         term = show_detail_job(762);   * a  * Returns:w  * 	4  * 	The key pressed by the user to close the window.  * sR  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  * *  */*    " show_detail_job(long entry_number)   {    	struct		job_detail_info 	{   	  char  note[255],f 	      	user[16],s  	        queue_name[33],q 		file_name[255],d 	        account_name[10], 	      	blocks_size[8],u 	      	name[42];u 	  long	id, 	 		flags, a
 		copies,  		copies_done, n 		entry_number,  		blocks_total, 
 		file_id[8],l 		submission_time[4],o 		blocks_completed;r 	struct  job_status status;= 	} job;u             int time_len = 0;  	short int	job_lengths[14],$9 			file_lengths[2];		/* Array of words showing lengths */s   	struct		iosb_block   	iosb;  4 	struct		qui_item     file_itmlst[2],job_itmlst[13];   	static	long		about_job_disp;u 	long			status;;  C 	int	jflags = QUI$M_SEARCH_ALL_JOBS | QUI$M_SEARCH_FREEZE_CONTEXT |)! 			 QUI$M_SEARCH_WILDCARD, i = 0;g  $ 	struct	dsc$descriptor_s	count_desc;  < 	char line[80], about_Job_label_str[80], ascii_time_str[25];  3 	$DESCRIPTOR(about_Job_label, about_Job_label_str);c 	$DESCRIPTOR(line_desc, line);) 	$DESCRIPTOR(ascii_time, ascii_time_str);2   /* Job information */n     job_itmlst[0].buflen = 4;;-   job_itmlst[0].itemcode = QUI$_SEARCH_FLAGS;'!   job_itmlst[0].buffer = &jflags;n   job_itmlst[0].retlen = 0;i     job_itmlst[1].buflen = 4; .   job_itmlst[1].itemcode = QUI$_SEARCH_NUMBER;'   job_itmlst[1].buffer = &entry_number;    job_itmlst[1].retlen = 0;      job_itmlst[2].buflen = 4;u)   job_itmlst[2].itemcode = QUI$_JOB_SIZE;;+   job_itmlst[2].buffer = &job.blocks_total;u   job_itmlst[2].retlen = 0;r     job_itmlst[3].buflen = 39;)   job_itmlst[3].itemcode = QUI$_JOB_NAME;"#   job_itmlst[3].buffer = &job.name; )   job_itmlst[3].retlen = &job_lengths[3];t     job_itmlst[4].buflen = 12;)   job_itmlst[4].itemcode = QUI$_USERNAME;e#   job_itmlst[4].buffer = &job.user; )   job_itmlst[4].retlen = &job_lengths[4];q     job_itmlst[5].buflen = 4;l1   job_itmlst[5].itemcode = QUI$_COMPLETED_BLOCKS;A/   job_itmlst[5].buffer = &job.blocks_completed;T   job_itmlst[5].retlen = 0;n     job_itmlst[6].buflen = 4;z+   job_itmlst[6].itemcode = QUI$_JOB_STATUS;s%   job_itmlst[6].buffer = &job.status;    job_itmlst[6].retlen = 0;I     job_itmlst[7].buflen = 8;,-   job_itmlst[7].itemcode = QUI$_ACCOUNT_NAME;a+   job_itmlst[7].buffer = &job.account_name; )   job_itmlst[7].retlen = &job_lengths[7];h     job_itmlst[8].buflen = 4;=+   job_itmlst[8].itemcode = QUI$_JOB_COPIES;g%   job_itmlst[8].buffer = &job.copies;o   job_itmlst[8].retlen = 0;      job_itmlst[9].buflen = 4; 0   job_itmlst[9].itemcode = QUI$_JOB_COPIES_DONE;*   job_itmlst[9].buffer = &job.copies_done;   job_itmlst[9].retlen = 0;      job_itmlst[10].buflen = 31;d,   job_itmlst[10].itemcode = QUI$_QUEUE_NAME;*   job_itmlst[10].buffer = &job.queue_name;+   job_itmlst[10].retlen = &job_lengths[10];      job_itmlst[11].buflen = 8;1   job_itmlst[11].itemcode = QUI$_SUBMISSION_TIME;*1   job_itmlst[11].buffer = &job.submission_time;  *   job_itmlst[11].retlen = 0;     ENDLIST(job_itmlst);   /* File information */      file_itmlst[0].buflen = 255;4   file_itmlst[0].itemcode = QUI$_FILE_SPECIFICATION;)   file_itmlst[0].buffer = &job.file_name;D+   file_itmlst[0].retlen = &file_lengths[0];,  9   ENDLIST(file_itmlst);1  H   call(sys$getquiw(0, QUI$_DISPLAY_ENTRY, 0, &job_itmlst, &iosb, 0, 0));  I   if ((iosb.status != JBC$_NOMOREENT) && (iosb.status != JBC$_NOSUCHENT))d   {eJ     call(sys$getquiw(0, QUI$_DISPLAY_FILE, 0, &file_itmlst, &iosb, 0, 0));  @     /* -=*( Set the lengths of the string data correctly )*=- */    r"     job.user[job_lengths[4]] = 0; !     job.name[job_lengths[3]] = 0;e)     job.account_name[job_lengths[7]] = 0;y(     job.queue_name[job_lengths[10]] = 0;'     job.file_name[file_lengths[0]] = 0;	  #     if (!strlen(job.account_name)) *& 	strcpy(job.account_name, "<none>\0");  "     /* Create and Label Display */  /     strcpy(about_Job_label_str, " Print Job ");t+     strcat(about_Job_label_str, &job.name); &     strcat(about_Job_label_str, &" ");?     about_Job_label.dsc$w_length = strlen(about_Job_label_str);=  N     call(smg$create_virtual_display(&9, &70, &about_job_disp, &SMG$M_BORDER));Y     call(smg$label_border(&about_job_disp, &about_Job_label, &SMG$K_TOP, 0,&SMG$M_BOLD));o          /* Put info in display */   I     sprintf(line, "Job %s, submitted by user %s, account %s, ", job.name,_ 		job.user, job.account_name);*     line_desc.dsc$w_length = strlen(line);=     call(smg$put_chars(&about_job_disp, &line_desc, &2, &1));s  C     sprintf(line, "   currently %s on queue %s at block %d of %d.",o@ 	chk_job_stat(job.status), job.queue_name, job.blocks_completed, 	job.blocks_total); *     line_desc.dsc$w_length = strlen(line);=     call(smg$put_chars(&about_job_disp, &line_desc, &3, &1));$  ;     sprintf(line, "File specification: %s", job.file_name);t*     line_desc.dsc$w_length = strlen(line);=     call(smg$put_chars(&about_job_disp, &line_desc, &5, &1));b  K     call(lib$sys_asctim(&time_len, &ascii_time, &job.submission_time, &0)); !     ascii_time_str[time_len] = 0;u<     sprintf(line, "Time of Submission: %s", ascii_time_str);*     line_desc.dsc$w_length = strlen(line);=     call(smg$put_chars(&about_job_disp, &line_desc, &7, &1));U  J     call(smg$paste_virtual_display(&about_job_disp, &pasteboard, &8, &5));  2     status = smg$read_keystroke(&keyboard, &term);  %     while (term == SMG$K_TRM_CTRLW) {l  ! 	smg$repaint_screen(&pasteboard);Q/ 	status = smg$read_keystroke(&keyboard, &term);a         }_  :     smg$pop_virtual_display(&about_job_disp, &pasteboard);        }t  7   return ((term == SMG$K_TRM_CTRLY) * SMG$K_TRM_CTRLY);m   }   P /******************************************************************************/ /*									      */_6 /*		        End of procedure SHOW_DETAIL_JOB		      */ /*									      */lP /******************************************************************************/     /*  * tR  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  * u  * Routine:	show_detail_queuem  * Author:	Baron L. Chandler  * Date:     	March 8, 1992t  *    * Functional Description:  *  O  * SHOW_DETAIL_QUEUE retrieves information about the queue and displays it in a 
  * window.  * f  * Formal Parameters:s  * o>  * 	queue_number:  The number of the queue in the linked list.  * t  * Implicit Inputs:O  * TF  * 	Miscellaneous constants, the pasteboard, and the virtual keyboard,$  * 	the linked queue list variables.  * g  * Calling Sequence:  * E'  *         term = show_detail_queue(3);   * b  * Returns:C  * 	4  * 	The key pressed by the user to close the window.  * lR  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  * b  */)     show_detail_queue(int que_num)   {e   	struct		queue_detail_info 	{   	  char  default_form[32], 		default_stock[32], 		device_name[32], 		form_name[32], 		form_stock[32],) 		processor[40], 		description[255], 
 		node[7]; 	  long	limit,
 		protection,  		owner; 	struct  queue_status status;a 	struct  queue_flags flags; 	 	} queue;n           struct protect {    	    unsigned pro$v_system : 4;	 	    unsigned pro$v_owner: 4;	 	    unsigned pro$v_group: 4;	 	    unsigned pro$v_world: 4;	  ' 	    unsigned pro$v_system_enable : 4;	C& 	    unsigned pro$v_owner_enable : 4;	& 	    unsigned pro$v_group_enable : 4;	& 	    unsigned pro$v_world_enable : 4;	
 	} prot_mask;.           int time_len = 0;r& 	short int	queue_lengths[15], userlen;   	struct		iosb_block   iosb;_  ( 	struct		qui_item     	queue_itmlst[15];   	static	long		about_queue_disp;  	long			status, i=0, 				scratch, context;l  $ 	struct	dsc$descriptor_s	count_desc;  < 	char line[80], about_Queue_label_str[80], username_str[14];    	struct que_info		*que_ptr, que;  7 	$DESCRIPTOR(about_Queue_label, about_Queue_label_str);) 	$DESCRIPTOR(line_desc, line);% 	$DESCRIPTOR(username, username_str);] 	$DESCRIPTOR(faocntrl, "!%I");  - /* Information to retrieve about the queue */c  ,   que_ptr = get_element(&que_list, que_num);   que = *que_ptr;k  ,   queue_itmlst[0].buflen = strlen(que.name);.   queue_itmlst[0].itemcode = QUI$_SEARCH_NAME;%   queue_itmlst[0].buffer = &que.name;n   queue_itmlst[0].retlen = 0;      queue_itmlst[1].buflen = 31;4   queue_itmlst[1].itemcode = QUI$_DEFAULT_FORM_NAME;/   queue_itmlst[1].buffer = &queue.default_form;t-   queue_itmlst[1].retlen = &queue_lengths[1];t     queue_itmlst[2].buflen = 31;5   queue_itmlst[2].itemcode = QUI$_DEFAULT_FORM_STOCK; 0   queue_itmlst[2].buffer = &queue.default_stock;-   queue_itmlst[2].retlen = &queue_lengths[2];b     queue_itmlst[3].buflen = 31;/   queue_itmlst[3].itemcode = QUI$_DEVICE_NAME; o.   queue_itmlst[3].buffer = &queue.device_name;-   queue_itmlst[3].retlen = &queue_lengths[3];&     queue_itmlst[4].buflen = 31;/   queue_itmlst[4].itemcode = QUI$_FORM_NAME;   ,,   queue_itmlst[4].buffer = &queue.form_name;-   queue_itmlst[4].retlen = &queue_lengths[4];_     queue_itmlst[5].buflen = 31;/   queue_itmlst[5].itemcode = QUI$_FORM_STOCK;  c-   queue_itmlst[5].buffer = &queue.form_stock;J-   queue_itmlst[5].retlen = &queue_lengths[5];d     queue_itmlst[6].buflen = 4;r/   queue_itmlst[6].itemcode = QUI$_JOB_LIMIT;   2)   queue_itmlst[6].buffer = &queue.limit; a   queue_itmlst[6].retlen = 0;1     queue_itmlst[7].buflen = 4;R/   queue_itmlst[7].itemcode = QUI$_OWNER_UIC;   ,(   queue_itmlst[7].buffer = &queue.owner;   queue_itmlst[7].retlen = 0;N     queue_itmlst[8].buflen = 39;/   queue_itmlst[8].itemcode = QUI$_PROCESSOR;    ,   queue_itmlst[8].buffer = &queue.processor;-   queue_itmlst[8].retlen = &queue_lengths[8];d     queue_itmlst[9].buflen = 4;i-   queue_itmlst[9].itemcode = QUI$_PROTECTION;d&   queue_itmlst[9].buffer = &prot_mask;   queue_itmlst[9].retlen = 0;i      queue_itmlst[10].buflen = 255;5   queue_itmlst[10].itemcode = QUI$_QUEUE_DESCRIPTION; /   queue_itmlst[10].buffer = &queue.description;_/   queue_itmlst[10].retlen = &queue_lengths[10];s     queue_itmlst[11].buflen = 4;0   queue_itmlst[11].itemcode = QUI$_QUEUE_STATUS;*   queue_itmlst[11].buffer = &queue.status;   queue_itmlst[11].retlen = 0;     queue_itmlst[12].buflen = 6;0   queue_itmlst[12].itemcode = QUI$_SCSNODE_NAME;(   queue_itmlst[12].buffer = &queue.node;/   queue_itmlst[12].retlen = &queue_lengths[12];      queue_itmlst[13].buflen = 4;/   queue_itmlst[13].itemcode = QUI$_QUEUE_FLAGS;_,   queue_itmlst[13].buffer = &queue.flags;      queue_itmlst[13].retlen = 0;     ENDLIST(queue_itmlst);   J   call(sys$getquiw(0, QUI$_DISPLAY_QUEUE, 0, &queue_itmlst, &iosb, 0, 0));  K   if ((iosb.status != JBC$_NOSUCHQUE) && (iosb.status != JBC$_NOMOREQUE)) {t  ?                /* -=*( Determine the owner of the queue )*=- */E       context = 0;  @     call(sys$fao(&faocntrl, &userlen, &username, queue.owner));   @     /* -=*( Set the lengths of the string data correctly )*=- */        username_str[userlen] = 0;  -     queue.default_form[queue_lengths[1]] = 0; .     queue.default_stock[queue_lengths[2]] = 0;,     queue.device_name[queue_lengths[3]] = 0;*     queue.form_name[queue_lengths[4]] = 0;+     queue.form_stock[queue_lengths[5]] = 0; *     queue.processor[queue_lengths[8]] = 0;-     queue.description[queue_lengths[10]] = 0;m&     queue.node[queue_lengths[12]] = 0;  A             /* -=*( Set up the window and its information )*=- */=  3     strcpy(about_Queue_label_str, " Print Queue ");(-     strcat(about_Queue_label_str, &que.name);=(     strcat(about_Queue_label_str, &" ");C     about_Queue_label.dsc$w_length = strlen(about_Queue_label_str);   Q     call(smg$create_virtual_display(&11, &76, &about_queue_disp, &SMG$M_BORDER));l]     call(smg$label_border(&about_queue_disp, &about_Queue_label, &SMG$K_TOP, 0,&SMG$M_BOLD));_     D     sprintf(line, "%s queue %s, located on node %s, has %s status.", 		chk_queue_type(queue.flags), 		que.name,G
 		queue.node,E 		chk_stat(queue.status));*     line_desc.dsc$w_length = strlen(line);?     call(smg$put_chars(&about_queue_disp, &line_desc, &2, &1));   *     sprintf(line, "Associated device: %s", 		queue.device_name);t*     line_desc.dsc$w_length = strlen(line);?     call(smg$put_chars(&about_queue_disp, &line_desc, &4, &1));O  "     sprintf(line, "Processor: %s", 		queue.processor);U*     line_desc.dsc$w_length = strlen(line);@     call(smg$put_chars(&about_queue_disp, &line_desc, &4, &51));.     sprintf(line, "Current form/stock: %s/%s", 		queue.form_name, 		queue.form_stock);*     line_desc.dsc$w_length = strlen(line);?     call(smg$put_chars(&about_queue_disp, &line_desc, &5, &1));e  3     sprintf(line, "   Job limit: %d", queue.limit);b*     line_desc.dsc$w_length = strlen(line);@     call(smg$put_chars(&about_queue_disp, &line_desc, &5, &48));  .     sprintf(line, "Default form/stock: %s/%s", 		queue.default_form,b 		queue.default_stock);j*     line_desc.dsc$w_length = strlen(line);?     call(smg$put_chars(&about_queue_disp, &line_desc, &6, &1));b  :     sprintf(line, "Queue Protection: S:%s,O:%s,G:%s,W:%s",# 		chk_prot(prot_mask.pro$v_system),i" 		chk_prot(prot_mask.pro$v_owner)," 		chk_prot(prot_mask.pro$v_group),# 		chk_prot(prot_mask.pro$v_world));d*     line_desc.dsc$w_length = strlen(line);?     call(smg$put_chars(&about_queue_disp, &line_desc, &8, &1));i  5     sprintf(line, "Queue Owner: %s", username_str);  d*     line_desc.dsc$w_length = strlen(line);@     call(smg$put_chars(&about_queue_disp, &line_desc, &8, &49));  >     sprintf(line, "Queue Description: %s", queue.description);*     line_desc.dsc$w_length = strlen(line);@     call(smg$put_chars(&about_queue_disp, &line_desc, &10, &1));  M     call(smg$paste_virtual_display(&about_queue_disp, &pasteboard, &10, &3));+  2     status = smg$read_keystroke(&keyboard, &term);  %     while (term == SMG$K_TRM_CTRLW) {   ! 	smg$repaint_screen(&pasteboard);i/ 	status = smg$read_keystroke(&keyboard, &term);,         }   <     smg$pop_virtual_display(&about_queue_disp, &pasteboard);        }M  7   return ((term == SMG$K_TRM_CTRLY) * SMG$K_TRM_CTRLY);    }   P /******************************************************************************/ /*									      */ 8 /*		      End of procedure SHOW_DETAIL_QUEUE  		      */ /*									      */(P /******************************************************************************/ t /*  * _R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  * d  * Routine:	chk_prot  * Author:	Baron L. Chandler  * Date:	March 8, 1992  * i  * Functional Description:  * iF  * 	This procedure checks the four protection bits in a bit vector andA  * 	returns a string in the form of RWED, according to the bits		f  * 	not set in the vector.  * t  * Formal Parameters:   * uE  * 	protection_mask:  The bit vector of four bits (nybble) containing(1  * 			  the protection information for the queue.E  * =  * Implicit inputs:-  * eG  * 	The contsants PRO$M_READ, PRO$M_WRITE, PRO$M_EXECUTE, PRO$M_DELETE.   *    * Calling sequence:  * 	.  * 	system = chk_prot(prot_mask.pro$v_system);  * p  * Returns:,  * 	E  * 	Returns a character string in the form of RWED matching the bits e-  * 	which are not set in the protection mask.   * eR  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  * *  */* *   chk_prot(char prot_mask)   {*       char str[5];       strcpy(str, "\0");3     if (!(prot_mask & PRO$M_READ)) strcat(str,"R");84     if (!(prot_mask & PRO$M_WRITE)) strcat(str,"W");6     if (!(prot_mask & PRO$M_EXECUTE)) strcat(str,"E");5     if (!(prot_mask & PRO$M_DELETE)) strcat(str,"D");=       return (str);*   }* u /*  * oR  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  * o  * Routine:  	chk_queue_type  * Author:	Baron L. Chandler  * Date:	March 8, 1992  *    * Functional Description:  * *@  * 	This function processes the flag bits set and determines the  * 	queue type.l  * i  * Formal Parameters:   *  >  * 	queue_flags:  The longword bit vector containing the queue  * 		      flag data.s  * ,  * Implicit Inputs:t  * 	F  * 	Miscellaneous constants, the pasteboard, and the virtual keyboard.  * i  * Calling Sequence:  * r   * 	chk_queue_type(queue.flags);  * u  * Returns:t  * n8  * 	A character string describing the type of the queue.  * =R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  *    */s c  ( chk_queue_type(struct queue_flags flags)   {  	if (flags.qui$v_queue_generic)_ 	    return ("Generic");  	else 	if (flags.qui$v_queue_printer)	 	    return ("Printer"); 	else]  	if (flags.qui$v_queue_terminal) 	    return ("Terminal");	 	elseu 	return ("Print"); }  	& chk_stat(struct queue_status que_stat)   /*  * lR  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  * t  * Routine:	chk_stat  * Author:	Brian Dickerson  * Date:	December 9, 1991s  * s  * Functional Description:  * r>  * 	This checks the queue status bits and determines a textual+  * 	representation for status of the queue.j  *    * Formal Parameters:   * $  * 	A queue status bit vector.  * _  * Implicit Inputs:0  *  	  * 	None.$  * i  * Calling Sequence:  *    * 	chk_stat(queue.status);[  * a  * Returns:[  *  >  * 	The textual representation as a string terminated by a \0.  * lR  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  *    */_ l     {u      )   if (que_stat.qui$v_queue_aligning == 1)H     return("ALIGNING");.   else)   if (que_stat.qui$v_queue_resuming == 1)      return("RESUMING");4   else'   if (que_stat.qui$v_queue_closed == 1);     return("CLOSED");r   else(   if (que_stat.qui$v_queue_stopped == 1)     return("STOPPED");   else)   if (que_stat.qui$v_queue_stopping == 1)      return("STOPPING");&   else)   if (que_stat.qui$v_queue_starting == 1)      return("STARTING");3   else'   if (que_stat.qui$v_queue_paused == 1)      return("PAUSED");&   else(   if (que_stat.qui$v_queue_pausing == 1)     return("PAUSING");   else*   if (que_stat.qui$v_queue_resetting == 1)     return("RESETTING");   else%   if (que_stat.qui$v_queue_busy == 1)_     return("BUSY");_   else*   if (que_stat.qui$v_queue_undefined == 1)     return("UNDEFINED");   else)   if (que_stat.qui$v_queue_disabled == 1)o     return("DISABLED");    else,   if (que_stat.qui$v_queue_unavailable == 1)     return("UNAVAILABLE");   else%   if (que_stat.qui$v_queue_idle == 1)t     return("IDLE");    else-   if (que_stat.qui$v_queue_stop_pending == 1)Q     return("STOP-PEND");   else3   if (que_stat.qui$v_queue_autostart_inactive == 1)n     return("NO AUTO");   else(   if (que_stat.qui$v_queue_stalled == 1)     return("STALLED");   else     return("PRINTING");o }s  P /******************************************************************************/ /*									      */I+ /*			   End of function CHK_STAT			      */s /*									      */9P /******************************************************************************/     N( chk_job_stat(struct job_status job_stat)   /*  * oR  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  * ]  * Procedure:	chk_job_stat  * Author:		Baron L. Chandler   * Date:		April 5, 1992*  * o  * Functional Description:  * L>  * 	This routine analyzes a job statuts bit vector and returns,  * 	a textual representation of that status.  * L  * Formal Parameters:e  * 	'  * 	job_stat	The job status bit vector.m  * ]  * Implicit inputs:h  * ,	  * 	None.L  * i  * Calling Sequence:  * g&  * 	status = chk_job_stat(job.status);  *    * Returns:;  *    * 	The textual representation.T  * (R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  * l  */l       {0'   if (job_stat.qui$v_job_aborting == 1)t     return("ABORTING");)   else(   if (job_stat.qui$v_job_executing == 1)     return("EXECUTING");   else&   if (job_stat.qui$v_job_holding == 1)     return("HOLDING");   else&   if (job_stat.qui$v_job_pending == 1)     return("PENDING");   else&   if (job_stat.qui$v_job_refused == 1)     return("REFUSED");   else'   if (job_stat.qui$v_job_retained == 1)c     return("RETAINED");    else'   if (job_stat.qui$v_job_starting == 1)j     return("STARTING");o   else(   if (job_stat.qui$v_job_suspended == 1)     return("SUSPENDED");&   if (job_stat.qui$v_job_stalled == 1)     return("STALLED");   else)   if (job_stat.qui$v_job_incomplete == 1)l     return("INCOMPLETE");b   else)   if (job_stat.qui$v_job_completing == 1)      return("COMPLETING");*   else     return("*UNKNOWN*"); }iP /******************************************************************************/ /*									      */=+ /*			   End of function CHK_STAT			      */_ /*									      */ P /******************************************************************************/     j+ strins(char str_1[], char str_2[], int pos)k   /*  * ,R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  * s  * Routine:	strins  * Author:	Brian Dickerson  * Date:	December 9, 1991c  * :  * Functional Description:  * d>  * 	This function overlays a string onto another, starting at ?  * 	a specified location.  The overlayment will pad the string _  * 	with spaces if necessary.o  * e  * Formal Parameters:e  * t"  * 	str_1		The destination string.+  * 	str_2		The string to overlay onto str_1 0  * 	pos		The location within the string at which"  * 			to overlay str_2 into str_1.  *    * Implicit Inputs:l  * p	  * 	None.l  * l  * Calling Sequence:  * o  * 	strins(a,b,52);   * s  * Returns:e  * k!  * 	The modified string in str_1.t  * =R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  * &  */a   t {)   	int	i, 	 		blanks;m     blanks = pos - strlen(str_1);s   for (i = 0; i < blanks; i++)     strcat(str_1, " ");T   strcat(str_1, str_2);L     return(str_1); }*  P /******************************************************************************/ /*									      */ * /*			    End of function STRINS			      */ /*									      */ P /******************************************************************************/     int help_screen()=   /*  * =R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  * i  * Procedure:	help_screenL  * Author:	Brian Dickerson.  * Modified:	Baron L. Chandler (April 5, 1992)  * Date:	December 9, 1992r  * v  * Functional Description:  * dF  * 	This procedure provides the user with some assistance with respect?  * 	to the user-interface and what keys perform what functions.   * p  * Formal Parameters:*  * c	  * 	None.o  * t  * Implicit Inputs:d  * v#  * 	The display and keyboard stuff.e  *    * Calling Sequence:  * g  * 	help_screen();  *    * Returns:w  * i  * 	Nothing.  *  R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  * =  */= =   {=   	static long			help_disp;= 	char				string[80]; 	int				status;   % 	$DESCRIPTOR(help, " Command Help ");e" 	$DESCRIPTOR(string_desc, string);  H   call(smg$create_virtual_display(&17, &40, &help_disp, &SMG$M_BORDER));F   call(smg$label_border(&help_disp, &help, &SMG$K_TOP,0,&SMG$M_BOLD));D   call(smg$paste_virtual_display(&help_disp, &pasteboard, &6, &20));     strcpy(string, "QUEUES:");,   string_desc.dsc$w_length = strlen(string);M   call(smg$put_chars(&help_disp, &string_desc, &2, &2, 0, &SMG$M_UNDERLINE));    3   strcpy(string, "I:  Show detailed INFORMATION.");4,   string_desc.dsc$w_length = strlen(string);;   call(smg$put_chars(&help_disp, &string_desc, &3, &8, 0));_  5   strcpy(string, "P - PAUSE the highlited queue(P)");	,   string_desc.dsc$w_length = strlen(string);;   call(smg$put_chars(&help_disp, &string_desc, &4, &8, 0));c  5   strcpy(string, "R - RESET the highlited queue(P)"); ,   string_desc.dsc$w_length = strlen(string);;   call(smg$put_chars(&help_disp, &string_desc, &5, &8, 0));c  2   strcpy(string, "S - START the highlited queue");,   string_desc.dsc$w_length = strlen(string);;   call(smg$put_chars(&help_disp, &string_desc, &6, &8, 0));e  1   strcpy(string, "X - STOP the highlited queue");R,   string_desc.dsc$w_length = strlen(string);;   call(smg$put_chars(&help_disp, &string_desc, &7, &8, 0));c  7   strcpy(string, "[RET] -  VIEW contents of queue(P)");q,   string_desc.dsc$w_length = strlen(string);;   call(smg$put_chars(&help_disp, &string_desc, &8, &4, 0));     _   strcpy(string, "JOBS (P):");,   string_desc.dsc$w_length = strlen(string);N   call(smg$put_chars(&help_disp, &string_desc, &10, &2, 0, &SMG$M_UNDERLINE));  0   strcpy(string, "D - DELETE the selected job");,   string_desc.dsc$w_length = strlen(string);=   call(smg$put_chars(&help_disp, &string_desc, &11 , &8, 0));E  -   strcpy(string, "I - Detailed INFORMATION");u,   string_desc.dsc$w_length = strlen(string);<   call(smg$put_chars(&help_disp, &string_desc, &12, &8, 0));       strcpy(string, "GENERAL:");N,   string_desc.dsc$w_length = strlen(string);N   call(smg$put_chars(&help_disp, &string_desc, &14, &2, 0, &SMG$M_UNDERLINE));  2   strcpy(string, "CTRL-Z - Close current window");,   string_desc.dsc$w_length = strlen(string);<   call(smg$put_chars(&help_disp, &string_desc, &15, &4, 0));  .   strcpy(string, "CTRL-Y - Exit Immediately");,   string_desc.dsc$w_length = strlen(string);=   call(smg$put_chars(&help_disp, &string_desc, &16, &4, 0 ));_  /   status = smg$read_keystroke(&keyboard,&term);uE   if (term == SMG$K_TRM_CTRLW)		/* -=*( CTRL-W: REDRAW SCREEN )*=- */=   {u  (       /* -=*( Re-draw the screen )*=- */  ! 	smg$repaint_screen(&pasteboard);u     }l  /   call(smg$delete_virtual_display(&help_disp));t  A   if ( !((term == SMG$K_TRM_CTRLY) || (term == SMG$K_TRM_CTRLC)))_       status = term = 0;     return (term); }e  P /******************************************************************************/ /*									      */e- /*			 End of procedure HELP_SCREEN			      */  /*									      */oP /******************************************************************************/ l= verify(char *function[], char *object_type[], char *object[])]   /*  *  R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  * t  * Routine:	verify  * Author:	Baron L. Chandler  * Date:	January 28, 1992_  * t  * Functional Description:  * ;@  * 	VERIFY is a procedure which is used to remind the user that E  * 	this is a potentially dangerous situation and that he/she should d3  * 	make sure that they really wish to take action.q  * n  * Formal Parameters:]  * e3  * 	function	The function, in text form, to verify. .  * 	object_type	The object type, in text form.*  * 	object		The object name, in text form.  *    * Implicit Inputs:]  * e  * 	The screen, keyboard, etc.  *    * Calling Sequence:  * $1  * 	if (verify("DELETE","QUEUE","SYS$PRINT")) ...   * (  * Returns:!  * $(  * 	Boolean value:		1 = okay, 0 = abort.  *  R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  * ;  */    l     {o   	static long			verify_disp;, 	char				string[80];& 	int				status, width, center, curpos;  . 	$DESCRIPTOR(verify_label, " Are you sure? ");" 	$DESCRIPTOR(string_desc, string);  0   strcpy(string, "Are you sure you want to \0");   strcat(string, function);e   strcat(string, " the ");   strcat(string, object_type);   strcat(string, " ");   strcat(string, object);s   strcat(string, "? N");  ,   string_desc.dsc$w_length = strlen(string);     width = strlen(string) + 10;   center = 40 - width/2;  L   call(smg$create_virtual_display(&1, &width, &verify_disp, &SMG$M_BORDER));Q   call(smg$label_border(&verify_disp, &verify_label, &SMG$K_TOP,0, &SMG$M_BOLD));l  K   call(smg$paste_virtual_display(&verify_disp, &pasteboard, &14, &center));aA   call(smg$put_chars(&verify_disp, &string_desc, &1, &5, 0, 0 ));c     curpos = width -6;6   call(smg$set_cursor_abs(&verify_disp, &1, &curpos));  0   status = smg$read_keystroke(&keyboard, &term);   if (status == SMG$_EOF)D       status = term = 0;  G   if ((term==SMG$K_TRM_UPPERCASE_Y) || (term == SMG$K_TRM_LOWERCASE_Y))e   {a!     string_desc.dsc$w_length = 1;      strcpy(string,"Y");;A     call(smg$put_chars(&verify_disp, &string_desc, &1, &curpos));s   }u  ;   call(smg$pop_virtual_display(&verify_disp, &pasteboard));c  J   return ((term==SMG$K_TRM_UPPERCASE_Y) || (term==SMG$K_TRM_LOWERCASE_Y));   }e  P /******************************************************************************/ /*									      */,) /*			  End of function VERIFY 			      */_ /*									      */;P /******************************************************************************/   C   /*  * /R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  * r  * Routine:	possess_id  * Author:	Baron L. Chandler  * Date:	February 15, 1992  * i  * Functional Description:  * u?  * 	POSSESS_ID checks the rights of the current process for thes?  * 	presence of a right given by the caller.  It returns a 1 toiC  * 	indicate that the right is present in the caller's rights list,u0  * 	and a 0 to indicate the right was not found.  * (  * Formal Parameters:t  * s?  * 	id:	The rights identifier, the presence of which process_idQ  * 		is to determine.:  * %  * Implcit Inputs:  * _8  * 	Miscellaneous constants, defined in the header files  * _  * Calling sequence:  * ,&  * 	verify = possess_id("ACCOUNTING");  * i  * Returns:_  * h  * 	Single integer value:s  * t-  * 		0 = The calling process does not own thei  * 		    specified identifier.  * s/  * 		1 = The calling process owns the specified=  * 		    rights id.a  * gR  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  * i */ ,     int possess_id(char id[])d   {s    )     int		found	  = 0;			/* Found flag		*/a  9     unsigned long holder[2] = {0,0};		/* UIC of holder	*/p  2     unsigned long	check_id,		/* ID to check for	*/' 			own_id,			/* ID found by FIND_HELD*/r# 			attribs,		/* Attributes of id	*/t! 			context,		/* Search context	*/r! 			status;			/* Status of call	*/u  0     char	id_name[31];			/* Name of id to find	*/        $DESCRIPTOR (name, id_name);    @ 	/* Get the ID and translate it to its numeric representation */   	strcpy(id_name, id);T  	name.dsc$w_length = strlen(id);2 	status = sys$asctoid(&name, &check_id, &attribs);. 	if (status != SS$_NORMAL) lib$signal(status);      	/* Get the UIC of the caller */  & 	lib$getjpi(&JPI$_UIC, 0, 0, &holder);    > 	/* Loop through the list of identifiers held by the holder */= 	/* until we've found the one we want(found=1) or until	   */=0 	/* there are no more id's (SS$_NOSUCHID)		   */  G 	while (((status = sys$find_held(&holder, &own_id, &attribs, &context))F  			!= SS$_NOSUCHID) && (!found))   	  {/ 		if (status != SS$_NORMAL) lib$signal(status);e 		if (own_id == check_id)i 		    found = 1; 	  }  9      return found;		/* Return the status of the search */* }r  P /******************************************************************************/ /*									      */h? /*                        End of function POSSESS_ID			      */s /*									      */tP /******************************************************************************/ c /*  *    * Routine:	nopriv  * Author:	Baron L. Chandler  * Date:	April 5, 1992  * e  * Functional Description:  * o>  * 	This procedure displays a no privilege message so the user@  * 	knows that the particular operation required OPER privilege.  * =  * Formal Parameters:=  * =	  * 	None.*  * *  * Implicit Inputs:t  * )1  * 	Miscellaneous constants, displays, keyobards.;  *    * Calling Sequence:  * D  * 	if (!necess_priv) nopriv();r  * s  * Returns:T  * t  * 	Nothing.  *  R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  * s  */( ,     nopriv()   {n   	long 	privdisp, status; 	short	term;    E 	$DESCRIPTOR(uhoh, "No privilege.  Command requires OPER privilege");o# 	$DESCRIPTOR(privlabel, " Sorry ");t  E 	call(smg$create_virtual_display(&1, &56, &privdisp, &SMG$M_BORDER));iK 	call(smg$label_border(&privdisp, &privlabel, &SMG$K_TOP, 0, &SMG$M_BOLD));e  C 	call(smg$paste_virtual_display(&privdisp, &pasteboard, &14, &12));:5 	call(smg$put_chars(&privdisp, &uhoh, &1, &5, 0, 0));   6         status = smg$read_keystroke(&keyboard, &term);7 	call(smg$pop_virtual_display(&privdisp, &pasteboard));o  4 	return ((term==SMG$K_TRM_CTRLY) * SMG$K_TRM_CTRLY);   }e