/* matrix.c
 *
 * Functions for matrix operations
 */
#include "net3d.h"

/* when using gcc, these are defined inline in net3d.h */
#if (!defined(__GNUC__) || USEINLINES != 1)
/* multiplies a point by a matrix, storing the result in a point */
void mmult(struct point *p, float m[3][3], struct point *r)
{
r->x=p->x*m[0][0] + p->y*m[0][1] + p->z*m[0][2];
r->y=p->x*m[1][0] + p->y*m[1][1] + p->z*m[1][2];
r->z=p->x*m[2][0] + p->y*m[2][1] + p->z*m[2][2];
}

/* performs one axis of a matrix multiplication */
float cmult(struct point *p, float l[3])
{
return p->x*l[0] + p->y*l[1] + p->z*l[2];
}
#endif

/* dot product of two points */
float dotprod(struct point *a, struct point *b)
{
return a->x*b->x + a->y*b->y + a->z*b->z;
}

/* multiplies a point by a scalar */
void smult(float s, struct point *p)
{
p->x *= s;
p->y *= s;
p->z *= s;
}

/* normalises a point */
void normalise(struct point *p)
{
float mag;
mag=sqrt(p->x*p->x + p->y*p->y + p->z*p->z);
p->x /= mag;
p->y /= mag;
p->z /= mag;
}

