 /*9  *   xsnap -- take a snapshot of a portion of the screen.   *"  *   Copyright 1989 Clauss Strauch&  *                  cbs@cad.cs.cmu.edu  *J  *   Permission to use, copy, modify, and distribute this software and itsE  *   documentation for any purpose and without fee is hereby granted. L  *   This software is provided "as is", without express or implied warranty.  *    H  *   Modified by Hal Brand 04-May-1989 to use XImages instead of Pixmaps  */    #include <stdio.h>    
 #ifdef VMS #include "decw$include:Xlib.h" #include "decw$include:Xos.h"  #include "decw$include:Xutil.h" $ #include "decw$include:cursorfont.h" #else  #include <X11/Xlib.h>  #include <X11/Xos.h> #include <X11/Xutil.h> #include <X11/cursorfont.h>  #endif /*VMS*/   #ifndef TRUE #define TRUE 1 #endif  
 #ifndef FALSE  #define FALSE 0  #endif  @ /*  Leave arguments as globals, since there are so many of them.8  *  They'll only be referenced in process_args and main.  */   = char *display_string = NULL;         /* display we'll open */ O int  border_width = 2;               /* border_width  of the snapshot window */ N int  start_iconic = FALSE;           /* start snap window in iconic state?  */M char *color_name = NULL;             /* user-supplied name of border color */ F char *window_geom_string = NULL;     /* geometry of snapshot window */8 char *icon_geom_string = NULL;       /* icon geometry */E char *region_geom_string = NULL;     /* location of region to copy */ Q char *app_name = "xsnap";            /* name of application for window manager */ ; int grab_server = TRUE;              /* grab the server? */      /*H  *  create_event_window returns the ID of a InputOnly window that covers  *  the given window.   */   ; Window create_event_window(a_display,a_window, init_cursor)       Display *a_display;      Window a_window;  {    XSetWindowAttributes xswa;   unsigned long xswa_valuemask;    Window root_win;   Window event_window;%   unsigned int win_width, win_height; ,   unsigned int  win_border_width, win_depth;   int win_x, win_y;    '   /* get the geometry of the window  */    >   XGetGeometry(a_display, a_window, &root_win, &win_x, &win_y,@ 	       &win_width, &win_height, &win_border_width, &win_depth);   5   /* make an input only window to get events from  */       xswa.cursor = init_cursor;    xswa.override_redirect = True;L   xswa.event_mask = ButtonPressMask | ButtonReleaseMask | Button1MotionMask;?   xswa_valuemask = CWCursor | CWOverrideRedirect | CWEventMask; L   event_window = XCreateWindow(a_display, a_window, win_x, win_y, win_width,7 			       win_height, 0, 0, InputOnly, CopyFromParent,  ! 			       xswa_valuemask, &xswa);    return(event_window);  }    /*A  *   draw box draws a box on the given window, with the given GC    *  */   8 void draw_box(a_display, a_window, a_gc, x1, y1, x2, y2)
      GC a_gc;       Window a_window;       Display *a_display;      int x1, y1, x2, y2; {    XSegment segments[4];    segments[0].x1 = (short)x1;    segments[0].y1 = (short)y1;    segments[0].x2 = (short)x1;    segments[0].y2 = (short)y2;       segments[1].x1 = (short)x1;    segments[1].y1 = (short)y1;    segments[1].x2 = (short)x2;    segments[1].y2 = (short)y1;       segments[2].x1 = (short)x2;    segments[2].y1 = (short)y2;    segments[2].x2 = (short)x1;    segments[2].y2 = (short)y2;       segments[3].x1 = (short)x2;    segments[3].y1 = (short)y2;    segments[3].x2 = (short)x2;    segments[3].y2 = (short)y1;    8   XDrawSegments(a_display, a_window, a_gc, segments, 4); }    /*  *  get_region  * takes as input:
  *    display    *    window to get region from '  *    pointers to x1, y1, width, height   *  5  *   returns:  the position and width and height of a ;  *             user selected region via the given pointers.   *  */     5 get_region(a_display, a_window,  x, y, width, height)       Display *a_display;      Window a_window;       int *x, *y;"      unsigned int *height, *width; {    Window event_window;%   Cursor up_right_curs, up_left_curs; '   Cursor low_right_curs, low_left_curs;    Cursor current_cursor;   int done;    int init_x, init_y;    int last_x, last_y;    XEvent event;    GC xor_gc;@   XGCValues xor_gc_values;             /* for creating xor_gc */J   unsigned long xor_gc_valuemask;      /* valuemask for creating xor_gc */   *   /* make the GC and cursors we'll need */   <   up_right_curs = XCreateFontCursor(a_display, XC_ur_angle);   ;   up_left_curs = XCreateFontCursor(a_display, XC_ul_angle);    =   low_right_curs = XCreateFontCursor(a_display, XC_lr_angle);    <   low_left_curs = XCreateFontCursor(a_display, XC_ll_angle);         B   xor_gc_valuemask = GCFunction | GCSubwindowMode  | GCForeground;!   xor_gc_values.function = GXxor; "   xor_gc_values.foreground = 0xfd;2   xor_gc_values.subwindow_mode = IncludeInferiors;L   xor_gc = XCreateGC(a_display, a_window, xor_gc_valuemask, &xor_gc_values);   G   event_window = create_event_window(a_display, a_window,up_left_curs); &   XMapRaised(a_display, event_window);      2   if (XGrabPointer(a_display, event_window, True,  		   ButtonPressMask, 7 		   GrabModeAsync, GrabModeAsync, None, up_left_curs,   		   CurrentTime) != 0)      { .       fprintf(stderr, "Cannot grab pointer.");       exit(1);     }       %   /* get the initial button  press */    done = FALSE;    while (! done)     { $       XNextEvent(a_display, &event);       switch(event.type) 	{ 	case MappingNotify:# 	  XRefreshKeyboardMapping(&event); 	 	  break;  	case ButtonPress:! 	  if (event.xbutton.button == 1)  	    {  	      init_x = event.xbutton.x;  	      init_y = event.xbutton.y; 	        	        	      done = TRUE; 
 	      break;  	    } 	}     }       M   /*  now we have the location of one corner of the box.   change the cursor, *    *  and have the user drag out the area.    */ "   current_cursor = low_right_curs;   last_x = init_x;   last_y = init_y;L   XChangeActivePointerGrab(a_display, ButtonReleaseMask | Button1MotionMask,# 			   current_cursor, CurrentTime);    done = FALSE; H   draw_box(a_display, a_window, xor_gc, init_x, init_y, last_x, last_y);   while (! done)     { $       XNextEvent(a_display, &event);       switch(event.type) 	{ 	case MappingNotify:# 	  XRefreshKeyboardMapping(&event); 	 	  break;  	case MotionNotify: ) 	  draw_box(a_display, a_window, xor_gc,  6 		   init_x, init_y, last_x, last_y);  /* erase old */ 	  last_x = event.xmotion.x; 	  last_y = event.xmotion.y;) 	  draw_box(a_display, a_window, xor_gc,  5 		   init_x, init_y, last_x, last_y); /* draw new  */ < 	  /*  Change cursor to correspond to position of pointer */- 	  if ((init_x < last_x) && (init_y < last_y) - 	      && (current_cursor != low_right_curs))  	    {' 	      current_cursor = low_right_curs; + 	      XChangeActivePointerGrab(a_display,  1 				       ButtonReleaseMask | Button1MotionMask, ( 				       low_right_curs, CurrentTime); 	    }2 	  else if ((last_x < init_x) && (last_y < init_y)* 		   &&  (current_cursor != up_left_curs)) 	    {% 	      current_cursor = up_left_curs; + 	      XChangeActivePointerGrab(a_display,  1 				       ButtonReleaseMask | Button1MotionMask, & 				       up_left_curs, CurrentTime); 	    } 	   2 	  else if ((init_x < last_x) && (last_y < init_y)* 		   && (current_cursor != up_right_curs)) 	    {& 	      current_cursor = up_right_curs;+ 	      XChangeActivePointerGrab(a_display,  1 				       ButtonReleaseMask | Button1MotionMask, ' 				       up_right_curs, CurrentTime);  	        	    }2 	  else if ((last_x < init_x) && (init_y < last_y)* 		   && (current_cursor != low_left_curs)) 	    {& 	      current_cursor = low_left_curs;+ 	      XChangeActivePointerGrab(a_display,  1 				       ButtonReleaseMask | Button1MotionMask, ' 				       low_left_curs, CurrentTime);  	    } 	   	 	  break;  	case ButtonRelease:! 	  if (event.xbutton.button == 1)  	    { 	      done = TRUE; ! 	      /* erase last box drawn */ - 	      draw_box(a_display, a_window, xor_gc,  ) 		       init_x, init_y, last_x, last_y);  	    }	 	  break;  	}     } =   XFlush(a_display);   /*  gets rid of last box on screen  */ #   if (init_x < last_x) *x = init_x;    else *x = last_x; #   if (init_y < last_y) *y = init_y;    else *y = last_y;e.   *width = (unsigned int)abs(last_x - init_x);/   *height = (unsigned int)abs(last_y - init_y);o   /* clean up after ourself: */T   *   XDestroyWindow(a_display, event_window);   XFreeGC(a_display, xor_gc);    /   /* we'll let the caller ungrab the pointer */     }    /* a  *  get_image_region t  *  *       input :G  *               a display, a window, x, y, width, height, interactive.eC  *               if interactive, the user is prompted for a region, B  *               other wise the given region is copied to a Image.F  *       returns : an image containing a copy of a user-specified area'  *                 of the given window;n  *  */   D XImage *get_image_region(a_display, a_screen, a_window, a_gc, x, y,  			 width, height, interactive)c      Display *a_display;
      GC a_gc;r      int a_screen;      Window a_window;       int *x, *y;"      unsigned int *width, *height;      int interactive;s        {d   int reg_x, reg_y;o%   unsigned int reg_width, reg_height;n   XImage *image_returned;h   int return_flag;      if (interactive){p3     get_region(a_display, a_window, &reg_x, &reg_y,i! 	       &reg_width, &reg_height);h     *x = reg_x;r     *y = reg_y;g     *width = reg_width;o     *height = reg_height;_   }g   D   image_returned = XGetImage(a_display,DefaultRootWindow(a_display), 			     *x,*y,*width,*height,o 			     XAllPlanes(),ZPixmap);   ;   if (interactive)  XUngrabPointer(a_display, CurrentTime);*   return(image_returned);n }h     /*  /  *  X error handler for,  mainly for future usew  */*  & int my_X_error_handler(display, myerr)      Display *display;      XErrorEvent *myerr; {    char msg[80];         3   /* Print out the error string that X generates */e   4   XGetErrorText(display, myerr->error_code, msg,80);,   fprintf(stderr, "xsnap error: %s\n", msg);1   /* no way to continue, so we'll just bag it  */y
   exit(1); }t      /*%  *  print a usage message to the usert  */d   usage()i {w0   printf("%s\n", "Usage:  xsnap [-options...]");'   printf("%s\n", "Where options are:");hD   printf("%s\n", "[-display host:display]  Display to connect to.");=   printf("%s\n", "[-bd borderwidth]        Color of border"); =   printf("%s\n", "[-bw borderwidth]        Width of border");MI   printf("%s\n", "[-geometry geom]         Geometry of snapshot window"); ?   printf("%s\n", "[-icongeometry geom]     Location of icon.");yL   printf("%s\n", "[-region geom]           Region of screen to be copied.");F   printf("%s\n", "[-iconic]                Start up in iconic state");Z   printf("%s\n", "[-name name]             Passed to window manager for name of window.");_   printf("%s\n", "[-nograb]                Don't grab server during specification of region.");i
   exit(1); }t     /*A  *        get the arguments.   arguments are matched to the first1#  *        distinguishing substring.   */n process_args(argc, argv)      int argc;      char **argv;  {m   int i;      for (i = 1; i < argc; i++)     {))       if (strncmp(argv[i], "-h", 2) == 0)m 	{ 	  usage();r 	  continue; 	}/       if (strncmp(argv[i], "-display", 2) == 0)r 	{ 	  display_string = argv[++i]; 	  continue; 	}*       if (strncmp(argv[i], "-bw", 3) == 0) 	{" 	  border_width = atoi(argv[++i]); 	  continue; 	}*       if (strncmp(argv[i], "-bd", 3) == 0) 	{ 	  color_name = argv[++i]; 	  continue; 	}*       if (strncmp(argv[i], "-ge", 3) == 0) 	{" 	  window_geom_string = argv[++i]; 	  continue; 	}-       if (strncmp(argv[i], "-icong", 6) == 0)h 	{  	  icon_geom_string = argv[++i]; 	  continue; 	})       if (strncmp(argv[i], "-r", 2) == 0)o 	{" 	  region_geom_string = argv[++i]; 	  continue; 	}-       if (strncmp(argv[i], "-iconi", 6) == 0)s 	{ 	  start_iconic = TRUE;  	  continue; 	}*       if (strncmp(argv[i], "-na", 3) == 0) 	{ 	  app_name = argv[++i]; 	  continue; 	}*       if (strncmp(argv[i], "-no", 3) == 0) 	{ 	  grab_server = FALSE;r 	  continue; 	}       usage();     }t }    main(argc, argv)      int argc;      char **argv;C {r   Display *the_display;v   int the_screen;/   XWMHints wmhints;    XEvent an_event;
   GC copy_gc;k"   unsigned long copy_gc_valuemask;   XGCValues copy_gc_values;a   long wmhints_mask;   XSizeHints wm_size_hints;e<   int x_return, y_return;           /* for XParseGeometry */<   int width_return, height_return;  /* ditto              */K   int geom_mask;                    /* bitmask for XParseGeometry fields */t@   unsigned long border_color_pixel; /* pixel for border color */   XColor color;    Colormap cmap;A   Window window_to_snap;            /* always root window, now */.   Window snapshot;   Cursor snap_cursor;o   XImage *snap_image;r   int reg_x, reg_y;e   int icon_x, icon_y;    int snap_x, snap_y;g'   unsigned int snap_width, snap_height;v%   unsigned int reg_width, reg_height;c   int done;pN   char buffer [4];                   /* key press buffer for XLookupString  */D   int string_length;                 /* length of returned string */      process_args(argc, argv);r'   XSetErrorHandler(my_X_error_handler);t;   if ((the_display = XOpenDisplay(display_string)) == NULL)      {g       6       fprintf(stderr, "Cannot open display:    %s\n", % 	      XDisplayName(display_string));y       exit(1);     }h'   XSetErrorHandler(my_X_error_handler); *   the_screen = DefaultScreen(the_display);8   window_to_snap = XRootWindow(the_display, the_screen);      /* make copy GC */   &   copy_gc_valuemask = GCSubwindowMode;3   copy_gc_values.subwindow_mode = IncludeInferiors; E   copy_gc = XCreateGC(the_display, window_to_snap, copy_gc_valuemask,o 		      &copy_gc_values);c      if (grab_server)     {a       XGrabServer(the_display);        XSync(the_display, 0);     }r      if (region_geom_string)y     {_D       geom_mask = XParseGeometry(region_geom_string, &reg_x, &reg_y, 				 &reg_width, &reg_height);9       if ((geom_mask & XValue) && (geom_mask & YValue) &&_9 	  (geom_mask & WidthValue) && (geom_mask & HeightValue))!0 	/* must specify complete geometry for region */ 	{ 	  if (geom_mask & XNegative)c@ 	    reg_x += DisplayWidth(the_display, the_screen) - reg_width; 	  if (geom_mask & YNegative)aB 	    reg_y += DisplayHeight(the_display, the_screen) - reg_height;: 	  snap_image = get_image_region(the_display, the_screen,  					window_to_snap, copy_gc,a! 					&reg_x, &reg_y, &reg_width,   					&reg_height, FALSE);_ 	}       else usage();*     }/   else  H     snap_image = get_image_region(the_display,the_screen,window_to_snap, 				  copy_gc,&reg_x,&reg_y,# 				  &reg_width,&reg_height,TRUE);       /* ungrab the server */       XUngrabServer(the_display);c      /* process border color */   2   cmap = DefaultColormap(the_display, the_screen);M   if ((color_name) && (XParseColor(the_display, cmap, color_name, &color)) &&t/       (XAllocColor(the_display, cmap, &color)))_%     border_color_pixel = color.pixel;    else=     border_color_pixel = BlackPixel(the_display, the_screen);       /*=    * get location of our window(from the window_geom_string),t)    * and set up the size hints structure. 
    */          wm_size_hints.flags = 0;   width_return = reg_width;)   height_return = reg_height;    if (window_geom_string)h     {i@       geom_mask = XParseGeometry(window_geom_string, &x_return,  				 &y_return, &width_return, _ 				 &height_return);        if (geom_mask & XValue)s 	{ 	  if (geom_mask & XNegative) 1 	    wm_size_hints.x = DisplayWidth(the_display,   					   the_screen) # 	      - width_return + x_return - e 		(border_width * 2);  	  else   	    wm_size_hints.x = x_return; 	}       if (geom_mask & YValue)  	{ 	  if (geom_mask & YNegative)e 	    wm_size_hints.y =  - 	      DisplayHeight(the_display, the_screen)   		- height_return + y_return  -  		  (border_width * 2);  	  a 	  elsei  	    wm_size_hints.y = y_return; 	}            }l   3   if ((geom_mask & XValue) || (geom_mask & YValue))h&     wm_size_hints.flags |= USPosition;   <   if ((geom_mask & WidthValue) || (geom_mask & HeightValue))"     wm_size_hints.flags |= USSize;%   wm_size_hints.width = width_return;d'   wm_size_hints.height = height_return;       .   snapshot = XCreateSimpleWindow(the_display, + 				 XRootWindow(the_display, the_screen), d& 				 wm_size_hints.x, wm_size_hints.y, 				 wm_size_hints.width, ( 				 wm_size_hints.height, border_width, 				 border_color_pixel,* 				 BlackPixel(the_display, the_screen));      if (window_geom_string)d;     XSetNormalHints(the_display, snapshot, &wm_size_hints);n.   XStoreName(the_display, snapshot, app_name);   wmhints_mask = 0;r   if (start_iconic)n     {i        wmhints_mask |= StateHint;*       wmhints.initial_state = IconicState;     }a   x_return = y_return = 0;   G   /* Icon geometry is sorta broken, since we don't supply an icon, and iH    * there isn't any way I know of to get the geometry  of the icon thatH    * the window manager will provide.   So, we'll pretend that our icon     * is 32x32 (ugh).    */w      if (icon_geom_string)r     {s>       geom_mask = XParseGeometry(icon_geom_string, &x_return,  				 &y_return, &width_return, n 				 &height_return);;       if (geom_mask & XValue)  	{ 	  if (geom_mask & XNegative)g0 	    wmhints.icon_x = DisplayWidth(the_display,  					  the_screen), 	      - 32 + x_return - (border_width * 2); 	  else  	    wmhints.icon_x = x_return;e 	}       if (geom_mask & YValue)t 	{ 	  if (geom_mask & YNegative)*2 	    wmhints.icon_y =  DisplayHeight(the_display,  					    the_screen)- 	      - 32 + y_return  - (border_width * 2);e 	  i 	  elser 	    wmhints.icon_y = y_return;  	}'       wmhints_mask |= IconPositionHint;      }X         if (wmhints_mask))     {D#       wmhints.flags = wmhints_mask;y3       XSetWMHints(the_display, snapshot, &wmhints);t     }r      /* solicit expose events */    C   XSelectInput(the_display, snapshot, ExposureMask | KeyPressMask);n   "   /* give it a different cursor */   9   snap_cursor = XCreateFontCursor(the_display, XC_gumby);*   4   XDefineCursor(the_display, snapshot, snap_cursor);      /* map it */   $   XMapRaised(the_display, snapshot);      /* process events */   done = FALSE;n      while (! done)     {D)       XNextEvent(the_display, &an_event);"       switch (an_event.type) 	{ 	case MappingNotify:& 	  XRefreshKeyboardMapping(&an_event);	 	  break;M
 	case Expose:n! 	  if (an_event.xexpose.count==0)r7 	    XPutImage(the_display,snapshot,copy_gc,snap_image,y" 		      0,0,0,0,snap_image->width, 		      snap_image->height);	 	  break;R 	case KeyPress:o4 	  string_length = XLookupString(&an_event, buffer,  					sizeof(buffer), 					NULL, NULL);f5 	  if ((string_length == 1) && ((buffer[0] == 'q') ||a  				       (buffer[0] == 'Q') ||" 				       (buffer[0] == '\003'))) 	    g 	    /*  clean up  */f 	    {- 	      XDestroyWindow(the_display, snapshot); % 	      XFreeGC(the_display, copy_gc);t" 	      XCloseDisplay(the_display); 	      done = TRUE;  	      exit(0);s
 	      break;  	    } 	}     }c    }r