 IDENTIFICATION DIVISION.   PROGRAM-ID.  MTCHK IS INITIAL.   ENVIRONMENT DIVISION.    CONFIGURATION SECTION.   SOURCE-COMPUTER.  VAX-11.    OBJECT-COMPUTER.  VAX-11.    DATA DIVISION.   WORKING-STORAGE SECTION.   *  *	Input Tape 1 Buffer  *    01 TAPE1 GLOBAL		PIC X(65534).     *  *	Input Tape 2 Buffer  *    01 TAPE2 GLOBAL		PIC X(65534).     *  *	Channel 1 Assignment Constant  *   % 01 C1 GLOBAL		PIC S9(9) COMP VALUE 1.      *  *	Channel 2 Assignment Constant  *   % 01 C2 GLOBAL		PIC S9(9) COMP VALUE 2.      *  *	Record Size Constants  *   . 01 RECSIZE1 GLOBAL	PIC S9(9) COMP VALUE 65534.. 01 RECSIZE2 GLOBAL	PIC S9(9) COMP VALUE 65534.     * & *	System Service Routine Return Status *   $ 01 SYS_STATUS GLOBAL	PIC S9(9) COMP.     *  *	I/O Status Block *    01 IOSB GLOBAL.   +    02 IO_SB		PIC S9(9) COMP OCCURS 2 TIMES.   % 01 WIOSB_REDEF REDEFINES IOSB GLOBAL.   *    02 WIOSB PIC S9(4) COMP OCCURS 4 TIMES.     *  *	EOF Mark Counter *   ) 01 EOF_CTR GLOBAL	PIC S9(9) COMP VALUE 0.      *  *	Input Tapes' EOF Mark Count  *   2 01 INPUT1_EOF_COUNT GLOBAL	PIC S9(9) COMP VALUE 0.  2 01 INPUT2_EOF_COUNT GLOBAL	PIC S9(9) COMP VALUE 0.  ( 01 ED_INPUT1_EOF_COUNT GLOBAL	PIC Z(7)9.  ( 01 ED_INPUT2_EOF_COUNT GLOBAL	PIC Z(7)9.     *  *	Input Tapes' Block Counts  *   4 01 INPUT1_BLOCK_COUNT GLOBAL	PIC S9(9) COMP VALUE 0.  4 01 INPUT2_BLOCK_COUNT GLOBAL	PIC S9(9) COMP VALUE 0.  * 01 ED_INPUT1_BLOCK_COUNT GLOBAL	PIC Z(7)9.  * 01 ED_INPUT2_BLOCK_COUNT GLOBAL	PIC Z(7)9.     * $ *	Input Tapes' Maximum Block Lengths *   9 01 MAX_INPUT1_BLOCK_LENGTH GLOBAL	PIC S9(9) COMP VALUE 0.   9 01 MAX_INPUT2_BLOCK_LENGTH GLOBAL	PIC S9(9) COMP VALUE 0.   / 01 ED_MAX_INPUT1_BLOCK_LENGTH GLOBAL	PIC Z(4)9.   / 01 ED_MAX_INPUT2_BLOCK_LENGTH GLOBAL	PIC Z(4)9.      *  *	QIO I/O Function Codes *   > 01 IO$_REWIND GLOBAL	PIC S9(9) COMP VALUE EXTERNAL IO$_REWIND.  B 01 IO$_READPBLK	GLOBAL	PIC S9(9) COMP VALUE EXTERNAL IO$_READPBLK.     * & *	System Service Return Code Constants *   A 01 SS$_NORMAL GLOBAL    PIC S9(9) COMP VALUE EXTERNAL SS$_NORMAL.   B 01 SS$_CTRLERR GLOBAL   PIC S9(9) COMP VALUE EXTERNAL SS$_CTRLERR.  D 01 SS$_DATACHECK GLOBAL PIC S9(9) COMP VALUE EXTERNAL SS$_DATACHECK.  A 01 SS$_DRVERR GLOBAL    PIC S9(9) COMP VALUE EXTERNAL SS$_DRVERR.   D 01 SS$_ENDOFFILE GLOBAL PIC S9(9) COMP VALUE EXTERNAL SS$_ENDOFFILE.  H 01 SS$_ENDOFVOLUME GLOBAL PIC S9(9) COMP VALUE EXTERNAL SS$_ENDOFVOLUME.  A 01 SS$_FORMAT GLOBAL    PIC S9(9) COMP VALUE EXTERNAL SS$_FORMAT.   A 01 SS$_MEDOFL GLOBAL    PIC S9(9) COMP VALUE EXTERNAL SS$_MEDOFL.   C 01 SS$_NONEXDRV GLOBAL  PIC S9(9) COMP VALUE EXTERNAL SS$_NONEXDRV.   A 01 SS$_PARITY GLOBAL    PIC S9(9) COMP VALUE EXTERNAL SS$_PARITY.   A 01 SS$_UNSAFE GLOBAL    PIC S9(9) COMP VALUE EXTERNAL SS$_UNSAFE.   A 01 SS$_VOLINV GLOBAL    PIC S9(9) COMP VALUE EXTERNAL SS$_VOLINV.   B 01 SS$_WRITLCK GLOBAL   PIC S9(9) COMP VALUE EXTERNAL SS$_WRITLCK.  F 01 SS$_DATAOVERUN GLOBAL PIC S9(9) COMP VALUE EXTERNAL SS$_DATAOVERUN.  @ 01 SS$_ABORT GLOBAL     PIC S9(9) COMP VALUE EXTERNAL SS$_ABORT.  F 01 SS$_DEVOFFLINE GLOBAL PIC S9(9) COMP VALUE EXTERNAL SS$_DEVOFFLINE.  D 01 SS$_ILLIOFUNC GLOBAL PIC S9(9) COMP VALUE EXTERNAL SS$_ILLIOFUNC.  D 01 SS$_OPINCOMPL GLOBAL PIC S9(9) COMP VALUE EXTERNAL SS$_OPINCOMPL.  B 01 SS$_TIMEOUT GLOBAL   PIC S9(9) COMP VALUE EXTERNAL SS$_TIMEOUT.  D 01 SS$_ENDOFTAPE GLOBAL PIC S9(9) COMP VALUE EXTERNAL SS$_ENDOFTAPE.  A 01 SS$_NOPRIV GLOBAL    PIC S9(9) COMP VALUE EXTERNAL SS$_NOPRIV.   H 01 SS$_DEVNOTMOUNT GLOBAL PIC S9(9) COMP VALUE EXTERNAL SS$_DEVNOTMOUNT.   PROCEDURE DIVISION.    0.   * 0 *	Assign channels, rewind tapes, and initialize. *    	CALL "SYS$ASSIGN" USING   	    BY DESCRIPTOR "_MFA0:",   	    BY REFERENCE C1,    	    BY VALUE 0, 0   	    GIVING SYS_STATUS.    	IF SYS_STATUS NOT = SS$_NORMAL    	THEN   * 	    DISPLAY "?:  Assign for mta0: failed"   	    CALL "MTCHK_RUNDOWN".   	CALL "SYS$ASSIGN" USING   	    BY DESCRIPTOR "_MFA1:",   	    BY REFERENCE C2,    	    BY VALUE 0, 0   	    GIVING SYS_STATUS.    	IF SYS_STATUS NOT = SS$_NORMAL    	THEN   * 	    DISPLAY "?:  Assign for mta1: failed"   	    CALL "MTCHK_RUNDOWN".   	CALL "REWIND_TAPE" USING C1.    	CALL "REWIND_TAPE" USING C2.    	MOVE 0 TO EOF_CTR.      * & *	Read input tapes and compare blocks. *    5.   	CALL "READ_INPUT_TAPE1".    	EVALUATE WIOSB(1)   	WHEN SS$_ENDOFFILE    	WHEN SS$_ENDOFVOLUME    	    ADD 1 TO INPUT1_EOF_COUNT   	WHEN OTHER    	    MOVE 0 TO EOF_CTR   	    END-EVALUATE.   	CALL "READ_INPUT_TAPE2".    	EVALUATE WIOSB(1)   	WHEN SS$_ENDOFFILE    	WHEN SS$_ENDOFVOLUME    	    ADD 1 TO INPUT2_EOF_COUNT   	WHEN OTHER   
 	    CONTINUE    	    END-EVALUATE.   	EVALUATE EOF_CTR    	WHEN 1    	WHEN 3    	    CALL "TAPES_DONT_COMPARE"   	WHEN 2    	    GO TO 5   	WHEN 4    	    CALL "MTCHK_RUNDOWN"    	WHEN OTHER    	    CONTINUE.  ' 	IF ((RECSIZE1 > 0 AND NOT > 65534) AND   ' 	    (RECSIZE2 > 0 AND NOT > 65534) AND    	    (RECSIZE1 = RECSIZE2))    	THEN   1 	    IF TAPE1(1 : RECSIZE1) = TAPE2(1 : RECSIZE2)   	 	    THEN   	 		GO TO 5   	 	    ELSE    		CALL "TAPES_DONT_COMPARE"    	ELSE    	    CALL "TAPES_DONT_COMPARE".    IDENTIFICATION DIVISION.  # PROGRAM-ID.  REWIND_TAPE IS COMMON.    DATA DIVISION.   WORKING-STORAGE SECTION.   01 SYS_STATUS		PIC S9(9) COMP.   01 IOSB			PIC X(8).    LINKAGE SECTION.   01 CHANNEL_NUM		PIC S9(9) COMP.   % PROCEDURE DIVISION USING CHANNEL_NUM.    0.   	CALL "SYS$QIOW" USING   	    BY VALUE 0,   	    BY VALUE CHANNEL_NUM,   	    BY VALUE IO$_REWIND,    	    BY REFERENCE IOSB,   $ 	    BY VALUE 0, 0, 0, 0, 0, 0, 0, 0   	    GIVING SYS_STATUS.    	IF SYS_STATUS NOT = SS$_NORMAL    	THEN    	    DISPLAY "?:  Rewind error"    	    CALL "MTCHK_RUNDOWN".   	EXIT PROGRAM.   END PROGRAM REWIND_TAPE.   IDENTIFICATION DIVISION.   PROGRAM-ID.  READ_INPUT_TAPE1.   DATA DIVISION.   PROCEDURE DIVISION.    0.   	MOVE 65534 TO RECSIZE1.   	CALL "SYS$QIOW" USING   	    BY VALUE 0,   	    BY VALUE C1,    	    BY VALUE IO$_READPBLK,    	    BY REFERENCE IOSB,    	    BY VALUE 0, 0,    	    BY REFERENCE TAPE1,   	    BY VALUE RECSIZE1,    	    BY VALUE 0, 0, 0, 0   	    GIVING SYS_STATUS.    	MOVE WIOSB(2) TO RECSIZE1.   2 	IF WIOSB(1) = 0 THEN MOVE SYS_STATUS TO IO_SB(1).  3 	IF WIOSB(1) IS SUCCESS OR WIOSB(1) = SS$_ENDOFTAPE    	THEN     	    ADD 1 TO INPUT1_BLOCK_COUNT  * 	    IF RECSIZE1 > MAX_INPUT1_BLOCK_LENGTH  	 	    THEN   * 		MOVE RECSIZE1 TO MAX_INPUT1_BLOCK_LENGTH   		END-IF   	ELSE    	    CALL "ANALYZE_IO_STATUS".   	EXIT PROGRAM.   END PROGRAM READ_INPUT_TAPE1.    IDENTIFICATION DIVISION.   PROGRAM-ID.  READ_INPUT_TAPE2.   PROCEDURE DIVISION.    0.   	MOVE 65534 TO RECSIZE2.   	CALL "SYS$QIOW" USING   	    BY VALUE 0,   	    BY VALUE C2,    	    BY VALUE IO$_READPBLK,    	    BY REFERENCE IOSB,    	    BY VALUE 0, 0,    	    BY REFERENCE TAPE2,   	    BY VALUE RECSIZE2,    	    BY VALUE 0, 0, 0, 0   	    GIVING SYS_STATUS.    	MOVE WIOSB(2) TO RECSIZE2.   2 	IF WIOSB(1) = 0 THEN MOVE SYS_STATUS TO IO_SB(1).  3 	IF WIOSB(1) IS SUCCESS OR WIOSB(1) = SS$_ENDOFTAPE    	THEN     	    ADD 1 TO INPUT2_BLOCK_COUNT  * 	    IF RECSIZE2 > MAX_INPUT2_BLOCK_LENGTH  	 	    THEN   * 		MOVE RECSIZE2 TO MAX_INPUT2_BLOCK_LENGTH   		END-IF   	ELSE    	    CALL "ANALYZE_IO_STATUS".   	EXIT PROGRAM.   END PROGRAM READ_INPUT_TAPE2.    IDENTIFICATION DIVISION.  ) PROGRAM-ID.  ANALYZE_IO_STATUS IS COMMON.    DATA DIVISION.   WORKING-STORAGE SECTION.   01 ERROR_MESSAGE PIC X(80).   ) 01 MESSAGE_FLAGS PIC S9(9) COMP VALUE 15.    PROCEDURE DIVISION.    0.   	EVALUATE WIOSB(1)   	WHEN SS$_ENDOFFILE    	WHEN SS$_ENDOFVOLUME    	    ADD 1 TO EOF_CTR    	WHEN SS$_PARITY   	    DISPLAY "?:  Parity error"    	WHEN SS$_NOPRIV  ? 	    DISPLAY "?:  You need PHY_IO privlege to use this program"    	    CALL "MTCHK_RUNDOWN"    	WHEN SS$_DEVNOTMOUNT   - 	    DISPLAY "?:  You must MOUNT/FOR/NOWRITE"    	    CALL "MTCHK_RUNDOWN"    	WHEN SS$_OPINCOMPL   + 	    DISPLAY "?:  I/O operation incomplete"    	    CALL "MTCHK_RUNDOWN"    	WHEN SS$_CTRLERR   # 	    DISPLAY "?:  Controller error"    	    CALL "MTCHK_RUNDOWN"    	WHEN SS$_DATACHECK   # 	    DISPLAY "?:  Data check error"    	    CALL "MTCHK_RUNDOWN"    	WHEN SS$_DRVERR   	    DISPLAY "?:  Driver error"    	    CALL "MTCHK_RUNDOWN"    	WHEN SS$_FORMAT   	    DISPLAY "?:  Format error"    	    CALL "MTCHK_RUNDOWN"    	WHEN SS$_MEDOFL    	    DISPLAY "?:  Media offline"   	    CALL "MTCHK_RUNDOWN"    	WHEN SS$_NONEXDRV  , 	    DISPLAY "?:  Non-existent driver error"   	    CALL "MTCHK_RUNDOWN"    	WHEN SS$_UNSAFE  & 	    DISPLAY "?:  Driver unsafe error"   	    CALL "MTCHK_RUNDOWN"    	WHEN SS$_VOLINV  ' 	    DISPLAY "?:  Volume invalid error"    	    CALL "MTCHK_RUNDOWN"    	WHEN SS$_WRITLCK    	    DISPLAY "?:  Write locked"    	    CALL "MTCHK_RUNDOWN"    	WHEN SS$_DATAOVERUN  & 	    DISPLAY "?:  Data over run error"   	    CALL "MTCHK_RUNDOWN"    	WHEN SS$_ABORT   $ 	    DISPLAY "?:  Operation aborted"   	    CALL "MTCHK_RUNDOWN"    	WHEN SS$_DEVOFFLINE  ! 	    DISPLAY "?:  Device offline"    	    CALL "MTCHK_RUNDOWN"    	WHEN SS$_ILLIOFUNC   ' 	    DISPLAY "?:  Illegal I/O function"    	    CALL "MTCHK_RUNDOWN"    	WHEN SS$_TIMEOUT   % 	    DISPLAY "?:  Timeout on magtape"    	    CALL "MTCHK_RUNDOWN"    	WHEN OTHER     	    MOVE WIOSB(1) TO SYS_STATUS    	    CALL "LIB$SYS_GETMSG" USING   		BY REFERENCE SYS_STATUS,  
 		BY VALUE 0,    		BY DESCRIPTOR ERROR_MESSAGE,   		BY REFERENCE MESSAGE_FLAGS   	    DISPLAY ERROR_MESSAGE   	    CALL "MTCHK_RUNDOWN".   	EXIT PROGRAM.   END PROGRAM ANALYZE_IO_STATUS.   IDENTIFICATION DIVISION.    PROGRAM-ID.  TAPES_DONT_COMPARE.   PROCEDURE DIVISION.    0.  % 	DISPLAY "?:  TAPES DON'T COMPARE!!!"    	CALL "MTCHK_RUNDOWN".   END PROGRAM TAPES_DONT_COMPARE.    IDENTIFICATION DIVISION.  % PROGRAM-ID.  MTCHK_RUNDOWN IS COMMON.    PROCEDURE DIVISION.    0.   * / *	Verify summary statistics and print them out.  *   2 	IF INPUT1_BLOCK_COUNT NOT = INPUT2_BLOCK_COUNT OR  < 	   MAX_INPUT1_BLOCK_LENGTH NOT = MAX_INPUT1_BLOCK_LENGTH OR  + 	   INPUT1_EOF_COUNT NOT = INPUT2_EOF_COUNT    	THEN   ) 	    DISPLAY "?:  TAPES DON'T COMPARE!!!"    	    DISPLAY " ".    \P	DISPLAY " ".   8 \P	DISPLAY "Magtape Compare Utility Summary Statistics:"   \P	DISPLAY " ".   2 	MOVE INPUT1_BLOCK_COUNT TO ED_INPUT1_BLOCK_COUNT.  F \P	DISPLAY "     " "Input tape 1 blocks read: " ED_INPUT1_BLOCK_COUNT.  2 	MOVE INPUT2_BLOCK_COUNT TO ED_INPUT2_BLOCK_COUNT.  F \P	DISPLAY "     " "Input tape 2 blocks read: " ED_INPUT2_BLOCK_COUNT.  < 	MOVE MAX_INPUT1_BLOCK_LENGTH TO ED_MAX_INPUT1_BLOCK_LENGTH.  R \P	DISPLAY "     " "Longest input tape 1 block read: " ED_MAX_INPUT1_BLOCK_LENGTH.  < 	MOVE MAX_INPUT2_BLOCK_LENGTH TO ED_MAX_INPUT2_BLOCK_LENGTH.  R \P	DISPLAY "     " "Longest input tape 2 block read: " ED_MAX_INPUT2_BLOCK_LENGTH.  . 	MOVE INPUT1_EOF_COUNT TO ED_INPUT1_EOF_COUNT.  B \P	DISPLAY "     " "Input tape 1 EOF count: " ED_INPUT1_EOF_COUNT.  . 	MOVE INPUT2_EOF_COUNT TO ED_INPUT2_EOF_COUNT.  B \P	DISPLAY "     " "Input tape 2 EOF count: " ED_INPUT2_EOF_COUNT.  
 	STOP RUN.   END PROGRAM MTCHK_RUNDOWN.   END PROGRAM MTCHK.