 IDENTIFICATION DIVISION.   PROGRAM-ID.  MTCOPY IS INITIAL.    ENVIRONMENT DIVISION.    CONFIGURATION SECTION.   SOURCE-COMPUTER.  VAX-11.    OBJECT-COMPUTER.  VAX-11.    DATA DIVISION.   WORKING-STORAGE SECTION.   *  *	Input Tape Buffer  *    01 TAPE1 GLOBAL		PIC X(65534).     *  *	Channel 1 Assignment Constant  *   % 01 C1 GLOBAL		PIC S9(9) COMP VALUE 1.      *  *	Channel 2 Assignment Constant  *   % 01 C2 GLOBAL		PIC S9(9) COMP VALUE 2.      *  *	Record Size Constant *   - 01 RECSIZE GLOBAL	PIC S9(9) COMP VALUE 65534.      * & *	System Service Routine Return Status *   $ 01 SYS_STATUS GLOBAL	PIC S9(9) COMP.     *  *	I/O Status Block *    01 IOSB GLOBAL.   +    02 IO_SB		PIC S9(9) COMP OCCURS 2 TIMES.   % 01 WIOSB_REDEF REDEFINES IOSB GLOBAL.   *    02 WIOSB PIC S9(4) COMP OCCURS 4 TIMES.     *  *	EOF Mark Counter *   ) 01 EOF_CTR GLOBAL	PIC S9(9) COMP VALUE 0.      * ' *	Input and Output Tape EOF Mark Counts  *   1 01 INPUT_EOF_COUNT GLOBAL	PIC S9(9) COMP VALUE 0.   2 01 OUTPUT_EOF_COUNT GLOBAL	PIC S9(9) COMP VALUE 0.  ' 01 ED_INPUT_EOF_COUNT GLOBAL	PIC Z(7)9.   ( 01 ED_OUTPUT_EOF_COUNT GLOBAL	PIC Z(7)9.     * $ *	Input and Output Tape Block Counts *   3 01 INPUT_BLOCK_COUNT GLOBAL	PIC S9(9) COMP VALUE 0.   4 01 OUTPUT_BLOCK_COUNT GLOBAL	PIC S9(9) COMP VALUE 0.  ) 01 ED_INPUT_BLOCK_COUNT GLOBAL	PIC Z(7)9.   * 01 ED_OUTPUT_BLOCK_COUNT GLOBAL	PIC Z(7)9.     * - *	Maximum Input and Output Tape Block Lengths  *   8 01 MAX_INPUT_BLOCK_LENGTH GLOBAL	PIC S9(9) COMP VALUE 0.  9 01 MAX_OUTPUT_BLOCK_LENGTH GLOBAL	PIC S9(9) COMP VALUE 0.   . 01 ED_MAX_INPUT_BLOCK_LENGTH GLOBAL	PIC Z(4)9.  / 01 ED_MAX_OUTPUT_BLOCK_LENGTH GLOBAL	PIC Z(4)9.      *  *	QIO I/O Function Codes *   > 01 IO$_REWIND GLOBAL	PIC S9(9) COMP VALUE EXTERNAL IO$_REWIND.  B 01 IO$_READPBLK	GLOBAL	PIC S9(9) COMP VALUE EXTERNAL IO$_READPBLK.  D 01 IO$_WRITEPBLK GLOBAL	PIC S9(9) COMP VALUE EXTERNAL IO$_WRITEPBLK.  @ 01 IO$_WRITEOF GLOBAL	PIC S9(9) COMP VALUE EXTERNAL IO$_WRITEOF.     * & *	System Service Return Code Constants *   A 01 SS$_NORMAL GLOBAL    PIC S9(9) COMP VALUE EXTERNAL SS$_NORMAL.   B 01 SS$_CTRLERR GLOBAL   PIC S9(9) COMP VALUE EXTERNAL SS$_CTRLERR.  D 01 SS$_DATACHECK GLOBAL PIC S9(9) COMP VALUE EXTERNAL SS$_DATACHECK.  A 01 SS$_DRVERR GLOBAL    PIC S9(9) COMP VALUE EXTERNAL SS$_DRVERR.   D 01 SS$_ENDOFFILE GLOBAL PIC S9(9) COMP VALUE EXTERNAL SS$_ENDOFFILE.  H 01 SS$_ENDOFVOLUME GLOBAL PIC S9(9) COMP VALUE EXTERNAL SS$_ENDOFVOLUME.  A 01 SS$_FORMAT GLOBAL    PIC S9(9) COMP VALUE EXTERNAL SS$_FORMAT.   A 01 SS$_MEDOFL GLOBAL    PIC S9(9) COMP VALUE EXTERNAL SS$_MEDOFL.   C 01 SS$_NONEXDRV GLOBAL  PIC S9(9) COMP VALUE EXTERNAL SS$_NONEXDRV.   A 01 SS$_PARITY GLOBAL    PIC S9(9) COMP VALUE EXTERNAL SS$_PARITY.   A 01 SS$_UNSAFE GLOBAL    PIC S9(9) COMP VALUE EXTERNAL SS$_UNSAFE.   A 01 SS$_VOLINV GLOBAL    PIC S9(9) COMP VALUE EXTERNAL SS$_VOLINV.   B 01 SS$_WRITLCK GLOBAL   PIC S9(9) COMP VALUE EXTERNAL SS$_WRITLCK.  F 01 SS$_DATAOVERUN GLOBAL PIC S9(9) COMP VALUE EXTERNAL SS$_DATAOVERUN.  @ 01 SS$_ABORT GLOBAL     PIC S9(9) COMP VALUE EXTERNAL SS$_ABORT.  F 01 SS$_DEVOFFLINE GLOBAL PIC S9(9) COMP VALUE EXTERNAL SS$_DEVOFFLINE.  D 01 SS$_ILLIOFUNC GLOBAL PIC S9(9) COMP VALUE EXTERNAL SS$_ILLIOFUNC.  D 01 SS$_OPINCOMPL GLOBAL PIC S9(9) COMP VALUE EXTERNAL SS$_OPINCOMPL.  B 01 SS$_TIMEOUT GLOBAL   PIC S9(9) COMP VALUE EXTERNAL SS$_TIMEOUT.  D 01 SS$_ENDOFTAPE GLOBAL PIC S9(9) COMP VALUE EXTERNAL SS$_ENDOFTAPE.  A 01 SS$_NOPRIV GLOBAL    PIC S9(9) COMP VALUE EXTERNAL SS$_NOPRIV.   H 01 SS$_DEVNOTMOUNT GLOBAL PIC S9(9) COMP VALUE EXTERNAL SS$_DEVNOTMOUNT.   PROCEDURE DIVISION.    0.   * 0 *	Assign channels, rewind tapes, and initialize. *    	CALL "SYS$ASSIGN" USING   	    BY DESCRIPTOR "_MFA0:",   	    BY REFERENCE C1,    	    BY VALUE 0, 0   	    GIVING SYS_STATUS.    	IF SYS_STATUS NOT = SS$_NORMAL    	THEN   * 	    DISPLAY "?:  Assign for mta0: failed"   	    CALL "MTCOPY_RUNDOWN".    	CALL "SYS$ASSIGN" USING   	    BY DESCRIPTOR "_MFA1:",   	    BY REFERENCE C2,    	    BY VALUE 0, 0   	    GIVING SYS_STATUS.    	IF SYS_STATUS NOT = SS$_NORMAL    	THEN   * 	    DISPLAY "?:  Assign for mta1: failed"   	    CALL "MTCOPY_RUNDOWN".    	CALL "REWIND_TAPE" USING C1.    	CALL "REWIND_TAPE" USING C2.    	MOVE 0 TO EOF_CTR.      * 4 *	Read input tape block and write output tape block. *    5.   	CALL "READ_INPUT_BLOCK".    	IF WIOSB(1) = SS$_ENDOFFILE   	THEN    	    GO TO 5   	ELSE    	    MOVE 0 TO EOF_CTR.    	CALL "WRITE_OUTPUT_BLOCK".   	 	GO TO 5.    IDENTIFICATION DIVISION.  # PROGRAM-ID.  REWIND_TAPE IS COMMON.    DATA DIVISION.   WORKING-STORAGE SECTION.   01 SYS_STATUS		PIC S9(9) COMP.   01 IOSB			PIC X(8).    LINKAGE SECTION.   01 CHANNEL_NUM		PIC S9(9) COMP.   % PROCEDURE DIVISION USING CHANNEL_NUM.    0.   	CALL "SYS$QIOW" USING   	    BY VALUE 0,   	    BY VALUE CHANNEL_NUM,   	    BY VALUE IO$_REWIND,    	    BY REFERENCE IOSB,   $ 	    BY VALUE 0, 0, 0, 0, 0, 0, 0, 0   	    GIVING SYS_STATUS.    	IF SYS_STATUS NOT = SS$_NORMAL    	THEN    	    DISPLAY "?:  Rewind error"    	    CALL "MTCOPY_RUNDOWN".    	EXIT PROGRAM.   END PROGRAM REWIND_TAPE.   IDENTIFICATION DIVISION.   PROGRAM-ID.  READ_INPUT_BLOCK.   DATA DIVISION.   PROCEDURE DIVISION.    0.   	MOVE 65534 TO RECSIZE.    	CALL "SYS$QIOW" USING   	    BY VALUE 0,   	    BY VALUE C1,    	    BY VALUE IO$_READPBLK,    	    BY REFERENCE IOSB,    	    BY VALUE 0, 0,    	    BY REFERENCE TAPE1,   	    BY VALUE RECSIZE,   	    BY VALUE 0, 0, 0, 0   	    GIVING SYS_STATUS.    	MOVE WIOSB(2) TO RECSIZE.  2 	IF WIOSB(1) = 0 THEN MOVE SYS_STATUS TO IO_SB(1).  3 	IF WIOSB(1) IS SUCCESS OR WIOSB(1) = SS$_ENDOFTAPE    	THEN    	    ADD 1 TO INPUT_BLOCK_COUNT   ( 	    IF RECSIZE > MAX_INPUT_BLOCK_LENGTH  	 	    THEN   ( 		MOVE RECSIZE TO MAX_INPUT_BLOCK_LENGTH   		END-IF   	ELSE    	    CALL "ANALYZE_IO_STATUS".   	EXIT PROGRAM.   END PROGRAM READ_INPUT_BLOCK.    IDENTIFICATION DIVISION.    PROGRAM-ID.  WRITE_OUTPUT_BLOCK.   PROCEDURE DIVISION.    0.   	CALL "SYS$QIOW" USING   	    BY VALUE 0,   	    BY VALUE C2,    	    BY VALUE IO$_WRITEPBLK,   	    BY REFERENCE IOSB,    	    BY VALUE 0, 0,    	    BY REFERENCE TAPE1,   	    BY VALUE RECSIZE,   	    BY VALUE 0, 0, 0, 0   	    GIVING SYS_STATUS.   2 	IF WIOSB(1) = 0 THEN MOVE SYS_STATUS TO IO_SB(1).  3 	IF WIOSB(1) IS SUCCESS OR WIOSB(1) = SS$_ENDOFTAPE    	THEN     	    ADD 1 TO OUTPUT_BLOCK_COUNT  ) 	    IF RECSIZE > MAX_OUTPUT_BLOCK_LENGTH   	 	    THEN   ) 		MOVE RECSIZE TO MAX_OUTPUT_BLOCK_LENGTH    		END-IF   	ELSE    	     CALL "ANALYZE_IO_STATUS".    	EXIT PROGRAM.   END PROGRAM WRITE_OUTPUT_BLOCK.    IDENTIFICATION DIVISION.  ) PROGRAM-ID.  ANALYZE_IO_STATUS IS COMMON.    DATA DIVISION.   WORKING-STORAGE SECTION.   01 ERROR_MESSAGE PIC X(80).   ) 01 MESSAGE_FLAGS PIC S9(9) COMP VALUE 15.    PROCEDURE DIVISION.    0.   	EVALUATE WIOSB(1)   	WHEN SS$_ENDOFFILE    	WHEN SS$_ENDOFVOLUME    	    ADD 1 TO INPUT_EOF_COUNT    	    CALL "WRITE_EOF"   ' 	    ADD 1 TO EOF_CTR, OUTPUT_EOF_COUNT    	    IF EOF_CTR = 2   	 	    THEN    		CALL "MTCOPY_RUNDOWN"    		END-IF   	WHEN SS$_PARITY   	    DISPLAY "?:  Parity error"    	WHEN SS$_NOPRIV  ? 	    DISPLAY "?:  You need PHY_IO privlege to use this program"    	    CALL "MTCOPY_RUNDOWN"   	WHEN SS$_DEVNOTMOUNT   % 	    DISPLAY "?:  You must MOUNT/FOR"    	    CALL "MTCOPY_RUNDOWN"   	WHEN SS$_OPINCOMPL   + 	    DISPLAY "?:  I/O operation incomplete"    	    CALL "MTCOPY_RUNDOWN"   	WHEN SS$_CTRLERR   # 	    DISPLAY "?:  Controller error"    	    CALL "MTCOPY_RUNDOWN"   	WHEN SS$_DATACHECK   # 	    DISPLAY "?:  Data check error"    	    CALL "MTCOPY_RUNDOWN"   	WHEN SS$_DRVERR   	    DISPLAY "?:  Driver error"    	    CALL "MTCOPY_RUNDOWN"   	WHEN SS$_FORMAT   	    DISPLAY "?:  Format error"    	    CALL "MTCOPY_RUNDOWN"   	WHEN SS$_MEDOFL    	    DISPLAY "?:  Media offline"   	    CALL "MTCOPY_RUNDOWN"   	WHEN SS$_NONEXDRV  , 	    DISPLAY "?:  Non-existent driver error"   	    CALL "MTCOPY_RUNDOWN"   	WHEN SS$_UNSAFE  & 	    DISPLAY "?:  Driver unsafe error"   	    CALL "MTCOPY_RUNDOWN"   	WHEN SS$_VOLINV  ' 	    DISPLAY "?:  Volume invalid error"    	    CALL "MTCOPY_RUNDOWN"   	WHEN SS$_WRITLCK    	    DISPLAY "?:  Write locked"    	    CALL "MTCOPY_RUNDOWN"   	WHEN SS$_DATAOVERUN  & 	    DISPLAY "?:  Data over run error"   	    CALL "MTCOPY_RUNDOWN"   	WHEN SS$_ABORT   $ 	    DISPLAY "?:  Operation aborted"   	    CALL "MTCOPY_RUNDOWN"   	WHEN SS$_DEVOFFLINE  ! 	    DISPLAY "?:  Device offline"    	    CALL "MTCOPY_RUNDOWN"   	WHEN SS$_ILLIOFUNC   ' 	    DISPLAY "?:  Illegal I/O function"    	    CALL "MTCOPY_RUNDOWN"   	WHEN SS$_TIMEOUT   % 	    DISPLAY "?:  Timeout on magtape"    	    CALL "MTCOPY_RUNDOWN"   	WHEN OTHER     	    MOVE WIOSB(1) TO SYS_STATUS    	    CALL "LIB$SYS_GETMSG" USING   		BY REFERENCE SYS_STATUS,  
 		BY VALUE 0,    		BY DESCRIPTOR ERROR_MESSAGE,   		BY REFERENCE MESSAGE_FLAGS   	    DISPLAY ERROR_MESSAGE   	    CALL "MTCOPY_RUNDOWN".    	EXIT PROGRAM.   IDENTIFICATION DIVISION.   PROGRAM-ID.  WRITE_EOF.    DATA DIVISION.   WORKING-STORAGE SECTION.   01 SYS_STATUS		PIC S9(9) COMP.   01 IOSB.  +    02 IO_SB		PIC S9(9) COMP OCCURS 2 TIMES.    01 WIOSB_REDEF REDEFINES IOSB.  +    02 WIOSB		PIC S9(4) COMP OCCURS 4 TIMES.    PROCEDURE DIVISION.    0.   	CALL "SYS$QIOW" USING   	    BY VALUE 0,   	    BY VALUE C2,    	    BY VALUE IO$_WRITEOF,   	    BY REFERENCE IOSB,   $ 	    BY VALUE 0, 0, 0, 0, 0, 0, 0, 0   	    GIVING SYS_STATUS.   2 	IF WIOSB(1) = 0 THEN MOVE SYS_STATUS TO IO_SB(1).  8 	IF WIOSB(1) IS FAILURE AND WIOSB(1) NOT = SS$_ENDOFTAPE   	THEN   , 	    DISPLAY "?:  Error in writing EOF mark"   	    CALL "MTCOPY_RUNDOWN".    	EXIT PROGRAM.   END PROGRAM WRITE_EOF.   END PROGRAM ANALYZE_IO_STATUS.   IDENTIFICATION DIVISION.  & PROGRAM-ID.  MTCOPY_RUNDOWN IS COMMON.   PROCEDURE DIVISION.    0.   * 7 *	 Validate Summary statistics and then print them out.  *   1 	IF INPUT_BLOCK_COUNT NOT = OUTPUT_BLOCK_COUNT OR   ; 	   MAX_INPUT_BLOCK_LENGTH NOT = MAX_OUTPUT_BLOCK_LENGTH OR   * 	   INPUT_EOF_COUNT NOT = OUTPUT_EOF_COUNT   	THEN   L 	    DISPLAY "?:  TAPES PROBABLY WON'T COMPARE DURING VERIFICATION PHASE!!!"   	    DISPLAY " ".    \P	DISPLAY " ".   5 \P	DISPLAY "Magtape Copy Utility Summary Statistics:"    \P	DISPLAY " ".   0 	MOVE INPUT_BLOCK_COUNT TO ED_INPUT_BLOCK_COUNT.  > \P	DISPLAY "     " "Input blocks read: " ED_INPUT_BLOCK_COUNT.  2 	MOVE OUTPUT_BLOCK_COUNT TO ED_OUTPUT_BLOCK_COUNT.  C \P	DISPLAY "     " "Output blocks written: " ED_OUTPUT_BLOCK_COUNT.   : 	MOVE MAX_INPUT_BLOCK_LENGTH TO ED_MAX_INPUT_BLOCK_LENGTH.  J \P	DISPLAY "     " "Longest input block read: " ED_MAX_INPUT_BLOCK_LENGTH.  < 	MOVE MAX_OUTPUT_BLOCK_LENGTH TO ED_MAX_OUTPUT_BLOCK_LENGTH.  O \P	DISPLAY "     " "Longest output block written: " ED_MAX_OUTPUT_BLOCK_LENGTH.   , 	MOVE INPUT_EOF_COUNT TO ED_INPUT_EOF_COUNT.  : \P	DISPLAY "     " "Input EOF count: " ED_INPUT_EOF_COUNT.  . 	MOVE OUTPUT_EOF_COUNT TO ED_OUTPUT_EOF_COUNT.  < \P	DISPLAY "     " "Output EOF count: " ED_OUTPUT_EOF_COUNT.  
 	STOP RUN.   END PROGRAM MTCOPY_RUNDOWN.    END PROGRAM MTCOPY. 