
$! SET NOVERIFY
$!************************************************************************
$!                                                                       *
$!                                                                       *
$!                                                                       *
$! Hewlett-Packard Registered in U.S. Patent and Trademark Office.       *
$!                                                                       *
$! Confidential computer software. Valid license from Compaq or          *
$! authorized sublicensor required for possession, use or copying.       *
$! Consistent with FAR 12.211 and 12.212, Commercial Computer Software,  *
$! Computer Software Documentation, and Technical Data for Commercial    *
$! Items are licensed to the U.S. Government under vendor's standard     *
$! commercial license.                                                   *
$!                                                                       *
$! Hewlett-Packard shall not be liable for technical or editorial errors *
$! or omissions contained herein. The information in this document is    *
$! subject to change without notice.                                     *
$!                                                                       *
$!                                                                       *
$!                                                                       *
$!************************************************************************
$!
$! File:         opcactivate
$! Description:  Completes the configuration of ITO preinstalled agents
$! Package:      HP OpenView IT/Operations
$!
$! (c) Copyright 1993 - 2004 Hewlett-Packard Development Company, L.P.
$!
$!************************************************************************
$!
$! DESCRIPTION
$!  Following tasks will be done by this opcactivate script:
$!
$!   Verify that this script is called with the right parameters
$!
$!   Configure L-Core using generated on mgmtsrv agent conf profile
$!
$!   or provided as parameter server name and/or certificate server name
$!
$!   starts the L-Core and registered with L-core processes
$! ASSUMPTION
$! /var/opt/OV/log/opc_inst.log file exists
$!
$!************************************************************************
$
$ SET NOON
$ ON ERROR THEN CONTINUE
$ ON SEVERE THEN CONTINUE
$!set verify
$ LANG_C="C"
$ DEFINE/SYSTEM/NOLOG OVO$INSTLOG OVO$POSIX_ROOT:[VAR.OPT.OV.LOG]
$! Commands
$ ovconfchg :== $OVO$POSIX_ROOT:[OPT.OV.BIN]OVCONFCHG.EXE
$ ovc :== $OVO$POSIX_ROOT:[OPT.OV.BIN]OVC.EXE
$ ovconfget :== $OVO$POSIX_ROOT:[OPT.OV.BIN]OVCONFGET.EXE
$ ovbbccb :== $OVO$POSIX_ROOT:[OPT.OV.BIN]OVBBCCB.EXE
$ ovcoreid:== $OVO$POSIX_ROOT:[OPT.OV.BIN]ovcoreid.exe
$ @SYS$STARTUP:OVO8$DEFINE.COM
$ IF f$search("OVO$POSIX_ROOT:[VAR.OPT.OV.DATAFILES.XPL.CONFIG]JOBS.DIR") .EQS. ""
$ THEN
$   CREATE/DIR OVO$POSIX_ROOT:[VAR.OPT.OV.DATAFILES.XPL.CONFIG.JOBS]
$ ENDIF
$ CREATE OVO$POSIX_ROOT:[VAR.OPT.OV.DATAFILES.XPL.CONFIG.JOBS]JOBNO
$ ovconfchg
$ OVO_SERVER :== ""
$ CERT_SERVER :== ""
$ CONF_FILE :== ""
$ OVO_BOOT == "START"
$ MGR_COREID:==""
$ OVO_START ==1
$!**************MAIN SCRIPT***********************************************
$
$ CALL display_writelog_msg  "          Starting opcactivate utility."
$
$!   Verify that this script is called with the right parameters
$
$! Verify that this script is called with the right parameters
$ GOSUB  AC_ENTRY_CHECK
$! Show parameters that are going to be set
$ IF p1 .NES. ""
$ THEN
$ CALL BBC_TRACE_NEW_SETTINGS
$ ENDIF
$!    Activate tasks
$!------------------------------------------------
$!
$!   Create Managed Node COREID
$!
$    define sys$output tempopcactivate.dat
$    pipe ovcoreid -show | search sys$pipe "No OvCoreId is set"
$    deassign sys$output
$    OPEN/READ FD TEMPOPCACTIVATE.DAT
$    READ FD COREREC
$    CLOSE FD
$    DELETE tempopcactivate.dat;*
$    tmp_id1=F$LOCATE("No OvCoreId is set",COREREC)
$        IF (tmp_id1 .NE. F$LENGTH(COREREC))
$        THEN
$        CALL display_writelog_msg "Creating COREID for managed node"
$        ovcoreid -create
$        ovconfchg
$        ENDIF      
$!
$!1. Get management server COREID.
$ IF (OVO_SERVER .NES. "") .AND. - 
         (F$SEARCH("OVO$POSIX_ROOT:[OPT.OV.BIN]OVBBCCB.EXE") .NES. "") .AND. - 
           (F$SEARCH("OVO$POSIX_ROOT:[OPT.OV.BIN]OVCONFGET.EXE") .NES. "")
$ THEN
$     DEFINE/USER_MODE SYS$OUTPUT NL:
$     ovbbccb -ping 'OVO_SERVER
$         IF $STATUS
$         THEN
$             define sys$output tempopcactivate.dat
$             pipe ovbbccb -ping 'OVO_SERVER | search sys$pipe "coreID"
$             deassign sys$output
$             OPEN/READ FD TEMPOPCACTIVATE.DAT
$             READ FD LINE
$             LINE = F$EDIT(LINE, "COMPRESS")
$             i = 0
$ loop_mgrid:
$             RECORD = F$ELEMENT(i," ", LINE)
$             IF RECORD .EQS. " "
$             THEN
$                 goto end_mgrid
$             ENDIF
$             pos = 0
$ sub_mgrid:
$             IF (F$EXTRACT(pos, 6, RECORD) .EQS. "")
$             THEN
$                 i= i+1
$                 goto loop_mgrid
$             ENDIF
$
$             IF (F$EXTRACT(pos, 6, RECORD) .EQS. "coreID")
$             THEN
$                 MGR_COREID=F$ELEMENT(1, "=", RECORD)
$             ELSE
$                 pos = pos+1
$                 goto sub_mgrid
$             ENDIF
$ end_mgrid:
$             CLOSE FD
$         ELSE
$             CALL display_writelog_msg "ERROR:    OV Comm.Broker on server is not reachable"
$             CALL display_writelog_msg "          Executing ovbbccb -ping 'OVO_SERVER failed."
$             CALL display_writelog_msg "          Check if ovbbccb on 'OVO_SERVER is running, "
$             CALL display_writelog_msg "          start it manually ovc -start ovbbccb"
$        ENDIF
$ ENDIF
$!
$! Step 2. Configure agent using provided agent profile.
$!
$ IF CONF_FILE .NES. ""
$ THEN 
$     IF (f$search(CONF_FILE) .NES. "") .AND. (f$search("OVO$POSIX_ROOT:[OPT.OV.BIN]OVCONFCHG.EXE") .NES. "")
$     THEN
$         CALL display_writelog_msg "          Configuring using agent profile."
$         IF f$search("OVO$POSIX_ROOT:[VAR.OPT.OV.DATAFILES.XPL.CONFIG]JOBS.DIR") .EQS. ""
$         THEN
$             CREATE/DIR OVO$POSIX_ROOT:[VAR.OPT.OV.DATAFILES.XPL.CONFIG.JOBS]
$         ENDIF
$         define sys$output OVO$POSIX_ROOT:[VAR.OPT.OV.DATAFILES.XPL.CONFIG.JOBS]chg00000.job
$         type 'CONF_FILE'
$         deassign sys$output
$!        copy 'CONF_FILE' OVO$POSIX_ROOT:[VAR.OPT.OV.DATAFILES.XPL.CONFIG.JOBS]chg00000.job
$!         CALL stop_ovc -kill
$!          WAIT 00:00:05
$         ovconfchg
$     ENDIF
$ ENDIF
$!
$! Step 3. Configure using provided server's nodename 
$!
$ IF (OVO_SERVER .NES. "") .AND. - 
         (F$SEARCH("OVO$POSIX_ROOT:[OPT.OV.BIN]OVCONFCHG.EXE") .NES. "") .AND. - 
           (F$SEARCH("OVO$POSIX_ROOT:[OPT.OV.BIN]OVCONFGET.EXE") .NES. "")
$ THEN
$     IF (CERT_SERVER .NES. "")
$     THEN
$         define sys$output tempopcactivate.dat
$         pipe ovconfget | search sys$pipe "CERTIFICATE_SERVER="
$         deassign sys$output
$         OPEN/READ FD TEMPOPCACTIVATE.DAT
$         READ FD RECORD
$         OLD_CSRV=F$ELEMENT(1,"=",RECORD)
$         CLOSE FD
$         DELETE tempopcactivate.dat;*
$         define sys$output tempopcactivate.dat
$         pipe ovconfget | search sys$pipe "MANAGER="
$         deassign sys$output
$         OPEN/READ FD TEMPOPCACTIVATE.DAT
$         READ FD RECORD
$         OLD_SRV=F$ELEMENT(1,"=",RECORD)
$         CLOSE FD
$         DELETE tempopcactivate.dat;* 
$    
$         IF (OLD_SRV .EQS. OLD_CSRV) .OR. (OLD_CSRV .EQS. "")
$         THEN
$             CERT_SERVER==OVO_SERVER 
$         ENDIF    
$     ENDIF
$!
$     IF f$search("OVO$POSIX_ROOT:[VAR.OPT.OV.DATAFILES.XPL.CONFIG]JOBS.DIR") .EQS. ""
$     THEN
$         CREATE/DIR OVO$POSIX_ROOT:[VAR.OPT.OV.DATAFILES.XPL.CONFIG.JOBS]
$     ENDIF
$     IF (CERT_SERVER .NES. "")
$     THEN
$         CALL display_writelog_msg "          Setting ''CERT_SERVER' as cert. server."
$         IF f$search("OVO$POSIX_ROOT:[VAR.OPT.OV.DATAFILES.XPL.CONFIG.JOBS]chg00000.job") .EQS. ""
$         THEN
$             OPEN/WRITE OUTFILE OVO$POSIX_ROOT:[VAR.OPT.OV.DATAFILES.XPL.CONFIG.JOBS]chg00000.job
$         ELSE
$             OPEN/APPEND OUTFILE OVO$POSIX_ROOT:[VAR.OPT.OV.DATAFILES.XPL.CONFIG.JOBS]chg00000.job
$         ENDIF
$         record1="set sec.cm.client:CERTIFICATE_SERVER="+CERT_SERVER
$         WRITE OUTFILE record1
$         CLOSE OUTFILE   
$     ENDIF
$     IF (MGR_COREID .NES. "")
$     THEN
$         CALL display_writelog_msg "          Setting ''OVO_SERVER' as mgmt server."
$         IF f$search("OVO$POSIX_ROOT:[VAR.OPT.OV.DATAFILES.XPL.CONFIG.JOBS]chg00000.job") .EQS. ""
$         THEN
$             OPEN/WRITE OUTFILE OVO$POSIX_ROOT:[VAR.OPT.OV.DATAFILES.XPL.CONFIG.JOBS]chg00000.job
$         ELSE
$             OPEN/APPEND OUTFILE OVO$POSIX_ROOT:[VAR.OPT.OV.DATAFILES.XPL.CONFIG.JOBS]chg00000.job
$         ENDIF
$         record1="set sec.core.auth:MANAGER="+OVO_SERVER
$         record2="set sec.core.auth:MANAGER_ID="+MGR_COREID
$          
$         WRITE OUTFILE record1
$         WRITE OUTFILE record2
$         CLOSE OUTFILE   
$     ENDIF
$     IF f$search("OVO$POSIX_ROOT:[VAR.OPT.OV.DATAFILES.XPL.CONFIG.JOBS]chg00000.job") .NES. ""
$     THEN
$!         CALL stop_ovc -kill
$!        WAIT 00:00:05
$         CALL display_writelog_msg "          Applying changes by calling ovconfchg."
$         ovconfchg
$! TODO "validate wether MANAGER ,MANAGERID updated in the config
$! TODO "validate the certificate installation
$     ENDIF 
$ ENDIF
$
$! Step 4.  Add boot entry (to be added)
$
$! Step 6.  Start OVC processes
$ IF OVO_START .EQ. 1
$ THEN
$     CALL start_ovc
$     CALL display_writelog_msg "          opcactivate successfully ended."
$ ENDIF
$ EXIT
$! The END
$!
$ START_OVC:SUBROUTINE
$!
$ FILE=F$SEARCH("OVO$POSIX_ROOT:[OPT.OV.BIN]OVC.EXE")
$ IF FILE .EQS. ""
$ THEN 
$     WRITE SYS$OUTPUT "OVC.EXE does not exist"
$     EXIT
$ ENDIF
$ CALL display_writelog_msg "          Starting OVC."
$ ovc -start
$
$ IF .NOT. $STATUS
$ THEN
$    CALL display_writelog_msg "          Failed to start Agent processes."
$    EXIT
$ ELSE
$    CALL display_writelog_msg "          Agent processes are started."
$!    ovcert -certreq
$!    WAIT 00:04
$!    ovconfchg
$ ENDIF
$ EXIT
$ ENDSUBROUTINE
$
$
$
$stop_ovc:SUBROUTINE
$       if p1 .nes. ""
$       then
$!       write sys$output p1
$               if p1 .eqs. "-STOP"
$               then
$               stop_param="-stop"
$               GOTO end_process_params
$               endif
$
$               if p1 .eqs. "-STOPAGENT"
$               then
$               stop_param="-stop AGENT"
$               GOTO end_process_params
$               endif
$
$
$               if p1 .eqs. "-STOPCODA"
$               then
$               stop_param="-stop CODA"
$               GOTO end_process_params
$               endif
$
$               if p1 .eqs. "-KILL"
$               then
$               stop_param="-kill"
$               GOTO end_process_params
$               else
$               EXIT
$               endif
$
$
$       else
$!               write sys$output " parameter missing"
$                EXIT
$       endif
$end_process_params:
$! Check if OVCD is running (to be completed)
$
$ FILE=F$SEARCH("OVO$POSIX_ROOT:[OPT.OV.BIN]OVC.EXE")
$ IF FILE .EQS. ""
$ THEN 
$     WRITE SYS$OUTPUT "OVC.EXE does not exist"
$     EXIT
$ ENDIF
$ CALL display_writelog_msg "          Stopping OVC."
$ ovc 'stop_param
$ IF .NOT. $STATUS
$ THEN
$    CALL display_writelog_msg "          Failed to stop OVC."
$    EXIT
$ ELSE
$    CALL display_writelog_msg "          OVC is stopped."
$ ENDIF
$ EXIT
$ ENDSUBROUTINE
$
$
$display_writelog_msg:SUBROUTINE
$ write sys$output p1
$ open/append/error=check opcinstfile ovo$instlog:opc_inst.log
$ write opcinstfile p1
$ close opcinstfile
$ EXIT
$check:
$ err_message = f$message($status)
$ write sys$output "error opening opc_inst.log"
$ write sys$output err_message
$ EXIT
$ ENDSUBROUTINE
$
$
$! write subroutine for opc_server_check (to be added)
$
$
$
$!==============================================================================
$!
$!  DESCRIPTION
$!
$!    Display current setting
$!
$bbc_trace_old_settings:SUBROUTINE
$ FILE=F$SEARCH("OVO$POSIX_ROOT:[OPT.OV.BIN]OVCONFGET.EXE")
$ IF FILE .EQS. ""
$ THEN 
$     CALL display_writelog_msg  "OVCONFGET.EXE does not exist"
$     EXIT
$ ENDIF
$ define sys$output tempopcactivate.dat
$ pipe ovconfget | search sys$pipe "CERTIFICATE_SERVER="
$ deassign sys$output
$ OPEN/READ FD TEMPOPCACTIVATE.DAT
$ READ FD RECORD
$ _CERT_SERVER=F$ELEMENT(1,"=",RECORD)
$ CLOSE FD
$ DELETE tempopcactivate.dat;*
$       
$ define sys$output tempopcactivate.dat
$ pipe ovconfget | search sys$pipe "MANAGER="
$ deassign sys$output
$ OPEN/READ FD TEMPOPCACTIVATE.DAT
$ READ FD RECORD
$ _OVO_SERVER=F$ELEMENT(1,"=",RECORD)
$ CLOSE FD
$ DELETE tempopcactivate.dat;*
$
$ define sys$output tempopcactivate.dat
$ pipe ovconfget | search sys$pipe "CORE_ID="
$ deassign sys$output
$ OPEN/READ FD TEMPOPCACTIVATE.DAT
$ READ FD RECORD
$ _CORE_ID=F$ELEMENT(1,"=",RECORD)
$ CLOSE FD
$ DELETE tempopcactivate.dat;*
$
$ define sys$output tempopcactivate.dat
$ pipe ovconfget | search sys$pipe "CERT_INSTALLED="
$ deassign sys$output
$ OPEN/READ FD TEMPOPCACTIVATE.DAT
$ READ FD RECORD
$ _CERT_INST=F$ELEMENT(1,"=",RECORD)
$ CLOSE FD
$ DELETE tempopcactivate.dat;*
$
$ IF _CERT_INST .EQS. "TRUE"
$ THEN
$ define sys$output tempopcactivate.dat
$ pipe ovconfget | search sys$pipe "LAST_CERT_UPDATE="
$ deassign sys$output
$ OPEN/READ FD TEMPOPCACTIVATE.DAT
$ READ FD RECORD
$ _CERT_UPD=F$ELEMENT(1,"=",RECORD)
$ CLOSE FD
$ DELETE tempopcactivate.dat;*
$
$ define sys$output tempopcactivate.dat
$ pipe ovconfget | search sys$pipe "LAST_TRUSTED_CERT_UPDATE="
$ deassign sys$output
$ OPEN/READ FD TEMPOPCACTIVATE.DAT
$ READ FD RECORD
$ _TCERT_UPD=F$ELEMENT(1,"=",RECORD)
$ CLOSE FD
$ DELETE tempopcactivate.dat;*
$ ENDIF
$
$ CALL display_writelog_msg "NOTE:     The current system is configured with:"
$ CALL display_writelog_msg "          Core ID:                      ''_CORE_ID'"
$ CALL display_writelog_msg "          OVO Server hostname:         ''_OVO_SERVER'"
$ CALL display_writelog_msg "          Certificate server hostname: ''_CERT_SERVER'"
$ CALL display_writelog_msg "          Certificate installed:       ''_CERT_INST'" 
$ IF _CERT_INST .EQS. "TRUE"
$ THEN
$ CALL display_writelog_msg  "          Certificate updated:         ''_CERT_UPD'" 
$ CALL display_writelog_msg  "          Trusted certificate updated: ''_TCERT_UPD'" 
$ ENDIF
$ EXIT
$ ENDSUBROUTINE
$
$
$
$
$
$!==============================================================================
$!
$!  DESCRIPTION
$!
$!  Display running setting  
$!
$BBC_TRACE_NEW_SETTINGS:SUBROUTINE
$ CALL display_writelog_msg " "
$ CALL display_writelog_msg "NOTE:     opcactivate script will use the values:"
$ IF CONF_FILE .NES. ""
$ THEN
$ CALL display_writelog_msg "          Agent profile:                ''CONF_FILE'" 
$ ENDIF
$ IF OVO_SERVER .NES. ""
$ THEN
$ CALL display_writelog_msg "          OVO Server hostname:          ''OVO_SERVER'" 
$ ENDIF
$ IF CERT_SERVER .EQS. "" 
$ THEN
$ CERT_SERVER == ''OVO_SERVER'
$ ENDIF 
$ IF CERT_SERVER .NES. ""
$ THEN
$ CALL display_writelog_msg "          Certificate Server hostname:  ''CERT_SERVER'"
$ ENDIF 
$! CALL display_writelog_msg "          OV Control Core boot entry:   ''OVO_BOOT'"
$ CALL display_writelog_msg " "
$ ENDSUBROUTINE
$
$bbc_ac_usage:
$!
$ my_status = %x00000001
$       write sys$output ""
$       write sys$output ""
$       write sys$output "Usage:    opcactivate -h | <mgmt_srv> |  [-no_start]"
$       write sys$output "          [-configure <conf_file>] [-srv <mgmt_srv> [-cert_srv <cert_srv>] ]"
$       write sys$output "Options: "
$       write sys$output "          -h                    Display this message"
$       write sys$output "          -configure <cf>       Configure product using agent profile."
$       write sys$output "          -srv <hostname>       Set management server."
$       write sys$output "          -cert_srv <hostname>  Set certificate server."
$       write sys$output "          -no_boot              Set Control Core boot entry to False."
$       write sys$output "          -no_start             Do not start agent. "
$       write sys$output " "
$       write sys$output ""
$       write sys$output ""
$       write sys$output ""
$ RETURN my_status
$
$
$check_whois_executing:
$!+
$!  Make sure SYSTEM is executing this command procedure.
$!  If not, display a message and exit.
$!-
$ my_status = %x00000001
$ user_name = f$getjpi(0,"USERNAME")
$ user_name = f$edit( user_name, "UPCASE,COLLAPSE")
$ if user_name .nes. "SYSTEM"
$ then
$       write sys$output ""
$       write sys$output ""
$       write sys$output ""
$       write sys$output "Sorry..."
$       write sys$output "Only users logged into the SYSTEM account"
$       write sys$output "can execute this command procedure."
$       write sys$output ""
$       write sys$output ""
$       write sys$output ""
$       exit
$ endif
$ RETURN my_status
$
$
$
$!==============================================================================
$!
$!  DESCRIPTION
$!
$!  Perform parameter checks and check that calling user is superuser.
$!  PARAMETERS
$!
$!    -h ..  Display usage
$
$AC_ENTRY_CHECK:
$
$ my_status = %x00000001
$ gosub check_whois_executing
$ COUNT=0
$       if p1 .nes. ""
$       then
$!       write sys$output p1
$               if p1 .eqs. "-H"   
$               then
$               OVO_START=0
$               gosub bbc_ac_usage
$               CALL display_writelog_msg  "          opcactivate successfully ended."
$               EXIT
$               endif
$
$LOOP:  
$               COUNT=COUNT+1
$               IF P'COUNT' .eqs. ""
$               THEN
$               GOTO END_LOOP
$               ENDIF
$ 
$               if P'COUNT' .eqs. "-NO_START"
$               then
$               OVO_START=0
$               GOTO LOOP
$               endif
$
$               if P'COUNT' .eqs. "-NO_BOOT"
$               then
$               OVO_BOOT="FALSE"
$               GOTO LOOP
$               endif
$
$               if (P'COUNT' .eqs. "-CONFIGURE") .OR. (P'COUNT' .eqs. "-C")
$               then
$               COUNT=COUNT+1
$                 IF P'COUNT' .NES. ""
$                 THEN 
$                   CONF_FILE = P'COUNT'
$                   GOTO LOOP
$                 ELSE
$                   gosub bbc_ac_usage
$                   CALL display_writelog_msg  "          opcactivate ended."
$                   EXIT
$                 ENDIF
$               endif
$               
$               if (P'COUNT' .eqs. "-SRV") .OR. (P'COUNT' .eqs. "-S")
$               then
$               COUNT=COUNT+1
$                 IF P'COUNT' .NES. ""
$                 THEN 
$                   OVO_SERVER= P'COUNT'
$                   GOTO LOOP
$                 ELSE
$                   gosub bbc_ac_usage
$                   CALL display_writelog_msg  "          opcactivate ended."
$                   EXIT
$                 ENDIF
$               endif
$               
$               if (P'COUNT' .eqs. "-CERT_SRV") 
$               then
$               COUNT=COUNT+1
$                 IF P'COUNT' .NES. ""
$                 THEN 
$                   CERT_SERVER= P'COUNT'
$                   GOTO LOOP
$                 ELSE
$                   gosub bbc_ac_usage
$                   CALL display_writelog_msg  "          opcactivate ended."
$                   EXIT
$                 ENDIF
$		GOTO LOOP
$		endif
$		gosub bbc_ac_usage
$		CALL display_writelog_msg  "          opcactivate successfully ended."
$		EXIT           
$       else
$               gosub bbc_ac_usage
$               CALL bbc_trace_old_settings
$               CALL display_writelog_msg  "          opcactivate successfully ended."
$               EXIT
$       endif
$
$END_LOOP:
$          RETURN my_status
