$! Command procedure to install HTTPS Agents
$ ON CONTROL_C THEN GOTO error_end
$ ON CONTROL_Y THEN GOTO error_end
$ ON ERROR THEN GOTO error_end
$
$ IF ( (P1 .EQS. "-c") .OR. (P1 .EQS. "-C") )
$ THEN
$	IF F$SEARCH("sys$system:lock.lck") .NES. ""
$ 	THEN
$		OPEN/READ fd sys$system:lock.lck
$		read_next:
$		READ/end=done fd rec
$		generic = F$ELEMENT(0, " ", rec)
$		original = F$ELEMENT(1, " ", rec)
$		ext = F$ELEMENT(2, " ", rec)
$		IF F$SEARCH("''original'.''ext'") .NES. ""
$		THEN
$			RENAME ''original'.''ext' ''generic'.''ext'
$		ENDIF
$		GOTO read_next
$		done:
$		CLOSE fd
$		DELETE sys$system:lock.lck;*
$ 	ENDIF
$	WRITE SYS$OUTPUT "Done."
$	EXIT
$ ENDIF
$ IF (P1 .EQS. "-r") .OR. (P1 .EQS. "-R") 
$ THEN 
$	CALL opc_uninst
$       IF .NOT. $STATUS
$       THEN
$           WRITE SYS$OUTPUT "Error while uninstalling the product."
$	ELSE
$	    WRITE SYS$OUTPUT "Product UNINSTALLED successfully!"
$       ENDIF
$	EXIT
$ ENDIF
$ IF ((P1 .NES. "-i") .AND. (P1 .NES. "-I")) .OR. (P6 .EQS. "")
$ THEN
$ 	CALL print_usage
$	EXIT
$ ENDIF
$
$ IF F$SEARCH("sys$system:lock.lck") .NES. ""
$ THEN
$       WRITE SYS$OUTPUT "Previous installation aborted abnormally. Run ""@sys$update:opc_inst -c"" to correct the environment."
$       WRITE SYS$OUTPUT "Exiting..."
$       EXIT
$ ENDIF
$
$ set def sys$update
$ IF (P2 .NES. "" .AND. P3 .EQS. "") .AND. (P4 .NES. "" .AND. P5 .EQS. "")
$ THEN
$ 	CALL print_usage
$ 	EXIT
$ ENDIF  
$
$ IF ((P2 .EQS. "-srv") .OR. (P2 .EQS. "-SRV")).AND. ((P4 .EQS. "-cert_srv") .OR. (P4 .EQS. "-CERT_SRV")) 
$ THEN
$   PIPE PRODUCT SHOW PRODUCT OVOAGENTS > ovo7.txt
$   OPEN/READ fd_ovo7_scan ovo7.txt
$   READ/END=done_ovo7_scan fd_ovo7_scan ovo7_rec
$   READ/END=done_ovo7_scan fd_ovo7_scan ovo7_rec
$   READ/END=done_ovo7_scan fd_ovo7_scan ovo7_rec
$   READ/END=done_ovo7_scan fd_ovo7_scan ovo7_rec
$   done_ovo7_scan:
$   CLOSE fd_ovo7_scan
$   DELETE ovo7.txt;*
$   IF ovo7_rec .EQS. "1 item found"
$   THEN 
$	WRITE SYS$OUTPUT "OVO DCE Agents installed. Can not install HTTPS Agents!"
$       WRITE SYS$OUTPUT "Exiting..."
$	EXIT
$   ENDIF
$
$   write sys$output "************************************************************"
$   write sys$output "Open View HTTPS agents MUST be installed on ODS-5 Disk only"
$   write sys$output "************************************************************"
$   disk_name = P6
$   IF ( F$LOCATE(":",  disk_name) .NE. F$LENGTH(disk_name) ) THEN disk_name = disk_name - ":"
$
$   IF F$GETDVI ("''disk_name'", "ACPTYPE") .NES. "F11V5"
$   THEN
$      write sys$output "DISK is not ODS-5, Exiting..."
$      EXIT
$   ENDIF
$   prod_ver = ""   
$   IF F$SEARCH("SYS$COMMON:[SYSMGR]OVO8_INSTDIR.TXT") .NES. ""
$   THEN
$	GOSUB product_check
$!       IF (prod_status .EQ. 0)
$!       THEN
$!	    WRITE SYS$OUTPUT "Corrupted environment. Delete all OVO related files and try again."
$!	    EXIT 
$!	ENDIF
$	IF (prod_ver .EQS. "8.6-1") 
$	THEN
$	    OPEN/READ/ERROR=open_fd_err fd_node_list SYS$COMMON:[SYSMGR]OVO8_NODE_LIST.TXT
$	    read_node_list:
$	    READ/END_OF_FILE=done_node_list fd_node_list line_node_list
$ 	    IF( F$ELEMENT(1, "$", F$ELEMENT(0, "]", F$ELEMENT(1, "[", line_node_list))) .EQS. F$GETSYI("NODENAME"))
$	    THEN
$		WRITE SYS$OUTPUT "Agents are already installed on this node."
$               WRITE SYS$OUTPUT "Exiting..."
$               EXIT
$	    ELSE
$		GOTO read_node_list
$	    ENDIF
$	    done_node_list:
$	    CLOSE fd_node_list
$! Common system disk
$	    WRITE SYS$OUTPUT "Agents are installed on one of the cluster member. Configuring this cluster node..."
$	    CALL opc_clu_node_conf 'P2 'P3 'P4 'P5
$	    IF $STATUS
$	    THEN
$	    	WRITE SYS$OUTPUT "Cluster node configured SUCCESSFULLY!"
$	    	EXIT
$	    ELSE
$               WRITE SYS$OUTPUT "Error configuring the cluster node."
$               EXIT
$	    ENDIF
$       ENDIF
$       IF (prod_ver .EQS. "8.0") .OR. (prod_ver .EQS. "8.6")
$	THEN
$! Take backup of all the node specific directories
$	    OPEN/READ/ERROR=OPEN_ERR fd_node_file SYS$COMMON:[SYSMGR]OVO8_NODE_LIST.TXT
$           fd_node_file_loop:
$           READ/END_OF_FILE=close_fd_node_file fd_node_file fd_node_file_rec
$           disk_name = F$ELEMENT(0, ":", fd_node_file_rec)
$	    backup_node = fd_node_file_rec - "]" + "...]*.*;*"
$	    backup_saveset_name = F$ELEMENT(0, "[", fd_node_file_rec) + "[000000]" + (F$ELEMENT(1, "[", fd_node_file_rec) - "]" + ".BCK/SAV")
$ 	    WRITE SYS$OUTPUT "Taking backup of node specific directory..."
$	    DEFINE SYS$OUTPUT NL:
$           DEFINE SYS$ERROR NL:
$           BACKUP/IGNORE=INTERLOCK 'backup_node 'backup_saveset_name
$           DEASSIGN SYS$OUTPUT
$           DEASSIGN SYS$ERROR
$	    GOTO fd_node_file_loop
$	    close_fd_node_file:
$	    CLOSE fd_node_file
$	    CALL opc_uninst
$           IF .NOT. $STATUS
$           THEN
$		WRITE SYS$OUTPUT "Error while uninstalling the product."
$               EXIT
$           ENDIF
$	ENDIF
$   ENDIF
$   
$! Finding if the common directory and node specific directory exist on disk_name
$ 
$   node_specific_path = disk_name + ":[" + "OVO$" + f$getsyi("NODENAME") + "]"
$   node_specific_dir = disk_name + ":[000000]" + "OVO$" + f$getsyi("NODENAME") + ".DIR"
$   IF F$GETSYI("ARCH_NAME") .EQS. "Alpha" 
$   THEN 
$       check_common_path = disk_name + ":[" + "OVO$COMMON_ALPHA]"
$   	check_common_dir = disk_name + ":[000000]" + "OVO$COMMON_ALPHA.DIR"
$   ELSE
$   	IF F$GETSYI("ARCH_NAME") .EQS. "IA64" 
$       THEN
$	  check_common_path = disk_name + ":[" + "OVO$COMMON_IA64]"
$         check_common_dir = disk_name + ":[000000]" + "OVO$COMMON_IA64.DIR"
$   	ELSE
$         WRITE SYS$OUTPUT "Unknown architecture!"
$         EXIT
$   	ENDIF
$   ENDIF
$
$   IF F$SEARCH(check_common_dir) .NES. ""
$   THEN
$       WRITE SYS$OUTPUT "Agents are already installed on this disk for other node."
$       WRITE SYS$OUTPUT "Please choose another ODS-5 disk."
$       EXIT
$   ENDIF
$
$   IF F$SEARCH(node_specific_dir) .NES. ""
$   THEN
$   	WRITE SYS$OUTPUT "Node specific directory exists."
$    	EXIT
$   ENDIF
$
$   write  sys$output "Installing OpenView HTTPS Agents for OpenVMS on ''disk_name'..."
$
$   node_name=F$GETSYI("NODENAME")
$   CREATE/DIR 'check_common_path
$   CREATE/DIR 'node_specific_path 
$   CALL install_routine 'check_common_path 
$   agent_xml_dir = check_common_path - "]" + ".OVO.VAR.OPT.OV.INSTALLATION.INVENTORY]"
$   copy sys$update:OVO-Agent.xml 'agent_xml_dir
$   copy sys$update:opcactivate.com sys$manager
$ ELSE
$   CALL print_usage
$   EXIT
$ ENDIF
$!
$ OPEN/READ/ERROR=open_err_instdir infile SYS$COMMON:[SYSMGR]OVO8_INSTDIR.TXT
$ loop:
$     READ/END_OF_FILE=close_instdir infile line
$     IF F$LOCATE("PCSI$DESTINATION", line ) .EQ. F$LENGTH(line)
$     THEN
$         GOTO loop
$     ELSE
$         CLOSE infile
$     ENDIF
$!
$ INSTDIR = F$ELEMENT( 1, " ", F$ELEMENT(1, "=", LINE) )
$ OVO_POSIX_ROOT = F$EXTRACT(1, ( F$LOCATE("]",INSTDIR) - 1 ), INSTDIR) +"OVO.]"
$ POSIXDEV = F$EXTRACT(0, F$LOCATE(":", OVO_POSIX_ROOT) , OVO_POSIX_ROOT)
$ DEVNAME = F$GETDVI(POSIXDEV, "DEVNAM")
$ DEVNAME = DEVNAME - "_"
$! POSIX_ROOT = DEVNAME + F$EXTRACT(( F$LOCATE(":", OVO_POSIX_ROOT) + 1 ), F$LENGTH(OVO_POSIX_ROOT), OVO_POSIX_ROOT)
$ POSIX_ROOT2 = DEVNAME + F$EXTRACT(( F$LOCATE(":", OVO_POSIX_ROOT) + 1 ), F$LENGTH(OVO_POSIX_ROOT), OVO_POSIX_ROOT)
$ POSIX_ROOT1 = DEVNAME +"["+"OVO$"+node_name+".OVO."+"]"
$   IF F$GETSYI("ARCH_NAME") .EQS. "Alpha"
$   THEN
$	 POSIX_ROOT3 = DEVNAME +"["+"OVO$COMMON_ALPHA.OVO."
$   ELSE
$       IF F$GETSYI("ARCH_NAME") .EQS. "IA64"
$       THEN
$ 	    POSIX_ROOT3 = DEVNAME +"["+"OVO$COMMON_IA64.OVO."
$ 	ELSE
$           WRITE SYS$OUTPUT "Unknown architecture!"
$           EXIT
$       ENDIF
$   ENDIF
$ POSIX_ROOT = "''POSIX_ROOT1'"+","+"''POSIX_ROOT2'"
$ WRITE SYS$OUTPUT "Defining OVO$POSIX_ROOT to ''POSIX_ROOT'"
$ DEFINE/SYSTEM/SUPER/NOLOG/TRANS=(CONC,TERM) OVO$POSIX_ROOT 'POSIX_ROOT 
$ copy opc_inst.log OVO$POSIX_ROOT:[var.opt.OV.log]opc_inst.log
$ COPY opc_inst.com OVO$POSIX_ROOT:[opt.ov.bin.opc.install]opc_inst.com
$ dir_name = DEVNAME +"["+"OVO$"+node_name+"]"
$ OPEN/WRITE/ERROR=log_write_err log SYS$COMMON:[SYSMGR]OVO8_NODE_LIST.TXT
$ write log dir_name
$ close log
$ IF (prod_ver .EQS. "8.0") .OR. (prod_ver .EQS. "8.6")
$ THEN
$     	WRITE SYS$OUTPUT "Restoring the existing configuration..."
$ 	backedup_node_name = F$ELEMENT(1, "[", F$ELEMENT(0, ".", backup_node))
$ 	restor_loc = posix_root1 - "]"
$	selection = "[" + backedup_node_name + ".OVO.VAR.OPT.OV.CONF.XPL.CONFIG]LOCAL_SETTINGS.INI"
$	extract_to = restor_loc + "VAR.OPT.OV.CONF.XPL.CONFIG]" 
$ 	BACKUP/REPLACE 'backup_saveset_name /SELECT='selection 'extract_to
$	convert_file_name = extract_to + "LOCAL_SETTINGS.INI"
$	CONVERT/FDL=SYS$INPUT 'convert_file_name 'convert_file_name
           FILE
                   ORGANIZATION            SEQUENTIAL

           RECORD
                   CARRIAGE_CONTROL        CARRIAGE_RETURN
                   FORMAT                  STREAM_LF
$
$ 	ovconfchg -ns sec.cm.certificates -clear "CERT_INSTALLED"
$ 	ovconfchg -ns sec.cm.certificates -clear "LAST_CERT_UPDATE"
$ 	ovconfchg -ns sec.cm.certificates -clear "LAST_TRUSTED_CERT_UPDATE"
$ 	WRITE SYS$OUTPUT "Files restored from backup save set successfully!"
$ ENDIF
$ WRITE SYS$OUTPUT "Please wait while opcactivate configures the installation and restart the agents..."
$ @SYS$MANAGER:OPCACTIVATE /OUTPUT=SYS$ERRORLOG:inst_opcactivate.log  'P2 'P3 'P4 'P5
$ IF .NOT. $STATUS THEN EXIT
$ @sys$startup:ovo8$define /OUTPUT=SYS$ERRORLOG:inst_define.log 
$ IF F$SEARCH("SYS$ERRORLOG:inst_opcactivate.log") .NES. "" 
$ THEN 
$     TYPE SYS$ERRORLOG:inst_opcactivate.log 
$     DELETE SYS$ERRORLOG:inst_opcactivate.log;*
$ ENDIF
$ IF F$SEARCH("SYS$ERRORLOG:inst_define.log") .NES. "" THEN DELETE SYS$ERRORLOG:inst_define.log;*
$
$! WRITE SYS$OUTPUT "Restarting Agents..."
$ ovc -kill
$ ovc -start
$ WRITE SYS$OUTPUT "OVO Agents installed SUCCESSFULLY!"
$ EXIT 
$! Begin install_routine
$ install_routine:SUBROUTINE
$     OPEN/WRITE fd_lock sys$system:lock.lck
$     RENAME HPOVBBC.PCSI$COMPRESSED;1 HP-AXPVMS-OVBBC-V0806-1-1.PCSI$COMPRESSED;1
$     WRITE/ERROR=err_lock fd_lock "HPOVBBC HP-AXPVMS-OVBBC-V0806-1-1 PCSI$COMPRESSED;1"
$     RENAME HPOVBBC.PCSI$COMPRESSED_ESW;1 HP-AXPVMS-OVBBC-V0806-1-1.PCSI$COMPRESSED_ESW;1
$     WRITE/ERROR=err_lock fd_lock "HPOVBBC HP-AXPVMS-OVBBC-V0806-1-1 PCSI$COMPRESSED_ESW;1"
$     RENAME HPOVCONF.PCSI$COMPRESSED;1 HP-AXPVMS-OVCONF-V0806-1-1.PCSI$COMPRESSED;1
$     WRITE/ERROR=err_lock fd_lock "HPOVCONF HP-AXPVMS-OVCONF-V0806-1-1 PCSI$COMPRESSED;1"
$     RENAME HPOVCONF.PCSI$COMPRESSED_ESW;1 HP-AXPVMS-OVCONF-V0806-1-1.PCSI$COMPRESSED_ESW;1
$     WRITE/ERROR=err_lock fd_lock "HPOVCONF HP-AXPVMS-OVCONF-V0806-1-1 PCSI$COMPRESSED_ESW;1"
$     RENAME HPOVCTRL.PCSI$COMPRESSED;1 HP-AXPVMS-OVCTRL-V0806-1-1.PCSI$COMPRESSED;1
$     WRITE/ERROR=err_lock fd_lock "HPOVCTRL HP-AXPVMS-OVCTRL-V0806-1-1 PCSI$COMPRESSED;1"
$     RENAME HPOVCTRL.PCSI$COMPRESSED_ESW;1 HP-AXPVMS-OVCTRL-V0806-1-1.PCSI$COMPRESSED_ESW;1
$     WRITE/ERROR=err_lock fd_lock "HPOVCTRL HP-AXPVMS-OVCTRL-V0806-1-1 PCSI$COMPRESSED_ESW;1"
$     RENAME HPOVDEPL.PCSI$COMPRESSED;1 HP-AXPVMS-OVDEPL-V0806-1-1.PCSI$COMPRESSED;1
$     WRITE/ERROR=err_lock fd_lock "HPOVDEPL HP-AXPVMS-OVDEPL-V0806-1-1 PCSI$COMPRESSED;1"
$     RENAME HPOVDEPL.PCSI$COMPRESSED_ESW;1 HP-AXPVMS-OVDEPL-V0806-1-1.PCSI$COMPRESSED_ESW;1
$     WRITE/ERROR=err_lock fd_lock "HPOVDEPL HP-AXPVMS-OVDEPL-V0806-1-1 PCSI$COMPRESSED_ESW;1"
$     RENAME HPOVEAAGT.PCSI$COMPRESSED;1 HP-AXPVMS-OVEAAGT-V0806-1-1.PCSI$COMPRESSED;1
$     WRITE/ERROR=err_lock fd_lock "HPOVEAAGT HP-AXPVMS-OVEAAGT-V0806-1-1 PCSI$COMPRESSED;1"
$     RENAME HPOVEAAGT.PCSI$COMPRESSED_ESW;1 HP-AXPVMS-OVEAAGT-V0806-1-1.PCSI$COMPRESSED_ESW;1
$     WRITE/ERROR=err_lock fd_lock "HPOVEAAGT HP-AXPVMS-OVEAAGT-V0806-1-1 PCSI$COMPRESSED_ESW;1"
$     RENAME HPOVSECCC.PCSI$COMPRESSED;1 HP-AXPVMS-OVSECCC-V0806-1-1.PCSI$COMPRESSED;1
$     WRITE/ERROR=err_lock fd_lock "HPOVSECCC HP-AXPVMS-OVSECCC-V0806-1-1 PCSI$COMPRESSED;1"
$     RENAME HPOVSECCC.PCSI$COMPRESSED_ESW;1 HP-AXPVMS-OVSECCC-V0806-1-1.PCSI$COMPRESSED_ESW;1
$     WRITE/ERROR=err_lock fd_lock "HPOVSECCC HP-AXPVMS-OVSECCC-V0806-1-1 PCSI$COMPRESSED_ESW;1"
$     RENAME HPOVSECCO.PCSI$COMPRESSED;1 HP-AXPVMS-OVSECCO-V0806-1-1.PCSI$COMPRESSED;1
$     WRITE/ERROR=err_lock fd_lock "HPOVSECCO HP-AXPVMS-OVSECCO-V0806-1-1 PCSI$COMPRESSED;1"
$     RENAME HPOVSECCO.PCSI$COMPRESSED_ESW;1 HP-AXPVMS-OVSECCO-V0806-1-1.PCSI$COMPRESSED_ESW;1
$     WRITE/ERROR=err_lock fd_lock "HPOVSECCO HP-AXPVMS-OVSECCO-V0806-1-1 PCSI$COMPRESSED_ESW;1"
$     RENAME HPOVXPL.PCSI$COMPRESSED;1 HP-AXPVMS-OVXPL-V0806-1-1.PCSI$COMPRESSED;1
$     WRITE/ERROR=err_lock fd_lock "HPOVXPL HP-AXPVMS-OVXPL-V0806-1-1 PCSI$COMPRESSED;1"
$     RENAME HPOVXPL.PCSI$COMPRESSED_ESW;1 HP-AXPVMS-OVXPL-V0806-1-1.PCSI$COMPRESSED_ESW;1
$     WRITE/ERROR=err_lock fd_lock "HPOVXPL HP-AXPVMS-OVXPL-V0806-1-1 PCSI$COMPRESSED_ESW;1"
$     RENAME HPVMSSPI.PCSI$COMPRESSED;1 HP-AXPVMS-VMSSPI-V0806-1-1.PCSI$COMPRESSED;1
$     WRITE/ERROR=err_lock fd_lock "HPVMSSPI HP-AXPVMS-VMSSPI-V0806-1-1 PCSI$COMPRESSED;1"
$     RENAME HPVMSSPI.PCSI$COMPRESSED_ESW;1 HP-AXPVMS-VMSSPI-V0806-1-1.PCSI$COMPRESSED_ESW;1
$     WRITE/ERROR=err_lock fd_lock "HPVMSSPI HP-AXPVMS-VMSSPI-V0806-1-1 PCSI$COMPRESSED_ESW;1"
$     err_lock:
$     CLOSE fd_lock
$     dest_disk = P1
$     write sys$output "OVXPL package is being installed..."
$     open/write log opc_inst.log
$     write log "OVXPL package is being installed"
$     product install/destination='dest_disk'/options=(NOCONFIRM) OVXPL
$     write sys$output "OVSECCO package is being installed..." 
$     write log "OVSECCO package is being installed"
$     product install/destination='dest_disk'/options=(NOCONFIRM) OVSECCO
$     write sys$output "OVBBC package is being installed..."
$     write log "OVBBC package is being installed"
$     product install/destination='dest_disk'/options=(NOCONFIRM)  OVBBC
$     write sys$output "OVSECCC package is being installed..." 
$     write log "OVSECCC package is being installed"
$     product install/destination='dest_disk'/options=(NOCONFIRM) OVSECCC
$     write sys$output "OVDEPL package is being installed..."  
$     write log "OVDEPL package is being installed"
$     product install/destination='dest_disk'/options=(NOCONFIRM) OVDEPL
$     write sys$output "OVCTRL package is being installed..."
$     write log "OVCTRL package is being installed"
$     product install/destination='dest_disk'/options=(NOCONFIRM) OVCTRL
$     write sys$output "OVCONF package is being installed..."
$     write log "OVCONF package is being installed"
$     product install/destination='dest_disk'/options=(NOCONFIRM) OVCONF
$     write sys$output "OVEAAGT package is being installed..."
$     write log "OVEAAGT package is being installed"
$     product install/destination='dest_disk'/options=(NOCONFIRM) OVEAAGT
$     write sys$output "VMSSPI package is being installed..."
$     write log "VMSSPI package is being installed..."
$     product install/destination='dest_disk'/options=(NOCONFIRM) VMSSPI
$     close log
$     RENAME HP-AXPVMS-OVBBC-V0806-1-1.PCSI$COMPRESSED;1 HPOVBBC.PCSI$COMPRESSED;1
$     RENAME HP-AXPVMS-OVBBC-V0806-1-1.PCSI$COMPRESSED_ESW;1 HPOVBBC.PCSI$COMPRESSED_ESW;1
$     RENAME HP-AXPVMS-OVCONF-V0806-1-1.PCSI$COMPRESSED;1 HPOVCONF.PCSI$COMPRESSED;1
$     RENAME HP-AXPVMS-OVCONF-V0806-1-1.PCSI$COMPRESSED_ESW;1 HPOVCONF.PCSI$COMPRESSED_ESW;1
$     RENAME HP-AXPVMS-OVCTRL-V0806-1-1.PCSI$COMPRESSED;1 HPOVCTRL.PCSI$COMPRESSED;1
$     RENAME HP-AXPVMS-OVCTRL-V0806-1-1.PCSI$COMPRESSED_ESW;1 HPOVCTRL.PCSI$COMPRESSED_ESW;1
$     RENAME HP-AXPVMS-OVDEPL-V0806-1-1.PCSI$COMPRESSED;1 HPOVDEPL.PCSI$COMPRESSED;1
$     RENAME HP-AXPVMS-OVDEPL-V0806-1-1.PCSI$COMPRESSED_ESW;1 HPOVDEPL.PCSI$COMPRESSED_ESW;1
$     RENAME HP-AXPVMS-OVEAAGT-V0806-1-1.PCSI$COMPRESSED;1 HPOVEAAGT.PCSI$COMPRESSED;1
$     RENAME HP-AXPVMS-OVEAAGT-V0806-1-1.PCSI$COMPRESSED_ESW;1 HPOVEAAGT.PCSI$COMPRESSED_ESW;1
$     RENAME HP-AXPVMS-OVSECCC-V0806-1-1.PCSI$COMPRESSED;1 HPOVSECCC.PCSI$COMPRESSED;1
$     RENAME HP-AXPVMS-OVSECCC-V0806-1-1.PCSI$COMPRESSED_ESW;1 HPOVSECCC.PCSI$COMPRESSED_ESW;1
$     RENAME HP-AXPVMS-OVSECCO-V0806-1-1.PCSI$COMPRESSED;1 HPOVSECCO.PCSI$COMPRESSED;1
$     RENAME HP-AXPVMS-OVSECCO-V0806-1-1.PCSI$COMPRESSED_ESW;1 HPOVSECCO.PCSI$COMPRESSED_ESW;1
$     RENAME HP-AXPVMS-OVXPL-V0806-1-1.PCSI$COMPRESSED;1 HPOVXPL.PCSI$COMPRESSED;1
$     RENAME HP-AXPVMS-OVXPL-V0806-1-1.PCSI$COMPRESSED_ESW;1 HPOVXPL.PCSI$COMPRESSED_ESW;1
$     RENAME HP-AXPVMS-VMSSPI-V0806-1-1.PCSI$COMPRESSED;1 HPVMSSPI.PCSI$COMPRESSED;1
$     RENAME HP-AXPVMS-VMSSPI-V0806-1-1.PCSI$COMPRESSED_ESW;1 HPVMSSPI.PCSI$COMPRESSED_ESW;1
$     DELETE sys$system:lock.lck;*
$     ENDSUBROUTINE
$! End of install_routine
$
$! Begin print_usage
$ print_usage:SUBROUTINE
$       WRITE SYS$OUTPUT ""
$	WRITE SYS$OUTPUT "opc_inst: An installation and uninstallation script for OVO HTTPS Agents V8.6."
$       WRITE SYS$OUTPUT ""
$       WRITE SYS$OUTPUT "Usage: @sys$update:opc_inst -c | -r | [-i -srv <MgmtSrvName> -cert_srv <CertSrvName> <disk_name>]"
$       WRITE SYS$OUTPUT ""
$       WRITE SYS$OUTPUT "-c: Correct the environment. Used when the previous installation is failed."
$       WRITE SYS$OUTPUT "-r: Removes the product"
$       WRITE SYS$OUTPUT "-i: Install the product using -srv as the management server and -cert_srv as the certificate server"
$       WRITE SYS$OUTPUT ""
$ ENDSUBROUTINE
$! End of print_usage
$
$! Begin opc_uninst
$ opc_uninst:SUBROUTINE
$	IF F$SEARCH("SYS$COMMON:[SYSMGR]OVO8_INSTDIR.TXT") .EQS. ""
$	THEN
$	    GOTO uninst_prod_not_found 
$	ENDIF
$           OPEN/READ/ERROR=err_uninst_node_list node_file_for_stop SYS$COMMON:[SYSMGR]OVO8_NODE_LIST.TXT
$           node_file_for_stop_loop:
$           READ/END_OF_FILE=done_fd_node_file node_file_for_stop node_file_for_stop_rec
$           stop_node_name = F$ELEMENT(1, "$", F$ELEMENT(1, "[", node_file_for_stop_rec)) - "]"
$! Create a temp file with commands to shutdown SPI and Agents on all cluster nodes
$           OPEN/WRITE/ERROR=cl_cant_open fd_stop stop_agents.com
$           WRITE/ERROR=cl_cant_write fd_stop "SET ENV/NODE=''stop_node_name'"
$           WRITE/ERROR=cl_cant_write fd_stop "do @sys$startup:ovo8$define"
$           WRITE/ERROR=cl_cant_rite fd_stop "do @sys$startup:vmsspi$shutdown"
$           WRITE/ERROR=cl_cant_write fd_stop "do @sys$startup:ovo8$shutdown.com"
$           CLOSE fd_stop
$           WRITE SYS$OUTPUT "Shutting down VMSSPI and OVO Agents on the node ''stop_node_name'..."
$ 	    OPEN/WRITE/ERROR=open_sysman_stop_agents fd_sysman_stop_agents sysman_stop_agents.com
$	    WRITE/ERROR=write_sysman_stop_agents fd_sysman_stop_agents "$ mc sysman"
$ 	    WRITE/ERROR=write_sysman_stop_agents fd_sysman_stop_agents "@stop_agents"
$ 	    WRITE/ERROR=write_sysman_stop_agents fd_sysman_stop_agents  "exit"
$ 	    CLOSE fd_sysman_stop_agents
$ 	    @sysman_stop_agents /OUTPUT=SYS$ERRORLOG:sysman_stop_agents.log
$           IF F$SEARCH("SYS$ERRORLOG:sysman_stop_agents.log") .NES. "" THEN DELETE SYS$ERRORLOG:sysman_stop_agents.log;*
$           IF F$SEARCH("stop_agents.com") .NES. "" THEN DELETE stop_agents.com;*
$	    GOTO node_file_for_stop_loop
$ 	    done_fd_node_file:
$ 	    CLOSE node_file_for_stop
$	WRITE SYS$OUTPUT "Uninstalling OVO Agents..."
$
$       product remove/options=(NOCONFIRM) VMSSPI
$       product remove/options=(NOCONFIRM) OVEAAGT
$       product remove/options=(NOCONFIRM) OVCONF
$       product remove/options=(NOCONFIRM) OVCTRL
$       product remove/options=(NOCONFIRM) OVDEPL
$       product remove/options=(NOCONFIRM) OVSECCC
$       product remove/options=(NOCONFIRM)  OVBBC
$       product remove/options=(NOCONFIRM) OVSECCO
$       product remove/options=(NOCONFIRM) OVXPL
$
$! Delete OVO Common Directory
$ OPEN/READ/ERROR=err_uninst_node_list fd_uninst SYS$COMMON:[SYSMGR]OVO8_INSTDIR.TXT
$ READ/END=fd_close fd_uninst rec
$ fd_close:
$ CLOSE fd_uninst
$ common_dir = F$ELEMENT(3, """", rec) - "]"
$ common_disk = F$ELEMENT(0, ":", common_dir)
$ common_path = "''common_dir'" + "..]*.*;*"
$ IF F$GETSYI("ARCH_NAME") .EQS. "Alpha"
$ THEN
$    common_entry = "''common_disk'" + ":[000000]OVO$COMMON_ALPHA.DIR;1"
$ ELSE
$    common_entry = "''common_disk'" + ":[000000]OVO$COMMON_IA64.DIR;1"
$ ENDIF
$
$ IF F$SEARCH(common_entry) .NES. ""
$ THEN
$   DEFINE SYS$OUTPUT NL:
$   DEFINE SYS$ERROR NL:
$   GOTO delete_common
$ ELSE
$   GOTO delete_node
$ ENDIF
$ delete_common:
$ DELETE 'common_path
$ IF $STATUS
$ THEN
$   DEASSIGN SYS$OUTPUT
$   DEASSIGN SYS$ERROR
$ ELSE
$   GOTO delete_common
$ ENDIF
$ DELETE 'common_entry
$! Delete all node specific directories and deassign the logicals
$ delete_node:
$ OPEN/READ/ERROR=err_uninst_node_list fd_uninst_node_list SYS$COMMON:[SYSMGR]OVO8_NODE_LIST.TXT
$ loop1:
$     READ/END_OF_FILE=close_uninst_node_list fd_uninst_node_list line
$     line1 = line - "]" + "...]*.*;*"
$     dir_name = F$ELEMENT(1, "[", line) - "]"
$     uninst_node_name = F$ELEMENT(1, "$", dir_name)
$! Create a temp file with commands to deassign the logicals
$ OPEN/WRITE/ERROR=cant_write FD CLEANUP.COM
$ WRITE/ERROR=cant_write FD "SET ENV/NODE=''uninst_node_name'"
$ WRITE/ERROR=cant_write FD "do/out if f$trnlnm(""OVO$POSIX_ROOT"") .NES. """" then deassign/system OVO$POSIX_ROOT"
$ WRITE/ERROR=cant_write FD "do/out if f$trnlnm(""OVO$LOGS"") .NES. """" then deassign/system OVO$LOGS"
$ WRITE/ERROR=cant_write FD "do/out if f$trnlnm(""OVO$LOGDIR"") .NES. """" then deassign/system OVO$LOGDIR"
$ WRITE/ERROR=cant_write FD "do/out if f$trnlnm(""OVO$INSTLOG"") .NES."""" then deassign/system OVO$INSTLOG"
$ WRITE/ERROR=cant_write FD "do/out if f$trnlnm(""OVDATADIR"") .NES."""" then deassign/system OVDATADIR"
$ WRITE/ERROR=cant_write FD "do/out if f$trnlnm(""OVINSTALLDIR"") .NES."""" then deassign/system OVINSTALLDIR"
$ WRITE/ERROR=cant_write FD "do/out if f$trnlnm(""OVO$SYSTEM"") .NES. """" then deassign/system OVO$SYSTEM"
$ WRITE/ERROR=cant_write FD "do/out if f$trnlnm(""OVO$MONITOR"") .NES. """" then deassign/system OVO$MONITOR"
$ WRITE/ERROR=cant_write FD "do/out if f$trnlnm(""OVO$ACTIONS"") .NES. """" then deassign/system OVO$ACTIONS"
$ WRITE/ERROR=cant_write FD "do/out if f$trnlnm(""OVO$CMDS"") .NES. """" then deassign/system OVO$CMDS"
$ WRITE/ERROR=cant_write FD "do/out if f$trnlnm(""OVO$INSTRUMENTATION"") .NES. """" then deassign/system OVO$INSTRUMENTATION"
$ WRITE/ERROR=cant_write FD "do/out if f$trnlnm(""OVO$MONITOR_PATH"") .NES. """" then deassign/system OVO$MONITOR_PATH"
$ WRITE/ERROR=cant_write FD "do/out if f$trnlnm(""OVO$ACTION_PATH"") .NES. """" then deassign/system OVO$ACTION_PATH"
$ WRITE/ERROR=cant_write FD "do/out if f$trnlnm(""OVO$LOGFILE_PATH"") .NES. """" then deassign/system OVO$LOGFILE_PATH"
$ WRITE/ERROR=cant_write FD "do/out if f$trnlnm(""OVO$CONTRIB"") .NES. """" then deassign/system OVO$CONTRIB"
$ WRITE/ERROR=cant_write FD "do/out if f$trnlnm(""OVO$AA_AUTHENTICATE"") .NES. """" then deassign/system OVO$AA_AUTHENTICATE"
$ WRITE/ERROR=cant_write FD "do/out if f$trnlnm(""OVO$BIN"") .NES. """" then deassign/system OVO$BIN"
$ WRITE/ERROR=cant_write FD "do/out if f$trnlnm(""OVO$CFG"") .NES. """" then deassign/system OVO$CFG"
$ WRITE/ERROR=cant_write FD "do/out if f$trnlnm(""OVO$LIB"") .NES. """" then deassign/system OVO$LIB"
$ WRITE/ERROR=cant_write FD "do/out if f$trnlnm(""OVO$INST"") .NES. """" then deassign/system OVO$INST"
$ WRITE/ERROR=cant_write FD "do/out if f$trnlnm(""OVO$UTIL"") .NES. """" then deassign/system OVO$UTIL"
$ WRITE/ERROR=cant_write FD "do/out if f$trnlnm(""OVO$LOG"") .NES. """" then deassign/system OVO$LOG"
$ WRITE/ERROR=cant_write FD "do/out if f$trnlnm(""OVO$TMP"") .NES. """" then deassign/system OVO$TMP"
$ WRITE/ERROR=cant_write FD "do/out if f$trnlnm(""OVO$ODS5_AVAIL"") .NES. """" then deassign/job OVO$ODS5_AVAIL"
$ WRITE/ERROR=cant_write FD "do/out if f$trnlnm(""SYS$POSIX_ROOT"") .NES. """" then deassign/job SYS$POSIX_ROOT"
$ WRITE/ERROR=cant_write FD "do/out if f$search(""SYS$SYSROOT:[SYSMGR]ovo8$define.com"") .NES. """" then delete SYS$SYSROOT:[SYSMGR]ovo8$define.com;*"
$ WRITE/ERROR=cant_write FD "do/out if f$search(""SYS$SYSROOT:[SYSMGR]OPCACTIVATE.COM"") .NES. """" then delete SYS$SYSROOT:[SYSMGR]OPCACTIVATE.COM;*"
$ WRITE/ERROR=cant_write FD "do/out if f$search(""SYS$SYSROOT:[SYSMGR]OVO8$STARTUP.COM"") .NES. """" then delete SYS$SYSROOT:[SYSMGR]OVO8$STARTUP.COM;*"
$ WRITE/ERROR=cant_write FD "do/out if f$search(""SYS$SYSROOT:[SYSMGR]OVO8$SHUTDOWN.COM"") .NES. """" then delete SYS$SYSROOT:[SYSMGR]OVO8$SHUTDOWN.COM;*"
$ WRITE/ERROR=cant_write FD "do/out if f$search(""SYS$SYSROOT:[SYSMGR]VMSSPI$STARTUP.COM"") .NES. """" then delete SYS$SYSROOT:[SYSMGR]VMSSPI$STARTUP.COM;*"
$ WRITE/ERROR=cant_write FD "do/out if f$search(""SYS$SYSROOT:[SYSMGR]VMSSPI$SHUTDOWN.COM"") .NES. """" then delete SYS$SYSROOT:[SYSMGR]VMSSPI$SHUTDOWN;*"
$ WRITE/ERROR=cant_write FD "do/out if f$search(""SYS$SYSROOT:[SYSLIB]OVO$LIBOPC_R.EXE"") .NES. """" then delete SYS$SYSROOT:[SYSLIB]OVO$LIBOPC_R.EXE;*"
$ WRITE/ERROR=cant_write FD "do/out if f$search(""SYS$SYSROOT:[SYSMGR]OPC_UNINST.COM"") .NES. """" then delete SYS$SYSROOT:[SYSMGR]OPC_UNINST.COM;*"
$ WRITE/ERROR=cant_write FD "do/out if f$search(""SYS$SYSROOT:[SYSMGR]OPC_CLU_NODE_CONF.COM"") .NES. """" then delete SYS$SYSROOT:[SYSMGR]OPC_UNINST.COM;*"
$ WRITE/ERROR=cant_write FD "do/out if f$search(""SYS$SYSROOT:[SYSMGR]OPC_PATCH_CLU_NODE_CONF.COM"") .NES. """" then delete SYS$SYSROOT:[SYSMGR]OPC_PATCH_CLU_NODE_CONF.COM;*"
$ WRITE/ERROR=cant_write FD "do/out if f$search(""SYS$SHARE:OVO$XPL_SHARE.EXE"") .NES. """" then delete SYS$SHARE:OVO$XPL_SHARE.EXE;*"
$ WRITE/ERROR=cant_write FD "do/out if f$search(""SYS$SHARE:OVO$BBC_SHARE.EXE"") .NES. """" then delete SYS$SHARE:OVO$BBC_SHARE.EXE;*"
$ WRITE/ERROR=cant_write FD "do/out if f$search(""SYS$SHARE:OVO$CONF_SHARE.EXE"") .NES. """" then delete SYS$SHARE:OVO$CONF_SHARE.EXE;*"
$ WRITE/ERROR=cant_write FD "do/out if f$search(""SYS$SHARE:OVO$CTRL_SHARE.EXE"") .NES. """" then delete SYS$SHARE:OVO$CTRL_SHARE.EXE;*"
$ WRITE/ERROR=cant_write FD "do/out if f$search(""SYS$SHARE:OVO$DEPL_SHARE.EXE"") .NES. """" then delete SYS$SHARE:OVO$DEPL_SHARE.EXE;*"
$ WRITE/ERROR=cant_write FD "do/out if f$search(""SYS$SHARE:OVO$SECCM_SHARE.EXE"") .NES. """" then delete SYS$SHARE:OVO$SECCM_SHARE.EXE;*"
$ WRITE/ERROR=cant_write FD "do/out if f$search(""SYS$SHARE:OVO$SECCORE_SHARE.EXE"") .NES. """" then delete SYS$SHARE:OVO$SECCORE_SHARE.EXE;*"
$ WRITE/ERROR=cant_write FD "do/out if f$search(""SYS$SHARE:OVO$PERLSHR.EXE"") .NES. """" then delete SYS$SHARE:OVO$PERLSHR.EXE;*"
$ WRITE/ERROR=cant_write FD "do/out if f$search(""SYS$SHARE:OVO$LIBOPC_R.EXE"") .NES. """" then delete SYS$SHARE:OVO$LIBOPC_R.EXE;*"
$ close_file:
$ CLOSE FD
$! Deassign all OVO logicals
$ WRITE SYS$OUTPUT "Deassigning the logicals defined by OVO on the node ''uninst_node_name'..."
$ OPEN/WRITE/ERROR=open_sysman_cleanup fd_sysman_cleanup sysman_cleanup.com
$ WRITE/ERROR=write_sysman_cleanup fd_sysman_cleanup "$ mc sysman"
$ WRITE/ERROR=write_sysman_cleanup fd_sysman_cleanup "@cleanup"
$ WRITE/ERROR=write_sysman_cleanup fd_sysman_cleanup "exit"
$ CLOSE fd_sysman_cleanup 
$ @sysman_cleanup /OUTPUT=SYS$ERRORLOG:sysman_cleanup.log
$ IF F$SEARCH("SYS$ERRORLOG:sysman_cleanup.log") .NES. "" THEN DELETE SYS$ERRORLOG:sysman_cleanup.log;*
$ IF F$SEARCH("cleanup.com") .NES. "" THEN DELETE cleanup.com;*
$ IF F$SEARCH("SYSMAN.LIS") .NES. "" THEN DELETE SYSMAN.LIS;*
$ DEFINE SYS$ERROR NL:
$ DEFINE SYS$OUTPUT NL:
$ loop2:
$     DELETE 'line1
$     IF $STATUS
$     THEN
$! Now delete the node specific directory.
$! Format root directory.
$         ROOT_DIR = F$EXTRACT(0,F$LOCATE("[",LINE) + 1, LINE) + "000000]"
$! Format node specific directory.
$         NODE_DIR = ROOT_DIR + F$EXTRACT( (F$LOCATE("[", LINE)+1), ((F$LOCATE("]",LINE) - F$LOCATE("[", LINE))-1), LINE) + ".DIR;*"
$         DELETE 'NODE_DIR
$   	  DEASSIGN SYS$OUTPUT
$   	  DEASSIGN SYS$ERROR
$         GOTO LOOP1
$     ELSE
$         GOTO LOOP2
$     ENDIF
$ 
$ close_uninst_node_list:
$     CLOSE fd_uninst_node_list
$       IF F$SEARCH("SYS$COMMON:[SYSMGR]ovo8$define.com") .NES. ""
$       THEN
$           DELETE SYS$COMMON:[SYSMGR]ovo8$define.com;*
$       ENDIF
$       IF F$SEARCH("SYS$COMMON:[SYSMGR]OPCACTIVATE.COM") .NES. ""
$       THEN
$           DELETE SYS$COMMON:[SYSMGR]OPCACTIVATE.COM;*
$       ENDIF
$       IF F$SEARCH("SYS$COMMON:[SYSMGR]OVO8$STARTUP.COM") .NES. ""
$       THEN
$           DELETE SYS$COMMON:[SYSMGR]OVO8$STARTUP.COM;*
$       ENDIF
$       IF F$SEARCH("SYS$COMMON:[SYSMGR]OVO8$SHUTDOWN.COM") .NES. ""
$       THEN
$           DELETE SYS$COMMON:[SYSMGR]OVO8$SHUTDOWN.COM;*
$       ENDIF
$       IF F$SEARCH("SYS$COMMON:[SYSMGR]VMSSPI$STARTUP.COM") .NES. ""
$       THEN
$           DELETE SYS$COMMON:[SYSMGR]VMSSPI$STARTUP.COM;*
$       ENDIF
$       IF F$SEARCH("SYS$COMMON:[SYSMGR]VMSSPI$SHUTDOWN.COM") .NES. ""
$       THEN
$           DELETE SYS$COMMON:[SYSMGR]VMSSPI$SHUTDOWN.COM;*
$       ENDIF
$       IF F$SEARCH("SYS$COMMON:[SYSLIB]OVO$LIBOPC_R.EXE") .NES. ""
$       THEN
$           DELETE SYS$COMMON:[SYSLIB]OVO$LIBOPC_R.EXE;*
$       ENDIF
$       IF F$SEARCH("SYS$COMMON:[SYSMGR]OPC_UNINST.COM") .NES. ""
$       THEN
$           DELETE SYS$COMMON:[SYSMGR]OPC_UNINST.COM;*
$       ENDIF
$       IF F$SEARCH("SYS$COMMON:[SYSMGR]OPC_CLU_NODE_CONF.COM") .NES. ""
$       THEN
$           DELETE SYS$COMMON:[SYSMGR]OPC_CLU_NODE_CONF.COM;*
$       ENDIF
$       IF F$SEARCH("SYS$COMMON:[SYSMGR]OPC_PATCH_CLU_NODE_CONF.COM") .NES. ""
$       THEN
$           DELETE SYS$COMMON:[SYSMGR]OPC_PATCH_CLU_NODE_CONF.COM;*
$       ENDIF
$     	IF F$SEARCH("SYS$COMMON:[SYSMGR]OVO8_NODE_LIST.TXT") .NES. ""
$     	THEN
$     	    DELETE SYS$COMMON:[SYSMGR]OVO8_NODE_LIST.TXT;*
$     	ENDIF
$     	IF F$SEARCH("SYS$COMMON:[SYSMGR]OVO8_INSTDIR.TXT") .NES. ""
$     	THEN
$    	    DELETE SYS$COMMON:[SYSMGR]OVO8_INSTDIR.TXT;*
$     	ENDIF
$
$     	WRITE SYS$OUTPUT "OVO HTTPS Agents UNINSTALLED successfully!"
$ EXIT 1
$ err_uninst_node_list:
$     WRITE SYS$OUTPUT "opc_uninst: Error opening SYS$COMMON:[SYSMGR]OVO8_NODE_LIST.TXT"
$     EXIT 0
$ uninst_prod_not_found:
$     WRITE SYS$OUTPUT "opc_uninst: OVO HTTPS Agents not found"
$     EXIT 0
$ cant_write:
$     WRITE SYS$OUTPUT "opc_uninst: Error in creating the cleanup file."
$     EXIT 0
$ cl_cant_open:
$     WRITE SYS$OUTPUT "opc_uninst: Error while creating stop_agents.com"
$     EXIT 0
$ cl_cant_write:
$     WRITE SYS$OUTPUT "opc_uninst: Error while writing to stop_agents.com"
$     CLOSE fd_stop
$     EXIT 0
$ open_sysman_cleanup:
$     WRITE SYS$OUTPUT "opc_uninst: Error opening sysman_cleanup.com"
$     EXIT 0                                   
$ write_sysman_cleanup:
$     CLOSE fd_sysman_cleanup 
$     WRITE SYS$OUTPUT "opc_uninst: Error writing to sysman_cleanup.com"
$     EXIT 0
$ open_sysman_stop_agents:
$     WRITE SYS$OUTPUT "opc_uninst: Error opening sysman_stop_agents.com"
$     EXIT 0
$ write_sysman_stop_agents:
$     CLOSE fd_sysman_stop_agents
$     WRITE SYS$OUTPUT "opc_uninst: Error writing to sysman_stop_agents.com"
$     EXIT 0
$ ENDSUBROUTINE
$! End of opc_uninst
$ 
$! opc_clu_node_conf
$ opc_clu_node_conf:SUBROUTINE
$  cl_node_name=F$GETSYI("NODENAME")
$
$  OPEN/READ/ERROR=cl_err_open_instdir fd_cl_instdir SYS$COMMON:[SYSMGR]OVO8_INSTDIR.TXT
$  cl_loop:
$      READ/END_OF_FILE=cl_close_instdir fd_cl_instdir cl_line
$      IF F$LOCATE("PCSI$DESTINATION", cl_line ) .EQ. F$LENGTH(cl_line)
$      THEN
$          GOTO cl_loop
$      ELSE
$          CLOSE fd_cl_instdir
$      ENDIF
$  cl_instdir = F$ELEMENT( 1, " ", F$ELEMENT(1, "=", cl_line) )
$  cl_ovo_posix_root = F$EXTRACT(1, ( F$LOCATE("]",cl_instdir) - 1 ), cl_instdir) +"OVO.]"
$  cl_posixdev = F$EXTRACT(0, F$LOCATE(":", cl_ovo_posix_root) , cl_ovo_posix_root)
$  cl_devname = F$GETDVI(cl_posixdev, "DEVNAM")
$  cl_devname = cl_devname - "_"
$  cl_dir_name = cl_devname +"["+"OVO$"+cl_node_name+".OVO"+"]"
$  create/dir 'cl_dir_name
$ posix_root2 = cl_devname + F$EXTRACT(( F$LOCATE(":", cl_ovo_posix_root) + 1 ), F$LENGTH(cl_ovo_posix_root), cl_ovo_posix_root)
$ posix_root1 = cl_devname + "[" + "OVO$" + cl_node_name + ".OVO." + "]"
$ posix_root = "''posix_root1'"+","+"''posix_root2'"
$ WRITE SYS$OUTPUT "Defining OVO$POSIX_ROOT to ''posix_root'"
$ DEFINE/SYSTEM/SUPER/NOLOG/TRANS=(CONC,TERM) OVO$POSIX_ROOT 'posix_root
$
$ CREATE/DIR OVO$POSIX_ROOT:[opt.OV.bin]
$ CREATE/DIR OVO$POSIX_ROOT:[opt.OV.help.en]
$ CREATE/DIR OVO$POSIX_ROOT:[opt.OV.lib]
$ CREATE/DIR OVO$POSIX_ROOT:[opt.OV.misc.xpl.config.defaults]
$ CREATE/DIR OVO$POSIX_ROOT:[opt.OV.msg.en]
$ CREATE/DIR OVO$POSIX_ROOT:[opt.OV.newconfig.DataDir.conf.bbc]
$ CREATE/DIR OVO$POSIX_ROOT:[opt.OV.newconfig.installation.inventory]
$ CREATE/DIR OVO$POSIX_ROOT:[opt.OV.newconfig.inventory]
$ CREATE/DIR OVO$POSIX_ROOT:[var.opt.OV.conf.bbc]
$ CREATE/DIR OVO$POSIX_ROOT:[var.opt.OV.conf.ctrl]
$ CREATE/DIR OVO$POSIX_ROOT:[var.opt.OV.tmp.bbc]
$ CREATE/DIR OVO$POSIX_ROOT:[opt.OV.lbin.conf]
$ CREATE/DIR OVO$POSIX_ROOT:[opt.OV.newconfig.datadir.conf.conf]
$ CREATE/DIR OVO$POSIX_ROOT:[opt.OV.lbin.ctrl]
$ CREATE/DIR OVO$POSIX_ROOT:[opt.OV.lbin.xpl]
$ CREATE/DIR OVO$POSIX_ROOT:[opt.OV.lbin.config.update]
$ CREATE/DIR OVO$POSIX_ROOT:[opt.OV.OpC.examples]
$ CREATE/DIR OVO$POSIX_ROOT:[opt.OV.bin.OpC.install]
$ CREATE/DIR OVO$POSIX_ROOT:[opt.OV.bin.OpC.utils]
$ CREATE/DIR OVO$POSIX_ROOT:[opt.OV.contrib.OpC]
$ CREATE/DIR OVO$POSIX_ROOT:[opt.OV.include]
$ CREATE/DIR OVO$POSIX_ROOT:[opt.OV.lbin.eaagt]
$ CREATE/DIR OVO$POSIX_ROOT:[opt.OV.misc.eaagt]
$ CREATE/DIR OVO$POSIX_ROOT:[opt.OV.msg.C]
$! CREATE/DIR OVO$POSIX_ROOT:[var.opt.OV.installation.incoming.files.conf_tmp]
$ CREATE/DIR OVO$POSIX_ROOT:[var.opt.OV.installation.temp.bbc.fx.temp]
$ CREATE/DIR OVO$POSIX_ROOT:[var.opt.OV.installation.temp.bbc.fx.upload]
$ CREATE/DIR OVO$POSIX_ROOT:[var.opt.OV.installation.temp.bbc.fxtemp]
$ CREATE/DIR OVO$POSIX_ROOT:[var.opt.OV.installation.temp.bbc.fxupload]
$ CREATE/DIR OVO$POSIX_ROOT:[var.opt.OV.log.OpC]
$ CREATE/DIR OVO$POSIX_ROOT:[var.opt.OV.bin.OpC.cmds]
$ CREATE/DIR OVO$POSIX_ROOT:[var.opt.OV.bin.OpC.monitor]
$ CREATE/DIR OVO$POSIX_ROOT:[var.opt.OV.bin.OpC.actions]
$ CREATE/DIR OVO$POSIX_ROOT:[var.opt.OV.bin.instrumentation]
$ CREATE/DIR OVO$POSIX_ROOT:[opt.OV.lbin.sec]
$ CREATE/DIR OVO$POSIX_ROOT:[var.opt.OV.datafiles.sec.cc]
$ CREATE/DIR OVO$POSIX_ROOT:[var.opt.OV.datafiles.sec.ks]
$ CREATE/DIR OVO$POSIX_ROOT:[opt.OV.lbin.secco]
$ CREATE/DIR OVO$POSIX_ROOT:[opt.OV.lbin.xpl.trc]
$ CREATE/DIR OVO$POSIX_ROOT:[opt.OV.newconfig.conf.xpl.log]
$ CREATE/DIR OVO$POSIX_ROOT:[opt.OV.newconfig.conf.xpl.trc]
$ CREATE/DIR OVO$POSIX_ROOT:[opt.OV.support]
$ CREATE/DIR OVO$POSIX_ROOT:[opt.perf.bin]
$ CREATE/DIR OVO$POSIX_ROOT:[var.perf.bin]
$ CREATE/DIR OVO$POSIX_ROOT:[var.opt.perf.bin]
$ CREATE/DIR OVO$POSIX_ROOT:[var.opt.OV.conf.conf]
$ CREATE/DIR OVO$POSIX_ROOT:[var.opt.OV.conf.OvXplTrc]
$ CREATE/DIR OVO$POSIX_ROOT:[var.opt.OV.conf.xpl.config]
$ CREATE/DIR OVO$POSIX_ROOT:[var.opt.OV.conf.xpl.LOG]
$ CREATE/DIR OVO$POSIX_ROOT:[var.opt.OV.datafiles.bbc]
$ CREATE/DIR OVO$POSIX_ROOT:[var.opt.OV.datafiles.policies.configsettings]
$ CREATE/DIR OVO$POSIX_ROOT:[var.opt.OV.datafiles.policies.le]
$ CREATE/DIR OVO$POSIX_ROOT:[var.opt.OV.datafiles.policies.monitor]
$ CREATE/DIR OVO$POSIX_ROOT:[var.opt.OV.datafiles.policies.msgi]
$ CREATE/DIR OVO$POSIX_ROOT:[var.opt.OV.datafiles.xpl.config.jobs]
$ CREATE/DIR OVO$POSIX_ROOT:[var.opt.OV.tmp.OPC]
$ CREATE/DIR OVO$POSIX_ROOT:[var.opt.OV.tmp.public]
$ CREATE/DIR OVO$POSIX_ROOT:[var.opt.OV.tmp.public.OpC]
$ CREATE/DIR OVO$POSIX_ROOT:[opt.OV.contrib.vmsspi]
$
$! XPL Specific files
$
$ COPY OVO$POSIX_ROOT:[OPT.OV.MISC]OVXPL_SHARE.EXE SYS$SHARE:OVO$XPL_SHARE.EXE
$ COPY OVO$POSIX_ROOT:[OPT.OV.MISC]OVBBC_SHARE.EXE SYS$SHARE:OVO$BBC_SHARE.EXE
$ COPY OVO$POSIX_ROOT:[OPT.OV.MISC]OVCONF_SHARE.EXE SYS$SHARE:OVO$CONF_SHARE.EXE
$ COPY OVO$POSIX_ROOT:[OPT.OV.MISC]OVCTRL_SHARE.EXE SYS$SHARE:OVO$CTRL_SHARE.EXE
$ COPY OVO$POSIX_ROOT:[OPT.OV.MISC]OVDEPL_SHARE.EXE SYS$SHARE:OVO$DEPL_SHARE.EXE
$ COPY OVO$POSIX_ROOT:[OPT.OV.MISC]OVSECCM_SHARE.EXE SYS$SHARE:OVO$SECCM_SHARE.EXE
$ COPY OVO$POSIX_ROOT:[OPT.OV.MISC]OVSECCORE_SHARE.EXE SYS$SHARE:OVO$SECCORE_SHARE.EXE
$ COPY OVO$POSIX_ROOT:[OPT.OV.MISC]OVO$PERLSHR.EXE SYS$SHARE:OVO$PERLSHR.EXE
$ COPY OVO$POSIX_ROOT:[OPT.OV.MISC]OVO$LIBOPC_R.EXE SYS$SHARE:OVO$LIBOPC_R.EXE
$
$ COPY OVO$POSIX_ROOT:[var.opt.OV.conf.xpl.config]local_settings.ini OVO$POSIX_ROOT:[var.opt.OV.conf.xpl.config]local_settings.ini
$
$ COPY OVO$POSIX_ROOT:[var.opt.OV.datafiles.xpl.config]policy_settings.ini OVO$POSIX_ROOT:[var.opt.OV.datafiles.xpl.config]policy_settings.ini
$ COPY OVO$POSIX_ROOT:[opt.OV.misc.xpl.config.defaults]xpl.ini OVO$POSIX_ROOT:[opt.OV.misc.xpl.config.defaults]xpl.ini
$ COPY OVO$POSIX_ROOT:[opt.OV.newconfig.conf.xpl.log]log.cfg OVO$POSIX_ROOT:[opt.OV.newconfig.conf.xpl.log]log.cfg
$ COPY OVO$POSIX_ROOT:[opt.OV.newconfig.conf.xpl.log]log.cfg OVO$POSIX_ROOT:[var.opt.OV.conf.xpl.log]log.cfg
$ COPY OVO$POSIX_ROOT:[opt.OV.newconfig.conf.xpl.trc]ovtrcmon.cfg OVO$POSIX_ROOT:[opt.OV.newconfig.conf.xpl.trc]ovtrcmon.cfg
$
$! conf specific files
$
$ COPY OVO$POSIX_ROOT:[opt.OV.misc.xpl.config.defaults]conf.ini  OVO$POSIX_ROOT:[opt.OV.misc.xpl.config.defaults]conf.ini
$
$! secco specific files
$
$ COPY OVO$POSIX_ROOT:[opt.OV.misc.xpl.config.defaults]sec.core.ini OVO$POSIX_ROOT:[opt.OV.misc.xpl.config.defaults]sec.core.ini
$
$! bbc specific files
$
$ COPY OVO$POSIX_ROOT:[opt.OV.misc.xpl.config.defaults]bbc.ini OVO$POSIX_ROOT:[opt.OV.misc.xpl.config.defaults]bbc.ini
$
$! seccc specific files
$
$ COPY OVO$POSIX_ROOT:[opt.OV.misc.xpl.config.defaults]sec.cm.ini OVO$POSIX_ROOT:[opt.OV.misc.xpl.config.defaults]sec.cm.ini
$
$! depl specific files
$
$ COPY OVO$POSIX_ROOT:[opt.OV.misc.xpl.config.defaults]depl.ini OVO$POSIX_ROOT:[opt.OV.misc.xpl.config.defaults]depl.ini
$
$! ctrl specific files
$
$ COPY OVO$POSIX_ROOT:[opt.OV.misc.xpl.config.defaults]ctrl.ini OVO$POSIX_ROOT:[opt.OV.misc.xpl.config.defaults]ctrl.ini
$
$! eaagt specific files
$
$ COPY OVO$POSIX_ROOT:[opt.OV.misc.xpl.config.defaults]eaagt.ini OVO$POSIX_ROOT:[opt.OV.misc.xpl.config.defaults]eaagt.ini
$
$ cl_dir_name = cl_devname + "[" + "OVO$" + cl_node_name + "]"
$ OPEN/APPEND/ERROR=cl_app_err cl_log SYS$COMMON:[SYSMGR]OVO8_NODE_LIST.TXT
$ WRITE cl_log cl_dir_name
$ CLOSE cl_log
$
$ OPEN/WRITE cl_file1  OVO$POSIX_ROOT:[var.opt.OV.log]opc_inst.log
$ CLOSE cl_file1
$ WRITE SYS$OUTPUT "Please wait while opcactivate configures cluster node and restart the agents..."
$ @SYS$MANAGER:OPCACTIVATE /OUTPUT=SYS$ERRORLOG:clu_node_opcactivate.log  'P1 'P2 'P3 'P4
$ IF .NOT. $STATUS THEN EXIT
$ @sys$startup:ovo8$define /OUTPUT=SYS$ERRORLOG:clu_node_define.log
$ IF F$SEARCH("SYS$ERRORLOG:clu_node_opcactivate.log") .NES. ""
$ THEN
$     TYPE SYS$ERRORLOG:clu_node_opcactivate.log
$     DELETE SYS$ERRORLOG:clu_node_opcactivate.log;*
$ ENDIF
$ IF F$SEARCH("SYS$ERRORLOG:clu_node_define.log") .NES. "" THEN DELETE SYS$ERRORLOG:clu_node_define.log;*
$! WRITE SYS$OUTPUT "Restarting Agents..."
$ ovc -kill
$ ovc -start
$ EXIT 1
$ cl_err_open_instdir:
$     WRITE SYS$OUTPUT "opc_clu_node_conf: Error opening SYS$COMMON:[SYSMGR]OVO8_INSTDIR.TXT"
$     EXIT 0
$ cl_app_err:
$     WRITE SYS$OUTPUT "opc_clu_node_conf: Error appending  SYS$COMMON:[SYSMGR]OVO8_NODE_LIST.TXT"
$     EXIT 0
$ cl_close_instdir:
$     CLOSE fd_cl_instdir
$     WRITE SYS$OUTPUT "opc_clu_node_conf: SYS$COMMON:[SYSMGR]OVO8_INSTDIR.TXT doesn't contain OVO8 Installation directory information."
$     EXIT 0
$ ENDSUBROUTINE
$! End of opc_clu_node_conf
$! Begin product_check
$ product_check:
$     PIPE PRODUCT SHOW PRODUCT OVBBC, OVCONF, OVCTRL, OVDEPL, OVEAAGT, OVSECCC, OVSECCO, OVXPL > product_list.txt
$     OPEN/READ fd_prod_scan product_list.txt
$     READ/END=done_prod_scan fd_prod_scan prod_rec
$     READ/END=done_prod_scan fd_prod_scan prod_rec
$     READ/END=done_prod_scan fd_prod_scan prod_rec
$     READ/END=done_prod_scan fd_prod_scan prod_rec
$     done_prod_scan:
$     CLOSE fd_prod_scan
$     DELETE product_list.txt;*
$     IF prod_rec .EQS. "0 items found" THEN RETURN 0
$     str = F$EDIT(F$ELEMENT(3, " ", prod_rec), "TRIM")
$     prod_ver = F$EXTRACT(1, 3, str) 
$     IF (prod_ver .EQS. "8.0")
$     THEN
$         RETURN
$     ELSE
$         prod_ver = F$EXTRACT(1, 5, str)
$     ENDIF
$ RETURN
$! End of product_check
$
$ log_write_err:
$     WRITE SYS$OUTPUT "opc_inst: Error creating SYS$COMMON:[SYSMGR]OVO8_NODE_LIST.TXT"
$     EXIT 0
$ open_err_instdir:
$     WRITE SYS$OUTPUT "opc_inst: Error opening SYS$COMMON:[SYSMGR]OVO8_INSTDIR.TXT"
$     EXIT 0
$ close_instdir:
$     CLOSE infile
$     WRITE SYS$OUTPUT "opc_inst: SYS$COMMON:[SYSMGR]OVO8_INSTDIR.TXT doesn't contain OVO8 Installation directory information."
$     EXIT 0
$ error_end:
$     EXIT
