#!/bin/sh
####################################################################################
## FILENAME:    OA-setup.sh
## VERSION:     08.60.030
## DESCRIPTION: HPUX/Solaris/Linux OMU/L 8/9 server side  installation script for 
##              OpenVMS Operation Agent
##              Script can be used for 
##              1. Pre-requisite check for server version, Disk Space for 
##              OpenVMS Operation Agent (8.6)
##              2. (De-)Installation of OpenVMS Operation Agent on OMU8 server.
## USAGE:       OA-setup.sh [-h][-c|i][-p IA|ALPHA]
## LANGUAGE:    sh
## Author:      asim.mandal@hp.com
# (c) Copyright 2010, Hewlett-Packard Development Company, L.P. all rights reserved.
####################################################################################
#set -x
####################################################################################
DIRNAME=`dirname $0`
SCRIPTNAME=`basename $0`

OMU_SRV_OS=`uname -s`
if [ -f /opt/OV/bin/OpC/agtinstall/opcversion ]
then
    v_text=`/opt/OV/bin/OpC/agtinstall/opcversion -s |cut -c1-2`
    if [ "x09" != "x$v_text" ]
    then
        OM_SRV=N9X
    else
        OM_SRV=Y9X
    fi
fi 


# Call the platform specific script that will execute for us
case ${OM_SRV} in
    Y9X)
        case ${OMU_SRV_OS} in
            HP-UX)
                oaExec=`echo $DIRNAME/ServerScripts/OA-setup_ux9.sh` 
            ;;
            SunOS)
                oaExec=`echo $DIRNAME/ServerScripts/OA-setup_sol9.sh`
            ;;
            Linux)
                oaExec=`echo $DIRNAME/ServerScripts/OA-setup_lin9.sh`
            ;;   
            *)
                echo "ERROR: Unsupported  OM Server for OpenVMS detected: ${OMU_SRV_OS}."
                exit 1
            ;;
        esac
    ;;
    N9X)
        case ${OMU_SRV_OS} in
            HP-UX)
                oaExec=`echo $DIRNAME/ServerScripts/OA-setup_hpux.sh` 
            ;;
            SunOS)
                oaExec=`echo $DIRNAME/ServerScripts/OA-setup_solaris.sh`
            ;;
            *)
                echo "ERROR: Unsupported  OMU Server for OpenVMS detected: ${OMU_SRV_OS}."
                exit 1
            ;;
        esac
    ;;
    *)
        echo "ERROR: OM Server has not detected."
        exit 1   
    ;;

esac

export DIRNAME SCRIPTNAME

${oaExec} $*
RETVAL=$?
exit ${RETVAL}
