#!/usr/xpg4/bin/sh
####################################################################################
## FILENAME:    getinstdisk.sh
## VERSION:     08.60.020
## DESCRIPTION: OML/HPUX/Solaris OMU8 server side getinstdisk script for OpenVMS
##              Operation Agent
##              Script can be used for
##              1. Pre-requisite check for node version, Disk Space for
##              OpenVMS Operation Agent (8.6)
##              2. generates the config file which will read by remtote installtion scripts.
## USAGE:       getinstdisk <node name>
## LANGUAGE:    sh
## Author:      kiran.madival@hp.com
# (c) Copyright 2010, Hewlett-Packard Development Company, L.P. all rights reserved.
####################################################################################
#set -x
####################################################################################
OMSVR_INST_DIR=/opt/OV/bin/OpC/agtinstall
OMSVR_INSTL_DIR=/opt/OV/bin/OpC/install
OMSVR_CONF_DIR=/opt/OV/bin/OpC/
OMSVR_VEND_DIR=/var/opt/OV/share/databases/OpC/mgd_node/vendor
OMSVR_CUST_DIR=/var/opt/OV/share/databases/OpC/mgd_node/customer
OPC_AGTINST_DIR=/opt/OV/bin/OpC/agtinstall

OPC_INST_DIR=/var/opt/OV/share/databases/OpC/mgd_node/vendor
OPC_ALPHA_DIR=/var/opt/OV/share/databases/OpC/mgd_node/vendor/hp/alpha/ovms/A.08.10.160/RPC_BBC/install
OPC_IA_DIR=/var/opt/OV/share/databases/OpC/mgd_node/vendor/hp/ipf64/ovms/A.08.10.160/RPC_BBC/install
OPC_VERSION=A.08.10.160
OPC_PACKAGE_TYPE=RPC_BBC
OPC_TOPC=/var/tmp
OPC_SW_SIZE=1000000
OPC_TAPE_SIZE=1000000
OPC_CMD_DIR=/opt/OV/bin/OpC/install
OPC_OUTPUT_FILE=/tmp/opcvmsdschk_outfile
INST_LOG_DIR=/var/tmp
INST_LOCK_FILE="/var/tmp/getinstdisk.lock"
VMS_NODE_TO_DISK=/var/tmp/nodetodisk.dat
VMS_TEMP_FILE=/var/tmp/vms_temp.dat

OPC_INST_USER=SYSTEM
OPC_NODE=$1
KERB_PAR=-in


#------------------------------------------------------------------------------
#  DESCRIPTION
#
#  PARAMETERS
#
#  ENVIRONMENT
#
#  EXIT CODE
#      0 .. size of VMS_FTP_OUTPUT file is zero
#      1 .. size of VMS_FTP_OUTPUT file is bigger than zero
#      2 .. VMS_FTP_OUTPUT file does not exist
#      3 .. error
#      4 .. wrong number of parameters
#
opcvmsftp()
{
  #  input parameters
  #

OPC_INST_USER="SYSTEM"
export OPC_INST_USER
  rm -f ${OPC_TOPC}/ftp.out
    ftp $KERB_PAR  -n <<-EOF >${OPC_TOPC}/ftp.out
    open ${OPC_NODE}
    user "${OPC_INST_USER}" ${OPC_PASSWD}
    $1
    $2
    $3
    close
    quit
EOF
    # check for errors on stdout also - in case ftp has problems because
    # the root shell is not in /etc/shells, we get no stderr output
    if [ `grep -c '^Login failed.$' ${OPC_TOPC}/ftp.out` -ne 0 ]
    then
      cat ${OPC_TOPC}/ftp.out
      return 1
    fi

    if [ `grep -c 'AUTH is unimplemented' ${OPC_TOPC}/ftp.out` -ne 0 ]
    then
      cat ${OPC_TOPC}/ftp.out
      return 0
    fi

    FTP_OUT=`cat ${OPC_TOPC}/ftp.out`
    if [ -n "${FTP_OUT}" ]
    then
    #   Problems transferring package via ftp...
    #
        cat ${OPC_TOPC}/ftp.out
    	return 1
    fi
    FTP_NODE=${OPC_NODE}
    echo "${FTP_NODE}" >${OPC_TOPC}/ftp.node

 return 0
}

#------------------------------------------------------------------------------
print_usage()
{
echo "Usage: $SCRIPTNAME <Node Name>"
echo ""
echo "NOTE: you must be root to run this script."
echo "          OVO Maintenance script ends `date`."
}

#------------------------------------------------------------------------------
#
#  Interlock multiple executions of install.ksh.
#
#------------------------------------------------------------------------------
check_lockfile()
{
   if [ -f ${INST_LOCK_FILE} ]
   then
      echo " An instance of the OMU OpenVMS 8.6 getinstdisk  Maintenance script is"
      echo " already running or has been terminated abnormally."
      echo " If you are sure no other instance is running,"
      echo " the lock file ${INST_LOCK_FILE} may be removed now."
      return 1
   else
      touch ${INST_LOCK_FILE}
      return 0
   fi
}
#------------------------------------------------------------------------------
remove_lockfile()
{
   rm -f $INST_LOCK_FILE
}

#------------------------------------------------------------------------------
trap cleanup 2 3 4 5 9 15 

cleanup()
{
  echo "Caught Signal ... cleaning up."
  rm -rf $INST_LOCK_FILE 
  echo "Done cleanup ... quitting."
  exit 1
}

#------------------------------------------------------------------------------
read_password()
{
#  ( sleep 20; kill $$ )&
  stty -echo 
  read -s OPC_PASSWD
  stty echo
#  kill $!
#  echo $OPC_PASSWD
}

#------------------------------------------------------------------------------


#MAIN

DIRNAME=`dirname $0`
SCRIPTNAME=`basename $0`
export DIRNAME SCRIPTNAME

if [ ! -d ${INST_LOG_DIR} ]
then
  mkdir -p ${INST_LOG_DIR}
fi

if [ ! -f ${VMS_NODE_TO_DISK} ]
then
touch ${VMS_NODE_TO_DISK}
fi

echo "          OMU OpenVMS 8.6 getinstdisk script starts `date`."
check_lockfile
if [ $? -ne 0 ]
then
  echo "         OMU OpenVMS 8.6 getinstdisk script is already running - exiting `date`."
  exit 1
fi

if [ $# -ne 1 ]
then
       print_usage
       remove_lockfile
       exit 0
fi

if [ -f $OPC_ALPHA_DIR/opcvmsods5disk.com ] && [ -f $OPC_ALPHA_DIR/opcvmsdschk.com ]
then
    OPC_PLATFORM=hp/alpha/ovms
elif [ -f $OPC_IA_DIR/opcvmsods5disk.com ] && [ -f $OPC_IA_DIR/opcvmsdschk.com ]
then
    OPC_PLATFORM=hp/ipf64/ovms
else
    echo "VMS Platforms(Alpha/IA) might not be registered"
    remove_lockfile
    exit 1
fi

#  read -t 20 -s -p "Enter Password for ${OPC_NODE}  : " OPC_PASSWD
  echo "Enter Password for ${OPC_NODE}  : "
  read_password

echo ""
echo "Checking the node connection..."
FTP_CMD1="ascii"
FTP_CMD2="put $OPC_INST_DIR/$OPC_PLATFORM/$OPC_VERSION/$OPC_PACKAGE_TYPE/install/opcvmsods5disk.com opcvmsods5disk.com"
opcvmsftp "$FTP_CMD1" "$FTP_CMD2"
if [ $? -ne 0 ]
then
   #   file couldn't be transferred to the managed node
   #
   echo "file couldn't be transferred to the managed node ${OPC_NODE}: FTP failed"
   remove_lockfile
   exit 1
fi

FTP_CMD3="ascii"
FTP_CMD4="put $OPC_INST_DIR/$OPC_PLATFORM/$OPC_VERSION/$OPC_PACKAGE_TYPE/install/opcvmsdschk.com opcvmsdschk.com"
opcvmsftp "$FTP_CMD3" "$FTP_CMD4"
if [ $? -ne 0 ]
then
   #   file couldn't be transferred to the managed node
   #
   echo "file couldn't be transferred to the managed node ${OPC_NODE}: FTP failed"
   remove_lockfile
   exit 1
fi

$OPC_CMD_DIR/opc_rexec $OPC_NODE $OPC_INST_USER ${OPC_PASSWD} "@SYS\$LOGIN:opcvmsods5disk.com ${OPC_SW_SIZE}"
echo "Checking the ODS-5 disks available in the system done...."

while true
do 
  echo "Re/Enter the disk name to check the available free space:"
  read DISK_NAME
  case ${DISK_NAME} in
       "")
       ;;
       *)
       break
       ;; 
  esac
done

echo "Checking the available free space for ${DISK_NAME}:"
rm -f ${OPC_OUTPUT_FILE}
#echo $DISK_NAME | sed -e "s/\$/\\/$/g"
$OPC_CMD_DIR/opc_rexec $OPC_NODE $OPC_INST_USER ${OPC_PASSWD} "@SYS\$LOGIN:opcvmsdschk.com ${OPC_TAPE_SIZE} ${OPC_SW_SIZE} ${DISK_NAME}" > ${OPC_OUTPUT_FILE}
RET_VAL=`sed -e 's/.$//g' ${OPC_OUTPUT_FILE}`
case ${RET_VAL} in
    "0")
    echo "Available free disk space for sys\$update or ${DISK_NAME} is less than the required ${OPC_SW_SIZE}"
    remove_lockfile
    exit 1
    ;;
    "2")
    echo "Available free disk space for sys\$update is less than the required ${OPC_SW_SIZE}"
    remove_lockfile
    exit 1
    ;;
    *)
    echo "Free disk space check is passed for ${DISK_NAME}" 
    ;;
esac

$OPC_CMD_DIR/opc_rexec $OPC_NODE $OPC_INST_USER ${OPC_PASSWD} "del SYS\$LOGIN:opcvmsdschk.com;*"
$OPC_CMD_DIR/opc_rexec $OPC_NODE $OPC_INST_USER ${OPC_PASSWD} "del SYS\$LOGIN:opcvmsods5disk.com;*"

#sed -i "/$OPC_NODE/Id" ${VMS_NODE_TO_DISK} 
rm -rf ${VMS_TEMP_FILE}
grep -iv "${OPC_NODE}" ${VMS_NODE_TO_DISK} > ${VMS_TEMP_FILE} 
mv ${VMS_TEMP_FILE}  ${VMS_NODE_TO_DISK} 
echo "${OPC_NODE}|${DISK_NAME}" >> ${VMS_NODE_TO_DISK}
echo "Configuration is created/updated to ${VMS_NODE_TO_DISK}" 

remove_lockfile
echo "          OMU OpenVMS 8.6 getinstdisk script ends `date`."
exit 0
