set curDir=%cd%
set targetRoot=%OvShareDir%\conf
set targetPkgRoot=%OvShareDir%\conf\ovms\pkg
set npreg=%OvInstallDir%\bin\OvOWNPReg.exe
if defined OvBinDir set npreg=%OvBinDir%\OvOWNPReg.exe
set xmlroot=%OvShareDir%\conf\ovms
set patchprefix=OVMS8.60.40

cd "%targetRoot%"
mkdir ovms
cd ovms
mkdir pkg
cd "%curDir%"

rem copy packages
xcopy "%curDir%\Package" "%targetPkgRoot%" /q /E /i

rem copy packages descriptor
xcopy "%curDir%\AgentConfig\OMW" "%targetPkgRoot%" /q /E /i


cd /d "%targetPkgRoot%"

rem do platform registration
for /f %%i in ('dir /B /ON') do "%npreg%" -reg "%%i\agent_config.xml" -patch %patchprefix%_%%i -log ..\%patchprefix%_%%i || goto erroroccurred

cd "%curDir%"

rem copy Unregister scripts.
copy /Y "%curDir%\ServerScripts\OMW\OvUnRegVmsPlatforms.bat" "%targetRoot%\ovms\OvUnRegVmsPlatforms.bat"


goto successful

:erroroccurred
echo ERROR: VMS Platform registration process canceled because an error occurred
goto end

:successful
echo VMS Platform registration process successfully finished

:end
