$! write sys$output "This script checks for the current version of OVO agents."
$ if P1 .EQS. "" 
$ then 
$ write sys$output "Usage: @OPCVERCHK <mgmt_srv>"
$ exit
$ endif
$ mgmt_srv = P1
$ ovo7 = 0
$ ovo8 = 0
$ pipe prod sh prod ovoagents > NL:
$ if $status .eqs. "%X00000001" then ovo7 = 1
$ pipe prod sh prod ovbbc > NL:
$ if $status .eqs. "%X00000001" then ovo8 = 1
$! No agents are installed
$ IF (ovo7 .EQ. 0) .AND. (ovo8 .EQ. 0)
$ THEN
$	WRITE SYS$OUTPUT "No OVO Agents found on this system"
$ 	EXIT
$ ENDIF
$!Finding installed version of OVO
$ if ovo7 .eq. 1 
$ then 
$ pipe product show product ovoagents > ovo_version.txt
$ else
$ pipe product show product ovbbc > ovo_version.txt
$ endif
$ open/read ovofd ovo_version.txt 
$ read/end=close_ovofd ovofd rec
$ read/end=close_ovofd ovofd rec
$ read/end=close_ovofd ovofd rec
$ read/end=close_ovofd ovofd rec
$ close_ovofd:
$ close ovofd
$ ovo_ver = f$element(3, " ", rec)
$ write sys$output "Version = ", ovo_ver
$ if ovo7 .eq. 1 
$ then 
$ 	write sys$output "Remove OVO DCE Agents before installing HTTPS agents"
$ 	EXIT
$ endif
$ if ovo8 .eq. 1 
$ then
$ write sys$output "HTTPS agents are already installed on this node."
$ @sys$startup:ovo8$define.com
$ pipe ovconfget sec.cm.client "CERTIFICATE_SERVER" > mgmt_srv.txt
$ open/read fd mgmt_srv.txt
$ read/end=done fd rec
$!write sys$output "mgmt_srv = ", rec 
$ write sys$output rec
$ if rec .NES. mgmt_srv
$ then
$!write sys$output "This node is managed by another management server."
$ endif
$ endif
$ done:
$ close fd
$ delete mgmt_srv.txt;*
$ delete ovo_version.txt;*
$ exit
