@ ECHO OFF
set CurDir=%cd%
set InstDir=%OvInstallDir%install
set VMSPolDir=%OvInstallDir%install\OVMSSPI\Policies
set VMSPolDirBck=%OvInstallDir%install\OVMSSPI\Policies_bck

cd "%InstDir%"

IF EXIST "%VMSPolDir%"  (

IF EXIST "%VMSPolDirBck%" (
RMDIR /S /Q "%VMSPolDirBck%"
)

MOVE "%VMSPolDir%" "%VMSPolDirBck%">NUL
cd OVMSSPI
mkdir Policies

) ELSE (

mkdir OVMSSPI
cd OVMSSPI
mkdir Policies

)

cd %CurDir%

xcopy "%CurDir%\Policies" "%VMSPolDir%" /Q /E /i >NUL

ECHO.
ECHO Uploading OpenVMS_policies group...
ovpmutil CFG POL UPL "%OvInstallDir%\install\OVMSSPI\Policies\OpenVMS_policies\config.mm"  || goto erroroccurred
ECHO.
ECHO Uploading OpenVMS_SPI_policies group...
ovpmutil CFG POL UPL "%OvInstallDir%\install\OVMSSPI\Policies\OpenVMS_SPI_policies\config.mm" || goto erroroccurred

goto successful

:erroroccurred

ECHO.
ECHO *********************************************
ECHO ERROR: Failed to upload OpenVMS SPI policies.
ECHO *********************************************
goto end

:successful
ECHO.
ECHO *********************************************
ECHO OpenVMS SPI policies uploaded successfully.
ECHO *********************************************
:end
@ECHO ON