/*
 * Decompiled with CFR 0.152.
 */
package com.hp.wsi;

import com.hp.wsi.b2wConnection;
import com.hp.wsi.b2wDataUtility;
import com.hp.wsi.b2wField;
import com.hp.wsi.b2wParameter;
import com.hp.wsi.b2wPrimitive;
import com.hp.wsi.b2wRoutine;
import com.hp.wsi.b2wStructure;
import com.hp.wsi.b2wView;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;

public class bwx2idl {
    private static String b2w_version = "V1.0-2";
    private static String jarpath = null;

    private static int generateFiles(b2wConnection curconn, String outdir, String tpldir) {
        int retval = 0;
        Vector aviews = curconn.getViews();
        for (int i1 = 0; i1 < aviews.size(); ++i1) {
            String xmlname;
            b2wView tview = (b2wView)aviews.get(i1);
            retval = bwx2idl.generateAFile(curconn, tview, outdir, (xmlname = curconn.getCnxName() + "_" + tview.getViewName()) + "_idl.xml", tpldir, "WsitIdl.vm");
            if (retval == 0) {
                retval = bwx2idl.generateAFile(curconn, tview, outdir, xmlname + ".wsi", tpldir, "WsitRtl.vm");
            }
            if (retval != 0) continue;
            retval = bwx2idl.generateAFile(curconn, tview, outdir, xmlname + ".log", tpldir, "WsiLogfile.vm");
        }
        if (retval == 0) {
            System.out.println("*** Files for Application " + curconn.getCnxName() + " successfully generated! ***");
        }
        return retval;
    }

    private static int generateAFile(b2wConnection curconn, b2wView tview, String outdir, String outfile, String tpldir, String tplfile) {
        int retval = 0;
        try {
            Properties props = new Properties();
            props.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.NullLogSystem");
            props.setProperty("resource.loader", "jar");
            props.setProperty("jar.resource.loader.class", "org.apache.velocity.runtime.resource.loader.JarResourceLoader");
            props.setProperty("jar.resource.loader.path", jarpath);
            Velocity.init(props);
            VelocityContext context = new VelocityContext();
            context.put("connection", curconn);
            context.put("view", tview);
            b2wDataUtility velDU = new b2wDataUtility();
            context.put("dtutility", velDU);
            Template template = Velocity.getTemplate(tpldir + "/" + tplfile);
            BufferedWriter writer = new BufferedWriter(new FileWriter(outdir + "/" + outfile));
            template.merge(context, writer);
            writer.flush();
            writer.close();
        }
        catch (Exception ex) {
            System.out.println("An error occurred generating: " + outdir + "/" + outfile);
            ex.printStackTrace();
        }
        System.out.println("File: " + outdir + "/" + outfile + " generated.");
        return retval;
    }

    private static int fixupStructure(b2wConnection curconn, b2wStructure curstruct, Vector ordstructvec) {
        int retval = 0;
        int curoffset = 0;
        int falign = curstruct.getFieldAlignment();
        int largestalign = 1;
        if (curstruct.isSizeDone()) {
            return 0;
        }
        Vector tfieldvec = curstruct.getFields();
        for (int i2 = 0; i2 < tfieldvec.size(); ++i2) {
            b2wStructure tstruct;
            int tfa;
            b2wField tfield = (b2wField)tfieldvec.get(i2);
            if (tfield.getDatatypeIdx() == 77) {
                b2wStructure tstruct2 = curconn.getStructure(tfield.getStructType());
                if (!tstruct2.isSizeDone()) {
                    retval = bwx2idl.fixupStructure(curconn, tstruct2, ordstructvec);
                }
                tfield.setSize(tstruct2.getPaddedSize());
            }
            if ((tfa = falign) == 0) {
                if (tfield.getDatatypeIdx() == 77) {
                    tstruct = curconn.getStructure(tfield.getStructType());
                    tfa = tstruct.getBaseAlignment();
                } else {
                    tfa = b2wDataUtility.getDatatypeAlignment(tfield.getDatatypeIdx());
                }
            }
            if (tfa > largestalign) {
                largestalign = tfa;
            }
            if (curoffset % tfa != 0) {
                curoffset += tfa - curoffset % tfa;
            }
            tfield.setOffset(curoffset);
            curoffset += tfield.getSize() * tfield.getElementCount();
            if (tfield.getDatatypeIdx() == 77) {
                tstruct = curconn.getStructure(tfield.getStructType());
                tfield.setDatatype(tstruct);
                continue;
            }
            String pname = b2wDataUtility.getTypeString(tfield.getDatatypeIdx());
            if (b2wDataUtility.isStringParam(tfield.getDatatypeIdx())) {
                pname = pname + "_" + Integer.toString(tfield.getSize());
                pname = tfield.getIsNullTerminated() ? pname + "_1" : pname + "_0";
            }
            if (b2wDataUtility.isDecimalParam(tfield.getDatatypeIdx())) {
                pname = pname + "_" + Integer.toString(tfield.getSize());
                pname = pname + "_" + Integer.toString(tfield.getScale());
            }
            b2wPrimitive tprim = new b2wPrimitive(pname, tfield.getDatatypeIdx(), tfield.getSize(), tfield.getScale(), tfield.getIsNullTerminated(), true);
            curconn.addPrimitive(pname, tprim);
            tfield.setDatatype(tprim);
        }
        int sba = curstruct.getBaseAlignment();
        if (sba != 1) {
            if (sba == 0) {
                sba = largestalign;
                curstruct.setBaseAlignment(sba);
            }
            if (curoffset % sba != 0) {
                curoffset += sba - curoffset % sba;
            }
        }
        curstruct.setPaddedSize(curoffset);
        ordstructvec.add(curstruct);
        curstruct.setSizeDone(true);
        return retval;
    }

    private static int fixupStructureDTs(b2wConnection curconn) {
        b2wStructure tstruct;
        int retval = 0;
        Vector tstructvec = curconn.getStructures();
        Vector ordstructvec = new Vector();
        for (int i1 = 0; i1 < tstructvec.size() && ((tstruct = (b2wStructure)tstructvec.get(i1)).isSizeDone() || (retval = bwx2idl.fixupStructure(curconn, tstruct, ordstructvec)) == 0); ++i1) {
        }
        curconn.setStructures(ordstructvec);
        return retval;
    }

    private static int fixupParamDTs(b2wConnection curconn) {
        b2wParameter tparam;
        int i2;
        Vector tparamvec;
        b2wRoutine trtn;
        int i1;
        int retval = 0;
        Vector trtnvec = curconn.getRoutines();
        for (i1 = 0; i1 < trtnvec.size(); ++i1) {
            trtn = (b2wRoutine)trtnvec.get(i1);
            tparamvec = trtn.getParams();
            for (i2 = 0; i2 < tparamvec.size(); ++i2) {
                tparam = (b2wParameter)tparamvec.get(i2);
                if (tparam.getDatatypeIdx() == 77) {
                    if (tparam.getName().compareToIgnoreCase("*retval*") == 0) {
                        trtn.setDatatype(curconn.getStructure(tparam.getStructType()));
                        continue;
                    }
                    tparam.setDatatype(curconn.getStructure(tparam.getStructType()));
                    continue;
                }
                if (tparam.getDatatypeIdx() > 0) {
                    String pname = b2wDataUtility.getTypeString(tparam.getDatatypeIdx());
                    if (b2wDataUtility.isStringParam(tparam.getDatatypeIdx())) {
                        pname = pname + "_" + Integer.toString(tparam.getSize());
                        pname = tparam.getIsNullTerminated() ? pname + "_1" : pname + "_0";
                    }
                    if (b2wDataUtility.isDecimalParam(tparam.getDatatypeIdx())) {
                        pname = pname + "_" + Integer.toString(tparam.getSize());
                        pname = pname + "_" + Integer.toString(tparam.getScale());
                    }
                    b2wPrimitive tprim = new b2wPrimitive(pname, tparam.getDatatypeIdx(), tparam.getSize(), tparam.getScale(), tparam.getIsNullTerminated(), tparam.getIsFixed());
                    if (tparam.getName().compareToIgnoreCase("*retval*") == 0) {
                        trtn.setDatatype(tprim);
                    } else {
                        tparam.setDatatype(tprim);
                    }
                    curconn.addPrimitive(pname, tprim);
                    continue;
                }
                tparam.setDatatype(null);
            }
        }
        trtnvec = curconn.getRoutines();
        for (i1 = 0; i1 < trtnvec.size(); ++i1) {
            trtn = (b2wRoutine)trtnvec.get(i1);
            tparamvec = trtn.getParams();
            for (i2 = 0; i2 < tparamvec.size(); ++i2) {
                tparam = (b2wParameter)tparamvec.get(i2);
                if (tparam.getName().compareToIgnoreCase("*retval*") != 0) continue;
                tparamvec.remove(i2);
            }
        }
        return retval;
    }

    private static int fixupDataTypes(b2wConnection curconn) {
        int retval = 0;
        retval = bwx2idl.fixupStructureDTs(curconn);
        if (retval == 0) {
            retval = bwx2idl.fixupParamDTs(curconn);
        }
        return retval;
    }

    private static int fixupConnection(b2wConnection curconn) {
        int retval = 0;
        Vector tviewvec = curconn.getViews();
        for (int i1 = 0; i1 < tviewvec.size(); ++i1) {
            b2wView tview = (b2wView)tviewvec.get(i1);
            tview.setRoutines(curconn);
            tview.setDcls(curconn);
            tview.setFiles(curconn);
        }
        String tmod = ((b2wRoutine)curconn.getRoutines().get(0)).getContainerFilePath();
        int tlang = ((b2wRoutine)curconn.getRoutines().get(0)).getLanguage();
        String stlang = "Unknown";
        switch (tlang) {
            case 2: {
                stlang = "Fortran";
                break;
            }
            case 4: {
                stlang = "COBOL";
                break;
            }
            case 5: {
                stlang = "BASIC";
                break;
            }
            case 8: {
                stlang = "C";
                break;
            }
            case 16: {
                stlang = "ACMS";
            }
        }
        curconn.setModule(tmod);
        curconn.setLanguage(stlang);
        retval = bwx2idl.fixupDataTypes(curconn);
        return retval;
    }

    private static HashMap parseCmdLine(String[] args) {
        int idx = 0;
        HashMap<String, String> cmdmap = new HashMap<String, String>();
        while (idx < args.length) {
            if (args[idx].charAt(0) == '-') {
                String akey = args[idx].toLowerCase();
                String avalue = null;
                if (++idx == args.length) {
                    cmdmap.put(akey, avalue);
                }
                if (idx >= args.length) continue;
                if (args[idx].charAt(0) != '-') {
                    avalue = args[idx];
                    ++idx;
                }
                cmdmap.put(akey, avalue);
                continue;
            }
            ++idx;
        }
        return cmdmap;
    }

    public static void main(String[] args) {
        int retval = 0;
        Vector avec = null;
        Connection conn = null;
        String cname = "*";
        String outdir = ".";
        String tpldir = ".";
        HashMap cmdmap = bwx2idl.parseCmdLine(args);
        if (cmdmap.containsKey("-v")) {
            System.out.println("WSIT bwx2idl utility version: " + b2w_version);
            if (cmdmap.size() == 1) {
                return;
            }
        }
        if (cmdmap.containsKey("-h")) {
            System.out.println("Command line qualifiers are:");
            System.out.println("");
            System.out.println("  -c <Connection Name>    - Name of the Connection to extract from BridgeWorks");
            System.out.println("  -o <WSIT IDL filespec>  - Output directory in which to generate the XML IDL files");
            System.out.println("  -j <Jar file filespec>  - Full file specification for this jar file, bwx2idl.jar");
            System.out.println("  -v                      - Print out the version number for this utility");
            System.out.println("  -h                      - Print this list of options out");
            System.out.println("");
            return;
        }
        if (cmdmap.containsKey("-c") && ((cname = (String)cmdmap.get("-c")) == null || cname.length() == 0)) {
            cname = "*";
        }
        if (cmdmap.containsKey("-o") && ((outdir = (String)cmdmap.get("-o")) == null || outdir.length() == 0)) {
            outdir = ".";
        }
        if (cmdmap.containsKey("-j") && (jarpath = (String)cmdmap.get("-j")).length() == 0) {
            jarpath = null;
        }
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver").newInstance();
        }
        catch (Exception ex) {
            System.out.println("Exception trying to register JDBC/ODBC Driver");
            ex.printStackTrace();
            return;
        }
        try {
            conn = DriverManager.getConnection("jdbc:odbc:BWXData_2_03");
        }
        catch (SQLException ex) {
            System.out.println("Exception trying open BridgeWorks V3.0 Database.");
            System.out.println("Please verify that it is correctly setup before running this tool.");
            System.out.println("");
            ex.printStackTrace();
            return;
        }
        b2wConnection myconn = new b2wConnection();
        avec = myconn.loadFromDatabase(conn, cname);
        if (avec != null) {
            System.out.println("The list of Requested Connections:");
            for (int i1 = 0; i1 < avec.size(); ++i1) {
                myconn = (b2wConnection)avec.get(i1);
                System.out.println("    " + myconn.getCnxName());
            }
            System.out.println("--- End list ---");
            return;
        }
        if (retval != 0) {
            return;
        }
        if (jarpath == null) {
            String cpath = System.getProperty("java.class.path");
            String[] cpitems = cpath.split(";");
            for (int i7 = 0; i7 < cpitems.length; ++i7) {
                cpitems[i7] = cpitems[i7].toLowerCase();
                if (cpitems[i7].indexOf("bwx2idl.jar") <= -1) continue;
                jarpath = cpitems[i7];
            }
            if (jarpath == null) {
                System.out.println("The Jar file, bwx2idl.jar, can not be found in the classpath.");
                System.out.println("Please rerun this utility using the -j option to specify the");
                System.out.println("location of this jar file.");
                return;
            }
        }
        jarpath = "jar:file:" + jarpath;
        retval = bwx2idl.fixupConnection(myconn);
        if (retval != 0) {
            return;
        }
        retval = bwx2idl.generateFiles(myconn, outdir, tpldir);
    }
}

