#!/bin/bash
# Copyright (c) 1990, 2011, Oracle and/or its affiliates. All rights reserved. 

en_message_rights_error="This script must be executed under root"
en_message_wait_for_enter="Press [ENTER] to exit"
en_message_patches_dir_missed="The 'patches' directory was not found"
en_message_wrong_destination_system="Trying to install patches on a system that is not running the Solaris 10 OS...exiting"
en_message_wrong_source_system="Not supported OS... exiting"
en_message_installing_patch="Installing patch"
en_message_unknown_option="Unknown option"
en_message_invalid_altroot_option="Invalid -R option argument"
en_message_help_options="options"
en_message_help_usage="Usage"
en_message_help_g_option="\t\t\tAdd patch(es) to packages in the current zone only (Solaris only)."
en_message_help_r_option="<client_root_path>\tAlternative root path (Solaris only)."
en_message_help_p_option="\t\t\tInstall Oracle Solaris Studio patches."
en_message_help_l_option="<locale>\t\tOverride default locale with specified <locale>. Possible values are: 'en', 'ja' or 'zh'."
en_message_help_h_option="\t\t\tPrint this help."
en_message_no_product_patches_available="No product patches available"
en_message_no_system_patches_available="No system patches available"
en_message_execution_finished="Execution finished"
en_message_rpm_not_found="rpm utility not found... exiting"
en_message_installing_rpm="Installing RPM package"
en_message_ignoring_rpm="Ignoring RPM package"
en_message_tmpdir_not_set="Please set TMPDIR environment variable to some world-writtable directory."
ja_message_invalid_altroot_option="\347\204\241\345\212\271\343\201\252\440\455\522\440\343\202\252\343\203\227\343\202\267\343\203\247\343\203\263\343\201\256\345\274\225\346\225\260"
ja_message_help_h_option="\t\t\t\343\201\223\343\201\256\343\203\230\343\203\253\343\203\227\343\202\222\345\207\272\345\212\233\343\201\227\343\201\276\343\201\231\343\200\202"
ja_message_help_r_option="\474\543\554\551\545\556\564\537\562\557\557\564\537\560\541\564\550\476\t\344\273\243\346\233\277\343\203\253\343\203\274\343\203\210\343\203\221\343\202\271\440\450\523\557\554\541\562\551\563\440\343\201\256\343\201\277\451\343\200\202"
ja_message_help_p_option="\t\t\t\517\562\541\543\554\545\440\523\557\554\541\562\551\563\440\523\564\565\544\551\557\440\343\201\256\343\203\221\343\203\203\343\203\201\343\202\222\343\202\244\343\203\263\343\202\271\343\203\210\343\203\274\343\203\253\343\201\227\343\201\276\343\201\231\343\200\202"
ja_message_patches_dir_missed="\447\560\541\564\543\550\545\563\447\440\343\203\207\343\202\243\343\203\254\343\202\257\343\203\210\343\203\252\343\201\214\350\246\213\343\201\244\343\201\213\343\202\212\343\201\276\343\201\233\343\202\223\343\201\247\343\201\227\343\201\237"
ja_message_help_usage="\344\275\277\347\224\250\346\263\225"
ja_message_help_options="\343\202\252\343\203\227\343\202\267\343\203\247\343\203\263"
ja_message_no_product_patches_available="\344\275\277\347\224\250\345\217\257\350\203\275\343\201\252\350\243\275\345\223\201\343\203\221\343\203\203\343\203\201\343\201\214\343\201\202\343\202\212\343\201\276\343\201\233\343\202\223"
ja_message_installing_rpm="\522\520\515\440\343\203\221\343\203\203\343\202\261\343\203\274\343\202\270\343\202\222\343\202\244\343\203\263\343\202\271\343\203\210\343\203\274\343\203\253\343\201\227\343\201\246\343\201\204\343\201\276\343\201\231"
ja_message_wrong_destination_system="\523\557\554\541\562\551\563\440\461\460\440\517\523\440\343\202\222\345\256\237\350\241\214\343\201\227\343\201\246\343\201\204\343\201\252\343\201\204\343\202\267\343\202\271\343\203\206\343\203\240\343\201\253\343\203\221\343\203\203\343\203\201\343\202\222\343\202\244\343\203\263\343\202\271\343\203\210\343\203\274\343\203\253\343\201\227\343\202\210\343\201\206\343\201\250\343\201\227\343\201\246\343\201\204\343\201\276\343\201\231\456\456\456\347\265\202\344\272\206\343\201\227\343\201\276\343\201\231"
ja_message_execution_finished="\345\256\237\350\241\214\343\201\214\347\265\202\344\272\206\343\201\227\343\201\276\343\201\227\343\201\237"
ja_message_no_system_patches_available="\344\275\277\347\224\250\345\217\257\350\203\275\343\201\252\343\202\267\343\202\271\343\203\206\343\203\240\343\203\221\343\203\203\343\203\201\343\201\214\343\201\202\343\202\212\343\201\276\343\201\233\343\202\223"
ja_message_unknown_option="\344\270\215\346\230\216\343\201\252\343\202\252\343\203\227\343\202\267\343\203\247\343\203\263"
ja_message_help_l_option="\474\554\557\543\541\554\545\476\t\t\346\214\207\345\256\232\343\201\225\343\202\214\343\201\237\440\474\554\557\543\541\554\545\476\440\343\202\222\343\203\207\343\203\225\343\202\251\343\203\253\343\203\210\343\203\255\343\202\261\343\203\274\343\203\253\343\202\210\343\202\212\343\202\202\345\204\252\345\205\210\343\201\227\343\201\276\343\201\231\343\200\202\346\214\207\345\256\232\343\201\247\343\201\215\343\202\213\345\200\244\343\201\257\440\447\545\556\447\343\200\201\447\552\541\447\343\200\201\343\201\276\343\201\237\343\201\257\440\447\572\550\447\440\343\201\247\343\201\231\343\200\202"
ja_message_help_g_option="\t\t\t\347\217\276\345\234\250\343\201\256\343\202\276\343\203\274\343\203\263\343\201\256\343\203\221\343\203\203\343\202\261\343\203\274\343\202\270\343\201\253\343\201\256\343\201\277\343\203\221\343\203\203\343\203\201\343\202\222\350\277\275\345\212\240\343\201\227\343\201\276\343\201\231\440\450\523\557\554\541\562\551\563\440\343\201\256\343\201\277\451\343\200\202"
ja_message_ignoring_rpm="\522\520\515\440\343\203\221\343\203\203\343\202\261\343\203\274\343\202\270\343\202\222\347\204\241\350\246\226\343\201\227\343\201\276\343\201\231"
ja_message_wrong_source_system="\343\202\265\343\203\235\343\203\274\343\203\210\343\201\225\343\202\214\343\201\246\343\201\204\343\202\213\440\517\523\440\343\201\247\343\201\257\343\201\202\343\202\212\343\201\276\343\201\233\343\202\223\456\456\456\440\347\265\202\344\272\206\343\201\227\343\201\276\343\201\231"
ja_message_installing_patch="\343\203\221\343\203\203\343\203\201\343\202\222\343\202\244\343\203\263\343\202\271\343\203\210\343\203\274\343\203\253\343\201\227\343\201\246\343\201\204\343\201\276\343\201\231"
ja_message_rights_error="\343\201\223\343\201\256\343\202\271\343\202\257\343\203\252\343\203\227\343\203\210\343\201\257\440\562\557\557\564\440\343\201\247\345\256\237\350\241\214\343\201\231\343\202\213\345\277\205\350\246\201\343\201\214\343\201\202\343\202\212\343\201\276\343\201\231"
ja_message_rpm_not_found="\562\560\555\440\343\203\246\343\203\274\343\203\206\343\202\243\343\203\252\343\203\206\343\202\243\343\203\274\343\201\214\350\246\213\343\201\244\343\201\213\343\202\212\343\201\276\343\201\233\343\202\223\456\456\456\440\347\265\202\344\272\206\343\201\227\343\201\276\343\201\231"
ja_message_tmpdir_not_set="\524\515\520\504\511\522\440\347\222\260\345\242\203\345\244\211\346\225\260\343\202\222\343\200\201\350\252\260\343\201\247\343\202\202\346\233\270\343\201\215\350\276\274\343\202\201\343\202\213\343\201\204\343\201\232\343\202\214\343\201\213\343\201\256\343\203\207\343\202\243\343\203\254\343\202\257\343\203\210\343\203\252\343\201\253\350\250\255\345\256\232\343\201\227\343\201\246\343\201\217\343\201\240\343\201\225\343\201\204\343\200\202"
ja_message_wait_for_enter="\347\265\202\344\272\206\343\201\231\343\202\213\343\201\253\343\201\257\440\533\505\516\524\505\522\535\440\343\202\222\346\212\274\343\201\227\343\201\276\343\201\231"

zh_message_rights_error="\345\277\205\351\241\273\344\273\245\440\562\557\557\564\440\347\224\250\346\210\267\350\272\253\344\273\275\346\211\247\350\241\214\346\255\244\350\204\232\346\234\254"
zh_message_no_system_patches_available="\346\262\241\346\234\211\347\263\273\347\273\237\344\277\256\350\241\245\347\250\213\345\272\217\345\217\257\347\224\250"
zh_message_help_l_option="\474\554\557\543\541\554\545\476\t\t\344\275\277\347\224\250\346\214\207\345\256\232\347\232\204\440\474\554\557\543\541\554\545\476\440\350\246\206\347\233\226\347\274\272\347\234\201\350\257\255\350\250\200\347\216\257\345\242\203\343\200\202\345\217\257\350\203\275\347\232\204\345\200\274\344\270\272\357\274\232\447\545\556\447\343\200\201\447\552\541\447\440\346\210\226\440\447\572\550\447\343\200\202"
zh_message_help_g_option="\t\t\t\344\273\205\345\260\206\344\277\256\350\241\245\347\250\213\345\272\217\346\267\273\345\212\240\345\210\260\345\275\223\345\211\215\345\214\272\345\237\237\347\232\204\350\275\257\344\273\266\345\214\205\344\270\255\357\274\210\344\273\205\351\231\220\440\523\557\554\541\562\551\563\357\274\211\343\200\202"
zh_message_help_options="\351\200\211\351\241\271"
zh_message_help_r_option="\474\543\554\551\545\556\564\537\562\557\557\564\537\560\541\564\550\476\t\345\244\207\347\224\250\346\240\271\350\267\257\345\276\204\357\274\210\344\273\205\351\231\220\440\523\557\554\541\562\551\563\357\274\211\343\200\202"
zh_message_help_h_option="\t\t\t\346\211\223\345\215\260\346\255\244\345\270\256\345\212\251\343\200\202"
zh_message_wrong_destination_system="\345\260\235\350\257\225\345\234\250\346\234\252\350\277\220\350\241\214\440\523\557\554\541\562\551\563\440\461\460\440\517\523\440\347\232\204\347\263\273\347\273\237\344\270\212\345\256\211\350\243\205\344\277\256\350\241\245\347\250\213\345\272\217\456\456\456\345\260\206\351\200\200\345\207\272"
zh_message_patches_dir_missed="\346\234\252\346\211\276\345\210\260\440\447\560\541\564\543\550\545\563\447\440\347\233\256\345\275\225"
zh_message_wait_for_enter="\346\214\211\440\533\505\516\524\505\522\535\440\351\224\256\351\200\200\345\207\272"
zh_message_unknown_option="\346\234\252\347\237\245\351\200\211\351\241\271"
zh_message_help_usage="\347\224\250\346\263\225"
zh_message_rpm_not_found="\346\234\252\346\211\276\345\210\260\440\562\560\555\440\345\256\236\347\224\250\347\250\213\345\272\217\456\456\456\345\260\206\351\200\200\345\207\272"
zh_message_wrong_source_system="\344\270\215\346\224\257\346\214\201\347\232\204\346\223\215\344\275\234\347\263\273\347\273\237\456\456\456\345\260\206\351\200\200\345\207\272"
zh_message_ignoring_rpm="\345\277\275\347\225\245\440\522\520\515\440\350\275\257\344\273\266\345\214\205"
zh_message_help_p_option="\t\t\t\345\256\211\350\243\205\440\517\562\541\543\554\545\440\523\557\554\541\562\551\563\440\523\564\565\544\551\557\440\344\277\256\350\241\245\347\250\213\345\272\217\343\200\202"
zh_message_installing_rpm="\345\256\211\350\243\205\440\522\520\515\440\350\275\257\344\273\266\345\214\205"
zh_message_execution_finished="\346\211\247\350\241\214\345\267\262\345\256\214\346\210\220"
zh_message_tmpdir_not_set="\350\257\267\345\260\206\440\524\515\520\504\511\522\440\347\216\257\345\242\203\345\217\230\351\207\217\350\256\276\347\275\256\344\270\272\346\237\220\345\205\250\345\261\200\345\217\257\345\206\231\347\232\204\347\233\256\345\275\225\343\200\202"
zh_message_installing_patch="\345\256\211\350\243\205\344\277\256\350\241\245\347\250\213\345\272\217"
zh_message_invalid_altroot_option="\455\522\440\351\200\211\351\241\271\345\217\202\346\225\260\346\227\240\346\225\210"
zh_message_no_product_patches_available="\346\262\241\346\234\211\344\272\247\345\223\201\344\277\256\350\241\245\347\250\213\345\272\217\345\217\257\347\224\250"

get_localized_message() {
    eval tst_msg=\$"$2_$1"
    if [ "$tst_msg" ]; then
	    eval msg=\$"$2_$1"
    else
        eval msg=\$"en_$1"
    fi
    echo $msg
}

get_message() {
    echo `get_localized_message $1 $SCRIPT_LOCALE`
}

LOCAL_ZONE_ONLY_OPTION=""
ALT_ROOT_OPTION=""
ALT_ROOT=""
BASE_PATCHES_PATH="`pwd`/patches"
PRODUCT_PATCHES_PATH="$BASE_PATCHES_PATH/product"
SYSTEM_PATCHES_PATH="$BASE_PATCHES_PATH/system"
PATCH_ADD=/usr/sbin/patchadd
PAUSE=""
SCRIPT_LOCALE="en"
PRODUCT_PATCHES=""

print_usage() {
   msg="install_patches.sh ["`get_message "message_help_options"`"]\n"
   printf "$msg"
   msg=`get_message "message_help_usage"`":\n"
   printf "$msg" 
   msg="  -G"`get_message "message_help_g_option"`"\n"
   printf "$msg"
   msg="  -R "`get_message "message_help_r_option"`"\n"
   printf "$msg"
   msg="  -p"`get_message "message_help_p_option"`"\n"
   printf "$msg"
   msg="  -l "`get_message "message_help_l_option"`"\n"
   printf "$msg"
   msg="  -h"`get_message "message_help_h_option"`"\n"
   printf "$msg"
}

script_exit() {
    msg=`get_message $2`"\n"
    printf "$msg" 1>&2
    if [ $1 -eq 2 ]; then
        print_usage
    fi
    if [ ! -z "$3" ]; then
	msg=`get_message "message_wait_for_enter"`"\n"
        printf "$msg" 1>&2
        read ANSWER
    fi
    exit $1
}

check_locale() {
    if [ "`echo $1 | /bin/grep $2`" ]; then
	SCRIPT_LOCALE=$2
    fi 
}

init() {
   if [ "`/usr/bin/locale | /bin/grep LANG | /bin/grep UTF-8`" ]; then
	lang=`/usr/bin/locale | /bin/grep LANG`
	check_locale $lang "ja"
	check_locale $lang "zh"
   fi
   while [ "$#" -gt "0" ]
   do
       case $1 in
       -h)
           print_usage;
           exit 0;
       ;;
       -G)
           LOCAL_ZONE_ONLY_OPTION="-G"
       ;;
       -R)
           shift
           if [ ! -d "$1" ]; then
               script_exit 2 "message_invalid_altroot_option";
           fi
           ALT_ROOT_OPTION="-R $1"
  	       ALT_ROOT="$1"
       ;;
       -w)
           PAUSE="true"
       ;;
       -l)
           shift
	   if [ "`/usr/bin/locale | /bin/grep LANG.*$1.*UTF-8`" ]; then
		SCRIPT_LOCALE="$1"
     	   fi
       ;;
       -p)
           PRODUCT_PATCHES="true"
       ;;
       *)
	    msg=`get_message "message_unknown_option"`": "$1"\n"
	    printf "$msg"
            print_usage;
            exit 2
       ;;
       esac
       shift
   done
}

install_patch() {
	patch_name=`echo ${1%-*}`
	patch_version=`echo ${1#*-}`
	found=''
	for i in `$PATCH_ADD $ALT_ROOT_OPTION -p | /bin/grep ^Patch:.$patch_name`;
	do
		if [ "`echo $i | /bin/grep $patch_name`" ]; then
			existing_patch_version=`echo ${i#*-}`
			if [ $existing_patch_version -ge $patch_version ]; then
				found='true'
			fi
		fi
	done
	if [ -z $found ]; then
		msg=`get_message "message_installing_patch"`" "$1"\n"
		printf "$msg"
		eval "$PATCH_ADD $LOCAL_ZONE_ONLY_OPTION $ALT_ROOT_OPTION -M $PATCHES_PATH $1"
	fi
}

install_rpm() {
        package_name="`/bin/rpm -qp $1 --qf '%{NAME}\n'`"
	if [ "`/bin/rpm -qa $package_name`" ]; then
	    msg=`get_message "message_installing_rpm"`" "`/usr/bin/basename $1`"\n"
	    printf "$msg" 
	    /bin/rpm -F $1
	else
	    msg=`get_message "message_ignoring_rpm"`" "`/usr/bin/basename $1`"\n"
	    printf "$msg" 
	fi
}

init $*;
if [ -z "`/usr/bin/id | /bin/grep uid=0`" ]; then
	script_exit 1 "message_rights_error"
fi
if [ ! -d "$BASE_PATCHES_PATH" ]; then
	script_exit 1 "message_patches_dir_missed" $PAUSE
fi
case `uname` in
    SunOS)
	if [ ! -d "$TMPDIR" ]; then
	    TMPDIR=/tmp
	    export TMPDIR
	fi
	if [ -n "$TMPDIR" ] && [ -d "$TMPDIR" ]; then
	    baseName=`/usr/bin/basename $TMPDIR`
	    dirName=`/usr/bin/dirname $TMPDIR`
	    if [ -z "`/bin/ls -l $dirName | /bin/grep $baseName | /bin/grep drwxrwxrw.`" ]; then
		script_exit 1 "message_tmpdir_not_set";
	    fi
        fi
		if [ -z "$PRODUCT_PATCHES" ]; then
			PATCHES_PATH=$SYSTEM_PATCHES_PATH
			if [ -z "`/bin/cat $ALT_ROOT/etc/release | /bin/grep 'Solaris 10'`" ]; then
				script_exit 1 "message_wrong_destination_system" $PAUSE
			fi
			if [ ! -d "$SYSTEM_PATCHES_PATH" ]; then
				script_exit 0 "message_no_system_patches_available";
			fi
			if [ -z "`/bin/ls $SYSTEM_PATCHES_PATH`" ]; then
				script_exit 0 "message_no_system_patches_available";
			fi
		else
			PATCHES_PATH=$PRODUCT_PATCHES_PATH
			if [ ! -d "$PRODUCT_PATCHES_PATH" ]; then
				script_exit 0 "message_no_product_patches_available";
			fi
			if [ -z "`/bin/ls $PRODUCT_PATCHES_PATH`" ]; then
				script_exit 0 "message_no_product_patches_available";
			fi
		fi
		for patch_file in `/bin/ls $PATCHES_PATH`; do
			install_patch $patch_file
		done
        echo ""
		script_exit 0 "message_execution_finished" $PAUSE
    ;;
	Linux)
		if [ -z "$PRODUCT_PATCHES" ]; then
			script_exit 0 "message_no_system_patches_available";
		else
			PATCHES_PATH=$PRODUCT_PATCHES_PATH
			if [ ! -d "$PRODUCT_PATCHES_PATH" ]; then
				script_exit 0 "message_no_product_patches_available";
			fi
			if [ -z "`/bin/ls $PRODUCT_PATCHES_PATH`" ]; then
				script_exit 0 "message_no_product_patches_available";
			fi
			/bin/rpm --version 1>/dev/null 2>/dev/null 
			if [ "$?" -ne "0" ]; then
				script_exit 2 "message_rpm_not_found";
			fi
		fi
		for patch_dir in `/bin/ls $PATCHES_PATH`; do
                    msg=`get_message "message_installing_patch"`" "$patch_dir"\n"
                    printf "$msg"
                    for rpm_file in `/bin/ls $PATCHES_PATH/$patch_dir | /bin/grep rpm`; do
			install_rpm $PATCHES_PATH/$patch_dir/$rpm_file
                    done
		done
        echo ""
		script_exit 0 "message_execution_finished" $PAUSE
	;;
    *)
        script_exit 1 "message_wrong_source_system"
    ;;
esac

