%define module megaraid
%define version v2.20.4.6

Summary:	megaraid dkms package
Name:		%{module}
Version:	%{version}
Release:	2dkms
Vendor:		LSI
License:	GPL
Packager:	Rajesh Prabhakaran <rajesh.prabhakaran@lsil.com>  
Group:		System Environment/Base
BuildArch:	x86_64
Requires:	dkms >= 1.00
Requires:	bash
Source0:	%{module}-%{version}-src.tgz
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root/

%description
This package contains LSI's megaraid module wrapped for the DKMS framework.

%prep
rm -rf %{module}-%{version}
mkdir %{module}-%{version}
cd %{module}-%{version}
tar xvzf $RPM_SOURCE_DIR/%{module}-%{version}-src.tgz

%install
if [ "$RPM_BUILD_ROOT" != "/" ]; then
	rm -rf $RPM_BUILD_ROOT
fi

mkdir -p $RPM_BUILD_ROOT/usr/src/%{module}-%{version}/
mkdir -p $RPM_BUILD_ROOT/usr/src/%{module}-%{version}/patches
mkdir -p $RPM_BUILD_ROOT/usr/src/%{module}-%{version}/redhat_driver_disk

cp -rf %{module}-%{version}/* $RPM_BUILD_ROOT/usr/src/%{module}-%{version}

install -m 644 $RPM_SOURCE_DIR/%{module}-%{version}-kernel2.6.9-5.EL-all.tgz $RPM_BUILD_ROOT/usr/src/%{module}-%{version}

%clean
if [ "$RPM_BUILD_ROOT" != "/" ]; then
	rm -rf $RPM_BUILD_ROOT
fi

%files
%defattr(0644,root,root)
/usr/src/%{module}-%{version}/

%pre

%post
dkms add -m %{module} -v %{version} --rpm_safe_upgrade

# Load tarballs as necessary
loaded_tarballs=""

base_kernel=2.6.9-5.EL		# this is the archive of all related kernels
for kernel_name in 2.6.9-5.EL; do
        if [ -d "/lib/modules/$kernel_name" ] && [ `uname -m | grep -c "i*86"` -gt 0 ]; then
                echo -e ""
                echo -e "Loading/Installing pre-built modules for $kernel_name."
                dkms ldtarball --archive=/usr/src/%{module}-%{version}/%{module}-%{version}-kernel${base_kernel}-all.tgz >/dev/null
                dkms install -m %{module} -v %{version} -k ${kernel_name} >/dev/null 2>&1
                dkms install -m %{module} -v %{version} -k ${kernel_name}smp >/dev/null 2>&1
                dkms install -m %{module} -v %{version} -k ${kernel_name}hugemem >/dev/null 2>&1
		[ `uname -r | grep -c "$kernel_name"` -gt 0 ] && loaded_tarballs="true"
        fi
done

# If we haven't loaded a tarball, then try building it for the current kernel
if [ -z "$loaded_tarballs" ]; then
	echo -e "dkms build start"
	dkms build -m %{module} -v %{version} --kernelsourcedir=/usr/src/redhat/BUILD/kernel-2.6/linux-2.6.9/
	echo -e "dkms build done"
	echo -e "dkms install start"
	dkms install -m %{module} -v %{version}
	echo -e "dkms install done"
else 
	echo -e ""
	echo -e "Module build for the currently running kernel was skipped since the"
	echo -e "kernel source for this kernel does not seem to be installed."
fi
exit 0

%preun
echo -e
echo -e "Uninstall of megaraid module (version %{version}) beginning:"
dkms remove -m %{module} -v %{version} --all --rpm_safe_upgrade
exit 0

%changelog
* Thu Mar 18 2005 Seokmann Ju <Seokmann.Ju@lsil.com>
- Released for megaraid v2.20.4.6/2.20.2.6 for built-in 2.6.9-5.EL/smp
* Thu Jan 27 2005 Seokmann Ju <Seokmann.Ju@lsil.com>
- Released for megaraid v2.20.4.4/2.20.2.5 for built-in 2.6.9.1-906_EL/smp
* Wed Dec 16 2004 Sreenivas Bagalkote <Sreenivas.Bagalkote@lsil.com>
- Released for megaraid v2.20.4.2/2.20.2.4 for built-in 2.6.9.1-648_EL/smp/hugemem
