/*******************************************************************************

This software program is available to you under a choice of one of two
licenses. You may choose to be licensed under either the GNU General Public
License 2.0, June 1991, available at http://www.fsf.org/copyleft/gpl.html,
or the Intel BSD + Patent License, the text of which follows:

Recipient has requested a license and Intel Corporation ("Intel") is willing
to grant a license for the software entitled Common Statistics Manager
being provided by Intel Corporation. The following definitions apply to this
license:

"Licensed Patents" means patent claims licensable by Intel Corporation which
are necessarily infringed by the use of sale of the Software alone or when
combined with the operating system referred to below.

"Recipient" means the party to whom Intel delivers this Software.

"Licensee" means Recipient and those third parties that receive a license to
any operating system available under the GNU General Public License 2.0 or
later.

Copyright (c) 2004 - 2005 Intel Corporation.
All rights reserved.

The license is provided to Recipient and Recipient's Licensees under the
following terms.

Redistribution and use in source and binary forms of the Software, with or
without modification, are permitted provided that the following conditions
are met:

Redistributions of source code of the Software may retain the above
copyright notice, this list of conditions and the following disclaimer
Redistributions in binary form of the Software may reproduce the above
copyright notice, this list of conditions and the following disclaimer in
the documentation and/or materials provided with the distribution.

Neither the name of Intel Corporation nor the names of its contributors
shall be used to endorse or promote products derived from this Software
without specific prior written permission.

Intel hereby grants Recipient and Licensees a non-exclusive, worldwide,
royalty-free patent license under Licensed Patents to make, use, sell, offer
to sell, import and otherwise transfer the Software, if any, in source code
and object code form. This license shall include changes to the Software
that are error corrections or other minor changes to the Software that do
not add functionality or features when the Software is incorporated in any
version of an operating system that has been distributed under the GNU
General Public License 2.0 or later. This patent license shall apply to the
combination of the Software and any operating system licensed under the GNU
General Public License 2.0 or later if, at the time Intel provides the
Software to Recipient, such addition of the Software to the then publicly
available versions of such operating systems available under the GNU General
Public License 2.0 or later (whether in gold, beta or alpha form) causes
such combination to be covered by the Licensed Patents. The patent license
shall not apply to any other combinations which include the Software. NO
hardware per se is licensed hereunder.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MECHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL INTEL OR IT CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
ANY LOSS OF USE; DATA, OR PROFITS; OR BUSINESS INTERUPTION) HOWEVER CAUSED
AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY OR
TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/
#ifndef DMA_H
#define DMA_H

#include <linux/init.h>

/*
 *  Platform dependent values. 
 */

#ifdef DMA_L
    #define EDMA_DEVICE_ID              0x3594
    #define PRODUCT_STRING             "DMA Reference Driver - IPD"
    #define CHAR_DRV_NAME              "dma_01"
    #define VERSION_STRING             "1.0.0"
   
    #define MAX_TRANSFER_PER_DESC       0x00400000  // 4MB
#elif EDMA_W
    #define EDMA_DEVICE_ID              0x35B5
    #define PRODUCT_STRING             "EDMA Reference Driver - IPD"
    #define CHAR_DRV_NAME              "edma_01"
    #define VERSION_STRING             "1.0.0"
    
    #define MAX_TRANSFER_PER_DESC       0x01000000  // 16MB
    /*
     * Memory Operations:
     * Additional Functionality present in EDMA_W platform.
     * Bits 9-11 Reserved.
     */
    #define SRC_INC         0x00000000
    #define SRC_DEC         0x00001000
    #define SRC_BUFFER_INIT 0x00002000
    
    #define DST_INC         0x00000000
    #define DST_CONST       0x00004000
    
    /* Bit 16 reserved */
    
    #define GRAN_1_BYTE     0x00000000
    #define GRAN_2_BYTE     0x00020000
    #define GRAN_4_BYTE     0x00040000
    
    /* Bits 19-28 Reserved */
    
    /* Traffic Classes */
    #define TC_0            0x00000000
    #define TC_1            0x20000000
    #define TC_2            0x40000000
    #define TC_3            0x60000000
    #define TC_4            0x80000000
    #define TC_5            0xA0000000
    #define TC_6            0xC0000000
    #define TC_7            0xE0000000
    
#endif


/*
*  Macros
*/
#define resource_to_dma(res) (struct edma_chan *)((res)->ptr)

/* PCI CONFIGURATION -
*  Configuration Space Register Offsets
*/
#define EDMA_PCICMD                 0x04       //Size = 16 bits
#define EDMA_CTL_REG	           0x40	      //Size = 8 bits
#define EDMA_FERR_REG	           0x80       //Size = 32 bits


/* MEMORY MAPPED REGISTERS - 
*  Channel Offsets
*/

#define EDMA_CHAN0_CCR              0x00       //Size = 32 bits
#define EDMA_CHAN1_CCR              0x40       //Size = 32 bits
#define EDMA_CHAN2_CCR              0x80       //Size = 32 bits
#define EDMA_CHAN3_CCR              0xC0       //Size = 32 bits

#define EDMA_CSR                    0x04       //Size = 32 bits
#define EDMA_CDAR		   0x08
#define EDMA_CDUAR		   0x0C
#define EDMA_SAR			   0x10
#define EDMA_SUAR                   0x14
#define EDMA_DAR		           0x18
#define EDMA_DUAR                   0x1C
#define EDMA_NDAR	           0x20
#define EDMA_NDUAR                  0x24
#define EDMA_DWCR	 	   0x28
#define EDMA_DCR                    0x2C



/* MEMORY MAPPED REGISTERS - 
*  Global Control Registers
*/
#define EDMA_DCGC_REG               0x100      //Size = 32 bits

/* VALUES*/
#define EDMA_CMD_VAL                0x02
#define EDMA_VENDOR_ID              0x8086
#define EDMA_CTL_ENABLE             0x80       //Control Register enable
#define EDMA_FERR_RESET             0xFFFFFFFF //Write all ones to clear FERR
#define EDMA_BAR0                   0x00000000
#define MAJOR_NO                   55
#define SUCCESS                    0
#define FAILED                     -1
#define CHANNEL_PRIORITY_ENABLED   0x04
#define CHANNEL_PRIORITY_DISABLED   0xFFFFFFF8

#define END_OF_CHAIN               0x01 //CSR
#define END_OF_TRANSFER            0x02 //CSR
#define DMA_SUSPENDED              0x04 //CSR
#define DMA_STOPPED                0x08 //CSR
#define DMA_ABORTED                0x10 //CSR
#define CHAN_ACTIVE                0x20 //CSR
#define CSR_IDLE		   0x00000000 //CSR value when system powered on or reset

#define START_DMA		   0x01   //CCR
#define SUSPEND_DMA                0x02   //CCR
#define STOP_DMA                   0x04   //Use Carefully! See documentation for details.
#define RESUME_DMA                 0x08   //CCR

#define FERR_ERR0                  0x00
#define FERR_ERR1                  0x01
#define FERR_ERR2                  0x02
#define FERR_ERR3                  0x03
#define FERR_ERR4                  0x04
#define FERR_ERR5                  0x05
#define FERR_ERR6                  0x06
#define FERR_ERR7                  0x07


/* Defines for the DWORD Memory_Ops which are placed in the DCR1 */
#define CLEAR_MEMORY_OPS 0xFFFFFFE0
/* Bits 0 - 4 are not bits that can be set by the user.
We set END_OF_CHAIN as a driver policy, and we won't allow 
the user to set these bits. 
*/
#define INT_END_OF_CHAIN      0x00000001
#define INT_END_OF_TRANSFER   0x00000002
#define INT_SUSPEND	      0x00000004
#define INT_STOPPED	      0x00000008
#define INT_ABORT	      0x00000010

/* Bit 5: Destination Address Points to local system memory or I/O Space */
#define DST_MEM   0x00000000
#define DST_IO 	  0x00000020

/* Bit 6 - Source address points to local system memory or I/O Space.
Should only be zero for this implementation */
#define SRC_MEM	  0x00000000  
#define SRC_IO	  0x00000040

/* Bit 7 - Destination is non-coherent or coherent */
#define DST_NONCOHERENT 0x00000000  
#define DST_COHERENT    0x00000080

/* Bit 8 - Source is non-coherent or coherent */
#define SRC_NONCOHERENT 0x00000000  
#define SRC_COHERENT    0x00000100

/* Bits 9  Source Alignment */

#define SRC_DWORD_ALIGNED 0x00000200
#define SRC_CACHE_ALIGNED 0x00000000

/* Bits 10  Destination Alignment */
#define DST_DWORD_ALIGNED 0x00000400
#define DST_CACHE_ALIGNED 0x00000000

/* DMA_L Bits 11:31 Reserved */



/* IOCTL VALUES - 
*  The "magic number" is necessary for the "new" way of
*  choosing ioctl numbers as described in Documentation/ioctl-number.txt,
*  which outlines how to add new ioctls to the kernel using
*  the _IO macros.
*/
#define DMA_IOC_MAGIC_NO            'k'
#define DMA_IOC_IS_COMPLETE         _IOR(DMA_IOC_MAGIC_NO, 0, unsigned long)
#define DMA_IOC_CHANNEL_PRIORITY    _IOW(DMA_IOC_MAGIC_NO, 1, unsigned long)
#define DMA_IOC_GET_ERRORS          _IOR(DMA_IOC_MAGIC_NO, 2, unsigned long)
#define DMA_IOC_CLIENT_ALLOC_APP    _IOWR(DMA_IOC_MAGIC_NO, 3, unsigned long)
#define DMA_IOC_CLIENT_RELEASE      _IOWR(DMA_IOC_MAGIC_NO, 4, unsigned long)
#define DMA_IOC_REGISTER            _IOWR(DMA_IOC_MAGIC_NO, 5, unsigned long)
#define DMA_IOC_UNREGISTER          _IOWR(DMA_IOC_MAGIC_NO, 6, unsigned long)
#define DMA_IOC_CHANNEL_ALLOC_APP   _IOWR(DMA_IOC_MAGIC_NO, 7, unsigned long)
#define DMA_IOC_CHANNEL_RELEASE     _IOWR(DMA_IOC_MAGIC_NO, 8, unsigned long)
#define DMA_IOC_MEMCPY              _IOWR(DMA_IOC_MAGIC_NO, 9, unsigned long)

/* STRINGS -
*  String Constants
*
*/




/* MESSAGES */
#define ERROR_REGISTRATION         "%s: Init: could not register module\n"
#define ERROR_DEREGISTRATION	   "%s: Cleanup: could not unregister module\n"	
#define MESSAGE_INIT               "%s: Init: Performing initialization...\n"
#define MESSAGE_INIT_COMPLETE      "%s: Init: Initialization complete\n"
#define ERROR_MM1                  "%s: Init: Failed to obtain PCI I/O Memory Region...\n"
#define ERROR_MM2                  "%s: Init: Failed to obtain a virtual address for memory mapped registers\n"
#define ERROR_DEVICE_NOT_FOUND     "%s: Init: Failed to find device...\n"
#define MESSAGE_CLEANUP            "%s: Cleanup: Performing Cleanup...\n"
#define MESSAGE_DEREGISTRATION     "%s: Deregistration successful. Cleanup complete\n"
#define MESSAGE_CHANNEL            "%i: Channel Allocation broken\n"
#define ERROR_CLIENT_ALLOC         "%s: Unable to allocate a edma_client struct.\n"
#define UNKNOWN_IOCTL              "%s :Unknown IOCTL operation\n"

/* MISC */
#define TRUE                       1
#define FALSE                      0
#define MAX_NO_CHANS               4   //maximum number of channels.
#define FREE			   0
#define IN_USE			   1
#define DWORD_ALIGNED		   0x20
#define DESCRIPTOR_NO              16
#define LOWER_64                   0x00000000FFFFFFFF
#define UPPER_64                   0xFFFFFFFF00000000
#define INVALID_COOKIE             -1
#define DWORD_SIZE                 4

#define ERROR_OUT_OF_DESCRIPTORS   -1

/* For Tasklets */
#define TASKLET_UNSCHEDULED        0x00
#define TASKLET_SCHEDULE           0x01
#define CHANNEL_0                  0x00010000
#define CHANNEL_1                  0x00020000
#define CHANNEL_2                  0x00030000
#define CHANNEL_3                  0x00040000

/* These references are here to prevent unnecessary warnings. */
struct edma_chan;
struct edma_client;

typedef signed long edma_cookie_t;
typedef char * edma_version_t;
/*
 * STRUCT: edma_ch_mm_regs - memory mapped registers associated with each channel.
 * @ccr: Channel control
 * @csr: Channel status
 * @cdar: Current descriptor address
 * @cduar: Current descriptor upper address
 * The remaining elements are described in the descriptor
 * structure below.
 */
struct edma_ch_mm_regs
{
    unsigned int ccr;
    unsigned int csr;
    unsigned int cdar;
    unsigned int cduar;
    unsigned int sar;
    unsigned int suar;
    unsigned int dar;
    unsigned int duar;
    unsigned int ndar;
    unsigned int nduar;
    unsigned int tcr;
    unsigned int dcr;
    /* There are 16 bytes between each set of per-channel registers
    * as well as sixteen bytes between the channel 3's registers
    * and the global control registers. 
    */
    unsigned int reserved[4];
};

/*
 * STRUCT: edma_descriptor - a portion of edma_ch_mm_regs, used in chaining
 * descriptors for transactions.
 * 
 * @sar: Source address 
 * @suar: Source upper address
 * @dar: Destination address
 * @duar: Destination upper address
 * @ndar: Next descriptor address
 * @nduar: Next descriptor upper address
 * @tcr: Byte Count
 * @dcr: Descriptor Control
 */
struct edma_descriptor
{
    unsigned int sar;
    unsigned int suar;
    unsigned int dar;
    unsigned int duar;
    unsigned int ndar;
    unsigned int nduar;
    unsigned int tcr;
    unsigned int dcr;

};

/*
* STRUCT: edma_mm_regs -
* @ch0-3: memmory mapped registers for channels 0 - 3
* @dcgc: DMA Controller Global Command
* @dcgs: DMA Controller Global Status 
*/
struct edma_mm_regs
{
    struct edma_ch_mm_regs ch0;
    struct edma_ch_mm_regs ch1;
    struct edma_ch_mm_regs ch2;
    struct edma_ch_mm_regs ch3;
    unsigned int dcgc;
    unsigned int dcgs;
};


/*
 * Return values for edma_is_complete function.
 */
enum edma_status_t
{
    EDMA_ERROR = -1,   //Error occurred in transaction
    EDMA_SUCCESS,      //Transaction completed successfully
    EDMA_IN_PROGRESS,  //Transaction in progress
    EDMA_NO_RECORD     //No record for transaction is available (cookie expired)
};

/*
 * Return values for the edma_change_channel_priority.
 */
enum edma_channel_priority_status_t
{
    EDMA_CP_FAIL = -1,	//Failed to reset channel priority
    EDMA_CP_DEFAULT,         //Set channel priority to default (round robin)
    EDMA_CP_VALID_CHANNEL    //Set user specified channel to have top priority
};



/*
 * This enumerated type leaves room for expansion - the
 * inclusion of other types...
 */
enum edma_resource_t {
	EDMA_RESOURCE
};

/*
 * STRUCT: edma_resource - generic resource structure.
 * @type: resource type identifier.
 * @ptr: pointer to a resource specific structure/handle.
 */
struct edma_resource {
    enum edma_resource_t type;
    void *ptr;
};

/*
 * TYPEDEF: edma_callback_t - client drivers should implement
 * a callback function with a prototype which mirrors the
 * parameters below.
 */
typedef void  (*edma_callback_t ) (struct edma_client *, struct edma_chan *, edma_cookie_t, enum edma_status_t, unsigned long);

/*
 * STRUCT: edma_client - generic client structure.
 * @pdev: see Linux documenation for information about the pci_dev struct.
 * @chan_no: number of channel requested.
 * @edma_callback: pointer to a callback function.
 */
struct edma_client {
    struct pci_dev *pdev;
    unsigned int chan_no; //Only 0,1,2,3
    edma_callback_t edma_callback;
	
};

/* For application testing purposes only. */
struct edma_memcpy_parameters
{
    unsigned int memory_ops;
    struct edma_chan *chan;
    unsigned long long dest;
    unsigned long long src;
    size_t size;
    unsigned long user_data;

};

#endif



