/*******************************************************************************

This software program is available to you under a choice of one of two
licenses. You may choose to be licensed under either the GNU General Public
License 2.0, June 1991, available at http://www.fsf.org/copyleft/gpl.html,
or the Intel BSD + Patent License, the text of which follows:

Recipient has requested a license and Intel Corporation ("Intel") is willing
to grant a license for the software entitled Common Statistics Manager
being provided by Intel Corporation. The following definitions apply to this
license:

"Licensed Patents" means patent claims licensable by Intel Corporation which
are necessarily infringed by the use of sale of the Software alone or when
combined with the operating system referred to below.

"Recipient" means the party to whom Intel delivers this Software.

"Licensee" means Recipient and those third parties that receive a license to
any operating system available under the GNU General Public License 2.0 or
later.

Copyright (c) 2004 - 2005 Intel Corporation.
All rights reserved.

The license is provided to Recipient and Recipient's Licensees under the
following terms.

Redistribution and use in source and binary forms of the Software, with or
without modification, are permitted provided that the following conditions
are met:

Redistributions of source code of the Software may retain the above
copyright notice, this list of conditions and the following disclaimer
Redistributions in binary form of the Software may reproduce the above
copyright notice, this list of conditions and the following disclaimer in
the documentation and/or materials provided with the distribution.

Neither the name of Intel Corporation nor the names of its contributors
shall be used to endorse or promote products derived from this Software
without specific prior written permission.

Intel hereby grants Recipient and Licensees a non-exclusive, worldwide,
royalty-free patent license under Licensed Patents to make, use, sell, offer
to sell, import and otherwise transfer the Software, if any, in source code
and object code form. This license shall include changes to the Software
that are error corrections or other minor changes to the Software that do
not add functionality or features when the Software is incorporated in any
version of an operating system that has been distributed under the GNU
General Public License 2.0 or later. This patent license shall apply to the
combination of the Software and any operating system licensed under the GNU
General Public License 2.0 or later if, at the time Intel provides the
Software to Recipient, such addition of the Software to the then publicly
available versions of such operating systems available under the GNU General
Public License 2.0 or later (whether in gold, beta or alpha form) causes
such combination to be covered by the Licensed Patents. The patent license
shall not apply to any other combinations which include the Software. NO
hardware per se is licensed hereunder.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MECHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL INTEL OR IT CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
ANY LOSS OF USE; DATA, OR PROFITS; OR BUSINESS INTERUPTION) HOWEVER CAUSED
AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY OR
TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

#ifndef DMA_INTERNALS_H
#define DMA_INTERNALS_H

#include "dma.h"
#include "dma_list.h"
#include <linux/init.h>
#include <linux/pci.h>
#include <linux/types.h>

typedef unsigned long long edma_addr_t;

/*
 * STRUCT: edma_resource_internal - wrapper resource struct 
 * internal to the driver.
 * 
 * @next_ptr: pointer to next edma_resource_internal
 * in the list of resources.
 * @prev_ptr: pointer to previous edma_resource_internal
 * in the list of resources.
 * @pub: public resource. 
 * @client: pointer to a client associated with the resource.
 */
struct edma_resource_internal
{
    char * next_ptr;
    char * prev_ptr;
    struct edma_resource pub;
    struct edma_client *client;
};


/*
 * STRUCT: edma_chan - dma channel.
 *
 * 
 * @channel_no: channels are organized by number 0...3.
 * @reg_offset: private reserved.
 * @sw_in_use: value set when a channel is allocated.
 * @resource: internal resource.
 * @desc_lock: used for spin lock operations.
 * @completed_cookie: completed_cookie last cookie seen completed on cleanup.
 * @cookie: value of last cookie given to client.
 */
struct edma_chan
{
    unsigned int channel_no;               // Only - 0,1,2,3 acceptable
    unsigned int reg_offset;               // Defines in dma.h
    int sw_in_use;                         // 1 = in use, 0 = not in use
    struct edma_resource_internal resource;
    spinlock_t desc_lock;
    edma_cookie_t completed_cookie;         //last cookie completed
    edma_cookie_t cookie;                   //'current' cookie
};


/*
 * STRUCT: edma_client_internal - a wrapper structure
 * around the edma_client
 *
 * @next_ptr: points to next edma_client_internal in list.
 * @prev_ptr: points to previous edma_client_internal in list.
 * @pub: public dma client.
 * @resources: head of a resource list.
 * 
 */
struct edma_client_internal {
    char * next_ptr;
    char * prev_ptr;
    struct edma_client pub;
    struct list_start resources;
};



/*
 * STRUCT: edma_descriptor_internal - a wrapper structure
 * around the edma_descriptor. 16 descriptors are created
 * and formatted into a linked list (1 list/channel).
 *
 * @hw: descriptor struct (must be dword aligned).
 * @next_ndar: points to next descriptor (lower add).
 * @next_nduar: points to next descriptor (upper add).
 * @cookie: cookie assigned to the descriptor.
 * @phys: physical address of the descriptor.
 * @ferr: FERR value (-1 = initialized).
 * @status: see dma.h for values.
 * @reserved: created for alignment purposes.
 */

struct edma_descriptor_internal
{
    struct edma_descriptor hw;
    unsigned int next_ndar;
    unsigned int next_nduar;
    edma_cookie_t cookie;
    edma_addr_t phys;
    int ferr;
    int status;
    int reserved[1];
};

/*
 * STRUCT: edma_descriptor_list - contains the descriptor
 * list information. (1 descriptor list/channel)
 * 
 * @descriptor_pool: points to a contiguous region of memory
 * set aside for 16 descriptors.
 * @head_index: index of the descriptor that is the first
 * free (available for use) descriptor.
 * @tail_index: index of the descriptor that is the first
 * used descriptor.
*/
struct edma_descriptor_list
{
/*
 * The descriptor indices are an internal mechanism created
 * to help manage and track which descriptors are
 * currently in use and which are available.
 */
    char * descriptor_pool; //points to 16 descriptors kmalloced.
    char * pool_addr;       //actual kmalloced address
    int head_index;         //index of the next free buffer
    int tail_index;         //index of the first used descriptor
};

#endif






