/* -*- pse-c -*-
 *----------------------------------------------------------------------------
 * Filename: iwdtdemo.c
 * $Revision: 1.5 $
 *----------------------------------------------------------------------------
 *
 * This software program is available to you under a choice of one of two
 * licenses. You may choose to be licensed under either the GNU General Public
 * License 2.0, June 1991, available at http://www.fsf.org/copyleft/gpl.html,
 * or the Intel BSD + Patent License, the text of which follows:
 * 
 * Recipient has requested a license and Intel Corporation ("Intel") is willing
 * to grant a license for the software entitled Common Statistics Manager
 * being provided by Intel Corporation. The following definitions apply to this
 * license:
 * 
 * "Licensed Patents" means patent claims licensable by Intel Corporation which
 * are necessarily infringed by the use of sale of the Software alone or when
 * combined with the operating system referred to below.
 * 
 * "Recipient" means the party to whom Intel delivers this Software.
 * 
 * "Licensee" means Recipient and those third parties that receive a license to
 * any operating system available under the GNU General Public License 2.0 or
 * later.
 * 
 * Copyright (c) 2004 - 2005 Intel Corporation.
 * All rights reserved.
 * 
 * The license is provided to Recipient and Recipient's Licensees under the
 * following terms.
 * 
 * Redistribution and use in source and binary forms of the Software, with or
 * without modification, are permitted provided that the following conditions
 * are met:
 * 
 * Redistributions of source code of the Software may retain the above
 * copyright notice, this list of conditions and the following disclaimer
 * Redistributions in binary form of the Software may reproduce the above
 * copyright notice, this list of conditions and the following disclaimer in
 * the documentation and/or materials provided with the distribution.
 * 
 * Neither the name of Intel Corporation nor the names of its contributors
 * shall be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * Intel hereby grants Recipient and Licensees a non-exclusive, worldwide,
 * royalty-free patent license under Licensed Patents to make, use, sell, offer
 * to sell, import and otherwise transfer the Software, if any, in source code
 * and object code form. This license shall include changes to the Software
 * that are error corrections or other minor changes to the Software that do
 * not add functionality or features when the Software is incorporated in any
 * version of an operating system that has been distributed under the GNU
 * General Public License 2.0 or later. This patent license shall apply to the
 * combination of the Software and any operating system licensed under the GNU
 * General Public License 2.0 or later if, at the time Intel provides the
 * Software to Recipient, such addition of the Software to the then publicly
 * available versions of such operating systems available under the GNU General
 * Public License 2.0 or later (whether in gold, beta or alpha form) causes
 * such combination to be covered by the Licensed Patents. The patent license
 * shall not apply to any other combinations which include the Software. NO
 * hardware per se is licensed hereunder.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MECHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL INTEL OR IT CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * ANY LOSS OF USE; DATA, OR PROFITS; OR BUSINESS INTERUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Module Name:   iwdtdemo.c
 *
 * Abstract:      Demo/configuration program for Intel WDT driver.
 *
 * Environment:   This file is intended to be specific to Linux
 *                operating system. It requires pthread and curses libraries.
 *
 * Build command: gcc -o iwdtdemo iwdtdemo.c -lcurses -lpthread
 *
 *****************************************************************************
 */
#include <pthread.h>
#include <curses.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <linux/types.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <signal.h>
#include <errno.h>
#include <getopt.h>
#include <linux/fs.h>
#include <linux/watchdog.h>
#include "../driver/iwdt.h"

#define DEVICE  "/dev/watchdog"
#define KEY_ESC 27
#define KEY_F1  265
#define KEY_F2  266
#define KEY_F3  267
#define KEY_F4  268
#define KEY_F5  269
#define KEY_F6  270
#define KEY_F7  271
#define KEY_F8  272
#define KEY_F9  273

#ifndef WDIOC_SETTIMEOUT
#define WDIOC_SETTIMEOUT        _IOWR(WATCHDOG_IOCTL_BASE, 6, int)
#endif
#ifndef WDIOC_GETTIMEOUT
#define WDIOC_GETTIMEOUT        _IOR(WATCHDOG_IOCTL_BASE, 7, int)
#endif

/* Global variables */
int i, tmp1, mode = 0, gmode, scale= 0, gscale, timerfd, junk1, state=0,
	gstate, stage=0, opin, gopin, ctoutsts, gtoutsts, closestate;

unsigned long tout1 = 30000, timeout2 = 60000, gtout1, gtimeout2,
	dwncnt, tmplong;

char cbuff[40];

/* variables for use with callback thread */
pthread_t thread_id;
pthread_mutex_t my_mutex = PTHREAD_MUTEX_INITIALIZER;
pthread_mutex_t display = PTHREAD_MUTEX_INITIALIZER;
unsigned long cbcnt=0;
static int forced_wui=0;

struct my_thread_parms {
	int filehand;
	int junk;
};

// pthread based callback routine goes here
void* mythread (void* parameters)
{
	// define local variables
	struct my_thread_parms* p = (struct my_thread_parms*) parameters;
	int local_fd = p->filehand;
	int nlines=5, ncols=75, y0=15, x0=0, lclflg, ret;
	long mtcnt;
	extern int forced_wui;
	extern unsigned long cbcnt;
	extern int stage;

	WINDOW *win1;
	// create a window (y=LINE, x=COL)
	win1 = newwin(nlines, ncols, y0, x0);
	wrefresh(win1);

	mvwprintw(win1, 0,0, "%s", "Thread Started to Monitor 1st Stage Timeout");
	mvwprintw(win1, 1,0,"%s", "WDIOC_NOTIFY ioctl blocks till ISR unblocks it");

	pthread_mutex_lock(&display);
	wnoutrefresh(win1);
	pthread_mutex_unlock(&display);

	// register with watchdog timer driver to recieve notification of
	// 1st stage timeout interrupt. WDIOC_NOTIFY ioctl puts the callin
	// process (in this example, the calling process is this thread)
	// to sleep till the watchdog timer drivers isr wakes it backup

	ret = ioctl(local_fd,WDIOC_NOTIFY);
	if (ret < 0) {
		mvwprintw(win1,2,0,"%s", "WDIOC_NOTIFY ioctl FAILED");
	} else {
		mvwprintw(win1,3,0,"%s", "WDIOC_NOTIFY success. ret = %d", ret);

		if (forced_wui == 0) { // forced_wui =0 ... wake due to irq
			mvwprintw(win1,2,0,"%s", "1st Stage Timeout IRQ Detected");

			// >> The only way to endup here is if the 'critical app' and/or
			//    the watchdog timer dameon app has stopped pinging long enough
			//    to allow the 1st stage countdown to reach 0...
			// >> 1st stage timeout has occurred, 2nd stage is counting down
			// >> if 2nd stage downcounter reaches 0, a system reset occurs
			//
			// The following code is application/oem specific, but in general
			// it should perfrom recovery/notification tasks (ex: send a email,
			// try and restart the 'critical app', etc). If this code is
			// successful
			// in it's attempts to bring the system back to a stable state, it
			// can issue reload seq to the wdt to restart stage1 countdown.
			// note that while the 'recovery/notification' code is doing it's
			// thing, the stage 2 countdown is in progress...if the 'recovery/
			// notification' code doesn't conclude it's business within the
			// preprogrammed stage2 timeout value (&/or issue a reload seq to
			// reset/restart the wdt timer from stage1) the stage2 timeout
			// will cause a system reset (assuming the hardware is wired to
			// do so)
			stage++;

			// try to do a clean reboot by using 'shutdown -r now' or 'reboot'
			// Note1: if clean reboot doesn't succeed within the confines of the
			//        stage 2 countdown, the wdt will cause a system reset
			// Note2: Unclean system resets will eventually corrupt the
			//        filesystem because anything cached
			//        (ex: vfs, kernel swap/data sturcts)
			//        won't get flushed properly back to perminant storage
		} else { // forced_wui =1 ... wake was forced, not due to irq
			mvwprintw(win1,2,0,"%s", "Forced wake_up_interruptible Detected");
		}
	}

	forced_wui = 0;
	pthread_mutex_lock(&display);
	wnoutrefresh(win1);
	pthread_mutex_unlock(&display);

	// cleanup and exit
	mvwprintw(win1, 0,0, "%70s", " ");
	mvwprintw(win1, 1,0, "%70s", " ");
	mvwprintw(win1, 2,0, "%70s", " ");
	mvwprintw(win1, 3,0, "%70s", " ");
	pthread_mutex_lock(&display);
	wnoutrefresh(win1);
	pthread_mutex_unlock(&display);
	delwin(win1);
}

// routine to display the screen using GET IOCTLS
void redraw(int myfd)
{
	mvprintw(0,0,"%s","Intel Watchdog Timer Demo App");

	if (ioctl(timerfd, WDIOC_GETMODE, &gmode) < 0) {
		mvprintw(1,0,"%s", "WDIOC_GETMODE ioctl FAILED");
	} else {
		mvprintw(1,0, "F1 MODE:\t%d\t0=WDT 1=FREE", gmode);
	}

	if (ioctl(timerfd, WDIOC_GETSCALE, &gscale) < 0) {
		mvprintw(2,0,"%s", "WDIOC_GETSCALE ioctl FAILED");
	} else {
		mvprintw(2,0, "F2 PRESCALER:\t%d\t0=1Khz 1=1Mhz", gscale);
	}

	if (ioctl(timerfd, WDIOC_GETTIMEOUT, &gtout1) < 0) {
		mvprintw(3,0,"%s", "WDIOC_GETTIMEOUT ioctl FAILED");
	} else {
		mvprintw(3,0, "%75s", " ");
		mvprintw(3,0, "F3 PRELOAD1:\t%ld\tValid range = 1 to 1048575", gtout1);
	}

	if (ioctl(timerfd, WDIOC_GETTIMEOUT2, &gtimeout2) < 0) {
		mvprintw(4,0,"%s", "WDIOC_GETTIMEOUT2 ioctl FAILED");
	} else {
		mvprintw(4,0, "%75s", " ");
		mvprintw(4,0, "F4 PRELOAD2:\t%ld\tValid range = 1 to 1048575",
			gtimeout2);
	}

	if (ioctl(timerfd, WDIOC_GETOPIN, &gopin) < 0) {
		mvprintw(5,0,"%s", "WDIOC_GETOPIN ioctl FAILED");
	} else {
		mvprintw(5,0, "F5 OUTPIN:\t%d\t0=En 1=Dis", gopin);
	}

	if (ioctl(timerfd, WDIOC_GETWDTENABLE, &gstate) < 0) {
		mvprintw(6,0,"%s", "WDIOC_GETWDTENABLE ioctl FAILED");
	} else {
		mvprintw(6,0, "F6 WDT_ENABLE:\t%d\t0=STOP 1=RUN", gstate);
	}

	mvprintw(7,0, "%s", "F7 RELOAD\t\tPing WDT");

	if (ioctl(timerfd, WDIOC_GETSTATUS, &gtoutsts) < 0) {
		mvprintw(8,0,"%s", "WDIOC_GETSTATUS ioctl FAILED");
	} else {
		mvprintw(8,0, "F8 WDT_TIMEOUT:\t%d\t0=no_TO 1=TO (F8 clrs)", gtoutsts);
	}

	mvprintw(9,0, "F9 CloseState:\t%d\t0=STOP 1=RUN", closestate);

	pthread_mutex_lock(&display);
	wnoutrefresh(stdscr);
	doupdate();
	pthread_mutex_unlock(&display);
	return;
}


int main()
{
	struct my_thread_parms thread_args;

	printf("Press Enter to continue...\n");
	getchar();

	if ((timerfd = open(DEVICE, O_WRONLY)) < 0) {
		perror("\n/dev/watchdog Open failed ");
		exit(1);
	}

	// fire up a ncurses screen
	initscr();
	cbreak();
	noecho();
	keypad(stdscr, TRUE);
	clear();
	curs_set(0);

	// display status & init get hw state (gstate, gmode, gscale)
	redraw(timerfd);

	// initialize state variables based on current state of hw upon open
	state = gstate;   // open starts wdt with dflt vals
	// 0 = DISABLED (STOPPED)  1 = ENABLED (RUNNING)
	mode = gmode;
	// 0 = WDT 1=FREE
	scale = gscale;
	// 0 = 1Khz 1=1Mhz

	// if (mode = WDT && RUNNING) than stage = 0 or 1 ...
	// only way to figure out is to det if irq happened
	// > however based on PRELOAD1/2 settings, the stage1 t/o could have
	// already happened...need to query isr
	// > to figure this out
	// given open() does not screw with h/w settings if wdt is already
	// running...
	// > todo:
	// > - add ioctl to query isr to see if stage1 t/o has already occurred
	// > - add ioctl to reset isr's stage1 t/o counter
	// >> for now... just say: "attaching to running wdt...mode=WDT,
	// stage=unknown"
	// >> user has to stop & restart to see driver's WDIOC_NOTIFY ioctl
	// in action
	if (mode == 0 && state == 1) {
		stage = 99;
	}

	// don't even screw with callback thread if wdt is already running...

	// forced_wui=0;
	// start the callback thread to monitor stage1 timeouts
	thread_args.filehand = timerfd;

	//thread_args.junk = 567;
	pthread_create(&thread_id, NULL, &mythread, &thread_args);

	//doupdate();  // to show callback handler is installed

	nodelay(stdscr, TRUE);

	while(1) {
		junk1 = getch();

		if (state == 0) {           /* state=0 (STOPPED) */
			switch (junk1) {
			case KEY_F1:
				if (gmode == 0) {
					mode = 1;
				} else {
					mode = 0;
				}
				tmp1 = mode;
				if (ioctl(timerfd, WDIOC_SETMODE, &tmp1) < 0) {
					mvprintw(23,0,"%75s"," ");
					mvprintw(23,0,"%s", "WDIOC_SETMODE ioctl FAILED");
				} else {
					mvprintw(23,0,"%75s"," ");
					mvprintw(23,0,"%s", "WDIOC_SETMODE ioctl OK");
				}
				break;

			case KEY_F2:
				if (gscale == 0) {
					scale = 1;
				} else {
					scale = 0;
				}
				tmp1 = scale;
				if (ioctl(timerfd, WDIOC_SETSCALE, &tmp1) < 0) {
					mvprintw(23,0,"%75s"," ");
					mvprintw(23,0,"%s", "WDIOC_SETSCALE ioctl FAILED");
				} else {
					mvprintw(23,0,"%75s"," ");
					mvprintw(23,0,"%s", "WDIOC_SETSCALE ioctl OK");
				}
				break;

			case KEY_F3:
				nodelay(stdscr, FALSE);
				mvprintw(23,0, "%75s"," ");
				mvprintw(23,0,"PRELOAD1: ");
				refresh();
				echo();
				getstr(cbuff);
				noecho();
				sscanf(cbuff, "%ld", &tout1);
				if (ioctl(timerfd, WDIOC_SETTIMEOUT, &tout1) < 0) {
					mvprintw(23,0, "%75s"," ");
					mvprintw(23,0,"%s", "WDIOC_SETTIMEOUT ioctl FAILED");
				} else {
					mvprintw(23,0,"%75s"," ");
					mvprintw(23,0,"%s", "WDIOC_SETTIMEOUT ioctl OK");
				}
				nodelay(stdscr, TRUE);
				break;

			case KEY_F4:
				nodelay(stdscr, FALSE);
				mvprintw(23,0, "%75s"," ");
				mvprintw(23,0,"PRELOAD2: ");
				refresh();
				echo();
				getstr(cbuff);
				noecho();
				sscanf(cbuff, "%ld", &timeout2);
				if (ioctl(timerfd, WDIOC_SETTIMEOUT2, &timeout2) < 0) {
					mvprintw(23,0, "%75s"," ");
					mvprintw(23,0,"%s", "WDIOC_SETTIMEOUT2 ioctl FAILED");
				} else {
					mvprintw(23,0,"%75s"," ");
					mvprintw(23,0,"%s", "WDIOC_SETTIMEOUT2 ioctl OK");
				}
				nodelay(stdscr, TRUE);
				break;

			case KEY_F5:
				if (gopin == 0) {
					opin = 1;
				} else {
					opin = 0;
				}
				tmp1 = opin;
				if (ioctl(timerfd, WDIOC_SETOPIN, &tmp1) < 0) {
					mvprintw(23,0,"%75s"," ");
					mvprintw(23,0,"%s", "WDIOC_SETOPIN ioctl FAILED");
				} else {
					mvprintw(23,0,"%75s"," ");
					mvprintw(23,0,"%s", "WDIOC_SETOPIN ioctl OK");
				}
				break;

			case KEY_F6:
				if (ioctl(timerfd, WDIOC_ENABLE, 1) < 0) {
					mvprintw(23,0,"%75s"," ");
					mvprintw(23,0,"%s", "WDIOC_ENABLE ioctl FAILED");
				} else {
					mvprintw(23,0,"%75s"," ");
					mvprintw(23,0,"%s", "WDIOC_ENABLE ioctl OK");
					state = 1; // RUNNING
				}
				if (mode == 0) { // starting in WDT mode
								// (use mode because gmode won't
								// update till next refresh
					stage = 0;
					forced_wui=0;
					// start the callback thread here to monitor stage1 timeouts
					thread_args.filehand = timerfd;
					thread_args.junk = 567;
					pthread_create(&thread_id, NULL, &mythread, &thread_args);
				} else { // mode == 1 ...starting in FREE mode
					mvprintw(23,0,"%75s"," ");
					mvprintw(23,0,"%s",
						"WDIOC_ENABLE ioctl OK...FREE mode...no irqs...no "
						"cb thread installed");
				}
				break;

			case KEY_F7:
				//KEEP_ALIVE DOESN't DO ANYTHING IF STOPPED and/or mode = FREE

				//if (ioctl(timerfd, WDIOC_KEEPALIVE, 1) < 0) {
				//	mvprintw(23,0,"%75s"," ");
				//	mvprintw(23,0,"%s", "WDIOC_KEEPALIVE ioctl FAILED");
				//} else {
					mvprintw(23,0,"%75s"," ");
					mvprintw(23,0,"%s",
						"Timer is STOPPED...WDIOC_KEEPALIVE ioctl not issued");
				//}
				// stage=0;
				break;

			case KEY_F8:
				if (ioctl(timerfd, WDIOC_CLRSTATUS, &ctoutsts) < 0) {
					mvprintw(23,0,"%75s"," ");
					mvprintw(23,0,"%s", "WDIOC_CLRSTATUS ioctl FAILED");
				} else {
					mvprintw(23,0,"%75s"," ");
					mvprintw(23,0,"%s","WDIOC_CLRSTATUS ioctl OK");
				}
				break;

			case KEY_F9:
				// toggle closestate
				// 0 = stop wdt on close
				// 1 = leave wdt running on close
				if (closestate == 0) {
					closestate = 1;
				} else {
					closestate=0;
				}
				break;
			} /* end switch */
			redraw(timerfd);
		} else {                        /* state = 1 (RUNNING) */
			switch (junk1) {

			case KEY_F6:
				if (ioctl(timerfd, WDIOC_DISABLE, 1) < 0) {
					mvprintw(23,0,"%75s"," ");
					mvprintw(23,0,"%s", "WDIOC_DISABLE ioctl FAILED");
				} else {
					mvprintw(23,0,"%75s"," ");
					mvprintw(23,0,"%s", "WDIOC_DISABLE ioctl OK");
					state = 0; // STOPPED
				}

				if (mode == 0 && stage == 0) {
					// stopping from WDT mode && know stage==0
					// new way
					// stage1 timeout hasn't occurred but callback thread is
					//  blocked at the driver level:
					//  WDIOC_NOTIFY ioctl > wait_event_interruptible
					//  (&wdt_waitque)
					//  driver's isr won't unblock it till it rcvs an irq.
					// in order to kill the callback thread prior to a 1st
					// stage t/o after the WDIOC_NOTIFY ioctl has been called,
					// 1st we have to do a WDIOC_CLRNOTIFY itocl to unblock
					// it at the driver level and get it back into user space
					// code.

					// tell callback thread ret from _NOTIFY was forced
					forced_wui = 1;
					ioctl(timerfd, WDIOC_CLRNOTIFY, 1);
				}
				break;

			case KEY_F7:
				if (ioctl(timerfd, WDIOC_KEEPALIVE, 1) < 0) {
					mvprintw(23,0,"%75s"," ");
					mvprintw(23,0,"%s", "WDIOC_KEEPALIVE ioctl FAILED");
				}
				else {
					mvprintw(23,0,"%75s"," ");
					if (mode == 1) { // mode = FREE
						mvprintw(23,0,"%s",
							"WDIOC_KEEPALIVE ioctl OK ...reloads only "
							"if mode=wdt");
					} else {
						mvprintw(23,0,"%s", "WDIOC_KEEPALIVE ioctl OK");
					}
				}

				if (mode == 0) {
					if (stage == 0) {
						// stage = 0 ... callback thread is still
						// waiting for irq
						stage = 0;
					}

					if (stage == 1) {
						// stage = 1 ... callback thread has detected isr 
						stage = 0;
						forced_wui=0;
						thread_args.filehand = timerfd;
						thread_args.junk = 567;
						pthread_create(&thread_id, NULL,
							&mythread, &thread_args);
					}

					if (stage == 99) {
						// was unknown...due to reload, now it's known
						stage = 0;        // set stage=0
						forced_wui=0;     // & start the callback thread
						thread_args.filehand = timerfd;
						thread_args.junk = 567;
						pthread_create(&thread_id, NULL, &mythread,
							&thread_args);
					}
				}
				break;
			} /* end switch */
			redraw(timerfd);
		} /* end else */

		// continously display down counter and test for program exit
		switch (state) {
			case 1:
				// RUNNING
				if (ioctl(timerfd, WDIOC_GETDC, &dwncnt) < 0) {
					mvprintw(23,0,"%75s"," ");
					mvprintw(23,0,"%s", "WDIOC_GETDC ioctl FAILED");
				} else {
					mvprintw(10,0,"%75s"," ");
					if (mode == 0) { // mode = WDT
						if (stage == 0 || stage == 1) {
							mvprintw(10,0, "WDT MODE Stage %d countdown "
								"progress:\t%ld",stage+1,dwncnt);
						} else {
							mvprintw(10,0,"Connected to running hw in wdt mode... "
								"stage unknown:\t%ld",dwncnt);
						}
					} else { // mode = FREE
						mvprintw(10,0,"FREE MODE Preload2 countdown "
							"in progress:\t%ld",dwncnt);
					}
				}
				pthread_mutex_lock(&display);
				wnoutrefresh(stdscr);
				doupdate();
				pthread_mutex_unlock(&display);
				break;

			case 0:
				// STOPPED
				mvprintw(10,0,"%75s"," ");
				mvprintw(10,0,"%s","WDT is STOPPED");
				pthread_mutex_lock(&display);
				wnoutrefresh(stdscr);
				doupdate();
				pthread_mutex_unlock(&display);
				break;
		}

		if ((junk1 == 'x')||(junk1 == KEY_ESC)) {
			mvprintw(10, 0,"%75s"," ");
			mvprintw(10, 0, "%s", "Exiting demo application...");
			break;
		}
	} /* end while(1) */

	// kill the callback thread prior to exiting... for the case where
	// user wants to exist without stopping the wdt & callback handler
	// is still waiting on stage1 timeout

	if (mode == 0 && stage == 0) {
		forced_wui = 1;  // tell callback thread ret from _NOTIFY was forced
		ioctl(timerfd, WDIOC_CLRNOTIFY, 1);
	}

	if (closestate == 0) {  // stop the wdt when /dev/watchdog device is closed
		write(timerfd, "V", 1); // write the 'magic character' V prior to closin
	}

	close(timerfd);

	mvprintw(23,0,"%75s"," ");
	mvprintw(23,0,"%s",
		"checking to make sure callback thread has terminated...");
	//doupdate();
	mvprintw(23,0,"%75s"," ");
	//doupdate();
	endwin();
	exit(0);
}
