/* -*- pse-c -*-
 *----------------------------------------------------------------------------
 * Filename: iwdt.h
 * $Revision: 1.10 $
 *----------------------------------------------------------------------------
 *
 * This software program is available to you under a choice of one of two
 * licenses. You may choose to be licensed under either the GNU General Public
 * License 2.0, June 1991, available at http://www.fsf.org/copyleft/gpl.html,
 * or the Intel BSD + Patent License, the text of which follows:
 * 
 * Recipient has requested a license and Intel Corporation ("Intel") is willing
 * to grant a license for the software entitled Common Statistics Manager
 * being provided by Intel Corporation. The following definitions apply to this
 * license:
 * 
 * "Licensed Patents" means patent claims licensable by Intel Corporation which
 * are necessarily infringed by the use of sale of the Software alone or when
 * combined with the operating system referred to below.
 * 
 * "Recipient" means the party to whom Intel delivers this Software.
 * 
 * "Licensee" means Recipient and those third parties that receive a license to
 * any operating system available under the GNU General Public License 2.0 or
 * later.
 * 
 * Copyright (c) 2004 - 2005 Intel Corporation.
 * All rights reserved.
 * 
 * The license is provided to Recipient and Recipient's Licensees under the
 * following terms.
 * 
 * Redistribution and use in source and binary forms of the Software, with or
 * without modification, are permitted provided that the following conditions
 * are met:
 * 
 * Redistributions of source code of the Software may retain the above
 * copyright notice, this list of conditions and the following disclaimer
 * Redistributions in binary form of the Software may reproduce the above
 * copyright notice, this list of conditions and the following disclaimer in
 * the documentation and/or materials provided with the distribution.
 * 
 * Neither the name of Intel Corporation nor the names of its contributors
 * shall be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * Intel hereby grants Recipient and Licensees a non-exclusive, worldwide,
 * royalty-free patent license under Licensed Patents to make, use, sell, offer
 * to sell, import and otherwise transfer the Software, if any, in source code
 * and object code form. This license shall include changes to the Software
 * that are error corrections or other minor changes to the Software that do
 * not add functionality or features when the Software is incorporated in any
 * version of an operating system that has been distributed under the GNU
 * General Public License 2.0 or later. This patent license shall apply to the
 * combination of the Software and any operating system licensed under the GNU
 * General Public License 2.0 or later if, at the time Intel provides the
 * Software to Recipient, such addition of the Software to the then publicly
 * available versions of such operating systems available under the GNU General
 * Public License 2.0 or later (whether in gold, beta or alpha form) causes
 * such combination to be covered by the Licensed Patents. The patent license
 * shall not apply to any other combinations which include the Software. NO
 * hardware per se is licensed hereunder.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MECHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL INTEL OR IT CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * ANY LOSS OF USE; DATA, OR PROFITS; OR BUSINESS INTERUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Module Name: iwdt.h
 *
 * Author:      chandra.konduru@intel.com
 *
 * Abstract:    This module support Intel watchdog timer.
 *              All of the driver functions are provided in this file.
 *
 * Environment: This file is intended to be specific to Linux
 *              operating system.
 *
 *****************************************************************************
 */
#ifndef WDT_H
#define WDT_H

#include <linux/ioctl.h>
#include <linux/watchdog.h>

/* Debug print macro */
#ifdef DEBUG
#define WDT_PRINTK(arg...) printk(KERN_INFO arg)
#else
#define WDT_PRINTK(arg...)
#endif

#define  PCI_DEVICE_ID_INTEL_LPC_WDT  0x2670

/* WDT I/O Registers */
#define WDT_PRELD1_REG0   0x00   /* Pre load1 register */
#define WDT_PRELD1_REG1   0x01
#define WDT_PRELD1_REG2   0x02
#define WDT_PRELD2_REG0   0x04   /* Pre load 2 register */
#define WDT_PRELD2_REG1   0x05
#define WDT_PRELD2_REG2   0x06
#define WDT_INT_STS_REG   0x08   /* Interrupt status register */
#define WDT_RLD_REG0      0x0C   /* Reload register */
#define WDT_RLD_REG1      0x0D
#define WDT_CONFIG_REG    0x10   /* Configuration register */
#define WDT_DOWN_CNT_REG0 0x14   /* Down count register */
#define WDT_DOWN_CNT_REG1 0x15
#define WDT_DOWN_CNT_REG2 0x16
#define WDT_LOCK_REG      0x18   /* Lock register */

/* Masks and values for registers */
#define WDT_LOCK          0x01
#define WDT_ENABLE        0x02
#define WDT_MASK          0xfd
#define MODE_MASK         0xfb
#define MODE_TEST         0x04
#define OPIN_MASK         0x20

#define WDIOF_SETMODE     0x0100
#define WDIOF_SETTIMEOUT2 0x0200

#define TIMER_MARGIN      60000

/* Watchdog timer ioctls from 0-7 are defined in watchdog.h */
#define WDIOC_SETTIMEOUT2   _IOWR(WATCHDOG_IOCTL_BASE, 8,  unsigned long)
#define WDIOC_SETMODE       _IOWR(WATCHDOG_IOCTL_BASE, 9,  unsigned long)
#define WDIOC_GETTIMEOUT2   _IOR(WATCHDOG_IOCTL_BASE,  10, unsigned long)
#define WDIOC_SETSCALE      _IOWR(WATCHDOG_IOCTL_BASE, 11, unsigned long)
#define WDIOC_LOCK          _IOWR(WATCHDOG_IOCTL_BASE, 14, unsigned long)
#define WDIOC_NOTIFY        _IOWR(WATCHDOG_IOCTL_BASE, 15, unsigned long)
#define WDIOC_ENABLE        _IOWR(WATCHDOG_IOCTL_BASE, 16, unsigned long)
#define WDIOC_DISABLE       _IOWR(WATCHDOG_IOCTL_BASE, 17, unsigned long)
#define WDIOC_GETSCALE      _IOR(WATCHDOG_IOCTL_BASE,  18, unsigned long)
#define WDIOC_GETMODE       _IOR(WATCHDOG_IOCTL_BASE,  19, unsigned long)
#define WDIOC_GETIRQSTAT    _IOR(WATCHDOG_IOCTL_BASE,  20, unsigned long)
#define WDIOC_CLRIRQSTAT    _IOWR(WATCHDOG_IOCTL_BASE, 21, unsigned long)
#define WDIOC_SETOPIN       _IOWR(WATCHDOG_IOCTL_BASE, 22, unsigned long)
#define WDIOC_GETOPIN       _IOR(WATCHDOG_IOCTL_BASE,  23, unsigned long)
#define WDIOC_GETDC         _IOR(WATCHDOG_IOCTL_BASE,  24, unsigned long)
#define WDIOC_GETIRQVEC     _IOR(WATCHDOG_IOCTL_BASE,  25, unsigned long)
#define WDIOC_CLRSTATUS     _IOR(WATCHDOG_IOCTL_BASE,  26, unsigned long)
#define WDIOC_CLRNOTIFY     _IOWR(WATCHDOG_IOCTL_BASE, 27, unsigned long)
#define WDIOC_GETWDTENABLE  _IOR(WATCHDOG_IOCTL_BASE,  28, unsigned long)
#define WDIOC_SET_INT_TYPE  _IOWR(WATCHDOG_IOCTL_BASE, 29, unsigned long)
#define WDIOC_GET_INT_TYPE  _IOR(WATCHDOG_IOCTL_BASE,  30, unsigned long)

/* Enumerated values */
/* WDT device modes of operation */
enum {
	WDT_MODE,  /* 0 */
	FREE_MODE, /* 1 */
};

/* Timeout value granulaties */
enum {
	HIGH_SCALE, /* 0 */
	LOW_SCALE,  /* 1 */
};

/* Out PIN enable or disable */
enum {
	OPIN0_EN,   /* 0 */
	OPIN1_DIS,  /* 1 */
};

/* Available interrupt types after 1st stage timeout */
enum {
	WDT_INT_TYPE_IRQ, /* 0 - SERIRQ default */
	WDT_INT_TYPE_NMI, /* 1 - NMI            */
	WDT_INT_TYPE_SMI, /* 2 - SMI            */
	WDT_INT_TYPE_DIS, /* 3 - Disabled       */
};
#endif
/*----------------------------------------------------------------------------
 * File Revision History
 * $Id: iwdt.h,v 1.10 2005/12/30 23:55:42 syeh2 Exp $
 * $Source: /nfs/fm/proj/eia/cvsroot/drivers/WhitmoreLake/Linux/rhel40u1/wdt/driver/iwdt.h,v $
 *----------------------------------------------------------------------------
 */
