#!/bin/sh

# main
KERNEL=$1
BUILD_PATH=$2
DRIVER_PATH=kernel/drivers/message/fusion
update_file=/etc/sysconfig/kernel
lspci_path=/sbin/lspci
found_spi=0
found_fc=0
found_sas=0

# uncomment following line for debugging
#set -x

etc_sysconfig_kernel_add()
{
sed -e "s/INITRD_MODULES=\"\(.*\)\"/INITRD_MODULES=\"\1 $1\"/" ${update_file} > ${update_file}.new
mv ${update_file}.new ${update_file}
}

etc_sysconfig_kernel_remove()
{
sed -e "s/\(INITRD_MODULES.*\)$1\b\(.*\)/\1\2/" ${update_file} > ${update_file}.new
mv ${update_file}.new ${update_file}
}

scan_for_spi()
{
	for device_id in 30 40; do
		if [ `${lspci_path} -d 1000:${device_id} | grep -c LSI` -gt 0 ]; then
			found_spi=1;
			return;
		fi;
	done;
}

scan_for_fc()
{
	for device_id in 621 622 624 626 628 640 642 646; do
		if [ `${lspci_path} -d 1000:${device_id} | grep -c LSI` -gt 0 ]; then
			found_fc=1;
			return;
		fi;
	done;
}

scan_for_sas()
{
	for device_id in 50 5C 56 5E 5A 54 58 60; do
		if [ `${lspci_path} -d 1000:${device_id} | grep -c LSI` -gt 0 ]; then
			found_sas=1;
			return;
		fi;
	done;
}

echo -e "Detected ${KERNEL} kernel.";
if [ -d "${BUILD_PATH}"/"${KERNEL}" ] ; then
	echo -e "Copying Fusion-MPT binaries to /lib/modules/${KERNEL}/${DRIVER_PATH}"
	cd /;
	tar -zcf mptlinux.tar.gz lib/modules/${KERNEL}/${DRIVER_PATH};
	mv mptlinux.tar.gz ${BUILD_PATH}/${KERNEL}/${DRIVER_PATH}
	cd -;
	rm -fr /lib/modules/${KERNEL}/${DRIVER_PATH}/*.ko;
	cp -f ${BUILD_PATH}/${KERNEL}/${DRIVER_PATH}/*.ko /lib/modules/${KERNEL}/${DRIVER_PATH};
else
	echo -e "WARNING: No Fusion-MPT binary update for ${KERNEL} kernel."
	exit 1;
fi;
if [ -e ${update_file} ]; then
	scan_for_fc
	scan_for_sas
	scan_for_spi
	if [ `grep -c mptscsih ${update_file}` -gt 0 ] && \
	   [ `grep -c mptspi ${update_file}` -eq 0 ] && \
	   [ `grep -c mptfc ${update_file}` -eq 0 ] && \
	   [ `grep -c mptsas ${update_file}` -eq 0 ]; then  
		module_name_after=""
		if [ ${found_spi} = "1" ]; then
			module_name_after="${module_name_after} mptspi"
		fi;
		if [ ${found_fc} = "1" ]; then
			module_name_after="${module_name_after} mptfc"
		fi;
		if [ ${found_sas} = "1" ]; then
			module_name_after="${module_name_after} mptsas"
		fi;
		sed -e "s/mptscsih/${module_name_after}/g" ${update_file} > ${update_file}.new
		mv ${update_file}.new ${update_file}
	else
		if [ `grep -c mptscsih ${update_file}` -gt 0 ]; then
			etc_sysconfig_kernel_remove mptscsih
		fi;
		if [ `grep -c mptspi ${update_file}` -eq 0 ] && [ ${found_spi} = "1" ]; then
			etc_sysconfig_kernel_add mptspi
		fi;
		if [ `grep -c mptfc ${update_file}` -eq 0 ] && [ ${found_fc} = "1" ]; then
			etc_sysconfig_kernel_add mptfc
		fi;
		if [ `grep -c mptsas ${update_file}` -eq 0 ] && [ ${found_sas} = "1" ]; then
			etc_sysconfig_kernel_add mptsas
		fi;
	fi;
fi;
if [ -e /boot/initrd-${KERNEL} ]; then
	echo -e "Saving initrd";
	cp -f /boot/initrd-${KERNEL} /${BUILD_PATH}/${KERNEL}/initrd-${KERNEL};
fi;
echo -e "Creating ramdisk images................";
/sbin/depmod -v ${KERNEL} >/dev/null 2>&1;
/sbin/mkinitrd -k vmlinuz-${KERNEL} -i /boot/initrd-${KERNEL} >/dev/null 2>&1;
echo -e "You must reboot for the change to take effect.";
