#!/bin/bash
#set -x
lspci_path=/sbin/lspci
update_file=/etc/modprobe.conf
alias_number=0
found_spi=0
found_fc=0
found_sas=0

scan_for_spi()
{
	for device_id in 30 40; do
		if [ `${lspci_path} -d 1000:${device_id} | grep -c LSI` -gt 0 ]; then
			found_spi=1;
			return;
		fi;
	done;
}

scan_for_fc()
{
	for device_id in 621 622 624 626 628 640 642 646; do
		if [ `${lspci_path} -d 1000:${device_id} | grep -c LSI` -gt 0 ]; then
			found_fc=1;
			return;
		fi;
	done;
}

scan_for_sas()
{
	for device_id in 50 5C 56 5E 5A 54 58 60; do
		if [ `${lspci_path} -d 1000:${device_id} | grep -c LSI` -gt 0 ]; then
			found_sas=1;
			return;
		fi;
	done;
}
 
if [ -e ${update_file} ]; then
	scan_for_fc
	scan_for_sas
	scan_for_spi
	if [ `grep -c mptbase ${update_file} ` -gt 0 ]; then
		alias_number=`grep "alias scsi_hostadapter[0-9]* mptbase" ${update_file} | awk '{print $2}' | \
		sed "s/scsi_hostadapter//"`
		if [ ${found_sas} = "1" ]; then
			sed -e "/mptbase/ a\alias scsi_hostadapter${alias_number} mptsas" ${update_file} > ${update_file}.new
			mv ${update_file}.new ${update_file}
		fi;
		if [ ${found_fc} = "1" ]; then
			sed -e "/mptbase/ a\alias scsi_hostadapter${alias_number} mptfc" ${update_file} > ${update_file}.new
			mv ${update_file}.new ${update_file}
		fi;
		if [ ${found_spi} = "1" ]; then
			sed -e "/mptbase/ a\alias scsi_hostadapter${alias_number} mptspi" ${update_file} > ${update_file}.new
			mv ${update_file}.new ${update_file}
		fi;
		sed -e '/mptbase/d' ${update_file} > ${update_file}.new
		mv ${update_file}.new ${update_file}
		sed -e '/mptscsih/d' ${update_file} > ${update_file}.new
		mv ${update_file}.new ${update_file}
		exit 0	
	elif [ `grep -c mptscsih ${update_file} ` -gt 0 ]; then
		alias_number=`grep "alias scsi_hostadapter[0-9]* mptscsih" ${update_file} | awk '{print $2}' | \
		sed "s/scsi_hostadapter//"`
		if [ ${found_sas} = "1" ]; then
			sed -e "/mptscsih/ a\alias scsi_hostadapter${alias_number} mptsas" ${update_file} > ${update_file}.new
			mv ${update_file}.new ${update_file}
		fi;
		if [ ${found_fc} = "1" ]; then
			sed -e "/mptscsih/ a\alias scsi_hostadapter${alias_number} mptfc" ${update_file} > ${update_file}.new
			mv ${update_file}.new ${update_file}
		fi;
		if [ ${found_spi} = "1" ]; then
			sed -e "/mptscsih/ a\alias scsi_hostadapter${alias_number} mptspi" ${update_file} > ${update_file}.new
			mv ${update_file}.new ${update_file}
		fi;
		sed -e '/mptbase/d' ${update_file} > ${update_file}.new
		mv ${update_file}.new ${update_file}
		sed -e '/mptscsih/d' ${update_file} > ${update_file}.new
		mv ${update_file}.new ${update_file}
		exit 0;
	fi;
	if [ `grep -c "alias scsi_hostadapter" ${update_file}` -eq 0 ] ; then
		alias_number="1"
	else
		alias_number=$(( `grep "alias scsi_hostadapter" ${update_file} | \
		awk '{print $2}' | sed "s/scsi_hostadapter//" | sort -n | tail -1` + 1 ))
	fi;
	if [ `grep -c mptspi ${update_file}` -eq 0 ] && [ ${found_spi} = "1" ]; then
		echo "alias scsi_hostadapter${alias_number} mptspi" >> ${update_file};
		alias_number=$(($alias_number+1))
	fi;
	if [ `grep -c mptfc ${update_file}` -eq 0 ] && [ ${found_fc} = "1" ]; then
		echo "alias scsi_hostadapter${alias_number} mptfc" >> ${update_file};
		alias_number=$(($alias_number+1))
	fi;
	if [ `grep -c mptsas ${update_file}` -eq 0 ] && [ ${found_sas} = "1" ]; then
		echo "alias scsi_hostadapter${alias_number} mptsas" >> ${update_file};
		alias_number=$(($alias_number+1))
	fi;
fi;
exit 0
