%define name mptlinux
%define version 3.02.77
%define release 1
Summary: MPT Fusion drivers for 53C1030, FC9XX, and SAS Adapters
Name: %{name}
Version: %{version}
Release: %{release}
Vendor: LSI Logic
License: GPL
Group: System Environment/Kernel
Source: %{name}-%{version}.tar.gz
URL: http://www.lsilogic.com
Distribution: LSI Logic
BuildRoot: /var/tmp/%{name}-buildroot
Packager: Eric Moore <Eric.Moore@lsil.com>

%description
Drivers for (suse i686, x86_64, ia64 and updates) for the
LSI Logic Fusion-MPT Architecture parts.
These include the Ultra320 53C1030, 53C1020 and the Fiber
Channel FC909, FC919, FC929, FC919X and FC929X adapters.
SAS1064, SAS1066, and SAS1068 adapters.

# prep ##############################################################################
%prep
%setup -c -b 0

# build ##############################################################################
%build
for i in /lib/modules/2.6.*; do
	kernel=`basename ${i}`;
	if [ -f /lib/modules/${kernel}/source/drivers/message/fusion/Kconfig ]; then
		make build KERNEL=$kernel;
	fi;
done;

# install ##############################################################################
%install
echo "%defattr(-,root,root)" > $RPM_BUILD_DIR/file.list.%{name}
for i in /lib/modules/2.6.*; do
	kernel=`basename ${i}`
	if [ -f /lib/modules/${kernel}/source/drivers/message/fusion/Kconfig ]; then
		MPTLINUX_IPATH=/lib/modules/${kernel}/kernel/drivers/message/fusion
		mkdir -p $RPM_BUILD_ROOT/lib/modules/${kernel}/kernel/drivers/message/fusion

		# create the file list used in %files to indicate which files are in package
		for driver_name in mptbase.ko mptscsih.ko mptctl.ko mptlan.ko mptspi.ko mptfc.ko mptsas.ko; do
			echo "$MPTLINUX_IPATH/${driver_name}.new" >> $RPM_BUILD_DIR/file.list.%{name}
		done;

		make install PREFIX=$RPM_BUILD_ROOT KERNEL=$kernel

		for driver_name in mptbase.ko mptscsih.ko mptctl.ko mptlan.ko mptspi.ko mptfc.ko mptsas.ko; do
			mv -f $RPM_BUILD_ROOT/$MPTLINUX_IPATH/${driver_name} \
				$RPM_BUILD_ROOT/$MPTLINUX_IPATH/${driver_name}.new
		done;
	fi;
done;

# post ##############################################################################
%post
if [ -f /etc/redhat-release ]; then
	# RHEL 4
	if [ -f /etc/modprobe.conf ] ; then
		cp /etc/modprobe.conf /etc/modprobe.conf.orig.%{release};
		sed -e '/mptbase/d' /etc/modprobe.conf > modprobe.edit;
		sed -e '/mptscsih/d' modprobe.edit > modprobe.edit.1;
		sed -e '/mptspi/d' modprobe.edit.1 > modprobe.edit.2;
		sed -e '/mptfc/d' modprobe.edit.2 > modprobe.edit.3;
		sed -e '/mptsas/d' modprobe.edit.3 > modprobe.edit;
		echo "alias scsi_hostadapter mptspi" >> modprobe.edit;
		echo "alias scsi_hostadapter1 mptfc" >> modprobe.edit;
		echo "alias scsi_hostadapter2 mptsas" >> modprobe.edit;
		mv -f modprobe.edit /etc/modprobe.conf;
		rm -fr modprobe.edit.*;
	fi;
elif [ -f /etc/SuSE-release ]; then
	# SLES 9
	if [ -f /etc/sysconfig/kernel ] ; then
		cp /etc/sysconfig/kernel /etc/sysconfig/kernel.orig.%{release};
		sed -e 's/mptscsih//g' /etc/sysconfig/kernel > kernel.edit;
		sed -e 's/mptsas//g' kernel.edit > kernel.edit.1;
		sed -e 's/mptfc//g' kernel.edit.1 > kernel.edit.2;
		sed -e 's/mptspi//g' kernel.edit.2 > kernel.edit.3;
		sed -e 's/INITRD_MODULES="/INITRD_MODULES="mptsas /g' kernel.edit.3 > kernel.edit.4;
		sed -e 's/INITRD_MODULES="/INITRD_MODULES="mptfc /g' kernel.edit.4 > kernel.edit.5;
		sed -e 's/INITRD_MODULES="/INITRD_MODULES="mptspi /g' kernel.edit.5 > kernel.edit;
		mv -f kernel.edit /etc/sysconfig/kernel;
		rm -fr kernel.edit.*; 
	fi;
fi

# adding device nodes
if [ ! -e /dev/mptctl ]; then
	echo "Creating /dev/mptctl ioctl node file";
	mknod /dev/mptctl c 10 220;
fi;

for i in /lib/modules/2.6.*; do
	kernel=`basename ${i}`;
	if [ -d /lib/modules/${kernel}/kernel/drivers/message/fusion ]; then
		echo "The mpt driver for kernel ${kernel} is now version 3.02.77";
		MPTLINUX_IPATH=/lib/modules/${kernel}/kernel/drivers/message/fusion
		#backup original fusion drivers here if not already done
		for driver_name in mptbase.ko mptscsih.ko mptctl.ko mptlan.ko mptspi.ko mptfc.ko mptsas.ko; do
########  Proposed change 
## I think we want to add a check here to make sure that the new driver is 
## in the directory before we update the driver. This is in case we did not
## compile the driver for all kernels
			if [ -e $RPM_BUILD_ROOT/$MPTLINUX_IPATH/${driver_name}.new ]; then
				if [ -e $RPM_BUILD_ROOT/$MPTLINUX_IPATH/${driver_name} ]; then
					mv -f $RPM_BUILD_ROOT/$MPTLINUX_IPATH/${driver_name} \
						$RPM_BUILD_ROOT/$MPTLINUX_IPATH/${driver_name}.orig.%{release}
				fi;
				cp -f $RPM_BUILD_ROOT/$MPTLINUX_IPATH/${driver_name}.new \
					$RPM_BUILD_ROOT/$MPTLINUX_IPATH/${driver_name}
			fi;
		done;
		# Calling depmod
		depmod -v ${kernel} > /dev/null 2>&1;
		# Remake the initrd image for the user, depending on their OS
		if [ -f /etc/redhat-release ]; then
			# RHEL 4
			if [ -d /boot/efi/efi/redhat ]; then
				bootpart=/boot/efi/efi/redhat;	
			elif [ -d /boot/efi ]; then
				bootpart=/boot/efi;
			else 
				bootpart=/boot;
			fi
			echo Saving initrd-${kernel}.img in ${bootpart} directory.
			cp ${bootpart}/initrd-${kernel}.img ${bootpart}/initrd-${kernel}.img.orig
			mkinitrd -f ${bootpart}/initrd-${kernel}.img ${kernel}
		elif [ -f /etc/SuSE-release ]; then
			# SLES 9
			echo Saving initrd-${kernel} in /boot directory.
			cp /boot/initrd-${kernel} /boot/initrd-${kernel}.orig
			mk_initrd -k vmlinuz-${kernel} -i /boot/initrd-${kernel}
		fi;
	fi;
done;
echo -e "post Install Done."

# preun ##############################################################################
%preun
for i in /lib/modules/2.6.*; do
	kernel=`basename ${i}`;
	if [ -d /lib/modules/${kernel}/kernel/drivers/message/fusion ]; then
		MPTLINUX_IPATH=/lib/modules/${kernel}/kernel/drivers/message/fusion
		for driver_name in mptbase.ko mptscsih.ko mptctl.ko mptlan.ko mptspi.ko mptfc.ko mptsas.ko; do
######### Proposed Change
## Since we are going to force move the old driver and overwrite the newer
## driver, I don't think we need the check and the first remove below.  This
## will also fix a problem incase there really isn't a driver to uninstall
#			if [ -f $MPTLINUX_IPATH/${driver_name} ]; then
#				rm -f $MPTLINUX_IPATH/${driver_name} 
#			fi;
			if [ -f $MPTLINUX_IPATH/${driver_name}.orig.%{release} ]; then
				mv -f $MPTLINUX_IPATH/${driver_name}.orig.%{release} $MPTLINUX_IPATH/${driver_name} 
			fi;
		done;
	fi;
done;

# postun ##############################################################################
%postun
if [ -f /etc/modprobe.conf.orig.%{release} ]; then
	# RHEL 4
	mv -f /etc/modprobe.conf.orig.%{release} /etc/modprobe.conf;
elif [ -f /etc/sysconfig/kernel.orig.%{release} ]; then
	# SLES 9
	mv -f /etc/sysconfig/kernel.orig.%{release} /etc/sysconfig/kernel;
fi;
for i in /lib/modules/2.6.*; do
	kernel=`basename ${i}`;
	if [ -d /lib/modules/${kernel}/kernel/drivers/message/fusion ]; then
		depmod -v ${kernel} > /dev/null 2>&1;
		# restore original initrd images
		if [ -f /etc/redhat-release ]; then
			# RHEL 4
			if [ -d /boot/efi/efi/redhat ]; then
				bootpart=/boot/efi/efi/redhat;	
			elif [ -d /boot/efi ]; then
				bootpart=/boot/efi;
			else 
				bootpart=/boot;
			fi
			if [ -f ${bootpart}/initrd-${kernel}.img.orig ]; then
				mv -f ${bootpart}/initrd-${kernel}.img.orig ${bootpart}/initrd-${kernel}.img;
			fi;
		elif [ -f /etc/SuSE-release ]; then
			# SLES 9
			if [ -f /boot/initrd-${kernel}.orig ]; then
				mv -f /boot/initrd-${kernel}.orig /boot/initrd-${kernel};
			fi;
		fi;
	fi;
done;
echo -e "Uninstall Done."

# files ##############################################################################
%files -f ../file.list.%{name}

# changelog  ##############################################################################
%changelog
* Wed May 18 2005 Eric Moore <Eric.Moore@lsil.com>
 -Adding support for compiling drivers for mulitple kernels.
 -Adding split driver support. 
