#!/bin/sh

echo "Checking for any Old Version"
##rpm -e --test MegaRAID_Storage_Manager_IR
linecount=`rpm -qa | grep MegaRAID_Storage_Manager_IR | wc -l`
if [ $linecount = 0 ]; then
  status=1
else
 if [ $linecount = 1 ]; then
     status=0
 else
    echo "More than one copy of MegaRAID Storage Manager-IR has been installed. Exiting installation."
    exit 1
 fi
fi

if [ $status = 0 ]; then
  newdate=1168596192
  olddate=`rpm -q --queryformat "%{BUILDTIME}" MegaRAID_Storage_Manager_IR`
  if [ $newdate -gt $olddate ]; then
	echo "Uninstalling Old version"
	"/usr/local/MegaRAID Storage Manager/uninstaller.sh"
  else
        if [ $newdate = $olddate ]; then
         echo "The version is already installed."
        else
	 echo "The installed version is newer."
        fi
        echo "Exiting installation."
        exit 1
  fi
else
  echo "No Old Version Found"
fi
echo "Continuing with installation"
exit 0
