/*
 * Decompiled with CFR 0.152.
 */
package jp.co.hitachi.soft.hntrlib2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import jp.co.hitachi.soft.hntrlib2.HntrErrCode;
import jp.co.hitachi.soft.hntrlib2.HntrFileOrderInfo;
import jp.co.hitachi.soft.hntrlib2.HntrFnameFilter;
import jp.co.hitachi.soft.hntrlib2.HntrTrace;

public class HntrPureTrace
implements HntrTrace {
    private static int m_msgCount;
    private int m_logLevel = 0;
    private int m_fileThreshold = 0;
    private long m_fileSize = 0L;
    private int m_fileNum = 0;
    private String m_basePath = null;
    private String m_appName = null;
    private File m_file = null;
    private FileOutputStream m_fileOut = null;
    private boolean m_isInitialized = false;
    private int m_fileNo = 1;
    private long m_currentFileSize = 0L;
    private HntrErrCode m_errCode = new HntrErrCode();
    private String m_Encoding;

    public HntrPureTrace() {
        try {
            this.m_Encoding = System.getProperty("hitachi.hntrlib.encoding");
            return;
        }
        catch (Throwable throwable) {
            this.m_Encoding = null;
            return;
        }
    }

    public synchronized int setLogLevel(int n) {
        int n2 = this.m_logLevel;
        if (n >= -1 && n <= 1000) {
            this.m_logLevel = n;
        }
        return n2;
    }

    public int getLogLevel() {
        return this.m_logLevel;
    }

    public synchronized int setFileThreshold(int n) {
        int n2 = this.m_fileThreshold;
        if (n >= -1 && n <= 1000) {
            this.m_fileThreshold = n;
        }
        return n2;
    }

    public int setShmThreshold(int n) {
        return -1;
    }

    public HntrErrCode startTrace(String string, String string2, int n, int n2) {
        if (this.m_isInitialized) {
            HntrErrCode hntrErrCode = new HntrErrCode();
            hntrErrCode.setApiNameAndPos(HntrErrCode.cs_apiName[6], HntrErrCode.cs_errPos[11]);
            return hntrErrCode;
        }
        if (n < 1 || n > 16) {
            HntrErrCode hntrErrCode = new HntrErrCode();
            hntrErrCode.setApiNameAndPos(HntrErrCode.cs_apiName[6], HntrErrCode.cs_errPos[1]);
            return hntrErrCode;
        }
        if (n2 < 4096) {
            HntrErrCode hntrErrCode = new HntrErrCode();
            hntrErrCode.setApiNameAndPos(HntrErrCode.cs_apiName[6], HntrErrCode.cs_errPos[1]);
            return hntrErrCode;
        }
        this.m_appName = string;
        this.m_basePath = string2;
        this.m_fileNum = n;
        this.m_fileSize = n2;
        HntrErrCode hntrErrCode = this.openTraceFile();
        if (hntrErrCode != null) {
            hntrErrCode.addApiName(HntrErrCode.cs_apiName[6]);
            this.m_isInitialized = false;
        } else {
            this.m_isInitialized = true;
        }
        return hntrErrCode;
    }

    public HntrErrCode endTrace() {
        HntrErrCode hntrErrCode = null;
        if (this.m_isInitialized) {
            this.m_isInitialized = false;
            hntrErrCode = this.closeTraceFile();
            if (hntrErrCode != null) {
                hntrErrCode.addApiName(HntrErrCode.cs_apiName[7]);
            }
        } else {
            hntrErrCode = new HntrErrCode();
            hntrErrCode.setApiNameAndPos(HntrErrCode.cs_apiName[7], HntrErrCode.cs_errPos[11]);
        }
        return hntrErrCode;
    }

    public HntrErrCode putWithId(int n, String string, String string2) {
        if (this.m_isInitialized) {
            if (this.isLevelOk(n)) {
                HntrErrCode hntrErrCode = this.putMsg(this.m_appName, string, null, string2);
                if (hntrErrCode != null) {
                    hntrErrCode.addApiName(HntrErrCode.cs_apiName[9]);
                }
                return hntrErrCode;
            }
            return null;
        }
        HntrErrCode hntrErrCode = new HntrErrCode();
        hntrErrCode.setApiNameAndPos(HntrErrCode.cs_apiName[9], HntrErrCode.cs_errPos[11]);
        return hntrErrCode;
    }

    public HntrErrCode putWithIdMb(int n, String string, String string2) {
        HntrErrCode hntrErrCode = this.putWithId(n, string, string2);
        if (hntrErrCode != null) {
            hntrErrCode.addApiName("HntrTrace.putWithIdMb");
        }
        return hntrErrCode;
    }

    public HntrErrCode putWithIdEx(int n, String string, String string2, String string3) {
        if (this.m_isInitialized) {
            if (this.isLevelOk(n)) {
                HntrErrCode hntrErrCode = this.putMsg(string, string2, null, string3);
                if (hntrErrCode != null) {
                    hntrErrCode.addApiName(HntrErrCode.cs_apiName[35]);
                }
                return hntrErrCode;
            }
            return null;
        }
        HntrErrCode hntrErrCode = new HntrErrCode();
        hntrErrCode.setApiNameAndPos(HntrErrCode.cs_apiName[35], HntrErrCode.cs_errPos[11]);
        return hntrErrCode;
    }

    public HntrErrCode putWithIdExMb(int n, String string, String string2, String string3) {
        HntrErrCode hntrErrCode = this.putWithIdEx(n, string, string2, string3);
        if (hntrErrCode != null) {
            hntrErrCode.addApiName("HntrTrace.putWithIdExMb");
        }
        return hntrErrCode;
    }

    public HntrErrCode putWithMsgType(int n, String string, String string2, String string3, String string4) {
        if (this.m_isInitialized) {
            if (this.isLevelOk(n)) {
                HntrErrCode hntrErrCode = this.putMsg(string, string2, string3, string4);
                if (hntrErrCode != null) {
                    hntrErrCode.addApiName(HntrErrCode.cs_apiName[36]);
                }
                return hntrErrCode;
            }
            return null;
        }
        HntrErrCode hntrErrCode = new HntrErrCode();
        hntrErrCode.setApiNameAndPos(HntrErrCode.cs_apiName[36], HntrErrCode.cs_errPos[11]);
        return hntrErrCode;
    }

    public HntrErrCode putWithMsgTypeMb(int n, String string, String string2, String string3, String string4) {
        HntrErrCode hntrErrCode = this.putWithMsgType(n, string, string2, string3, string4);
        if (hntrErrCode != null) {
            hntrErrCode.addApiName("Hntrlib.putWithMsgTypeMb");
        }
        return hntrErrCode;
    }

    public HntrErrCode logFileClearByNum(String string, int n) {
        HntrErrCode hntrErrCode = null;
        String string2 = string.replace('/', File.separatorChar);
        try {
            String[] stringArray = this.getSpecifiedFilelist(string2);
            if (stringArray == null) {
                hntrErrCode = new HntrErrCode();
                hntrErrCode.setApiNameAndPos(HntrErrCode.cs_apiName[12], HntrErrCode.cs_errPos[13]);
                return hntrErrCode;
            }
            Vector<HntrFileOrderInfo> vector = new Vector<HntrFileOrderInfo>(Array.getLength(stringArray));
            int n2 = 0;
            while (n2 < Array.getLength(stringArray)) {
                File file = new File(stringArray[n2]);
                if (!file.isDirectory()) {
                    long l = file.lastModified();
                    HntrFileOrderInfo hntrFileOrderInfo = new HntrFileOrderInfo(file, l);
                    int n3 = 0;
                    while (n3 < vector.size()) {
                        HntrFileOrderInfo hntrFileOrderInfo2 = (HntrFileOrderInfo)vector.elementAt(n3);
                        if (hntrFileOrderInfo2.isOlder(hntrFileOrderInfo)) break;
                        ++n3;
                    }
                    if (n3 < vector.size()) {
                        vector.insertElementAt(hntrFileOrderInfo, n3);
                    } else {
                        vector.addElement(hntrFileOrderInfo);
                    }
                }
                ++n2;
            }
            int n4 = n;
            while (n4 < vector.size()) {
                HntrFileOrderInfo hntrFileOrderInfo = (HntrFileOrderInfo)vector.elementAt(n4);
                if (!hntrFileOrderInfo.m_file.delete()) {
                    hntrErrCode = new HntrErrCode();
                    hntrErrCode.setApiNameAndPos(HntrErrCode.cs_apiName[12], HntrErrCode.cs_errPos[8]);
                }
                ++n4;
            }
        }
        catch (Throwable throwable) {
            hntrErrCode = new HntrErrCode();
            hntrErrCode.setApiNameAndPos(HntrErrCode.cs_apiName[12], throwable.getMessage());
        }
        return hntrErrCode;
    }

    public HntrErrCode logFileClearByTime(String string, int n) {
        HntrErrCode hntrErrCode = new HntrErrCode();
        hntrErrCode.setApiNameAndPos(HntrErrCode.cs_apiName[12], "logFileClearByTime is not implemented.");
        return hntrErrCode;
    }

    public HntrErrCode traceBackup(String string) {
        if (!this.m_isInitialized) {
            HntrErrCode hntrErrCode = new HntrErrCode();
            hntrErrCode.setApiNameAndPos(HntrErrCode.cs_apiName[14], HntrErrCode.cs_errPos[11]);
            return hntrErrCode;
        }
        try {
            File file = new File(string);
            if (file.exists()) {
                file.delete();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            int n = this.m_fileNo + 1;
            byte[] byArray = new byte[1024];
            int n2 = 1;
            while (n2 <= this.m_fileNum) {
                String string2;
                File file2;
                if (n > this.m_fileNum) {
                    n = 1;
                }
                if ((file2 = new File(string2 = String.valueOf(this.m_basePath) + n + ".log")).isFile()) {
                    int n3;
                    FileInputStream fileInputStream = new FileInputStream(file2);
                    while ((n3 = fileInputStream.read(byArray)) >= 0) {
                        fileOutputStream.write(byArray, 0, n3);
                    }
                    fileInputStream.close();
                }
                ++n2;
                ++n;
            }
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            HntrErrCode hntrErrCode = new HntrErrCode();
            hntrErrCode.setApiNameAndPos(HntrErrCode.cs_apiName[14], iOException.getMessage());
            return hntrErrCode;
        }
        catch (Throwable throwable) {
            HntrErrCode hntrErrCode = new HntrErrCode();
            hntrErrCode.setApiNameAndPos(HntrErrCode.cs_apiName[14], throwable.getMessage());
            return hntrErrCode;
        }
        return null;
    }

    public HntrErrCode setEncoding(String string) {
        if (string != null) {
            String string2 = "abc";
            try {
                string2.getBytes(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                HntrErrCode hntrErrCode = new HntrErrCode();
                hntrErrCode.setApiNameAndPos("HntrTrace.setEncoding", "Unsupported Encoding.");
                return hntrErrCode;
            }
        }
        this.m_Encoding = string;
        return null;
    }

    public String getEncoding() {
        return this.m_Encoding;
    }

    public HntrErrCode chFileAttr(int n) {
        HntrErrCode hntrErrCode = new HntrErrCode();
        hntrErrCode.setApiNameAndPos(HntrErrCode.cs_apiName[37], HntrErrCode.cs_errPos[28]);
        return hntrErrCode;
    }

    private boolean isLevelOk(int n) {
        return this.m_logLevel != -1 && this.m_fileThreshold != -1 && this.m_logLevel >= n && n >= this.m_fileThreshold;
    }

    private String[] getSpecifiedFilelist(String string) {
        String string2;
        String string3;
        int n = string.lastIndexOf(File.separatorChar);
        if (n == -1) {
            string3 = "";
            string2 = string;
        } else {
            string3 = string.substring(0, n);
            if (n + 1 == string.length()) {
                return null;
            }
            string2 = string.substring(n + 1);
        }
        File file = new File(string3);
        if (!file.isDirectory()) {
            return null;
        }
        HntrFnameFilter hntrFnameFilter = new HntrFnameFilter(string3, string2);
        String[] stringArray = file.list(hntrFnameFilter);
        int n2 = 0;
        while (n2 < Array.getLength(stringArray)) {
            stringArray[n2] = String.valueOf(string3) + File.separatorChar + stringArray[n2];
            ++n2;
        }
        return stringArray;
    }

    private HntrErrCode chkAndMkDir(String string) {
        HntrErrCode hntrErrCode = null;
        try {
            File file = new File(string);
            if (!file.exists()) {
                String string2 = file.getParent();
                hntrErrCode = this.chkAndMkDir(string2);
                if (hntrErrCode != null) {
                    return hntrErrCode;
                }
                if (!file.mkdir()) {
                    hntrErrCode = new HntrErrCode();
                    hntrErrCode.setApiNameAndPos("", HntrErrCode.cs_errPos[21]);
                    return hntrErrCode;
                }
            } else if (!file.isDirectory()) {
                hntrErrCode = new HntrErrCode();
                hntrErrCode.setApiNameAndPos("", HntrErrCode.cs_errPos[17]);
                return hntrErrCode;
            }
            return null;
        }
        catch (Throwable throwable) {
            hntrErrCode = new HntrErrCode();
            hntrErrCode.setApiNameAndPos("", throwable.getMessage());
            return hntrErrCode;
        }
    }

    private void searchNewestTraceFileName() {
        String string = this.m_basePath.replace('/', File.separatorChar);
        long l = 0L;
        long l2 = this.m_fileSize;
        int n = 0;
        try {
            int n2 = 1;
            while (n2 <= this.m_fileNum) {
                String string2 = String.valueOf(string) + n2 + ".log";
                File file = new File(string2);
                if (file.exists()) {
                    long l3 = file.lastModified();
                    if (n == 0) {
                        l = l3;
                        n = n2;
                        l2 = file.length();
                    } else if (l3 > l) {
                        l = l3;
                        n = n2;
                        l2 = file.length();
                    } else if (l3 == l && n2 - n == 1) {
                        if (l2 < this.m_fileSize) {
                            if (l2 >= file.length()) {
                                l = l3;
                                n = n2;
                                l2 = file.length();
                            }
                        } else {
                            l = l3;
                            n = n2;
                            l2 = file.length();
                        }
                    }
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {}
        if (n == 0) {
            this.m_fileNo = 1;
            return;
        }
        this.m_fileNo = n;
    }

    private synchronized HntrErrCode openTrace(boolean bl) {
        try {
            if (this.m_fileNo < 1 || this.m_fileNo > this.m_fileNum) {
                this.m_fileNo = 1;
            }
            String string = String.valueOf(this.m_basePath.replace('/', File.separatorChar)) + this.m_fileNo + ".log";
            this.m_file = new File(string);
            if (bl && this.m_file.exists() && this.m_file.length() >= this.m_fileSize) {
                ++this.m_fileNo;
                if (this.m_fileNo > this.m_fileNum) {
                    this.m_fileNo = 1;
                }
                string = String.valueOf(this.m_basePath.replace('/', File.separatorChar)) + this.m_fileNo + ".log";
                bl = false;
                this.m_file = new File(string);
            }
            this.m_currentFileSize = !bl ? 0L : this.m_file.length();
            try {
                this.m_fileOut = new FileOutputStream(this.m_file.toString(), bl);
            }
            catch (Throwable throwable) {
                this.m_currentFileSize = this.m_fileSize;
                HntrErrCode hntrErrCode = new HntrErrCode();
                hntrErrCode.setApiNameAndPos("", throwable.getMessage());
                return hntrErrCode;
            }
            String string2 = this.createHeadLineMsg();
            if (this.m_Encoding != null) {
                try {
                    this.m_fileOut.write(string2.getBytes(this.m_Encoding));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.m_Encoding = null;
                    this.m_fileOut.write(string2.getBytes());
                }
            } else {
                this.m_fileOut.write(string2.getBytes());
            }
            this.m_currentFileSize += (long)string2.length();
        }
        catch (Throwable throwable) {
            HntrErrCode hntrErrCode = new HntrErrCode();
            hntrErrCode.setApiNameAndPos("", throwable.getMessage());
            return hntrErrCode;
        }
        return null;
    }

    private HntrErrCode openTraceFile() {
        HntrErrCode hntrErrCode;
        String string = this.m_basePath.replace('/', File.separatorChar);
        int n = string.lastIndexOf(File.separatorChar);
        if (n != -1 && (hntrErrCode = this.chkAndMkDir(string = string.substring(0, n))) != null) {
            return hntrErrCode;
        }
        this.searchNewestTraceFileName();
        return this.openTrace(true);
    }

    private HntrErrCode closeTraceFile() {
        try {
            if (this.m_fileOut != null) {
                this.m_fileOut.close();
            }
            this.m_fileOut = null;
            this.m_file = null;
        }
        catch (Throwable throwable) {
            HntrErrCode hntrErrCode = new HntrErrCode();
            hntrErrCode.setApiNameAndPos("", throwable.getMessage());
            return hntrErrCode;
        }
        return null;
    }

    private synchronized HntrErrCode putMsg(String string, String string2, String string3, String string4) {
        try {
            int n;
            int n2;
            Object object;
            if (string2 == null || string4 == null) {
                HntrErrCode hntrErrCode = new HntrErrCode();
                hntrErrCode.setApiNameAndPos("", HntrErrCode.cs_errPos[1]);
                return hntrErrCode;
            }
            StringBuffer stringBuffer = string3 == null ? this.modifyString(new StringBuffer(22).append(string2), 21).append(" ") : this.modifyString(new StringBuffer(22).append(string2), 16).append(" ").append((Object)this.modifyString(new StringBuffer(4).append(string3), 4)).append(" ");
            StringBuffer stringBuffer2 = new StringBuffer(100);
            stringBuffer2.append((Object)this.intString(m_msgCount, 4)).append(" ").append((Object)this.dateString()).append("     ").append((Object)this.modifyString(new StringBuffer(string), 16)).append(" ").append((Object)this.hexString(Runtime.getRuntime().hashCode())).append(" ").append((Object)this.hexString(Thread.currentThread().hashCode()));
            String string5 = stringBuffer2.append(" ").append((Object)stringBuffer).toString();
            if (++m_msgCount >= 10000) {
                m_msgCount = 0;
            }
            if (this.m_file == null || this.m_currentFileSize >= this.m_fileSize) {
                this.closeTraceFile();
                ++this.m_fileNo;
                if (this.m_fileNo > this.m_fileNum) {
                    this.m_fileNo = 1;
                }
                if ((object = this.openTrace(false)) != null) {
                    return object;
                }
            }
            object = null;
            byte[] byArray = null;
            byte[] byArray2 = null;
            byte[] byArray3 = new byte[]{13, 10};
            int n3 = byArray3.length;
            if (this.m_Encoding != null) {
                try {
                    object = string5.getBytes(this.m_Encoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.m_Encoding = null;
                    object = string5.getBytes();
                }
            } else {
                object = string5.getBytes();
            }
            int n4 = ((Object)object).length;
            if (this.m_Encoding != null) {
                try {
                    byArray = string4.getBytes(this.m_Encoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.m_Encoding = null;
                    byArray = string4.getBytes();
                }
            } else {
                byArray = string4.getBytes();
            }
            if ((n2 = byArray.length) >= 4096) {
                n = n4 + 4095 + n3;
                byArray2 = new byte[n];
                System.arraycopy(object, 0, byArray2, 0, n4);
                System.arraycopy(byArray, 0, byArray2, n4, 4095);
                System.arraycopy(byArray3, 0, byArray2, n4 + 4095, n3);
            } else {
                n = n4 + n2 + n3;
                byArray2 = new byte[n];
                System.arraycopy(object, 0, byArray2, 0, n4);
                System.arraycopy(byArray, 0, byArray2, n4, n2);
                System.arraycopy(byArray3, 0, byArray2, n4 + n2, n3);
            }
            this.m_fileOut.write(byArray2);
            this.m_fileOut.flush();
            this.m_currentFileSize += (long)n;
        }
        catch (Throwable throwable) {
            HntrErrCode hntrErrCode = new HntrErrCode();
            hntrErrCode.setApiNameAndPos("", throwable.getMessage());
            return hntrErrCode;
        }
        return null;
    }

    private StringBuffer modifyString(StringBuffer stringBuffer, int n) {
        StringBuffer stringBuffer2;
        int n2 = stringBuffer.length();
        if (n2 == n) {
            stringBuffer2 = stringBuffer;
        } else if (n2 > n) {
            stringBuffer2 = new StringBuffer(stringBuffer.toString().substring(0, n));
        } else {
            stringBuffer2 = stringBuffer;
            while (n2 < n) {
                stringBuffer2.append(' ');
                ++n2;
            }
        }
        return stringBuffer2;
    }

    private StringBuffer hexString(int n) {
        StringBuffer stringBuffer = new StringBuffer(8).append(Integer.toHexString(n).toUpperCase());
        int n2 = stringBuffer.length();
        while (n2 < 8) {
            stringBuffer.insert(0, '0');
            ++n2;
        }
        return stringBuffer;
    }

    private StringBuffer intString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(4).append(n);
        int n3 = stringBuffer.length();
        while (n3 < n2) {
            stringBuffer.insert(0, '0');
            ++n3;
        }
        return stringBuffer;
    }

    private StringBuffer dateString() {
        Calendar calendar = Calendar.getInstance();
        return new StringBuffer(24).append((Object)this.intString(calendar.get(1), 4)).append("/").append((Object)this.intString(calendar.get(2) + 1, 2)).append("/").append((Object)this.intString(calendar.get(5), 2)).append(" ").append((Object)this.intString(calendar.get(11), 2)).append(":").append((Object)this.intString(calendar.get(12), 2)).append(":").append((Object)this.intString(calendar.get(13), 2)).append(".").append((Object)this.intString(calendar.get(14), 3));
    }

    private String createHeadLineMsg() {
        StringBuffer stringBuffer = new StringBuffer("**** ");
        StringBuffer stringBuffer2 = new StringBuffer(System.getProperty("os.name")).append(" ").append(System.getProperty("os.version"));
        stringBuffer.append((Object)this.modifyString(stringBuffer2, 60)).append(" ");
        stringBuffer.append("                 ");
        TimeZone timeZone = TimeZone.getDefault();
        stringBuffer.append((Object)this.modifyString(new StringBuffer("TZ=" + timeZone.getID()), 32)).append(" ").append((Object)this.dateString());
        stringBuffer.append("\r\n     yyyy/mm/dd hh:mm:ss.sss                      pid      tid      message-id            ");
        stringBuffer.append("message(LANG=").append(Locale.getDefault().getLanguage()).append(")");
        return stringBuffer.append("\r\n").toString();
    }
}

