/*
 * Decompiled with CFR 0.152.
 */
package JP.co.Hitachi.soft.System_Manager.console;

import JP.co.Hitachi.soft.System_Manager.console.HsmDocument;
import JP.co.Hitachi.soft.System_Manager.console.HsmErrorDlg;
import JP.co.Hitachi.soft.System_Manager.console.HsmEventListener;
import JP.co.Hitachi.soft.System_Manager.console.HsmInfoDlg;
import JP.co.Hitachi.soft.System_Manager.console.HsmInfoPane;
import JP.co.Hitachi.soft.System_Manager.console.HsmListEventListener;
import JP.co.Hitachi.soft.System_Manager.console.HsmOperationDialog;
import JP.co.Hitachi.soft.System_Manager.console.HsmPropertyDialog;
import JP.co.Hitachi.soft.System_Manager.console.HsmTreeEventListener;
import JP.co.Hitachi.soft.System_Manager.console.HsmTreeView;
import JP.co.Hitachi.soft.System_Manager.data.HsmAlert;
import JP.co.Hitachi.soft.System_Manager.data.HsmControlData;
import JP.co.Hitachi.soft.System_Manager.data.HsmError;
import JP.co.Hitachi.soft.System_Manager.data.HsmEvent;
import JP.co.Hitachi.soft.System_Manager.data.HsmException;
import JP.co.Hitachi.soft.System_Manager.data.HsmFuncIdData;
import JP.co.Hitachi.soft.System_Manager.data.HsmFuncNodeData;
import JP.co.Hitachi.soft.System_Manager.data.HsmGatewaySettingData;
import JP.co.Hitachi.soft.System_Manager.data.HsmHostNodeData;
import JP.co.Hitachi.soft.System_Manager.data.HsmHostSerchData;
import JP.co.Hitachi.soft.System_Manager.data.HsmInfo;
import JP.co.Hitachi.soft.System_Manager.data.HsmNodeData;
import JP.co.Hitachi.soft.System_Manager.data.HsmNodeStatusChanged;
import JP.co.Hitachi.soft.System_Manager.data.HsmStartPageInfo;
import JP.co.Hitachi.soft.System_Manager.data.HsmStatusCheckReply;
import JP.co.Hitachi.soft.System_Manager.data.HsmTableModel;
import JP.co.Hitachi.soft.System_Manager.data.HsmTreeData;
import JP.co.Hitachi.soft.System_Manager.data.HsmUrlData;
import java.applet.AppletContext;
import java.awt.GridLayout;
import java.io.Serializable;
import java.net.URL;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class HsmMainPane
extends JPanel
implements HsmEventListener,
HsmTreeEventListener,
HsmListEventListener,
Runnable {
    private static final int maxRows_ = 256;
    protected HsmDocument hsmDocument_ = null;
    protected HsmTreeView hsmTreeView_ = null;
    protected HsmInfoPane hsmInfoPane_ = null;
    protected JSplitPane splitPane_ = null;
    protected JMenu shortcutMenu_ = null;
    protected HsmGatewaySettingData hsmGatewaySettingData_ = null;
    protected Thread pollingTimer_ = null;
    protected boolean isPoling_ = false;
    protected Vector nListeners_ = new Vector();
    protected boolean isInited_ = false;
    GridLayout gridLayout1 = new GridLayout(1, 1);

    public HsmMainPane(HsmDocument hsmDocument) throws HsmException {
        this.hsmDocument_ = hsmDocument;
        this.createPanel();
    }

    public void SendStartPageEvent(HsmNodeData hsmNodeData, int n) {
        Vector<HsmNodeData> vector = new Vector<HsmNodeData>();
        vector.add(hsmNodeData);
        int n2 = 0;
        switch (n) {
            case 0xA000000: {
                n2 = 65537;
                break;
            }
            case 0xC000000: {
                n2 = 65544;
                break;
            }
            case 0xB000000: {
                n2 = 65542;
            }
        }
        HsmEvent hsmEvent = new HsmEvent((Object)this, n2, vector);
        this.eventOccurred(hsmEvent);
    }

    public void addEventListener(EventListener eventListener) throws HsmException {
        try {
            Class<?> clazz = Class.forName("JP.co.Hitachi.soft.System_Manager.console.HsmTreeEventListener");
            Class<?> clazz2 = Class.forName("JP.co.Hitachi.soft.System_Manager.console.HsmEventListener");
            Class<?> clazz3 = Class.forName("JP.co.Hitachi.soft.System_Manager.console.HsmListEventListener");
            if (!(eventListener != null && clazz.isInstance(eventListener) && clazz2.isInstance(eventListener) && clazz3.isInstance(eventListener))) {
                throw new HsmException(471896068);
            }
            this.hsmInfoPane_.addEventListener(eventListener);
            this.hsmTreeView_.addEventListener((HsmTreeEventListener)eventListener);
            this.nListeners_.add((HsmEventListener)eventListener);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new HsmException(471896068, classNotFoundException);
        }
    }

    public synchronized boolean checkStatus(int n) throws HsmException {
        Serializable serializable;
        if (!this.isInited_) {
            return true;
        }
        boolean bl = false;
        boolean bl2 = false;
        HsmStatusCheckReply hsmStatusCheckReply = this.hsmDocument_.statusCheck();
        boolean bl3 = hsmStatusCheckReply.getReloadTreeFlag();
        if (n != 0) {
            this.reload();
            bl = true;
            bl3 = false;
        }
        if (hsmStatusCheckReply.isChangedStatus() && !bl) {
            serializable = hsmStatusCheckReply.getChangedStatusList();
            int n2 = 0;
            while (n2 < serializable.size()) {
                HsmNodeStatusChanged hsmNodeStatusChanged = (HsmNodeStatusChanged)serializable.get(n2);
                int n3 = hsmNodeStatusChanged.getNodeId();
                HsmHostNodeData hsmHostNodeData = this.hsmDocument_.getNode(n3);
                if (hsmHostNodeData != null) {
                    int n4 = hsmHostNodeData.getIconStatus();
                    int n5 = hsmNodeStatusChanged.getStatus();
                    if (n4 == 1 && n5 == 2 || n4 == 2 && n5 == 1) {
                        bl = this.hsmDocument_.changeStatusAndIcon(hsmNodeStatusChanged.getStatus(), n3, false);
                        if (bl) {
                            bl3 = true;
                        }
                    } else if (n4 != n5) {
                        bl3 = true;
                    }
                }
                ++n2;
            }
            this.hsmTreeView_.reDraw();
            this.hsmInfoPane_.reDraw();
        }
        if (hsmStatusCheckReply.isAlert()) {
            this.sendAlertEvent(hsmStatusCheckReply.getAlertList());
            bl2 = true;
        }
        if (hsmStatusCheckReply.isError()) {
            this.drawErrorDlg(hsmStatusCheckReply.getErrorList());
        }
        if (hsmStatusCheckReply.isInfo()) {
            this.drawInfoDlg(hsmStatusCheckReply.getInfoList());
        }
        if (bl3) {
            serializable = new HsmInfo(HsmDocument.getResource().getString("TREE_CHANGED_MSG"));
            HsmInfoDlg hsmInfoDlg = new HsmInfoDlg((HsmInfo)serializable, this.hsmDocument_);
        }
        this.hsmInfoPane_.setIsAlertReload(bl2);
        return bl;
    }

    public void connect(Vector vector) throws HsmException {
        if (vector.size() != 1) {
            throw new HsmException(471699461);
        }
        HsmNodeData hsmNodeData = (HsmNodeData)vector.get(0);
        if ((hsmNodeData.getNodeType() & 0xF0000) != 65536) {
            throw new HsmException(471699461);
        }
        HsmHostNodeData hsmHostNodeData = (HsmHostNodeData)hsmNodeData;
        HsmControlData hsmControlData = new HsmControlData(65537);
        boolean bl = this.hsmDocument_.controlManagedNode(hsmNodeData, hsmControlData);
        if (bl) {
            int n = hsmHostNodeData.isExistAlert() ? 2 : 1;
            int n2 = hsmHostNodeData.getNodeId();
            this.hsmDocument_.changeStatusAndIconWithDraw(n, n2, true);
            this.sendNodeStatChangedEvent();
            this.repaint();
        }
    }

    public void createPanel() throws HsmException {
        this.setLayout(this.gridLayout1);
        this.hsmTreeView_ = new HsmTreeView(this.hsmDocument_, this);
        JScrollPane jScrollPane = new JScrollPane(this.hsmTreeView_);
        this.hsmInfoPane_ = new HsmInfoPane(this.hsmDocument_, this);
        this.splitPane_ = new JSplitPane(1);
        if (this.hsmDocument_.isStartPageVisible(2)) {
            this.splitPane_.setLeftComponent(jScrollPane);
        }
        this.splitPane_.setRightComponent(this.hsmInfoPane_);
        this.splitPane_.setContinuousLayout(true);
        this.splitPane_.setDividerLocation(230);
        this.add(this.splitPane_);
    }

    public void csvOut(Vector vector) throws HsmException {
        if (vector.size() != 1) {
            throw new HsmException(471633925);
        }
        HsmNodeData hsmNodeData = (HsmNodeData)vector.get(0);
        if (hsmNodeData.getNodeType() != 393217) {
            throw new HsmException(471633925);
        }
        HsmFuncNodeData hsmFuncNodeData = (HsmFuncNodeData)hsmNodeData;
        int n = hsmFuncNodeData.getFuncId();
        if (n == 0x1000000 || n == 0x4000000 || n == 0x6000000 || n == 0x8000000 || n == 0x2000000) {
            HsmUrlData hsmUrlData;
            Object object;
            String string;
            Serializable serializable;
            Object object2;
            Object object3 = hsmFuncNodeData.getUserObject();
            if (!(object3 instanceof HsmTableModel)) {
                throw new HsmException(471633925);
            }
            HsmTableModel hsmTableModel = (HsmTableModel)object3;
            int n2 = 0;
            if (n == 0x2000000) {
                object2 = hsmFuncNodeData.getUserObject2();
                if (!(object2 instanceof HsmHostSerchData)) {
                    throw new HsmException(471633924);
                }
                serializable = (HsmHostSerchData)object2;
                String string2 = ((HsmHostSerchData)serializable).toString2();
                string = this.hsmDocument_.createCsvFile(string2);
                n2 = 1;
                String string3 = hsmTableModel.getCsvHeaderString(n2);
                object = new Vector<String>();
                ((Vector)object).add(string3);
                hsmUrlData = this.hsmDocument_.addCsvRows(string, (Vector)object);
            } else {
                object2 = hsmTableModel.getCsvHeaderString();
                string = this.hsmDocument_.createCsvFile((String)object2);
            }
            int n3 = 0;
            serializable = new Vector();
            int n4 = hsmTableModel.getRowCount();
            int n5 = 0;
            while (n5 < n4) {
                object = hsmTableModel.getCsvDataString(n5, n2);
                ((Vector)serializable).add(object);
                if (n5 == n4 - 1) {
                    hsmUrlData = this.hsmDocument_.addCsvRows(string, (Vector)serializable);
                    URL uRL = hsmUrlData.getUrl(this.hsmDocument_.getBaseCodeUrl());
                    if (uRL == null) break;
                    AppletContext appletContext = this.hsmDocument_.getAppletContext();
                    appletContext.showDocument(uRL, "_blank");
                }
                if (++n3 == 256) {
                    hsmUrlData = this.hsmDocument_.addCsvRows(string, (Vector)serializable);
                    ((Vector)serializable).removeAllElements();
                }
                ++n5;
            }
        }
    }

    public void drawErrorDlg(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            HsmErrorDlg hsmErrorDlg = new HsmErrorDlg((HsmError)vector.get(n), this.hsmDocument_);
            ++n;
        }
    }

    public void drawInfoDlg(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            HsmInfoDlg hsmInfoDlg = new HsmInfoDlg((HsmInfo)vector.get(n), this.hsmDocument_);
            ++n;
        }
    }

    public void drawInventory(HsmAlert hsmAlert) throws HsmException {
        HsmFuncIdData hsmFuncIdData = this.hsmDocument_.getFunctionId(hsmAlert);
        HsmTreeData hsmTreeData = this.hsmDocument_.getSelectedTree();
        HsmNodeData hsmNodeData = this.searchFuncIdNode(hsmAlert.getNodeId(), hsmFuncIdData.getFuncId(), hsmFuncIdData.getDetailIds());
        if (hsmNodeData != null) {
            this.hsmTreeView_.setSelectedNode(hsmNodeData);
            this.hsmTreeView_.requestFocus();
        }
    }

    public void drawPropertyDlg(Vector vector) throws HsmException {
        if (vector.size() != 1) {
            throw new HsmException(471764997);
        }
        HsmNodeData hsmNodeData = (HsmNodeData)vector.get(0);
        HsmPropertyDialog hsmPropertyDialog = new HsmPropertyDialog(this.hsmDocument_, hsmNodeData);
    }

    public void eventOccurred(HsmEvent hsmEvent) {
        try {
            int n = hsmEvent.getEventId();
            if (n == 65537 || n == 65538 || n == 65541 || n == 65542 || n == 65543 || n == 65544 || n == 65545 || n == 65546 || n == 65559) {
                HsmOperationDialog hsmOperationDialog = new HsmOperationDialog(this.hsmDocument_, hsmEvent);
                if (n == 65546) {
                    this.reDraw();
                }
            } else if (n == 65552) {
                this.hsmTreeView_.selectAlertForce();
                this.hsmTreeView_.requestFocus();
            } else if (n == 65551) {
                boolean bl = this.checkStatus(1);
                if (!bl) {
                    this.reload();
                }
            } else if (n == 262145) {
                int n2 = hsmEvent.getOption();
                if (n2 == 1) {
                    this.hsmDocument_.setSelectedTree(1);
                } else if (n2 == 2) {
                    this.hsmDocument_.setSelectedTree(3);
                } else if (n2 == 3) {
                    this.hsmDocument_.setSelectedTree(2);
                }
                boolean bl = this.checkStatus(1);
                if (!bl) {
                    this.reload();
                }
            } else if (n == 65549) {
                this.connect((Vector)hsmEvent.getOptionObj());
            } else if (n == 65548) {
                this.csvOut((Vector)hsmEvent.getOptionObj());
            } else if (n == 65550) {
                this.drawPropertyDlg((Vector)hsmEvent.getOptionObj());
            } else if (n == 65547 || n == 65574) {
                HsmUrlData hsmUrlData = this.hsmDocument_.getHelpUrl(n);
                URL uRL = hsmUrlData.getUrl(this.hsmDocument_.getBaseCodeUrl());
                AppletContext appletContext = this.hsmDocument_.getAppletContext();
                appletContext.showDocument(uRL, "_blank");
            } else if (n == 65555) {
                this.reDraw();
            } else if (n == 65558) {
                Vector vector = this.hsmDocument_.getSelectedAlerts();
                if (vector != null && vector.size() > 0) {
                    HsmAlert hsmAlert = (HsmAlert)vector.get(0);
                    if (hsmAlert.getNodeId() == -1) {
                        throw new HsmException(349478937);
                    }
                    this.drawInventory(hsmAlert);
                }
            } else if (n == 65560) {
                this.hsmDocument_.setIntergerViewRadix(10);
                this.reDraw();
            } else if (n == 65561) {
                this.hsmDocument_.setIntergerViewRadix(16);
                this.reDraw();
            } else if (n == 65569) {
                this.hsmDocument_.sendDBReload(new HsmFuncNodeData());
            } else if (n == 65573) {
                this.hsmInfoPane_.changeAlertLogTerm();
            }
        }
        catch (HsmException hsmException) {
            HsmErrorDlg hsmErrorDlg = new HsmErrorDlg(hsmException.getError(), this.hsmDocument_);
        }
    }

    public void init() throws HsmException {
        HsmStartPageInfo hsmStartPageInfo = this.hsmDocument_.getStartPageInfo();
        if (hsmStartPageInfo != null) {
            HsmTreeData hsmTreeData = this.hsmDocument_.getSelectedTree();
            int n = hsmStartPageInfo.getNodeId();
            int n2 = hsmStartPageInfo.getFunctionId();
            Vector vector = hsmStartPageInfo.getDitailId();
            HsmNodeData hsmNodeData = null;
            switch (n2) {
                case 0xA000000: 
                case 0xB000000: 
                case 0xC000000: {
                    hsmNodeData = hsmTreeData.searchHost(n);
                    if (hsmNodeData == null) {
                        throw new HsmException(404717569);
                    }
                    this.SendStartPageEvent(hsmNodeData, n2);
                    break;
                }
                default: {
                    hsmNodeData = this.searchFuncIdNode(n, n2, vector);
                }
            }
            if (hsmNodeData != null) {
                hsmTreeData.setTreeSelectedNode(hsmNodeData);
            }
        }
        this.hsmTreeView_.reload();
        this.hsmGatewaySettingData_ = this.hsmDocument_.getGatewaySettingData();
        this.isPoling_ = this.hsmGatewaySettingData_.getPollSettingData().isEnalbe();
    }

    public void initTimer() throws HsmException {
        if (this.isPoling_ && this.pollingTimer_ == null) {
            this.pollingTimer_ = new Thread(this);
            this.pollingTimer_.start();
        }
        this.isInited_ = true;
    }

    public void listItemPerformed(HsmEvent hsmEvent) {
        try {
            Vector vector = (Vector)hsmEvent.getOptionObj();
            if (vector != null && vector.size() > 0) {
                HsmNodeData hsmNodeData = (HsmNodeData)vector.get(0);
                this.hsmTreeView_.setSelectedNode(hsmNodeData);
            }
        }
        catch (HsmException hsmException) {
            HsmErrorDlg hsmErrorDlg = new HsmErrorDlg(hsmException.getError(), this.hsmDocument_);
        }
    }

    public void listItemSelectionChanged(HsmEvent hsmEvent) {
    }

    public void reDraw() throws HsmException {
        this.hsmInfoPane_.reDraw();
        this.hsmTreeView_.reDraw();
    }

    public synchronized void reload() throws HsmException {
        this.hsmDocument_.reload();
        this.hsmInfoPane_.reload();
        this.hsmTreeView_.reload();
        this.hsmTreeView_.requestFocus();
        System.gc();
    }

    public void removeEventListener(EventListener eventListener) throws HsmException {
        try {
            Class<?> clazz = Class.forName("JP.co.Hitachi.soft.System_Manager.console.HsmTreeEventListener");
            Class<?> clazz2 = Class.forName("JP.co.Hitachi.soft.System_Manager.console.HsmEventListener");
            Class<?> clazz3 = Class.forName("JP.co.Hitachi.soft.System_Manager.console.HsmListEventListener");
            if (!(eventListener != null && clazz.isInstance(eventListener) && clazz2.isInstance(eventListener) && clazz3.isInstance(eventListener))) {
                throw new HsmException(471961604);
            }
            this.hsmInfoPane_.removeEventListener(eventListener);
            this.hsmTreeView_.removeEventListener((HsmTreeEventListener)eventListener);
            this.nListeners_.remove((HsmEventListener)eventListener);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new HsmException(471961604, classNotFoundException);
        }
    }

    public void run() {
        while (this.isPoling_) {
            try {
                boolean bl = this.checkStatus(0);
                Thread.sleep(this.hsmGatewaySettingData_.getPollSettingData().getInterval() * 1000);
            }
            catch (HsmException hsmException) {
                HsmErrorDlg hsmErrorDlg = new HsmErrorDlg(hsmException.getError(), this.hsmDocument_);
            }
            catch (InterruptedException interruptedException) {
                if (!this.isPoling_) continue;
                this.hsmDocument_.errorLogging(0, interruptedException.toString());
                System.out.println(interruptedException);
            }
        }
    }

    public HsmNodeData searchExpandChildNodes(HsmTreeData hsmTreeData, int n, int n2, Vector vector) throws HsmException {
        HsmHostNodeData hsmHostNodeData = hsmTreeData.searchHost(n);
        if (hsmHostNodeData == null) {
            return null;
        }
        HsmNodeData hsmNodeData = null;
        do {
            if ((hsmNodeData = hsmHostNodeData.getUnknownChild(n2)) == null) {
                return null;
            }
            if (hsmNodeData.getNodeType() != 393217) {
                return null;
            }
            HsmFuncNodeData hsmFuncNodeData = (HsmFuncNodeData)hsmNodeData;
            this.hsmDocument_.getChildTree(hsmFuncNodeData);
            HsmNodeData hsmNodeData2 = hsmTreeData.searchNode(n, n2, vector);
            if (hsmNodeData2 == null) continue;
            return hsmNodeData2;
        } while (hsmNodeData != null);
        return null;
    }

    public HsmNodeData searchFuncIdNode(int n, int n2, Vector vector) throws HsmException {
        HsmTreeData hsmTreeData = this.hsmDocument_.getSelectedTree();
        HsmNodeData hsmNodeData = hsmTreeData.searchNode(n, n2, vector);
        if (hsmNodeData == null) {
            hsmNodeData = this.searchExpandChildNodes(hsmTreeData, n, n2, vector);
        }
        if (hsmNodeData == null) {
            hsmNodeData = hsmTreeData.searchNode(n, n2, null);
        }
        if (hsmNodeData == null) {
            hsmNodeData = hsmTreeData.searchNode(n);
        }
        return hsmNodeData;
    }

    public void sendAlertEvent(Vector vector) {
        HsmEvent hsmEvent = new HsmEvent((Object)this, 65553, vector);
        this.sendEvent(hsmEvent);
    }

    public void sendEvent(HsmEvent hsmEvent) {
        if (this.nListeners_ == null) {
            return;
        }
        int n = 0;
        while (n < this.nListeners_.size()) {
            HsmEventListener hsmEventListener = (HsmEventListener)this.nListeners_.get(n);
            hsmEventListener.eventOccurred(hsmEvent);
            ++n;
        }
    }

    public void sendNodeStatChangedEvent() {
        HsmEvent hsmEvent = new HsmEvent(this, 65554);
        this.sendEvent(hsmEvent);
    }

    public void stop() {
        this.isPoling_ = false;
    }

    public void treeSelectionChanged(HsmEvent hsmEvent) {
        Vector vector = (Vector)hsmEvent.getOptionObj();
        if (vector != null && vector.size() > 0) {
            HsmNodeData hsmNodeData = (HsmNodeData)vector.get(0);
            this.hsmInfoPane_.setSelectedNode(hsmNodeData);
        }
    }
}

