/*
 * Decompiled with CFR 0.152.
 */
package JP.co.Hitachi.soft.System_Manager.console;

import JP.co.Hitachi.soft.System_Manager.console.HsmMarkButton;
import JP.co.Hitachi.soft.System_Manager.console.HsmScCalendarListener;
import JP.co.Hitachi.soft.System_Manager.console.HsmScDataExchanger;
import JP.co.Hitachi.soft.System_Manager.console.HsmScMarkPanel;
import JP.co.Hitachi.soft.System_Manager.console.HsmScPwClsDialog;
import JP.co.Hitachi.soft.System_Manager.console.HsmScRepExecDialog;
import JP.co.Hitachi.soft.System_Manager.console.HsmScRepUpdateDialog;
import JP.co.Hitachi.soft.System_Manager.console.HsmScTableModel;
import JP.co.Hitachi.soft.System_Manager.console.HsmScTableRenderer;
import JP.co.Hitachi.soft.System_Manager.console.HsmScUniCalendar;
import JP.co.Hitachi.soft.System_Manager.console.HsmScUtil;
import JP.co.Hitachi.soft.System_Manager.data.HsmNodeNameData;
import JP.co.Hitachi.soft.System_Manager.data.HsmOneDayScheduleData;
import JP.co.Hitachi.soft.System_Manager.data.HsmPwClsScheduleData;
import JP.co.Hitachi.soft.System_Manager.data.HsmReportScheduleData;
import JP.co.Hitachi.soft.System_Manager.data.HsmScheduleData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class HsmScCalendars
extends JPanel
implements HsmScDataExchanger,
HsmScCalendarListener,
ActionListener {
    HsmScDataExchanger exchanger;
    Frame frame;
    int nodeId = 0;
    HsmScheduleData scheduleData;
    Hashtable scheduleMap;
    int dateKey;
    int settingFlag;
    int thisYear;
    int thisMonth;
    int dispYear;
    int dispMonth;
    int markedYear = -100;
    int markedMonth = -100;
    int markedDayOfMonth = -100;
    int markedDayOfWeek = -100;
    HsmScUniCalendar[] hsmCalendar;
    HsmScTableModel model = new HsmScTableModel();
    JPanel calendarPanel = new JPanel();
    JTextField txtYear = new JTextField();
    HsmMarkButton mkbUp = new HsmMarkButton();
    HsmMarkButton mkbDown = new HsmMarkButton();
    HsmMarkButton mkbPrev = new HsmMarkButton();
    HsmMarkButton mkbNext = new HsmMarkButton();
    JPanel settingBtns = new JPanel();
    JRadioButton rbSingle = new JRadioButton();
    JRadioButton rbWeekly = new JRadioButton();
    JCheckBox chkAnual = new JCheckBox();
    JCheckBox chkMonthly = new JCheckBox();
    JCheckBox chkDaily = new JCheckBox();
    HsmScMarkPanel mkpSingle = new HsmScMarkPanel();
    HsmScMarkPanel mkpAnual = new HsmScMarkPanel();
    HsmScMarkPanel mkpMonthly = new HsmScMarkPanel();
    HsmScMarkPanel mkpDaily = new HsmScMarkPanel();
    HsmScMarkPanel mkpWeekly = new HsmScMarkPanel();
    JButton btnSetting = new JButton();
    JButton btnCopy = new JButton();
    JButton btnPaste = new JButton();
    JButton btnRemove = new JButton();
    JLabel lblSchedule = new JLabel();
    JScrollPane scSchedule = new JScrollPane();
    JTable tblSchedule = new JTable();
    JLabel lblScheduleNum = new JLabel();
    JLabel lblDate = new JLabel();
    JLabel lblDay = new JLabel();
    ButtonGroup grpSetting = new ButtonGroup();
    JComboBox cbHost = new JComboBox();
    JTextField txtHost = new JTextField();

    public HsmScCalendars() {
        this.getCurrentMonth();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("up")) {
            this.setYear(this.dispYear + 1);
        } else if (string.equals("down")) {
            this.setYear(this.dispYear - 1);
        } else if (string.equals("prev")) {
            this.rollMonth(false);
        } else if (string.equals("next")) {
            this.rollMonth(true);
        } else if (string.equals("single")) {
            if (this.settingFlag != 0) {
                this.chkAnual.setEnabled(true);
                this.chkMonthly.setEnabled(true);
                this.chkDaily.setEnabled(true);
                this.settingFlag = 0;
                this.clear();
            }
        } else if (string.equals("weekly")) {
            if (this.settingFlag != 1) {
                this.chkAnual.setEnabled(false);
                this.chkMonthly.setEnabled(false);
                this.chkDaily.setEnabled(false);
                this.settingFlag = 1;
                this.clear();
            }
        } else if (string.equals("anual")) {
            this.setMarkToCalendar();
        } else if (string.equals("monthly")) {
            this.setMarkToCalendar();
        } else if (string.equals("daily")) {
            this.setMarkToCalendar();
        } else if (string.equals("setting")) {
            this.popupSettingDialog();
            this.setScheduleMap();
        } else if (string.equals("host")) {
            HsmNodeNameData hsmNodeNameData = (HsmNodeNameData)this.cbHost.getSelectedItem();
            this.nodeId = hsmNodeNameData.getNodeId();
            this.scheduleData = this.exchanger.getScheduleData(this.nodeId);
            int n = 0;
            while (n < 3) {
                this.hsmCalendar[n].setScheduleData(this.scheduleData);
                ++n;
            }
            this.selectDate(this.markedYear, this.markedMonth, this.markedDayOfMonth, this.markedDayOfWeek);
            if (this.markedDayOfMonth == -100 && this.markedDayOfWeek == -100) {
                this.btnSetting.setEnabled(false);
            }
        } else if (!string.equals("copy") && !string.equals("paste")) {
            string.equals("remove");
        }
    }

    private void clear() {
        this.setSelection(-100, -100, -100, -100);
        int n = 0;
        while (n < this.hsmCalendar.length) {
            this.hsmCalendar[n].setSelectedDate(this.settingFlag, -100, -100, -100);
            this.hsmCalendar[n].setSelectedDay(this.settingFlag, -100);
            ++n;
        }
        this.btnSetting.setEnabled(false);
        this.lblSchedule.setText("\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb\u30ea\u30b9\u30c8\u8868\u793a\u6b04");
        this.model.clearOneDaySchedule();
    }

    private void createCalendars(Container container) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        this.dispYear = gregorianCalendar.get(1);
        this.dispMonth = gregorianCalendar.get(2) + 1;
        this.hsmCalendar = new HsmScUniCalendar[3];
        int n = 0;
        while (n < 3) {
            int n2 = gregorianCalendar.get(1);
            int n3 = gregorianCalendar.get(2) + 1;
            this.hsmCalendar[n] = new HsmScUniCalendar(n2, n3, this.scheduleData, this);
            container.add(this.hsmCalendar[n]);
            this.hsmCalendar[n].setBounds(150 * n, 5, 145, 225);
            this.hsmCalendar[n].createPanel();
            ((Calendar)gregorianCalendar).roll(2, true);
            ++n;
        }
    }

    public void createPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void getCurrentMonth() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        this.thisYear = gregorianCalendar.get(1);
        this.thisMonth = gregorianCalendar.get(2) + 1;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public HsmScheduleData getScheduleData(int n) {
        return this.exchanger.getScheduleData(n);
    }

    private int getSettingDateKey() {
        if (this.rbSingle.isSelected()) {
            int n = this.chkAnual.isSelected() ? -1 : this.markedYear;
            int n2 = this.chkMonthly.isSelected() ? -1 : this.markedMonth;
            int n3 = this.chkDaily.isSelected() ? -1 : this.markedDayOfMonth;
            int n4 = HsmScUtil.getDateKey(n, n2, n3);
            return n4;
        }
        return this.markedDayOfWeek;
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(600, 400));
        this.setLayout(null);
        this.calendarPanel.setBounds(new Rectangle(135, 30, 450, 235));
        this.calendarPanel.setLayout(null);
        this.createCalendars(this.calendarPanel);
        BevelBorder bevelBorder = new BevelBorder(1);
        this.txtYear.setText(String.valueOf(this.thisYear));
        this.txtYear.setEditable(false);
        this.txtYear.setBorder(bevelBorder);
        this.txtYear.setBackground(Color.white);
        this.txtYear.setBounds(new Rectangle(167, 5, 70, 20));
        this.mkbUp.setMark(0);
        this.mkbUp.setBounds(new Rectangle(237, 5, 10, 10));
        this.mkbDown.setMark(1);
        this.mkbDown.setBounds(new Rectangle(237, 15, 10, 10));
        this.mkbPrev.setMark(2);
        this.mkbPrev.setBounds(new Rectangle(300, 5, 50, 20));
        this.mkbNext.setMark(3);
        this.mkbNext.setBounds(new Rectangle(355, 5, 50, 20));
        this.setHsmScMarkButtonParam();
        TitledBorder titledBorder = new TitledBorder("\u9078\u629e\u65b9\u6cd5");
        this.settingBtns.setBorder(titledBorder);
        this.settingBtns.setBounds(new Rectangle(10, 120, 110, 140));
        this.settingBtns.setLayout(null);
        this.rbSingle.setText("\u65e5\u4ed8");
        this.rbSingle.setBounds(new Rectangle(15, 20, 60, 20));
        this.rbWeekly.setText("\u66dc\u65e5");
        this.rbWeekly.setBounds(new Rectangle(15, 108, 60, 20));
        this.setRbSettingParam();
        this.chkAnual.setText("\u6bce\u5e74");
        this.chkAnual.setBounds(new Rectangle(40, 42, 60, 20));
        this.chkMonthly.setText("\u6bce\u6708");
        this.chkMonthly.setBounds(new Rectangle(40, 64, 60, 20));
        this.chkDaily.setText("\u6bce\u65e5");
        this.chkDaily.setBounds(new Rectangle(40, 86, 60, 20));
        this.setChkSettingParam();
        this.settingBtns.add(this.rbSingle);
        this.settingBtns.add(this.chkAnual);
        this.settingBtns.add(this.chkMonthly);
        this.settingBtns.add(this.chkDaily);
        this.settingBtns.add(this.rbWeekly);
        this.mkpSingle.setMark(0, new Color(128, 128, 255));
        this.mkpSingle.setBounds(new Rectangle(77, 20, 30, 20));
        this.mkpWeekly.setMark(1, new Color(255, 128, 128));
        this.mkpWeekly.setBounds(new Rectangle(77, 108, 30, 20));
        this.settingBtns.add(this.mkpSingle);
        this.settingBtns.add(this.mkpAnual);
        this.settingBtns.add(this.mkpMonthly);
        this.settingBtns.add(this.mkpDaily);
        this.settingBtns.add(this.mkpWeekly);
        this.btnSetting.setText("\u8a2d\u5b9a");
        this.btnSetting.setBounds(new Rectangle(15, 270, 90, 20));
        this.btnCopy.setText("\u30b3\u30d4\u30fc");
        this.btnCopy.setBounds(new Rectangle(310, 270, 90, 20));
        this.btnPaste.setText("\u30da\u30fc\u30b9\u30c8");
        this.btnPaste.setBounds(new Rectangle(400, 270, 90, 20));
        this.btnRemove.setText("\u524a\u9664");
        this.btnRemove.setBounds(new Rectangle(490, 270, 90, 20));
        this.setButtonParam();
        this.lblSchedule.setBounds(new Rectangle(5, 295, 575, 20));
        this.setTableParam();
        this.scSchedule.setBounds(new Rectangle(5, 315, 575, 75));
        this.scSchedule.getViewport().setView(this.tblSchedule);
        this.lblScheduleNum.setText("\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb\u500b\u6570");
        this.lblScheduleNum.setBounds(new Rectangle(15, 40, 110, 20));
        this.lblDate.setText("\u7279\u5b9a\u65e5");
        this.lblDate.setBounds(new Rectangle(15, 70, 110, 20));
        this.lblDay.setText("\u66dc\u65e5");
        this.lblDay.setBounds(new Rectangle(15, 90, 110, 20));
        this.add(this.calendarPanel);
        this.add(this.txtYear);
        this.add(this.mkbUp);
        this.add(this.mkbDown);
        this.add(this.mkbPrev);
        this.add(this.mkbNext);
        this.add(this.settingBtns);
        this.add(this.btnSetting);
        this.add(this.btnCopy);
        this.add(this.btnPaste);
        this.add(this.btnRemove);
        this.add(this.lblSchedule);
        this.add(this.scSchedule);
        this.add(this.lblScheduleNum);
        this.add(this.lblDate);
        this.add(this.lblDay);
        switch (this.scheduleData.getScheduleId()) {
            case 0: {
                this.cbHost.setBounds(new Rectangle(10, 5, 110, 20));
                HsmPwClsScheduleData hsmPwClsScheduleData = (HsmPwClsScheduleData)this.scheduleData;
                int n = hsmPwClsScheduleData.getNodeNames().size();
                int n2 = 0;
                while (n2 < n) {
                    this.cbHost.addItem(hsmPwClsScheduleData.getNodeNames().elementAt(n2));
                    ++n2;
                }
                this.cbHost.setActionCommand("host");
                this.cbHost.addActionListener(this);
                this.add(this.cbHost);
                break;
            }
            case 1: {
                BevelBorder bevelBorder2 = new BevelBorder(1);
                this.txtHost.setBorder(bevelBorder2);
                HsmReportScheduleData hsmReportScheduleData = (HsmReportScheduleData)this.scheduleData;
                this.txtHost.setText(hsmReportScheduleData.getScheduleTitle());
                this.txtHost.setEditable(false);
                this.txtHost.setBounds(new Rectangle(10, 5, 110, 20));
                this.add(this.txtHost);
                break;
            }
        }
    }

    private void popupPwClsDialog() {
        HsmScPwClsDialog hsmScPwClsDialog = new HsmScPwClsDialog(this.frame);
        hsmScPwClsDialog.setExchanger(this);
        hsmScPwClsDialog.setSettingFlag(this.settingFlag);
        hsmScPwClsDialog.createDialog();
        hsmScPwClsDialog.setDateKey(this.getSettingDateKey());
        ((Component)hsmScPwClsDialog).setSize(580, 430);
        ((Component)hsmScPwClsDialog).setVisible(true);
    }

    private void popupRepExecDialog() {
        HsmScRepExecDialog hsmScRepExecDialog = new HsmScRepExecDialog(this.frame);
        hsmScRepExecDialog.setExchanger(this);
        hsmScRepExecDialog.setSettingFlag(this.settingFlag);
        hsmScRepExecDialog.createDialog();
        hsmScRepExecDialog.setDateKey(this.getSettingDateKey());
        ((Component)hsmScRepExecDialog).setSize(580, 430);
        ((Component)hsmScRepExecDialog).setVisible(true);
    }

    private void popupRepUpdateDialog() {
        HsmScRepUpdateDialog hsmScRepUpdateDialog = new HsmScRepUpdateDialog(this.frame);
        hsmScRepUpdateDialog.setExchanger(this);
        hsmScRepUpdateDialog.setSettingFlag(this.settingFlag);
        hsmScRepUpdateDialog.createDialog();
        hsmScRepUpdateDialog.setDateKey(this.getSettingDateKey());
        ((Component)hsmScRepUpdateDialog).setSize(580, 430);
        ((Component)hsmScRepUpdateDialog).setVisible(true);
    }

    private void popupSettingDialog() {
        switch (this.scheduleData.getScheduleId()) {
            case 0: {
                this.popupPwClsDialog();
                break;
            }
            case 1: {
                this.popupRepExecDialog();
                break;
            }
            case 2: {
                this.popupRepUpdateDialog();
                break;
            }
        }
    }

    private void rollMonth(boolean bl) {
        GregorianCalendar gregorianCalendar = bl ? new GregorianCalendar(this.dispYear, this.dispMonth - 1 + 1, 1) : new GregorianCalendar(this.dispYear, this.dispMonth - 1 - 1, 1);
        this.setCalendars(gregorianCalendar);
    }

    public void selectDate(int n, int n2, int n3, int n4) {
        if (this.settingFlag == 1) {
            this.selectDay(n4);
            return;
        }
        this.setSelection(n, n2, n3, -100);
        this.setMarkToCalendar();
        if (n3 != -100) {
            String string = HsmScUtil.getDateString(n, n2, n3);
            this.lblSchedule.setText(String.valueOf(string) + "\u306e\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb");
            this.scheduleMap = this.scheduleData.getDaysMap();
            this.dateKey = HsmScUtil.getDateKey(n, n2, n3);
            this.setScheduleMap();
        }
    }

    public void selectDay(int n) {
        if (this.settingFlag != 1) {
            return;
        }
        this.setSelection(-100, -100, -100, n);
        int n2 = 0;
        while (n2 < this.hsmCalendar.length) {
            this.hsmCalendar[n2].setSelectedDate(this.settingFlag, -100, -100, -100);
            this.hsmCalendar[n2].setSelectedDay(this.settingFlag, n);
            ++n2;
        }
        if (n != -100) {
            String string = HsmScUtil.getDateString(n);
            this.lblSchedule.setText(String.valueOf(string) + "\u306e\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb");
            this.scheduleMap = this.scheduleData.getWeeklyMap();
            this.dateKey = n;
            this.setScheduleMap();
        }
    }

    private void setButtonParam() {
        this.btnSetting.setActionCommand("setting");
        this.btnCopy.setActionCommand("copy");
        this.btnPaste.setActionCommand("paste");
        this.btnRemove.setActionCommand("remove");
        this.btnSetting.addActionListener(this);
        this.btnCopy.addActionListener(this);
        this.btnPaste.addActionListener(this);
        this.btnRemove.addActionListener(this);
    }

    private void setCalendars(Calendar calendar) {
        int n = calendar.get(1);
        int n2 = calendar.get(2) + 1;
        int n3 = 0;
        while (n3 < 3) {
            int n4 = calendar.get(1);
            int n5 = calendar.get(2) + 1;
            this.hsmCalendar[n3].setYearMonth(n4, n5);
            calendar.set(n4, n5 - 1 + 1, 1);
            ++n3;
        }
        this.dispMonth = n2;
        if (this.dispYear != n) {
            this.dispYear = n;
            this.txtYear.setText(String.valueOf(n));
        }
        this.selectDate(this.markedYear, this.markedMonth, this.markedDayOfMonth, this.markedDayOfWeek);
        this.selectDay(this.markedDayOfWeek);
    }

    private void setChkSettingParam() {
        this.chkAnual.setActionCommand("anual");
        this.chkMonthly.setActionCommand("monthly");
        this.chkDaily.setActionCommand("daily");
        this.chkAnual.addActionListener(this);
        this.chkMonthly.addActionListener(this);
        this.chkDaily.addActionListener(this);
    }

    public void setExchanger(HsmScDataExchanger hsmScDataExchanger) {
        this.exchanger = hsmScDataExchanger;
        this.nodeId = hsmScDataExchanger.getNodeId();
        this.scheduleData = hsmScDataExchanger.getScheduleData(this.nodeId);
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    private void setHsmScMarkButtonParam() {
        this.mkbUp.setActionCommand("up");
        this.mkbDown.setActionCommand("down");
        this.mkbPrev.setActionCommand("prev");
        this.mkbNext.setActionCommand("next");
        this.mkbUp.addActionListener(this);
        this.mkbDown.addActionListener(this);
        this.mkbPrev.addActionListener(this);
        this.mkbNext.addActionListener(this);
    }

    private void setMarkToCalendar() {
        int n = this.chkAnual.isSelected() ? -1 : this.markedYear;
        int n2 = this.chkMonthly.isSelected() ? -1 : this.markedMonth;
        int n3 = this.chkDaily.isSelected() ? -1 : this.markedDayOfMonth;
        int n4 = 0;
        while (n4 < this.hsmCalendar.length) {
            this.hsmCalendar[n4].setSelectedDay(this.settingFlag, -100);
            this.hsmCalendar[n4].setSelectedDate(this.settingFlag, n, n2, n3);
            ++n4;
        }
    }

    private void setRbSettingParam() {
        this.rbSingle.setActionCommand("single");
        this.rbWeekly.setActionCommand("weekly");
        this.rbSingle.addActionListener(this);
        this.rbWeekly.addActionListener(this);
        this.grpSetting.add(this.rbSingle);
        this.grpSetting.add(this.rbWeekly);
        this.settingFlag = 0;
        this.rbSingle.setSelected(true);
        this.clear();
    }

    public void setScheduleData(int n, HsmScheduleData hsmScheduleData) {
        if (n == this.nodeId) {
            this.scheduleData = hsmScheduleData;
        }
        this.scheduleMap = this.dateKey >= 0 && this.dateKey < 7 ? hsmScheduleData.getWeeklyMap() : hsmScheduleData.getDaysMap();
        this.exchanger.setScheduleData(n, hsmScheduleData);
        int n2 = 0;
        while (n2 < 3) {
            this.hsmCalendar[n2].setScheduleData(hsmScheduleData);
            ++n2;
        }
        this.selectDate(this.markedYear, this.markedMonth, this.markedDayOfMonth, this.markedDayOfWeek);
    }

    private void setScheduleMap() {
        if (this.scheduleMap == null) {
            return;
        }
        if (this.settingFlag == 1) {
            if (this.scheduleMap.containsKey(new Integer(this.dateKey))) {
                HsmOneDayScheduleData hsmOneDayScheduleData = (HsmOneDayScheduleData)this.scheduleMap.get(new Integer(this.dateKey));
                this.model.setOneDaySchedule(hsmOneDayScheduleData.getTimeSchedule(), this.dateKey);
            } else {
                this.model.clearOneDaySchedule();
            }
        } else {
            Vector vector = HsmScUtil.getSingleKeys(this.scheduleMap, this.dateKey);
            int n = vector.size();
            if (n > 0) {
                int n2 = 0;
                while (n2 < n) {
                    Integer n3 = (Integer)vector.elementAt(n2);
                    HsmOneDayScheduleData hsmOneDayScheduleData = (HsmOneDayScheduleData)this.scheduleMap.get(n3);
                    if (n2 == 0) {
                        this.model.setOneDaySchedule(hsmOneDayScheduleData.getTimeSchedule(), n3);
                    } else {
                        this.model.addOneDaySchedule(hsmOneDayScheduleData.getTimeSchedule(), n3);
                    }
                    ++n2;
                }
            } else {
                this.model.clearOneDaySchedule();
            }
        }
    }

    private void setSelection(int n, int n2, int n3, int n4) {
        if (!this.btnSetting.isEnabled()) {
            this.btnSetting.setEnabled(true);
        }
        this.markedYear = n;
        this.markedMonth = n2;
        this.markedDayOfMonth = n3;
        this.markedDayOfWeek = n4;
    }

    private void setTableParam() {
        this.model.setType(1);
        this.model.setScheduleId(this.scheduleData.getScheduleId());
        this.tblSchedule.setModel(this.model);
        this.tblSchedule.setShowGrid(false);
        TableColumnModel tableColumnModel = this.tblSchedule.getColumnModel();
        int n = this.tblSchedule.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnModel.getColumn(n2);
            HsmScTableRenderer hsmScTableRenderer = new HsmScTableRenderer();
            hsmScTableRenderer.setMode(0);
            tableColumn.setCellRenderer(hsmScTableRenderer);
            if (n2 == 2) {
                tableColumn.setPreferredWidth(350);
            }
            ++n2;
        }
    }

    private void setYear(int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, this.dispMonth - 1, 1);
        this.setCalendars(gregorianCalendar);
    }
}

