/*
 * Decompiled with CFR 0.152.
 */
package JP.co.Hitachi.soft.System_Manager.console;

import JP.co.Hitachi.soft.System_Manager.console.HsmScCbItem;
import JP.co.Hitachi.soft.System_Manager.console.HsmScDataExchanger;
import JP.co.Hitachi.soft.System_Manager.console.HsmScPwClsListener;
import JP.co.Hitachi.soft.System_Manager.data.HsmNodeNameData;
import JP.co.Hitachi.soft.System_Manager.data.HsmOneDayScheduleData;
import JP.co.Hitachi.soft.System_Manager.data.HsmPwClsScheduleData;
import JP.co.Hitachi.soft.System_Manager.data.HsmPwClsTimeScheduleData;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HsmScClusterSetting
extends JPanel
implements ActionListener {
    int hour;
    int minute;
    int setting;
    int nodeSelect;
    String groupName = new String();
    String nodeName = new String();
    HsmScPwClsListener listener;
    HsmScDataExchanger exchanger;
    int nodeId;
    int dateKey;
    JLabel lblGroup = new JLabel();
    JLabel lblTime = new JLabel();
    JLabel lblMoveTo = new JLabel();
    JLabel lblState = new JLabel();
    JLabel lblHour = new JLabel();
    JLabel lblMinute = new JLabel();
    JComboBox cbGroup = new JComboBox();
    JComboBox cbHour = new JComboBox();
    JComboBox cbMinute = new JComboBox();
    JComboBox cbMoveTo = new JComboBox();
    JComboBox cbState = new JComboBox();

    HsmScClusterSetting() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("group")) {
            this.groupName = (String)this.cbGroup.getSelectedItem();
            this.checkDataValidity();
        } else if (string.equals("move")) {
            Object object = this.cbMoveTo.getSelectedItem();
            HsmScCbItem hsmScCbItem = (HsmScCbItem)object;
            this.nodeSelect = hsmScCbItem.getNodeSelect();
            if (this.nodeSelect == 2) {
                this.nodeName = hsmScCbItem.toString();
            }
        } else if (string.equals("state")) {
            Object object = this.cbState.getSelectedItem();
            HsmScCbItem hsmScCbItem = (HsmScCbItem)object;
            this.setting = hsmScCbItem.getSetting();
        } else if (string.equals("hour")) {
            this.hour = this.cbHour.getSelectedIndex();
            this.checkDataValidity();
        } else if (string.equals("minute")) {
            this.minute = this.cbMinute.getSelectedIndex();
            this.checkDataValidity();
        }
    }

    public void checkDataValidity() {
        HsmPwClsScheduleData hsmPwClsScheduleData = (HsmPwClsScheduleData)this.exchanger.getScheduleData(this.nodeId);
        HsmOneDayScheduleData hsmOneDayScheduleData = null;
        hsmOneDayScheduleData = this.dateKey >= 0 && this.dateKey < 7 ? hsmPwClsScheduleData.getWeeklyData(this.dateKey) : hsmPwClsScheduleData.getDayData(this.dateKey);
        if (hsmOneDayScheduleData == null) {
            this.listener.setSettingButton(true);
            return;
        }
        int n = (this.hour << 8) + this.minute;
        Vector vector = hsmOneDayScheduleData.getTimeSchedule();
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            Object e = vector.elementAt(n3);
            HsmPwClsTimeScheduleData hsmPwClsTimeScheduleData = (HsmPwClsTimeScheduleData)e;
            int n4 = hsmPwClsTimeScheduleData.getTimeKey();
            byte by = hsmPwClsTimeScheduleData.getSetting();
            if (n >= n4 - 5 && n <= n4 + 5) {
                if (by == 1 || by == 2) {
                    this.listener.setSettingButton(false);
                    return;
                }
                String string = hsmPwClsTimeScheduleData.getGroupName();
                if (string.equals(this.groupName)) {
                    this.listener.setSettingButton(false);
                    return;
                }
            }
            ++n3;
        }
        this.listener.setSettingButton(true);
    }

    public void createPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public HsmPwClsTimeScheduleData getData() {
        HsmPwClsTimeScheduleData hsmPwClsTimeScheduleData = new HsmPwClsTimeScheduleData();
        int n = (this.hour << 8) + this.minute;
        hsmPwClsTimeScheduleData.setTimeKey(n);
        hsmPwClsTimeScheduleData.setSetting((byte)this.setting);
        hsmPwClsTimeScheduleData.setHour((byte)this.hour);
        hsmPwClsTimeScheduleData.setMinute((byte)this.minute);
        hsmPwClsTimeScheduleData.setNodeSelect(this.nodeSelect);
        hsmPwClsTimeScheduleData.setGroupName(this.groupName);
        hsmPwClsTimeScheduleData.setNodeName(this.nodeName);
        return hsmPwClsTimeScheduleData;
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(390, 115));
        this.setLayout(null);
        this.lblGroup.setText("\u5bfe\u8c61\u30b0\u30eb\u30fc\u30d7");
        this.lblGroup.setBounds(new Rectangle(20, 60, 95, 20));
        this.cbGroup.setBounds(new Rectangle(30, 85, 150, 20));
        this.lblTime.setText("\u6642\u523b");
        this.lblTime.setBounds(new Rectangle(20, 5, 40, 20));
        this.cbHour.setBounds(new Rectangle(30, 30, 50, 20));
        this.lblHour.setText("\u6642");
        this.lblHour.setBounds(new Rectangle(85, 30, 20, 20));
        this.cbMinute.setBounds(new Rectangle(110, 30, 50, 20));
        this.lblMinute.setText("\u5206");
        this.lblMinute.setBounds(new Rectangle(165, 30, 25, 20));
        this.lblMoveTo.setText("\u79fb\u52d5\u5148\u30ce\u30fc\u30c9");
        this.lblMoveTo.setBounds(new Rectangle(200, 5, 100, 20));
        this.lblState.setText("\u72b6\u614b");
        this.lblState.setBounds(new Rectangle(200, 60, 100, 20));
        this.cbMoveTo.setBounds(new Rectangle(210, 30, 150, 20));
        this.cbState.setBounds(new Rectangle(210, 85, 150, 20));
        this.add(this.lblTime);
        this.add(this.lblHour);
        this.add(this.lblGroup);
        this.add(this.lblMinute);
        this.add(this.lblMoveTo);
        this.add(this.lblState);
        this.add(this.cbGroup);
        this.add(this.cbHour);
        this.add(this.cbMinute);
        this.add(this.cbMoveTo);
        this.add(this.cbState);
        this.setComboBoxParam();
    }

    private void setCbGroupParam(HsmPwClsScheduleData hsmPwClsScheduleData) {
        Vector vector = hsmPwClsScheduleData.getGroupNames();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = vector.elementAt(n2);
            String string = (String)e;
            this.cbGroup.addItem(string);
            ++n2;
        }
        this.cbGroup.setActionCommand("group");
        this.cbGroup.addActionListener(this);
        this.cbGroup.setSelectedItem(vector.elementAt(0));
        this.groupName = (String)vector.elementAt(0);
    }

    private void setCbHourParam() {
        int n = 0;
        while (n < 24) {
            String string = n < 10 ? "0" + n : String.valueOf(n);
            this.cbHour.addItem(string);
            ++n;
        }
        this.cbHour.setActionCommand("hour");
        this.cbHour.addActionListener(this);
        this.cbHour.setSelectedIndex(0);
        this.hour = 0;
    }

    private void setCbMinuteParam() {
        int n = 0;
        while (n < 60) {
            String string = n < 10 ? "0" + n : String.valueOf(n);
            this.cbMinute.addItem(string);
            ++n;
        }
        this.cbMinute.setActionCommand("minute");
        this.cbMinute.addActionListener(this);
        this.cbMinute.setSelectedIndex(0);
        this.minute = 0;
    }

    private void setCbMoveToParam(HsmPwClsScheduleData hsmPwClsScheduleData) {
        HsmScCbItem hsmScCbItem = new HsmScCbItem();
        hsmScCbItem.setNodeSelect(0);
        hsmScCbItem.setStrDisplay("\u30aa\u30fc\u30ca\u30fc\u30ce\u30fc\u30c9");
        this.cbMoveTo.addItem(hsmScCbItem);
        HsmScCbItem hsmScCbItem2 = new HsmScCbItem();
        hsmScCbItem2.setNodeSelect(1);
        hsmScCbItem2.setStrDisplay("\u30aa\u30fc\u30ca\u30fc\u30ce\u30fc\u30c9\u4ee5\u5916");
        this.cbMoveTo.addItem(hsmScCbItem2);
        Vector vector = hsmPwClsScheduleData.getNodeNames();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = vector.elementAt(n2);
            HsmNodeNameData hsmNodeNameData = (HsmNodeNameData)e;
            HsmScCbItem hsmScCbItem3 = new HsmScCbItem();
            hsmScCbItem3.setNodeSelect(2);
            hsmScCbItem3.setStrDisplay(new String(hsmNodeNameData.getNodeName()));
            this.cbMoveTo.addItem(hsmScCbItem3);
            ++n2;
        }
        this.cbMoveTo.setActionCommand("move");
        this.cbMoveTo.addActionListener(this);
        this.cbMoveTo.setSelectedItem(hsmScCbItem);
        this.nodeSelect = 0;
    }

    private void setCbStateParam(HsmPwClsScheduleData hsmPwClsScheduleData) {
        HsmScCbItem hsmScCbItem = new HsmScCbItem();
        hsmScCbItem.setSetting(17);
        hsmScCbItem.setStrDisplay("OnLine");
        this.cbState.addItem(hsmScCbItem);
        HsmScCbItem hsmScCbItem2 = new HsmScCbItem();
        hsmScCbItem2.setSetting(18);
        hsmScCbItem2.setStrDisplay("OffLine");
        this.cbState.addItem(hsmScCbItem2);
        HsmScCbItem hsmScCbItem3 = new HsmScCbItem();
        hsmScCbItem3.setSetting(19);
        hsmScCbItem3.setStrDisplay("\u72b6\u614b\u5909\u5316\u306a\u3057");
        this.cbState.addItem(hsmScCbItem3);
        this.cbState.setActionCommand("state");
        this.cbState.addActionListener(this);
        this.cbState.setSelectedItem(hsmScCbItem);
        this.setting = 17;
    }

    private void setComboBoxParam() {
        int n = this.exchanger.getNodeId();
        HsmPwClsScheduleData hsmPwClsScheduleData = (HsmPwClsScheduleData)this.exchanger.getScheduleData(n);
        this.setCbGroupParam(hsmPwClsScheduleData);
        this.setCbMoveToParam(hsmPwClsScheduleData);
        this.setCbStateParam(hsmPwClsScheduleData);
        this.setCbHourParam();
        this.setCbMinuteParam();
    }

    public void setDateKey(int n) {
        this.dateKey = n;
        this.checkDataValidity();
    }

    public void setExchanger(HsmScDataExchanger hsmScDataExchanger) {
        this.exchanger = hsmScDataExchanger;
        this.nodeId = hsmScDataExchanger.getNodeId();
    }

    public void setPwClsListener(HsmScPwClsListener hsmScPwClsListener) {
        this.listener = hsmScPwClsListener;
    }
}

