/*
 * Decompiled with CFR 0.152.
 */
package JP.co.Hitachi.soft.System_Manager.console;

import JP.co.Hitachi.soft.System_Manager.console.HsmScCalendarListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JPanel;

class HsmScDateCell
extends JPanel {
    static final int NOT_SELECTED = 0;
    static final int CAN_SET = 1;
    static final int CANNOT_SET = 2;
    int selectFlag;
    int settingFlag;
    boolean enabled = true;
    boolean singleSetting = false;
    boolean weeklySetting = false;
    Vector scheduleData = new Vector();
    HsmScCalendarListener listener;
    int year = -100;
    int month = -100;
    int dayOfMonth = -100;
    int dayOfWeek = -100;

    HsmScDateCell(HsmScCalendarListener hsmScCalendarListener) {
        this.listener = hsmScCalendarListener;
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                HsmScDateCell.this.select();
            }
        });
    }

    public void initData() {
        this.selectFlag = 0;
        this.settingFlag = -1;
        this.enabled = true;
        this.singleSetting = false;
        this.weeklySetting = false;
        if (!this.scheduleData.isEmpty()) {
            this.scheduleData.clear();
        }
    }

    public void paint(Graphics graphics) {
        if (this.dayOfMonth == -100) {
            return;
        }
        int n = this.getWidth();
        int n2 = this.getHeight();
        Color color = graphics.getColor();
        Font font = graphics.getFont();
        if (!this.enabled) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n - 1, n2 - 1);
            graphics.setColor(color);
            return;
        }
        Font font2 = null;
        Color color2 = Color.white;
        Color color3 = Color.black;
        if (this.selectFlag == 1) {
            font2 = new Font("SansSerif", 1, 12);
            color2 = new Color(128, 0, 0);
            color3 = Color.white;
        } else if (this.selectFlag == 2) {
            font2 = new Font("SansSerif", 1, 12);
            color2 = Color.yellow;
            color3 = Color.black;
        } else if (this.selectFlag == 0) {
            font2 = new Font("SansSerif", 0, 12);
        }
        graphics.setColor(color2);
        graphics.fillRect(0, 0, n - 1, n2 - 1);
        graphics.setColor(Color.black);
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(font2);
        String string = String.valueOf(this.dayOfMonth);
        int n3 = fontMetrics.stringWidth(string);
        int n4 = (n - n3) / 2;
        graphics.setColor(color3);
        graphics.drawString(string, n4, 12);
        if (this.singleSetting) {
            graphics.setColor(new Color(128, 128, 255));
            graphics.fillOval(5, 15, n - 10, n - 10);
            graphics.setColor(Color.black);
            graphics.drawOval(5, 15, n - 10, n - 10);
        } else if (this.weeklySetting) {
            graphics.setColor(new Color(255, 128, 128));
            Polygon polygon = new Polygon();
            polygon.addPoint(10, 15);
            polygon.addPoint(4, 25);
            polygon.addPoint(16, 25);
            graphics.fillPolygon(polygon);
            graphics.setColor(Color.black);
            graphics.drawPolygon(polygon);
        }
        graphics.setColor(color);
    }

    private void select() {
        if (this.dayOfMonth > 0) {
            this.listener.selectDate(this.year, this.month, this.dayOfMonth, this.dayOfWeek);
        }
    }

    public void selectDate(int n, int n2, int n3, int n4) {
        this.settingFlag = n;
        switch (n) {
            case 0: {
                if (!(n2 != this.year && n2 != -1 || n3 != this.month && n3 != -1 || n4 != this.dayOfMonth && n4 != -1)) {
                    this.selectFlag = 1;
                    break;
                }
                this.selectFlag = 0;
                break;
            }
        }
    }

    public void selectDay(int n, int n2) {
        this.settingFlag = n;
        if (n == 1) {
            this.selectFlag = this.dayOfWeek == n2 ? (!this.singleSetting ? 1 : 2) : 0;
        }
    }

    public void setDate(int n, int n2, int n3, int n4) {
        this.year = n;
        this.month = n2;
        this.dayOfMonth = n3;
        this.dayOfWeek = n4;
        this.repaint();
    }

    public void setExistence(boolean bl) {
        this.enabled = bl;
    }

    public void setSingleSetting(boolean bl) {
        this.singleSetting = bl;
    }

    public void setWeeklySetting(boolean bl) {
        this.weeklySetting = bl;
    }
}

