/*
 * Decompiled with CFR 0.152.
 */
package JP.co.Hitachi.soft.System_Manager.console;

import JP.co.Hitachi.soft.System_Manager.console.HsmScDataExchanger;
import JP.co.Hitachi.soft.System_Manager.console.HsmScPwClsListener;
import JP.co.Hitachi.soft.System_Manager.data.HsmOneDayScheduleData;
import JP.co.Hitachi.soft.System_Manager.data.HsmPwClsScheduleData;
import JP.co.Hitachi.soft.System_Manager.data.HsmPwClsTimeScheduleData;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class HsmScPowerSetting
extends JPanel
implements ActionListener {
    int hour;
    int minute;
    int setting;
    HsmScPwClsListener listener;
    HsmScDataExchanger exchanger;
    int dateKey;
    int nodeId;
    JLabel lblTime = new JLabel();
    JComboBox cbHour = new JComboBox();
    JComboBox cbMinute = new JComboBox();
    JLabel lblHour = new JLabel();
    JLabel lblMinute = new JLabel();
    JLabel lblAction = new JLabel();
    JRadioButton rbPowerOn = new JRadioButton();
    JRadioButton rbPowerOff = new JRadioButton();
    ButtonGroup group = new ButtonGroup();

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("poweron")) {
            this.setting = 1;
        } else if (string.equals("poweroff")) {
            this.setting = 2;
        } else if (string.equals("hour")) {
            this.hour = this.cbHour.getSelectedIndex();
            this.checkDataValidity();
        } else if (string.equals("minute")) {
            this.minute = this.cbMinute.getSelectedIndex();
            this.checkDataValidity();
        }
    }

    public void checkDataValidity() {
        HsmPwClsScheduleData hsmPwClsScheduleData = (HsmPwClsScheduleData)this.exchanger.getScheduleData(this.nodeId);
        HsmOneDayScheduleData hsmOneDayScheduleData = null;
        hsmOneDayScheduleData = this.dateKey >= 0 && this.dateKey < 7 ? hsmPwClsScheduleData.getWeeklyData(this.dateKey) : hsmPwClsScheduleData.getDayData(this.dateKey);
        if (hsmOneDayScheduleData == null) {
            this.listener.setSettingButton(true);
            return;
        }
        int n = (this.hour << 8) + this.minute;
        Vector vector = hsmOneDayScheduleData.getTimeSchedule();
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            Object e = vector.elementAt(n3);
            HsmPwClsTimeScheduleData hsmPwClsTimeScheduleData = (HsmPwClsTimeScheduleData)e;
            int n4 = hsmPwClsTimeScheduleData.getTimeKey();
            if (n >= n4 - 5 && n <= n4 + 5) {
                this.listener.setSettingButton(false);
                return;
            }
            ++n3;
        }
        this.listener.setSettingButton(true);
    }

    public void createPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public HsmPwClsTimeScheduleData getData() {
        HsmPwClsTimeScheduleData hsmPwClsTimeScheduleData = new HsmPwClsTimeScheduleData();
        int n = (this.hour << 8) + this.minute;
        hsmPwClsTimeScheduleData.setTimeKey(n);
        hsmPwClsTimeScheduleData.setSetting((byte)this.setting);
        hsmPwClsTimeScheduleData.setHour((byte)this.hour);
        hsmPwClsTimeScheduleData.setMinute((byte)this.minute);
        return hsmPwClsTimeScheduleData;
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(390, 115));
        this.setLayout(null);
        this.lblTime.setText("\u6642\u523b");
        this.lblTime.setBounds(new Rectangle(20, 5, 40, 20));
        this.cbHour.setBounds(new Rectangle(30, 30, 50, 20));
        this.lblHour.setText("\u6642");
        this.lblHour.setBounds(new Rectangle(85, 30, 20, 20));
        this.cbMinute.setBounds(new Rectangle(110, 30, 50, 20));
        this.lblMinute.setText("\u5206");
        this.lblMinute.setBounds(new Rectangle(165, 30, 25, 20));
        this.lblAction.setText("\u52d5\u4f5c");
        this.lblAction.setBounds(new Rectangle(200, 5, 100, 20));
        this.rbPowerOn.setText("\u96fb\u6e90ON");
        this.rbPowerOn.setBounds(new Rectangle(210, 35, 120, 20));
        this.rbPowerOff.setText("\u96fb\u6e90OFF");
        this.rbPowerOff.setBounds(new Rectangle(210, 60, 120, 20));
        this.setComboBoxParam();
        this.setRbParam();
        this.add(this.lblTime);
        this.add(this.lblAction);
        this.add(this.cbHour);
        this.add(this.cbMinute);
        this.add(this.lblHour);
        this.add(this.lblMinute);
        this.add(this.rbPowerOn);
        this.add(this.rbPowerOff);
    }

    private void setCbHourParam() {
        int n = 0;
        while (n < 24) {
            String string = n < 10 ? "0" + n : String.valueOf(n);
            this.cbHour.addItem(string);
            ++n;
        }
        this.cbHour.setActionCommand("hour");
        this.cbHour.addActionListener(this);
        this.cbHour.setSelectedIndex(0);
        this.hour = 0;
    }

    private void setCbMinuteParam() {
        int n = 0;
        while (n < 60) {
            String string = n < 10 ? "0" + n : String.valueOf(n);
            this.cbMinute.addItem(string);
            ++n;
        }
        this.cbMinute.setActionCommand("minute");
        this.cbMinute.addActionListener(this);
        this.cbMinute.setSelectedIndex(0);
        this.minute = 0;
    }

    private void setComboBoxParam() {
        this.setCbHourParam();
        this.setCbMinuteParam();
    }

    public void setDateKey(int n) {
        this.dateKey = n;
        this.checkDataValidity();
    }

    public void setExchanger(HsmScDataExchanger hsmScDataExchanger) {
        this.exchanger = hsmScDataExchanger;
        this.nodeId = hsmScDataExchanger.getNodeId();
    }

    public void setPwClsListener(HsmScPwClsListener hsmScPwClsListener) {
        this.listener = hsmScPwClsListener;
    }

    private void setRbParam() {
        this.group.add(this.rbPowerOn);
        this.group.add(this.rbPowerOff);
        this.rbPowerOn.setActionCommand("poweron");
        this.rbPowerOff.setActionCommand("poweroff");
        this.rbPowerOn.addActionListener(this);
        this.rbPowerOff.addActionListener(this);
        this.rbPowerOn.setSelected(true);
        this.setting = 1;
    }
}

