/*
 * Decompiled with CFR 0.152.
 */
package JP.co.Hitachi.soft.System_Manager.console;

import JP.co.Hitachi.soft.System_Manager.console.HsmScClusterSetting;
import JP.co.Hitachi.soft.System_Manager.console.HsmScDataExchanger;
import JP.co.Hitachi.soft.System_Manager.console.HsmScPowerSetting;
import JP.co.Hitachi.soft.System_Manager.console.HsmScPwClsListener;
import JP.co.Hitachi.soft.System_Manager.console.HsmScPwClsRefDialog;
import JP.co.Hitachi.soft.System_Manager.console.HsmScTableCell;
import JP.co.Hitachi.soft.System_Manager.console.HsmScTableModel;
import JP.co.Hitachi.soft.System_Manager.console.HsmScTableRenderer;
import JP.co.Hitachi.soft.System_Manager.console.HsmScUtil;
import JP.co.Hitachi.soft.System_Manager.data.HsmNodeNameData;
import JP.co.Hitachi.soft.System_Manager.data.HsmOneDayScheduleData;
import JP.co.Hitachi.soft.System_Manager.data.HsmPwClsScheduleData;
import JP.co.Hitachi.soft.System_Manager.data.HsmPwClsTimeScheduleData;
import JP.co.Hitachi.soft.System_Manager.data.HsmScheduleData;
import JP.co.Hitachi.soft.System_Manager.data.HsmTimeScheduleData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class HsmScPwClsDialog
extends JDialog
implements HsmScDataExchanger,
HsmScPwClsListener,
ActionListener,
ChangeListener,
TableModelListener,
ListSelectionListener {
    HsmScDataExchanger exchanger;
    HsmPwClsScheduleData scheduleData;
    int settingFlag;
    Hashtable scheduleMap;
    int nodeId;
    int dateKey;
    Hashtable schedules = new Hashtable();
    HsmScTableModel model = new HsmScTableModel();
    HsmScPowerSetting powerSetting = new HsmScPowerSetting();
    HsmScClusterSetting clusterSetting = new HsmScClusterSetting();
    boolean updateFlag = false;
    JPanel panel = new JPanel();
    JLabel lblDate = new JLabel();
    JLabel lblNode = new JLabel();
    JLabel lblRef = new JLabel();
    JLabel lblSchedule = new JLabel();
    JLabel lblPower = new JLabel();
    JLabel lblCluster = new JLabel();
    JButton btnRef = new JButton();
    JButton btnSet = new JButton();
    JButton btnRemove = new JButton();
    JButton btnOk = new JButton();
    JButton btnCancel = new JButton();
    JTabbedPane settingPanel = new JTabbedPane();
    JScrollPane scSchedule = new JScrollPane();
    JTable tblSchedule = new JTable();

    HsmScPwClsDialog(Frame frame) {
        super(frame, true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ref")) {
            this.popupRefDialog();
        } else if (string.equals("set")) {
            Serializable serializable;
            Integer n = new Integer(this.dateKey);
            Object v = this.scheduleMap.get(n);
            if (v == null) {
                serializable = new HsmOneDayScheduleData();
                ((HsmOneDayScheduleData)serializable).setDateKey(this.dateKey);
                ((HsmOneDayScheduleData)serializable).setYear(HsmScUtil.getYear(this.dateKey));
                ((HsmOneDayScheduleData)serializable).setMonth(HsmScUtil.getMonth(this.dateKey));
                ((HsmOneDayScheduleData)serializable).setDayOfMonth(HsmScUtil.getDayOfMonth(this.dateKey));
                this.scheduleMap.put(n, serializable);
                this.model.setOneDaySchedule(((HsmOneDayScheduleData)serializable).getTimeSchedule(), this.dateKey);
            }
            if ((serializable = this.settingPanel.getSelectedComponent()) instanceof HsmScPowerSetting) {
                this.addPowerScheduleData();
            } else if (serializable instanceof HsmScClusterSetting) {
                this.addClusterScheduleData();
            }
            if (!this.updateFlag) {
                this.btnOk.setEnabled(true);
                this.updateFlag = true;
            }
        } else if (string.equals("remove")) {
            this.removeScheduleData();
            if (!this.updateFlag) {
                this.btnOk.setEnabled(true);
                this.updateFlag = true;
            }
        } else if (string.equals("ok")) {
            this.updateScheduleData();
            this.dispose();
        } else if (string.equals("cancel")) {
            this.dispose();
        }
    }

    private void addClusterScheduleData() {
        HsmPwClsTimeScheduleData hsmPwClsTimeScheduleData = this.clusterSetting.getData();
        Vector vector = this.scheduleData.getNodeNames();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            HsmNodeNameData hsmNodeNameData = (HsmNodeNameData)vector.elementAt(n2);
            int n3 = hsmNodeNameData.getNodeId();
            HsmPwClsScheduleData hsmPwClsScheduleData = (HsmPwClsScheduleData)this.getScheduleData(n3);
            HsmPwClsScheduleData hsmPwClsScheduleData2 = new HsmPwClsScheduleData(hsmPwClsScheduleData);
            HsmOneDayScheduleData hsmOneDayScheduleData = null;
            if (this.settingFlag == 0) {
                hsmOneDayScheduleData = hsmPwClsScheduleData2.getDayData(this.dateKey);
            } else if (this.settingFlag == 1) {
                hsmOneDayScheduleData = hsmPwClsScheduleData2.getWeeklyData(this.dateKey);
            }
            if (hsmOneDayScheduleData == null) {
                hsmOneDayScheduleData = new HsmOneDayScheduleData();
                if (this.settingFlag == 0) {
                    hsmPwClsScheduleData2.setDayData(this.dateKey, hsmOneDayScheduleData);
                } else if (this.settingFlag == 1) {
                    hsmPwClsScheduleData2.setWeeklyData(this.dateKey, hsmOneDayScheduleData);
                }
            }
            Vector vector2 = hsmOneDayScheduleData.getTimeSchedule();
            HsmPwClsTimeScheduleData hsmPwClsTimeScheduleData2 = new HsmPwClsTimeScheduleData(hsmPwClsTimeScheduleData);
            vector2.addElement(hsmPwClsTimeScheduleData2);
            this.schedules.put(new Integer(n3), hsmPwClsScheduleData2);
            ++n2;
        }
        this.model.addTimeSchedule(hsmPwClsTimeScheduleData, this.dateKey);
        this.clusterSetting.checkDataValidity();
    }

    private void addPowerScheduleData() {
        HsmPwClsTimeScheduleData hsmPwClsTimeScheduleData = this.powerSetting.getData();
        HsmPwClsScheduleData hsmPwClsScheduleData = (HsmPwClsScheduleData)this.getScheduleData(this.nodeId);
        HsmPwClsScheduleData hsmPwClsScheduleData2 = new HsmPwClsScheduleData(hsmPwClsScheduleData);
        HsmOneDayScheduleData hsmOneDayScheduleData = null;
        if (this.settingFlag == 0) {
            hsmOneDayScheduleData = hsmPwClsScheduleData2.getDayData(this.dateKey);
        } else if (this.settingFlag == 1) {
            hsmOneDayScheduleData = hsmPwClsScheduleData2.getWeeklyData(this.dateKey);
        }
        Vector vector = hsmOneDayScheduleData.getTimeSchedule();
        HsmPwClsTimeScheduleData hsmPwClsTimeScheduleData2 = new HsmPwClsTimeScheduleData(hsmPwClsTimeScheduleData);
        vector.addElement(hsmPwClsTimeScheduleData2);
        this.schedules.put(new Integer(this.nodeId), hsmPwClsScheduleData2);
        this.model.addTimeSchedule(hsmPwClsTimeScheduleData, this.dateKey);
        this.powerSetting.checkDataValidity();
    }

    public void createDialog() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public HsmScheduleData getScheduleData(int n) {
        Integer n2 = new Integer(n);
        HsmScheduleData hsmScheduleData = (HsmScheduleData)this.schedules.get(n2);
        return hsmScheduleData;
    }

    private void jbInit() throws Exception {
        this.panel.setSize(new Dimension(570, 410));
        this.panel.setLayout(null);
        this.lblDate.setText("XX\u5e74XX\u6708XX\u65e5\u306e\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb");
        this.lblDate.setBounds(new Rectangle(5, 5, 200, 20));
        this.lblNode.setText("\u30af\u30e9\u30b9\u30bf\u69cb\u6210\u30ce\u30fc\u30c9");
        this.lblNode.setBounds(new Rectangle(430, 55, 120, 20));
        this.lblRef.setText("\u306e\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb\u53c2\u7167");
        this.lblRef.setBounds(new Rectangle(430, 75, 120, 20));
        this.lblSchedule.setText("\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb\u500b\u6570");
        this.lblSchedule.setBounds(new Rectangle(430, 220, 110, 20));
        this.lblPower.setText("\u96fb\u6e90\u5236\u5fa1");
        this.lblPower.setBounds(new Rectangle(430, 250, 100, 20));
        this.lblCluster.setText("\u30af\u30e9\u30b9\u30bf");
        this.lblCluster.setBounds(new Rectangle(430, 290, 100, 20));
        this.btnRef.setText("\u53c2\u7167");
        this.btnRef.setBounds(new Rectangle(440, 110, 100, 20));
        this.btnSet.setText("\u8a2d\u5b9a");
        this.btnSet.setBounds(new Rectangle(175, 190, 100, 20));
        this.btnRemove.setText("\u524a\u9664");
        this.btnRemove.setBounds(new Rectangle(320, 340, 100, 20));
        this.btnOk.setText("OK");
        this.btnOk.setBounds(new Rectangle(340, 375, 100, 20));
        this.btnCancel.setText("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this.btnCancel.setBounds(new Rectangle(440, 375, 100, 20));
        this.setButtonParam();
        this.powerSetting.setPwClsListener(this);
        this.powerSetting.setExchanger(this);
        this.powerSetting.createPanel();
        this.clusterSetting.setPwClsListener(this);
        this.clusterSetting.setExchanger(this);
        this.clusterSetting.createPanel();
        this.settingPanel.add("\u96fb\u6e90\u5236\u5fa1", this.powerSetting);
        this.settingPanel.add("\u30af\u30e9\u30b9\u30bf", this.clusterSetting);
        this.settingPanel.setBounds(new Rectangle(30, 35, 390, 145));
        this.settingPanel.addChangeListener(this);
        this.setTableParam();
        this.scSchedule.setBounds(new Rectangle(30, 220, 390, 110));
        this.scSchedule.getViewport().setView(this.tblSchedule);
        this.getContentPane().add(this.panel);
        this.panel.add(this.lblDate);
        this.panel.add(this.lblNode);
        this.panel.add(this.lblRef);
        this.panel.add(this.lblSchedule);
        this.panel.add(this.lblPower);
        this.panel.add(this.lblCluster);
        this.panel.add(this.btnRef);
        this.panel.add(this.btnRemove);
        this.panel.add(this.btnSet);
        this.panel.add(this.btnCancel);
        this.panel.add(this.btnOk);
        this.panel.add(this.scSchedule);
        this.panel.add(this.settingPanel);
    }

    private void popupRefDialog() {
        HsmScPwClsRefDialog hsmScPwClsRefDialog = new HsmScPwClsRefDialog();
        hsmScPwClsRefDialog.setExchanger(this);
        hsmScPwClsRefDialog.createDialog();
        hsmScPwClsRefDialog.displayData(this.dateKey);
        ((Component)hsmScPwClsRefDialog).setSize(580, 430);
        ((Component)hsmScPwClsRefDialog).setVisible(true);
    }

    private void removeClusterScheduleData(HsmTimeScheduleData hsmTimeScheduleData) {
        Vector vector = this.scheduleData.getNodeNames();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            HsmNodeNameData hsmNodeNameData = (HsmNodeNameData)vector.elementAt(n2);
            int n3 = hsmNodeNameData.getNodeId();
            HsmPwClsScheduleData hsmPwClsScheduleData = (HsmPwClsScheduleData)this.getScheduleData(n3);
            HsmPwClsScheduleData hsmPwClsScheduleData2 = new HsmPwClsScheduleData(hsmPwClsScheduleData);
            HsmOneDayScheduleData hsmOneDayScheduleData = null;
            if (this.settingFlag == 0) {
                hsmOneDayScheduleData = hsmPwClsScheduleData2.getDayData(this.dateKey);
            } else if (this.settingFlag == 1) {
                hsmOneDayScheduleData = hsmPwClsScheduleData2.getWeeklyData(this.dateKey);
            }
            if (hsmOneDayScheduleData != null) {
                Vector vector2 = hsmOneDayScheduleData.getTimeSchedule();
                int n4 = vector2.size();
                int n5 = 0;
                while (n5 < n4) {
                    Object e = vector2.elementAt(n5);
                    HsmPwClsTimeScheduleData hsmPwClsTimeScheduleData = (HsmPwClsTimeScheduleData)e;
                    if (hsmPwClsTimeScheduleData.equals(hsmTimeScheduleData)) {
                        vector2.removeElementAt(n5);
                        break;
                    }
                    ++n5;
                }
                this.schedules.put(new Integer(n3), hsmPwClsScheduleData2);
            }
            ++n2;
        }
        this.model.removeTimeSchedule(hsmTimeScheduleData);
    }

    private void removePowerScheduleData(HsmTimeScheduleData hsmTimeScheduleData) {
        HsmPwClsScheduleData hsmPwClsScheduleData = (HsmPwClsScheduleData)this.getScheduleData(this.nodeId);
        HsmPwClsScheduleData hsmPwClsScheduleData2 = new HsmPwClsScheduleData(hsmPwClsScheduleData);
        HsmOneDayScheduleData hsmOneDayScheduleData = null;
        if (this.settingFlag == 0) {
            hsmOneDayScheduleData = hsmPwClsScheduleData2.getDayData(this.dateKey);
        } else if (this.settingFlag == 1) {
            hsmOneDayScheduleData = hsmPwClsScheduleData2.getWeeklyData(this.dateKey);
        }
        Vector vector = hsmOneDayScheduleData.getTimeSchedule();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = vector.elementAt(n2);
            HsmPwClsTimeScheduleData hsmPwClsTimeScheduleData = (HsmPwClsTimeScheduleData)e;
            if (hsmPwClsTimeScheduleData.equals(hsmTimeScheduleData)) {
                vector.removeElementAt(n2);
                break;
            }
            ++n2;
        }
        this.schedules.put(new Integer(this.nodeId), hsmPwClsScheduleData2);
        this.model.removeTimeSchedule(hsmTimeScheduleData);
    }

    private void removeScheduleData() {
        int n = this.tblSchedule.getSelectedRow();
        Object object = this.tblSchedule.getValueAt(n, 0);
        HsmScTableCell hsmScTableCell = (HsmScTableCell)object;
        HsmPwClsTimeScheduleData hsmPwClsTimeScheduleData = (HsmPwClsTimeScheduleData)hsmScTableCell.getOneSchedule();
        byte by = hsmPwClsTimeScheduleData.getSetting();
        if (by == 1 || by == 2) {
            this.removePowerScheduleData(hsmPwClsTimeScheduleData);
            this.powerSetting.checkDataValidity();
        } else {
            this.removeClusterScheduleData(hsmPwClsTimeScheduleData);
            this.clusterSetting.checkDataValidity();
        }
    }

    private void setButtonParam() {
        this.btnRef.setActionCommand("ref");
        this.btnSet.setActionCommand("set");
        this.btnRemove.setActionCommand("remove");
        this.btnOk.setActionCommand("ok");
        this.btnCancel.setActionCommand("cancel");
        this.btnRef.addActionListener(this);
        this.btnSet.addActionListener(this);
        this.btnRemove.addActionListener(this);
        this.btnOk.addActionListener(this);
        this.btnCancel.addActionListener(this);
        this.btnOk.setEnabled(false);
    }

    public void setDateKey(int n) {
        this.dateKey = n;
        String string = HsmScUtil.getDateStringByKey(n);
        this.lblDate.setText(String.valueOf(string) + "\u306e\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb");
        if (this.settingFlag == 0) {
            this.scheduleMap = this.scheduleData.getDaysMap();
        } else if (this.settingFlag == 1) {
            this.scheduleMap = this.scheduleData.getWeeklyMap();
        }
        this.setScheduleTable();
        this.powerSetting.setDateKey(n);
        this.clusterSetting.setDateKey(n);
    }

    public void setExchanger(HsmScDataExchanger hsmScDataExchanger) {
        this.exchanger = hsmScDataExchanger;
        this.nodeId = hsmScDataExchanger.getNodeId();
        HsmPwClsScheduleData hsmPwClsScheduleData = (HsmPwClsScheduleData)hsmScDataExchanger.getScheduleData(this.nodeId);
        Vector vector = hsmPwClsScheduleData.getNodeNames();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            HsmNodeNameData hsmNodeNameData = (HsmNodeNameData)vector.elementAt(n2);
            int n3 = hsmNodeNameData.getNodeId();
            HsmPwClsScheduleData hsmPwClsScheduleData2 = (HsmPwClsScheduleData)hsmScDataExchanger.getScheduleData(n3);
            HsmPwClsScheduleData hsmPwClsScheduleData3 = new HsmPwClsScheduleData(hsmPwClsScheduleData2);
            this.schedules.put(new Integer(n3), hsmPwClsScheduleData3);
            ++n2;
        }
        this.scheduleData = (HsmPwClsScheduleData)this.getScheduleData(this.nodeId);
    }

    public void setRemoveButton() {
        int n = this.tblSchedule.getSelectedRow();
        int n2 = this.model.getRowCount();
        if (n < 0) {
            this.btnRemove.setEnabled(false);
        } else if (n == n2) {
            if (n2 > 0) {
                this.tblSchedule.setRowSelectionInterval(n2 - 1, n2 - 1);
                this.btnRemove.setEnabled(true);
            } else {
                this.btnRemove.setEnabled(false);
            }
        } else {
            this.btnRemove.setEnabled(true);
        }
    }

    public void setScheduleData(int n, HsmScheduleData hsmScheduleData) {
        Integer n2 = new Integer(n);
        this.schedules.put(n2, hsmScheduleData);
    }

    private void setScheduleTable() {
        if (this.scheduleMap != null && this.scheduleMap.containsKey(new Integer(this.dateKey))) {
            HsmOneDayScheduleData hsmOneDayScheduleData = (HsmOneDayScheduleData)this.scheduleMap.get(new Integer(this.dateKey));
            this.model.setOneDaySchedule(hsmOneDayScheduleData.getTimeSchedule(), this.dateKey);
        } else {
            this.model.clearOneDaySchedule();
        }
    }

    public void setSettingButton(boolean bl) {
        this.btnSet.setEnabled(bl);
    }

    public void setSettingFlag(int n) {
        this.settingFlag = n;
    }

    private void setTableParam() {
        this.model.setType(2);
        this.model.setScheduleId(0);
        this.model.addTableModelListener(this);
        this.tblSchedule.setModel(this.model);
        this.tblSchedule.setShowGrid(false);
        this.tblSchedule.setIntercellSpacing(new Dimension(0, 0));
        this.tblSchedule.setSelectionMode(0);
        this.tblSchedule.getSelectionModel().addListSelectionListener(this);
        Color color = this.tblSchedule.getSelectionForeground();
        Color color2 = this.tblSchedule.getSelectionBackground();
        TableColumnModel tableColumnModel = this.tblSchedule.getColumnModel();
        int n = this.tblSchedule.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnModel.getColumn(n2);
            HsmScTableRenderer hsmScTableRenderer = new HsmScTableRenderer();
            hsmScTableRenderer.setMode(1);
            hsmScTableRenderer.setSelectionForeground(color);
            hsmScTableRenderer.setSelectionBackground(color2);
            tableColumn.setCellRenderer(hsmScTableRenderer);
            if (n2 == 1) {
                tableColumn.setPreferredWidth(300);
            }
            ++n2;
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Component component = this.settingPanel.getSelectedComponent();
        if (component instanceof HsmScPowerSetting) {
            this.powerSetting.checkDataValidity();
        } else if (component instanceof HsmScClusterSetting) {
            this.clusterSetting.checkDataValidity();
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.setRemoveButton();
    }

    private void updateScheduleData() {
        Vector vector = this.scheduleData.getNodeNames();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            HsmNodeNameData hsmNodeNameData = (HsmNodeNameData)vector.elementAt(n2);
            int n3 = hsmNodeNameData.getNodeId();
            HsmPwClsScheduleData hsmPwClsScheduleData = (HsmPwClsScheduleData)this.getScheduleData(n3);
            Hashtable hashtable = null;
            if (this.settingFlag == 0) {
                hashtable = hsmPwClsScheduleData.getDaysMap();
            } else if (this.settingFlag == 1) {
                hashtable = hsmPwClsScheduleData.getWeeklyMap();
            }
            Object v = hashtable.get(new Integer(this.dateKey));
            HsmOneDayScheduleData hsmOneDayScheduleData = (HsmOneDayScheduleData)v;
            if (hsmOneDayScheduleData != null) {
                Vector vector2 = hsmOneDayScheduleData.getTimeSchedule();
                if (vector2.isEmpty()) {
                    hashtable.remove(new Integer(this.dateKey));
                }
                this.exchanger.setScheduleData(n3, hsmPwClsScheduleData);
            }
            ++n2;
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setRemoveButton();
    }
}

