/*
 * Decompiled with CFR 0.152.
 */
package JP.co.Hitachi.soft.System_Manager.console;

import JP.co.Hitachi.soft.System_Manager.console.HsmScDataExchanger;
import JP.co.Hitachi.soft.System_Manager.console.HsmScTableCell;
import JP.co.Hitachi.soft.System_Manager.console.HsmScTableModel;
import JP.co.Hitachi.soft.System_Manager.console.HsmScTableRenderer;
import JP.co.Hitachi.soft.System_Manager.console.HsmScUtil;
import JP.co.Hitachi.soft.System_Manager.data.HsmOneDayScheduleData;
import JP.co.Hitachi.soft.System_Manager.data.HsmReportScheduleData;
import JP.co.Hitachi.soft.System_Manager.data.HsmReportTimeScheduleData;
import JP.co.Hitachi.soft.System_Manager.data.HsmTimeScheduleData;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class HsmScRepUpdateDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    protected HsmScDataExchanger exchanger_ = null;
    protected HsmReportScheduleData scheduleData_ = null;
    protected int settingFlag_;
    protected Hashtable scheduleMap_;
    protected int dateKey_;
    protected int hour_;
    protected int minute_;
    protected int setting_;
    protected boolean updateFlag_ = false;
    protected HsmScTableModel model_ = new HsmScTableModel();
    JPanel panel = new JPanel();
    JLabel lblDate = new JLabel();
    JLabel lblTime = new JLabel();
    JComboBox cbHour = new JComboBox();
    JComboBox cbMinute = new JComboBox();
    JLabel lblHour = new JLabel();
    JLabel lblMinute = new JLabel();
    JRadioButton rbUpdate = new JRadioButton();
    JRadioButton rbNotUpdate = new JRadioButton();
    ButtonGroup group = new ButtonGroup();
    JButton btnSet = new JButton();
    JButton btnRemove = new JButton();
    JButton btnOk = new JButton();
    JButton btnCancel = new JButton();
    JLabel lblSchedule = new JLabel();
    JScrollPane scSchedule = new JScrollPane();
    JTable tblSchedule = new JTable();

    HsmScRepUpdateDialog(Frame frame) {
        super(frame, true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ok")) {
            this.updateScheduleData();
            this.dispose();
        } else if (string.equals("cancel")) {
            this.dispose();
        } else if (string.equals("update")) {
            this.setting_ = 49;
        } else if (string.equals("not_update")) {
            this.setting_ = 50;
        } else if (string.equals("set")) {
            Integer n = new Integer(this.dateKey_);
            Object v = this.scheduleMap_.get(n);
            if (v == null) {
                HsmOneDayScheduleData hsmOneDayScheduleData = new HsmOneDayScheduleData();
                hsmOneDayScheduleData.setDateKey(this.dateKey_);
                hsmOneDayScheduleData.setYear(HsmScUtil.getYear(this.dateKey_));
                hsmOneDayScheduleData.setMonth(HsmScUtil.getMonth(this.dateKey_));
                hsmOneDayScheduleData.setDayOfMonth(HsmScUtil.getDayOfMonth(this.dateKey_));
                this.scheduleMap_.put(n, hsmOneDayScheduleData);
                this.model_.setOneDaySchedule(hsmOneDayScheduleData.getTimeSchedule(), this.dateKey_);
            }
            this.addScheduleData();
            if (!this.updateFlag_) {
                this.btnOk.setEnabled(true);
                this.updateFlag_ = true;
            }
            this.adjustDisplay();
        } else if (string.equals("remove")) {
            this.removeScheduleData();
            if (!this.updateFlag_) {
                this.btnOk.setEnabled(true);
                this.updateFlag_ = true;
            }
            this.adjustDisplay();
        } else if (string.equals("hour")) {
            this.hour_ = this.cbHour.getSelectedIndex();
            this.checkDataValidity();
        } else if (string.equals("minute")) {
            this.minute_ = this.cbMinute.getSelectedIndex();
            this.checkDataValidity();
        }
    }

    private void addScheduleData() {
        HsmReportTimeScheduleData hsmReportTimeScheduleData = new HsmReportTimeScheduleData();
        int n = (this.hour_ << 8) + this.minute_;
        hsmReportTimeScheduleData.setTimeKey(n);
        hsmReportTimeScheduleData.setSetting((byte)this.setting_);
        hsmReportTimeScheduleData.setHour((byte)this.hour_);
        hsmReportTimeScheduleData.setMinute((byte)this.minute_);
        HsmOneDayScheduleData hsmOneDayScheduleData = null;
        if (this.settingFlag_ == 0) {
            hsmOneDayScheduleData = this.scheduleData_.getDayData(this.dateKey_);
        } else if (this.settingFlag_ == 1) {
            hsmOneDayScheduleData = this.scheduleData_.getWeeklyData(this.dateKey_);
        }
        Vector vector = hsmOneDayScheduleData.getTimeSchedule();
        HsmReportTimeScheduleData hsmReportTimeScheduleData2 = new HsmReportTimeScheduleData(hsmReportTimeScheduleData);
        vector.addElement(hsmReportTimeScheduleData2);
        this.model_.addTimeSchedule(hsmReportTimeScheduleData, this.dateKey_);
        this.checkDataValidity();
    }

    public void adjustDisplay() {
        int n = this.tblSchedule.getSelectedRow();
        int n2 = this.model_.getRowCount();
        if (n < 0) {
            this.btnRemove.setEnabled(false);
        } else if (n == n2) {
            if (n2 > 0) {
                this.tblSchedule.setRowSelectionInterval(n2 - 1, n2 - 1);
                this.btnRemove.setEnabled(true);
            } else {
                this.btnRemove.setEnabled(false);
            }
        } else {
            this.btnRemove.setEnabled(true);
        }
    }

    public void checkDataValidity() {
        HsmOneDayScheduleData hsmOneDayScheduleData = null;
        hsmOneDayScheduleData = this.dateKey_ >= 0 && this.dateKey_ < 7 ? this.scheduleData_.getWeeklyData(this.dateKey_) : this.scheduleData_.getDayData(this.dateKey_);
        if (hsmOneDayScheduleData == null) {
            this.btnSet.setEnabled(true);
            return;
        }
        int n = (this.hour_ << 8) + this.minute_;
        Vector vector = hsmOneDayScheduleData.getTimeSchedule();
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            Object e = vector.elementAt(n3);
            HsmReportTimeScheduleData hsmReportTimeScheduleData = (HsmReportTimeScheduleData)e;
            int n4 = hsmReportTimeScheduleData.getTimeKey();
            if (n >= n4 - 5 && n <= n4 + 5) {
                this.btnSet.setEnabled(false);
                return;
            }
            ++n3;
        }
        this.btnSet.setEnabled(true);
    }

    public void createDialog() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.panel.setSize(new Dimension(570, 410));
        this.panel.setLayout(null);
        this.lblDate.setText("XX\u5e74XX\u6708XX\u65e5\u306e\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb");
        this.lblDate.setBounds(new Rectangle(5, 5, 200, 20));
        this.lblTime.setText("\u6642\u523b");
        this.lblTime.setBounds(new Rectangle(100, 70, 40, 20));
        this.cbHour.setBounds(new Rectangle(150, 70, 50, 20));
        this.lblHour.setText("\u6642");
        this.lblHour.setBounds(new Rectangle(205, 70, 20, 20));
        this.cbMinute.setBounds(new Rectangle(230, 70, 50, 20));
        this.lblMinute.setText("\u5206");
        this.lblMinute.setBounds(new Rectangle(285, 70, 25, 20));
        this.rbUpdate.setText("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u3092\u66f4\u65b0\u3059\u308b");
        this.rbUpdate.setBounds(new Rectangle(100, 110, 300, 20));
        this.rbNotUpdate.setText("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306e\u66f4\u65b0\u304b\u3089\u9664\u5916\u3059\u308b");
        this.rbNotUpdate.setBounds(new Rectangle(100, 140, 300, 20));
        this.setComboBoxParam();
        this.setRbParam();
        this.btnSet.setText("\u8a2d\u5b9a");
        this.btnSet.setBounds(new Rectangle(175, 190, 100, 20));
        this.btnRemove.setText("\u524a\u9664");
        this.btnRemove.setBounds(new Rectangle(320, 340, 100, 20));
        this.btnOk.setText("OK");
        this.btnOk.setBounds(new Rectangle(340, 375, 100, 20));
        this.btnCancel.setText("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this.btnCancel.setBounds(new Rectangle(440, 375, 100, 20));
        this.setButtonParam();
        this.lblSchedule.setText("\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb\u500b\u6570");
        this.lblSchedule.setBounds(new Rectangle(430, 220, 110, 20));
        this.scSchedule.setBounds(new Rectangle(30, 220, 390, 110));
        this.scSchedule.getViewport().setView(this.tblSchedule);
        this.setTableParam();
        this.getContentPane().add(this.panel);
        this.panel.add(this.lblDate);
        this.panel.add(this.lblTime);
        this.panel.add(this.cbHour);
        this.panel.add(this.cbMinute);
        this.panel.add(this.lblHour);
        this.panel.add(this.lblMinute);
        this.panel.add(this.rbUpdate);
        this.panel.add(this.rbNotUpdate);
        this.panel.add(this.btnRemove);
        this.panel.add(this.btnSet);
        this.panel.add(this.btnCancel);
        this.panel.add(this.btnOk);
        this.panel.add(this.lblSchedule);
        this.panel.add(this.scSchedule);
    }

    private void removeScheduleData() {
        int n = this.tblSchedule.getSelectedRow();
        Object object = this.tblSchedule.getValueAt(n, 0);
        HsmScTableCell hsmScTableCell = (HsmScTableCell)object;
        HsmReportTimeScheduleData hsmReportTimeScheduleData = (HsmReportTimeScheduleData)hsmScTableCell.getOneSchedule();
        HsmOneDayScheduleData hsmOneDayScheduleData = null;
        if (this.settingFlag_ == 0) {
            hsmOneDayScheduleData = this.scheduleData_.getDayData(this.dateKey_);
        } else if (this.settingFlag_ == 1) {
            hsmOneDayScheduleData = this.scheduleData_.getWeeklyData(this.dateKey_);
        }
        Vector vector = hsmOneDayScheduleData.getTimeSchedule();
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            Object e = vector.elementAt(n3);
            HsmTimeScheduleData hsmTimeScheduleData = (HsmTimeScheduleData)e;
            if (hsmTimeScheduleData.equals(hsmReportTimeScheduleData)) {
                vector.removeElementAt(n3);
                break;
            }
            ++n3;
        }
        this.model_.removeTimeSchedule(hsmReportTimeScheduleData);
        this.checkDataValidity();
    }

    private void setButtonParam() {
        this.btnSet.setActionCommand("set");
        this.btnRemove.setActionCommand("remove");
        this.btnOk.setActionCommand("ok");
        this.btnCancel.setActionCommand("cancel");
        this.btnSet.addActionListener(this);
        this.btnRemove.addActionListener(this);
        this.btnOk.addActionListener(this);
        this.btnCancel.addActionListener(this);
        this.btnOk.setEnabled(false);
    }

    private void setCbHourParam() {
        int n = 0;
        while (n < 24) {
            String string = n < 10 ? "0" + n : String.valueOf(n);
            this.cbHour.addItem(string);
            ++n;
        }
        this.cbHour.setActionCommand("hour");
        this.cbHour.addActionListener(this);
        this.cbHour.setSelectedIndex(0);
        this.hour_ = 0;
    }

    private void setCbMinuteParam() {
        int n = 0;
        while (n < 60) {
            String string = n < 10 ? "0" + n : String.valueOf(n);
            this.cbMinute.addItem(string);
            ++n;
        }
        this.cbMinute.setActionCommand("minute");
        this.cbMinute.addActionListener(this);
        this.cbMinute.setSelectedIndex(0);
        this.minute_ = 0;
    }

    private void setComboBoxParam() {
        this.setCbHourParam();
        this.setCbMinuteParam();
    }

    public void setDateKey(int n) {
        this.dateKey_ = n;
        String string = HsmScUtil.getDateStringByKey(n);
        this.lblDate.setText(String.valueOf(string) + "\u306e\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb");
        if (this.settingFlag_ == 0) {
            this.scheduleMap_ = this.scheduleData_.getDaysMap();
        } else if (this.settingFlag_ == 1) {
            this.scheduleMap_ = this.scheduleData_.getWeeklyMap();
        }
        this.setScheduleTable();
    }

    public void setExchanger(HsmScDataExchanger hsmScDataExchanger) {
        this.exchanger_ = hsmScDataExchanger;
        HsmReportScheduleData hsmReportScheduleData = (HsmReportScheduleData)hsmScDataExchanger.getScheduleData(0);
        this.scheduleData_ = new HsmReportScheduleData(hsmReportScheduleData);
    }

    private void setRbParam() {
        this.group.add(this.rbUpdate);
        this.group.add(this.rbNotUpdate);
        this.rbUpdate.setActionCommand("update");
        this.rbNotUpdate.setActionCommand("not_update");
        this.rbUpdate.addActionListener(this);
        this.rbNotUpdate.addActionListener(this);
        this.rbUpdate.setSelected(true);
        this.setting_ = 49;
    }

    private void setScheduleTable() {
        if (this.scheduleMap_ != null && this.scheduleMap_.containsKey(new Integer(this.dateKey_))) {
            HsmOneDayScheduleData hsmOneDayScheduleData = (HsmOneDayScheduleData)this.scheduleMap_.get(new Integer(this.dateKey_));
            this.model_.setOneDaySchedule(hsmOneDayScheduleData.getTimeSchedule(), this.dateKey_);
        } else {
            this.model_.clearOneDaySchedule();
        }
        this.adjustDisplay();
    }

    public void setSettingFlag(int n) {
        this.settingFlag_ = n;
    }

    private void setTableParam() {
        this.model_.setType(2);
        this.model_.setScheduleId(2);
        this.tblSchedule.setModel(this.model_);
        this.tblSchedule.setShowGrid(false);
        this.tblSchedule.setIntercellSpacing(new Dimension(0, 0));
        this.tblSchedule.setSelectionMode(0);
        this.tblSchedule.getSelectionModel().addListSelectionListener(this);
        Color color = this.tblSchedule.getSelectionForeground();
        Color color2 = this.tblSchedule.getSelectionBackground();
        TableColumnModel tableColumnModel = this.tblSchedule.getColumnModel();
        int n = this.tblSchedule.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnModel.getColumn(n2);
            HsmScTableRenderer hsmScTableRenderer = new HsmScTableRenderer();
            hsmScTableRenderer.setMode(1);
            hsmScTableRenderer.setSelectionForeground(color);
            hsmScTableRenderer.setSelectionBackground(color2);
            tableColumn.setCellRenderer(hsmScTableRenderer);
            if (n2 == 1) {
                tableColumn.setPreferredWidth(300);
            }
            ++n2;
        }
    }

    private void updateScheduleData() {
        Hashtable hashtable = null;
        if (this.settingFlag_ == 0) {
            hashtable = this.scheduleData_.getDaysMap();
        } else if (this.settingFlag_ == 1) {
            hashtable = this.scheduleData_.getWeeklyMap();
        }
        Object v = hashtable.get(new Integer(this.dateKey_));
        HsmOneDayScheduleData hsmOneDayScheduleData = (HsmOneDayScheduleData)v;
        if (hsmOneDayScheduleData == null) {
            return;
        }
        Vector vector = hsmOneDayScheduleData.getTimeSchedule();
        if (vector.isEmpty()) {
            hashtable.remove(new Integer(this.dateKey_));
        }
        this.exchanger_.setScheduleData(0, this.scheduleData_);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.adjustDisplay();
    }
}

