/*
 * Decompiled with CFR 0.152.
 */
package JP.co.Hitachi.soft.System_Manager.console;

import JP.co.Hitachi.soft.System_Manager.console.HsmScCalendarListener;
import JP.co.Hitachi.soft.System_Manager.console.HsmScDateCell;
import JP.co.Hitachi.soft.System_Manager.console.HsmScDayCell;
import JP.co.Hitachi.soft.System_Manager.console.HsmScUtil;
import JP.co.Hitachi.soft.System_Manager.data.HsmScheduleData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import javax.swing.JPanel;

public class HsmScUniCalendar
extends JPanel {
    static final int cellWidth = 20;
    static final int cellHeight = 30;
    static final int dayCellHeight = 20;
    int year = 0;
    int month = 0;
    HsmScCalendarListener listener = null;
    HsmScheduleData scheduleData = null;
    HsmScDayCell[] dayCell;
    HsmScDateCell[] dateCell;

    HsmScUniCalendar(int n, int n2, HsmScheduleData hsmScheduleData, HsmScCalendarListener hsmScCalendarListener) {
        this.year = n;
        this.month = n2;
        this.scheduleData = hsmScheduleData;
        this.listener = hsmScCalendarListener;
    }

    private void createDatePanel(Container container) {
        this.dateCell = new HsmScDateCell[42];
        int n = 0;
        while (n < 6) {
            int n2 = 0;
            while (n2 < 7) {
                this.dateCell[n * 7 + n2] = new HsmScDateCell(this.listener);
                container.add(this.dateCell[n * 7 + n2]);
                this.dateCell[n * 7 + n2].setBounds(n2 * 20, n * 30 + 40, 20, 30);
                this.dateCell[n * 7 + n2].setBackground(this.getBackground());
                ++n2;
            }
            ++n;
        }
    }

    private void createDayPanel(Container container) {
        String[] stringArray = new String[]{"\u65e5", "\u6708", "\u706b", "\u6c34", "\u6728", "\u91d1", "\u571f"};
        this.dayCell = new HsmScDayCell[7];
        int n = 0;
        while (n < 7) {
            this.dayCell[n] = new HsmScDayCell(n, stringArray[n], this.listener);
            container.add(this.dayCell[n]);
            this.dayCell[n].setBounds(20 * n, 20, 20, 20);
            ++n;
        }
    }

    public void createPanel() {
        this.setLayout(null);
        this.createDayPanel(this);
        this.createDatePanel(this);
        this.setDate();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.month == 0) {
            return;
        }
        int n = this.getWidth();
        int n2 = this.getHeight();
        Color color = graphics.getColor();
        Font font = graphics.getFont();
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, 0, 140, 20);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, 140, 20);
        graphics.drawRect(0, 20, 140, 200);
        Font font2 = new Font("SansSerif", 1, 12);
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(font2);
        String string = this.year + "\u5e74" + this.month + "\u6708";
        int n3 = fontMetrics.stringWidth(string);
        graphics.drawString(string, (140 - n3) / 2, 15);
        graphics.setColor(color);
    }

    private void setDate() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(this.year, this.month - 1, 1);
        int n = ((Calendar)gregorianCalendar).getActualMaximum(5);
        int n2 = gregorianCalendar.get(7);
        int n3 = 0;
        switch (n2) {
            case 1: {
                n3 = 0;
                break;
            }
            case 2: {
                n3 = 1;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
            case 4: {
                n3 = 3;
                break;
            }
            case 5: {
                n3 = 4;
                break;
            }
            case 6: {
                n3 = 5;
                break;
            }
            case 7: {
                n3 = 6;
                break;
            }
        }
        int n4 = 0;
        while (n4 < this.dateCell.length) {
            this.dateCell[n4].initData();
            int n5 = n4 - n3 + 1;
            if (n5 > 0 && n5 <= n) {
                Hashtable hashtable;
                int n6;
                Hashtable hashtable2 = this.scheduleData.getWeeklyMap();
                if (hashtable2.containsKey(new Integer(n6 = (n5 + n3 - 1) % 7))) {
                    this.dateCell[n4].setWeeklySetting(true);
                }
                if (HsmScUtil.hasSingleSetting(hashtable = this.scheduleData.getDaysMap(), this.year, this.month, n5)) {
                    this.dateCell[n4].setSingleSetting(true);
                }
                this.dateCell[n4].setDate(this.year, this.month, n5, n6);
            } else {
                this.dateCell[n4].setExistence(false);
            }
            ++n4;
        }
    }

    public void setScheduleData(HsmScheduleData hsmScheduleData) {
        this.scheduleData = hsmScheduleData;
        this.setDate();
        this.repaint();
    }

    public void setSelectedDate(int n, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < this.dateCell.length) {
            this.dateCell[n5].selectDate(n, n2, n3, n4);
            ++n5;
        }
        this.repaint();
    }

    public void setSelectedDay(int n, int n2) {
        int n3 = 0;
        while (n3 < this.dateCell.length) {
            this.dateCell[n3].selectDay(n, n2);
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.dayCell.length) {
            this.dayCell[n4].selectDay(n2);
            ++n4;
        }
        this.repaint();
    }

    public void setYearMonth(int n, int n2) {
        this.year = n;
        this.month = n2;
        this.setDate();
        this.repaint();
    }
}

