/*
 * Decompiled with CFR 0.152.
 */
package JP.co.Hitachi.soft.System_Manager.console;

import JP.co.Hitachi.soft.System_Manager.console.HsmDocument;
import JP.co.Hitachi.soft.System_Manager.console.HsmErrorDlg;
import JP.co.Hitachi.soft.System_Manager.console.HsmTreeEventListener;
import JP.co.Hitachi.soft.System_Manager.data.HsmError;
import JP.co.Hitachi.soft.System_Manager.data.HsmEvent;
import JP.co.Hitachi.soft.System_Manager.data.HsmException;
import JP.co.Hitachi.soft.System_Manager.data.HsmFuncNodeData;
import JP.co.Hitachi.soft.System_Manager.data.HsmNodeData;
import JP.co.Hitachi.soft.System_Manager.data.HsmStartPageInfo;
import JP.co.Hitachi.soft.System_Manager.data.HsmTreeData;
import JP.co.Hitachi.soft.System_Manager.data.HsmUrlData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class HsmTreeView
extends JTree
implements TreeSelectionListener,
DragGestureListener,
DragSourceListener,
DropTargetListener {
    protected HsmDocument hsmDocument_;
    protected Vector nListeners_ = new Vector();
    HsmNodeData selectedNode_ = null;
    protected DragSource dragSource_ = null;
    protected DropTarget dropTarget_ = null;
    protected boolean isRenewal = true;

    public HsmTreeView() throws HsmException {
    }

    public HsmTreeView(HsmDocument hsmDocument) throws HsmException {
        this.init(hsmDocument, null);
    }

    public HsmTreeView(HsmDocument hsmDocument, HsmTreeEventListener hsmTreeEventListener) throws HsmException {
        this.init(hsmDocument, hsmTreeEventListener);
    }

    public HsmTreeView(HsmTreeEventListener hsmTreeEventListener) throws HsmException {
        this.addTreeSelectionListener(this);
        this.addEventListener(hsmTreeEventListener);
    }

    public void addEventListener(HsmTreeEventListener hsmTreeEventListener) throws HsmException {
        if (hsmTreeEventListener == null) {
            throw new HsmException(473534468);
        }
        this.nListeners_.add(hsmTreeEventListener);
    }

    public void createPane() throws HsmException {
        Object object;
        TreeNode treeNode;
        HsmTreeData hsmTreeData = this.hsmDocument_.getSelectedTree();
        if (this.hsmDocument_.isStartPageVisible(3)) {
            treeNode = hsmTreeData.GetTree();
        } else {
            object = this.hsmDocument_.getStartPageInfo();
            int n = ((HsmStartPageInfo)object).getNodeId();
            treeNode = hsmTreeData.GetTree(n);
            if (treeNode == null) {
                treeNode = hsmTreeData.GetTree();
            }
        }
        object = this.getModel();
        if (object != null && object instanceof DefaultTreeModel) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)object;
            defaultTreeModel.setRoot(treeNode);
            defaultTreeModel.nodeStructureChanged(treeNode);
        } else {
            DefaultTreeModel defaultTreeModel = new DefaultTreeModel(treeNode);
            this.setModel(defaultTreeModel);
        }
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        if (this.selectedNode_ != null) {
            Vector<HsmNodeData> vector = new Vector<HsmNodeData>();
            vector.add(this.selectedNode_);
            this.hsmDocument_.doDrag(dragGestureEvent, vector, this);
        }
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        DataFlavor dataFlavor = new DataFlavor("application/x-java-object", "HsmDnDData");
        if (dropTargetDragEvent.isDataFlavorSupported(dataFlavor)) {
            dropTargetDragEvent.acceptDrag(3);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            TreePath treePath = this.getClosestPathForLocation(dropTargetDropEvent.getLocation().x, dropTargetDropEvent.getLocation().y);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            HsmNodeData hsmNodeData = (HsmNodeData)defaultMutableTreeNode.getUserObject();
            Vector vector = this.hsmDocument_.dropData(dropTargetDropEvent);
            if (vector.size() == 0) {
                return;
            }
            if (dropTargetDropEvent.getDropAction() == 1) {
                this.hsmDocument_.copyNodes(hsmNodeData, vector);
            } else if (dropTargetDropEvent.getDropAction() == 2) {
                this.hsmDocument_.moveNodes(hsmNodeData, vector);
            }
            HsmEvent hsmEvent = new HsmEvent(this, 65555);
            this.sendEvent(hsmEvent);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            HsmError hsmError = new HsmError(473272326, iOException);
            HsmErrorDlg hsmErrorDlg = new HsmErrorDlg(hsmError, this.hsmDocument_);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            System.out.println(unsupportedFlavorException);
            HsmError hsmError = new HsmError(473272326, unsupportedFlavorException);
            HsmErrorDlg hsmErrorDlg = new HsmErrorDlg(hsmError, this.hsmDocument_);
        }
        catch (HsmException hsmException) {
            HsmErrorDlg hsmErrorDlg = new HsmErrorDlg(hsmException.getError(), this.hsmDocument_);
        }
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void fireSelectChanged() throws HsmException {
        Vector<HsmNodeData> vector = new Vector<HsmNodeData>();
        vector.add(this.selectedNode_);
        HsmEvent hsmEvent = new HsmEvent((Object)this, 131073, vector);
        this.sendSelectionEvent(hsmEvent);
    }

    public void init(HsmDocument hsmDocument, HsmTreeEventListener hsmTreeEventListener) throws HsmException {
        this.hsmDocument_ = hsmDocument;
        this.hsmDocument_.setTreeView(this);
        this.createPane();
        this.setEditable(false);
        this.getSelectionModel().setSelectionMode(1);
        this.addTreeSelectionListener(this);
        if (hsmTreeEventListener != null) {
            this.addEventListener(hsmTreeEventListener);
        }
        this.setCellRenderer(new HsmTreeCellRenderer());
    }

    public void initDnD() {
        this.dragSource_ = DragSource.getDefaultDragSource();
        this.dragSource_.createDefaultDragGestureRecognizer(this, 3, this);
        this.dropTarget_ = new DropTarget(this, 3, this);
    }

    public void openPopupMenu(MouseEvent mouseEvent) {
        Rectangle rectangle = this.getPathBounds(this.getSelectionPath());
        if (rectangle.contains(mouseEvent.getX(), mouseEvent.getY())) {
            Vector<HsmNodeData> vector = new Vector<HsmNodeData>();
            vector.add(this.selectedNode_);
            this.hsmDocument_.getToolBar().openPopupMenu(mouseEvent, vector);
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        if (focusEvent.getID() == 1004) {
            this.hsmDocument_.setSelectedView(this);
            if (this.isRenewal) {
                Vector<HsmNodeData> vector = new Vector<HsmNodeData>();
                vector.add(this.selectedNode_);
                this.hsmDocument_.reEnableMenu(vector);
            }
        }
        super.processFocusEvent(focusEvent);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        try {
            if (keyEvent.getID() == 401) {
                int n = keyEvent.getKeyCode();
                switch (n) {
                    case 127: {
                        Vector<HsmNodeData> vector = new Vector<HsmNodeData>();
                        vector.add(this.selectedNode_);
                        this.hsmDocument_.delItem(vector, false);
                        HsmEvent hsmEvent = new HsmEvent(this, 65555);
                        this.sendEvent(hsmEvent);
                        break;
                    }
                }
            }
            super.processKeyEvent(keyEvent);
        }
        catch (HsmException hsmException) {
            HsmErrorDlg hsmErrorDlg = new HsmErrorDlg(hsmException.getError(), this.hsmDocument_);
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.openPopupMenu(mouseEvent);
        }
        super.processMouseEvent(mouseEvent);
    }

    public void reDraw() {
        this.repaint();
    }

    public void reload() throws HsmException {
        HsmTreeData hsmTreeData = this.hsmDocument_.getSelectedTree();
        HsmNodeData hsmNodeData = hsmTreeData.getTreeSelectedNode();
        this.createPane();
        this.setSelectedNode(hsmNodeData);
    }

    public void removeEventListener(HsmTreeEventListener hsmTreeEventListener) throws HsmException {
        if (hsmTreeEventListener == null) {
            throw new HsmException(473600004);
        }
        this.nListeners_.remove(hsmTreeEventListener);
    }

    public void selectAlertForce() throws HsmException {
        HsmFuncNodeData hsmFuncNodeData;
        boolean bl = false;
        if (this.selectedNode_ != null && this.selectedNode_ instanceof HsmFuncNodeData && (hsmFuncNodeData = (HsmFuncNodeData)this.selectedNode_).getFuncId() == 0x1000000) {
            bl = true;
        }
        this.setSelectedNode(-1, 0x1000000, null);
        if (bl) {
            this.fireSelectChanged();
        }
    }

    void sendEvent(HsmEvent hsmEvent) {
        int n = 0;
        while (n < this.nListeners_.size()) {
            HsmTreeEventListener hsmTreeEventListener = (HsmTreeEventListener)this.nListeners_.get(n);
            hsmTreeEventListener.eventOccurred(hsmEvent);
            ++n;
        }
    }

    void sendSelectionEvent(HsmEvent hsmEvent) {
        int n = 0;
        while (n < this.nListeners_.size()) {
            HsmTreeEventListener hsmTreeEventListener = (HsmTreeEventListener)this.nListeners_.get(n);
            hsmTreeEventListener.treeSelectionChanged(hsmEvent);
            ++n;
        }
    }

    public void setHsmDocument(HsmDocument hsmDocument) throws HsmException {
        this.hsmDocument_ = hsmDocument;
        this.reload();
    }

    public void setSelectedNode(int n, int n2, Vector vector) throws HsmException {
        HsmTreeData hsmTreeData = this.hsmDocument_.getSelectedTree();
        if (hsmTreeData == null) {
            throw new HsmException(473337860);
        }
        HsmNodeData hsmNodeData = hsmTreeData.searchNode(n, n2, vector);
        if (hsmNodeData == null) {
            Vector vector2 = hsmTreeData.searchNodes(n);
            int n3 = 0;
            while (n3 < vector2.size()) {
                HsmNodeData hsmNodeData2 = (HsmNodeData)vector2.get(n3);
                HsmNodeData hsmNodeData3 = hsmNodeData2.getParentNode();
                if (hsmNodeData3 != null && hsmNodeData3.getNodeType() == 327681) {
                    hsmNodeData = hsmNodeData2;
                    break;
                }
                ++n3;
            }
        }
        if (hsmNodeData != null) {
            this.setSelectedNode(hsmNodeData);
        }
    }

    public void setSelectedNode(HsmNodeData hsmNodeData) throws HsmException {
        if (hsmNodeData == null) {
            throw new HsmException(473403396);
        }
        DefaultMutableTreeNode defaultMutableTreeNode = hsmNodeData.getTreeNode();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        if (defaultTreeModel == null) {
            throw new HsmException(473337860);
        }
        Object[] objectArray = defaultTreeModel.getPathToRoot(defaultMutableTreeNode);
        TreePath treePath = new TreePath(objectArray);
        this.setSelectionPath(treePath);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        try {
            if (this.hsmDocument_ == null) {
                return;
            }
            TreePath treePath = treeSelectionEvent.getPath();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            this.selectedNode_ = (HsmNodeData)defaultMutableTreeNode.getUserObject();
            if (this.selectedNode_ == null) {
                throw new HsmException(473468932);
            }
            HsmTreeData hsmTreeData = this.hsmDocument_.getSelectedTree();
            if (hsmTreeData == null) {
                throw new HsmException(473468932);
            }
            if (hsmTreeData.getRoot().isNodeChild(this.selectedNode_)) {
                Serializable serializable;
                hsmTreeData.setTreeSelectedNode(this.selectedNode_);
                if (this.selectedNode_.getNodeType() == 393217 && this.selectedNode_.isExistUnknownChild() && (serializable = this.hsmDocument_.getChildTree((HsmFuncNodeData)this.selectedNode_)) != null && this.selectedNode_ != serializable) {
                    this.setSelectedNode((HsmNodeData)serializable);
                }
                serializable = new Vector<HsmNodeData>();
                serializable.add(this.selectedNode_);
                this.hsmDocument_.reEnableMenu((Vector)serializable);
                HsmEvent hsmEvent = new HsmEvent((Object)this, 131073, serializable);
                this.sendSelectionEvent(hsmEvent);
            }
        }
        catch (HsmException hsmException) {
            HsmErrorDlg hsmErrorDlg = new HsmErrorDlg(hsmException.getError(), this.hsmDocument_);
        }
    }

    public class HsmTreeCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        URL prevSelectedIconUrl_ = null;
        URL prevIconUrl_ = null;
        Icon selectedIcon_ = null;
        Icon icon_ = null;

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            try {
                HsmFuncNodeData hsmFuncNodeData;
                Object object2;
                URL uRL = null;
                URL uRL2 = null;
                if (bl4) {
                    this.setOpaque(true);
                    this.setBackground(Color.blue);
                    this.setForeground(Color.white);
                } else if (bl) {
                    this.setOpaque(true);
                    this.setBackground(Color.lightGray);
                    this.setForeground(Color.black);
                } else {
                    this.setOpaque(false);
                    this.setBackground(Color.white);
                    this.setForeground(Color.black);
                }
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                HsmNodeData hsmNodeData = (HsmNodeData)defaultMutableTreeNode.getUserObject();
                if (bl) {
                    object2 = hsmNodeData.getSelectedIconUrl();
                    uRL = ((HsmUrlData)object2).getUrl(HsmTreeView.this.hsmDocument_.getBaseCodeUrl());
                    if (uRL != null && !uRL.equals(this.prevSelectedIconUrl_)) {
                        this.selectedIcon_ = new ImageIcon(uRL);
                        this.prevSelectedIconUrl_ = uRL;
                    }
                    if (this.selectedIcon_ != null) {
                        this.setIcon(this.selectedIcon_);
                    }
                } else {
                    object2 = hsmNodeData.getIconUrl();
                    uRL2 = ((HsmUrlData)object2).getUrl(HsmTreeView.this.hsmDocument_.getBaseCodeUrl());
                    if (uRL2 != null && !uRL2.equals(this.prevIconUrl_)) {
                        this.icon_ = new ImageIcon(uRL2);
                        this.prevIconUrl_ = uRL2;
                    }
                    if (this.icon_ != null) {
                        this.setIcon(this.icon_);
                    }
                }
                object2 = defaultMutableTreeNode.toString();
                if (hsmNodeData.getNodeType() == 393217 && (hsmFuncNodeData = (HsmFuncNodeData)hsmNodeData).getFuncId() == 0x9000000 && HsmTreeView.this.hsmDocument_.isChangedGrpData(hsmFuncNodeData.getDetailId(0))) {
                    object2 = String.valueOf(object2) + HsmDocument.getResource().getString("CHANGED_GROUP");
                }
                this.setText((String)object2);
            }
            catch (HsmException hsmException) {
                System.out.println(hsmException);
            }
            return this;
        }
    }
}

