/*
 * Decompiled with CFR 0.152.
 */
package JP.co.Hitachi.soft.System_Manager.webconsole.common;

import JP.co.Hitachi.soft.System_Manager.data.HsmHostNodeData;
import JP.co.Hitachi.soft.System_Manager.webconsole.common.ErrorLog;
import JP.co.Hitachi.soft.System_Manager.webconsole.common.WcException;
import java.io.File;
import java.rmi.AccessException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.struts.util.LabelValueBean;

public class CommonUtil {
    public static boolean isNumber(String string) {
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.isDigit(cArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.isDigit(cArray[i]) || string2 != null && string2.indexOf(cArray[i]) >= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumberInRange(String string, int n, int n2) {
        if (!CommonUtil.isNumber(string)) {
            return false;
        }
        int n3 = Integer.parseInt(string);
        return n3 >= n && n3 <= n2;
    }

    public static boolean isAlphaNumeric(String string) {
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        string = string.trim();
        char c = '\u0000';
        for (int i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaNumeric(String string, String string2) {
        char c = '\u0000';
        for (int i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || string2.indexOf(c) >= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidAlertID(String string) {
        if (string == null) {
            return false;
        }
        int n = (string = string.trim()).length();
        if (n == 6 || n == 4) {
            if (n == 6) {
                if (string.substring(0, 2).equalsIgnoreCase("0X")) {
                    string = string.substring(2, n);
                } else {
                    return false;
                }
            }
            return CommonUtil.isHexaDec(string);
        }
        return false;
    }

    public static boolean isValidAscii(String string) {
        if (string == null || string.length() <= 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c <= '~') continue;
            return false;
        }
        return true;
    }

    public static boolean isHexaDec(String string) {
        return CommonUtil.isHexaDec(string, null);
    }

    public static boolean isHexaDec(String string, String string2) {
        if (string == null || string.trim().length() <= 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = Character.toUpperCase(cArray[i]);
            if (Character.isDigit(cArray[i]) || c == 'A' || c == 'B' || c == 'C' || c == 'D' || c == 'E' || c == 'F' || string2 != null && string2.indexOf(c) >= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isInvalidChar(String string, String string2) {
        if (string2 == null || string == null) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (string2.indexOf(cArray[i]) < 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isIPAddress(String string) {
        if (string == null || string.trim().length() <= 0) {
            return false;
        }
        if (!CommonUtil.isNumber(string, ".")) {
            return false;
        }
        if (string.trim().length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ".");
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != ".".charAt(0)) continue;
                ++n;
            }
            if (stringTokenizer.countTokens() == 4 && n == 3) {
                String string2 = null;
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (CommonUtil.isNumber(string2)) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public static boolean isValidIPAddress(String string) {
        if (string == null || string.trim().length() <= 0) {
            return false;
        }
        if (!CommonUtil.isNumber(string, ".")) {
            return false;
        }
        if (string.trim().length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ".");
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != ".".charAt(0)) continue;
                ++n;
            }
            if (stringTokenizer.countTokens() == 4 && n == 3) {
                String string2 = null;
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.length() == 0 || string2.length() >= 4) {
                        return false;
                    }
                    if (Integer.parseInt(string2) <= 255) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public static boolean isDate(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append("/");
        stringBuffer.append(string3);
        stringBuffer.append("/");
        stringBuffer.append(string);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy");
        Date date = null;
        try {
            date = simpleDateFormat.parse(stringBuffer.toString());
        }
        catch (ParseException parseException) {
            return false;
        }
        return simpleDateFormat.format(date).equals(stringBuffer.toString());
    }

    public static boolean isDateRangeValid(Calendar calendar, Calendar calendar2) {
        if (calendar.before(calendar2)) {
            return true;
        }
        return calendar.equals(calendar2);
    }

    public static String sanitize(String string) {
        if (string != null && string.length() > 0) {
            string = string.replaceAll("&", "&amp;");
            string = string.replaceAll("<", "&lt;");
            string = string.replaceAll(">", "&gt;");
            string = string.replaceAll("'", "&#39;");
            string = string.replaceAll("\"", "&quot;");
        }
        return string;
    }

    public static String deSanitize(String string) {
        if (string != null && string.length() > 0) {
            string = string.replaceAll("&lt;", "<");
            string = string.replaceAll("&gt;", ">");
            string = string.replaceAll("&#39;", "'");
            string = string.replaceAll("&quot;", "\"");
            string = string.replaceAll("&amp;", "&");
        }
        return string;
    }

    public static String[] sanitize(String[] stringArray) {
        String string = null;
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            stringArray2[i] = string = CommonUtil.sanitize(string);
        }
        return stringArray2;
    }

    public static Vector sanitize(Vector vector) {
        String string = null;
        Vector<String> vector2 = new Vector<String>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.get(i) instanceof String) {
                string = (String)vector.get(i);
                string = CommonUtil.sanitize(string);
                vector2.add(string);
                continue;
            }
            vector2.add((String)vector.get(i));
        }
        return vector2;
    }

    public static String formatOccurenceDate(String string, String string2, String string3, int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null && string.trim().length() > 0 && string2 != null && string2.trim().length() > 0 && string3 != null && string3.trim().length() > 0) {
            stringBuffer.append(string);
            stringBuffer.append("-");
            stringBuffer.append(string2);
            stringBuffer.append("-");
            stringBuffer.append(string3);
            stringBuffer.append(" ");
            stringBuffer.append(n);
            stringBuffer.append(":");
            stringBuffer.append(n2);
            stringBuffer.append(":");
            stringBuffer.append(n3);
        }
        return stringBuffer.toString();
    }

    public static Calendar convertDateToCalendar(String string, String string2) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        if (string != null && string.trim().length() > 0) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            Date date = new Date();
            date = simpleDateFormat.parse(string);
            calendar.setTime(date);
        }
        return calendar;
    }

    public static int convertDateToInt(String string, String string2) throws ParseException {
        if (string == null || string.trim().length() == 0) {
            return 0;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        Date date = new Date();
        date = simpleDateFormat.parse(string);
        long l = date.getTime();
        int n = (int)(l / 1000L);
        return n;
    }

    public static Calendar convertDateToCalendar(String string, String string2, String string3) throws NumberFormatException {
        Calendar calendar = null;
        if (string != null && string.trim().length() > 0 && string2 != null && string2.trim().length() > 0 && string3 != null && string3.trim().length() > 0) {
            calendar = Calendar.getInstance();
            calendar.set(1, new Integer(string));
            calendar.set(2, new Integer(string2));
            calendar.set(5, new Integer(string3));
        }
        return calendar;
    }

    public static List getOccurenceYearList(int n) {
        ArrayList<LabelValueBean> arrayList = new ArrayList<LabelValueBean>();
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2006);
        LabelValueBean labelValueBean = null;
        LabelValueBean labelValueBean2 = new LabelValueBean("", "");
        arrayList.add(labelValueBean2);
        for (int i = calendar.get(1); i <= n; ++i) {
            labelValueBean = new LabelValueBean(String.valueOf(calendar.get(1)), String.valueOf(calendar.get(1)));
            calendar.add(1, 1);
            arrayList.add(labelValueBean);
        }
        return arrayList;
    }

    public static List getOccurenceMonthList() {
        ArrayList<LabelValueBean> arrayList = new ArrayList<LabelValueBean>();
        LabelValueBean labelValueBean = null;
        Calendar calendar = Calendar.getInstance();
        LabelValueBean labelValueBean2 = null;
        LabelValueBean labelValueBean3 = null;
        LabelValueBean labelValueBean4 = new LabelValueBean("", "");
        arrayList.add(labelValueBean4);
        for (int i = 0; i < 12; ++i) {
            calendar.set(2, i);
            labelValueBean2 = new LabelValueBean("0" + (1 + calendar.get(2)), String.valueOf("0" + (1 + calendar.get(2))));
            labelValueBean3 = new LabelValueBean(String.valueOf(1 + calendar.get(2)), String.valueOf(1 + calendar.get(2)));
            labelValueBean = i < 9 ? labelValueBean2 : labelValueBean3;
            arrayList.add(labelValueBean);
        }
        return arrayList;
    }

    public static List getOccurenceDayList() {
        LabelValueBean labelValueBean = null;
        ArrayList<LabelValueBean> arrayList = new ArrayList<LabelValueBean>();
        LabelValueBean labelValueBean2 = null;
        LabelValueBean labelValueBean3 = null;
        LabelValueBean labelValueBean4 = new LabelValueBean("", "");
        arrayList.add(labelValueBean4);
        for (int i = 0; i < 31; ++i) {
            labelValueBean2 = new LabelValueBean("0" + (i + 1), String.valueOf("0" + (i + 1)));
            labelValueBean3 = new LabelValueBean(String.valueOf(i + 1), String.valueOf(i + 1));
            labelValueBean = i < 9 ? labelValueBean2 : labelValueBean3;
            arrayList.add(labelValueBean);
        }
        return arrayList;
    }

    public static String getCurrentDateTime(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, locale);
        return dateFormat.format(new Date());
    }

    public static List splitter(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            arrayList.add(string3);
        }
        return arrayList;
    }

    public static boolean isAllowableNode(HsmHostNodeData hsmHostNodeData) {
        int n = hsmHostNodeData.getNodeType();
        return n == 65541 || n == 65542;
    }

    public static boolean isLinuxNode(String string) {
        int n = Integer.valueOf(string);
        return n == 65541;
    }

    public static boolean isWindowsNode(String string) {
        int n = Integer.valueOf(string);
        return n == 65542;
    }

    public static boolean populateBuffer(Vector[] vectorArray, StringBuffer stringBuffer) {
        boolean bl = false;
        int n = 0;
        Vector vector = null;
        Vector vector2 = null;
        Vector vector3 = null;
        Vector vector4 = null;
        Vector vector5 = null;
        Vector vector6 = null;
        if (vectorArray.length != 6) {
            return bl;
        }
        bl = true;
        vector = vectorArray[n++];
        vector2 = vectorArray[n++];
        vector3 = vectorArray[n++];
        vector4 = vectorArray[n++];
        vector5 = vectorArray[n++];
        vector6 = vectorArray[n];
        for (int i = 0; i < vector2.size(); ++i) {
            String[] stringArray;
            int n2;
            Object object;
            CommonUtil.populateData(stringBuffer, "DeviceID", vector, i);
            CommonUtil.populateData(stringBuffer, "DeviceName", vector2, i);
            CommonUtil.populateData(stringBuffer, "UsageRateCheck", vector3, i);
            CommonUtil.populateData(stringBuffer, "SamplingCount", vector4, i);
            CommonUtil.populateData(stringBuffer, "PollingInterval", vector5, i);
            int n3 = (Integer)vector.elementAt(i);
            if (n3 == 196608 || n3 == 131072) {
                stringBuffer.append("<ThresholdParam>");
                object = ((String)((Vector)vector6.elementAt(i)).elementAt(0)).split("-");
                CommonUtil.populateData(stringBuffer, "Threshold", object[2], i);
                stringBuffer.append("</ThresholdParam>");
                continue;
            }
            if (n3 == 65536) {
                stringBuffer.append("<ThresholdParam>");
                object = (Vector)vector6.elementAt(i);
                for (n2 = 0; n2 < ((Vector)object).size(); ++n2) {
                    stringArray = ((String)((Vector)object).elementAt(n2)).split("-");
                    CommonUtil.populateData(stringBuffer, "Drive", stringArray[1], i);
                    CommonUtil.populateData(stringBuffer, "Threshold", stringArray[2], i);
                }
                stringBuffer.append("</ThresholdParam>");
                continue;
            }
            if (n3 != 262144) continue;
            stringBuffer.append("<ThresholdParam>");
            object = (Vector)vector6.elementAt(i);
            for (n2 = 0; n2 < ((Vector)object).size(); ++n2) {
                stringArray = ((String)((Vector)object).elementAt(n2)).split("-");
                CommonUtil.populateData(stringBuffer, "FileSystem", stringArray[1], i);
                CommonUtil.populateData(stringBuffer, "Threshold", stringArray[2], i);
            }
            stringBuffer.append("</ThresholdParam>");
        }
        vector = null;
        vector2 = null;
        vector3 = null;
        vector4 = null;
        vector5 = null;
        vector6 = null;
        return bl;
    }

    public static void populateData(StringBuffer stringBuffer, String string, Object object, int n) {
        Vector vector = null;
        stringBuffer.append("<" + string + ">");
        if (object == null) {
            stringBuffer.append("@@@@@NULL_STRING@@@@@");
        } else if (object instanceof Vector) {
            vector = (Vector)object;
            Object e = vector.elementAt(n);
            if (e == null) {
                stringBuffer.append("@@@@@NULL_STRING@@@@@");
            } else {
                stringBuffer.append(e.toString());
            }
        } else {
            stringBuffer.append(object.toString());
        }
        stringBuffer.append("</" + string + ">");
    }

    public static void populateStringBuffer(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append("<" + string + ">");
        stringBuffer.append(string2 != null ? string2 : "@@@@@NULL_STRING@@@@@");
        stringBuffer.append("</" + string + ">");
    }

    public static boolean isFileExists(String string) {
        boolean bl = false;
        File file = null;
        file = new File(string);
        bl = file.exists();
        return bl;
    }

    public static String checkAlerts(String string, String string2, String string3) {
        String string4 = null;
        String string5 = null;
        string4 = string;
        string5 = string2;
        try {
            if (string == null) {
                string4 = string5;
                ErrorLog.getErrorLog().writeDebugTrace(7, "Property Key in file envAlert.properties doesn't Exists", string3);
            } else if (string.trim().length() < 1) {
                string4 = string5;
                ErrorLog.getErrorLog().writeDebugTrace(7, "Property Value in file envAlert.properties doesn't Exists", string3);
            } else if (!CommonUtil.isNumber(string.trim())) {
                string4 = string5;
                ErrorLog.getErrorLog().writeDebugTrace(7, "Property value is not an integer in file envAlert.properties .", string3);
            } else if (!CommonUtil.isNumberInRange(string.trim(), Integer.parseInt("5"), Integer.parseInt("100"))) {
                string4 = string5;
                ErrorLog.getErrorLog().writeDebugTrace(7, "Property value is outside the range in envAlert.properties file ", string3);
            } else {
                string4 = string.trim();
            }
        }
        catch (NumberFormatException numberFormatException) {
            string4 = string5;
            ErrorLog.getErrorLog().writeDebugTrace(7, "Property value is outside the range in envAlert.properties file ", string3);
        }
        return string4;
    }

    public static WcException getGatewayConnectError(RemoteException remoteException, WcException wcException, String string) {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, string);
        boolean bl = false;
        if (remoteException == null) {
            bl = false;
        }
        ErrorLog.getErrorLog().writeDebugTrace(7, "Exception thrown is of type: " + remoteException, string);
        if (remoteException instanceof AccessException || remoteException instanceof ConnectException || remoteException instanceof ConnectIOException || remoteException instanceof UnknownHostException) {
            bl = true;
        }
        if (bl) {
            wcException = new WcException("KASM18112-E");
        }
        ErrorLog.getErrorLog().writeFunctionalTrace(4, string);
        return wcException;
    }
}

