/*
 * Decompiled with CFR 0.152.
 */
package JP.co.Hitachi.soft.System_Manager.webconsole.common;

import JP.co.Hitachi.soft.System_Manager.webconsole.common.Const;
import JP.co.Hitachi.soft.System_Manager.webconsole.common.ResourceBundler;
import JP.co.Hitachi.soft.System_Manager.webconsole.common.WcException;
import java.util.ArrayList;
import jp.co.hitachi.soft.hntrlib2.HntrPureTrace;
import org.apache.struts.util.MessageResources;

public class ErrorLog {
    private static ErrorLog m_objErrorLogger = null;
    private HntrPureTrace m_objHntrTrace = null;
    private int m_iTraceLevel = 0;
    private int m_iTracefileSize = 0;
    private int m_iTracefileCount = 0;
    private String m_stTraceFilePath = null;
    public static final int APP_START = 1;
    public static final int APP_END = 2;
    public static final int FT_ENTRY = 3;
    public static final int FT_EXIT = 4;
    public static final int FT_ERROR = 5;
    public static final int FT_EXCEPTION = 6;
    public static final int FT_INFORMATION = 7;
    public static final int FT_ARGUMENTS = 8;
    public static final int FT_RETURN = 9;
    private static final String TRACE_FILE_NAME = "@WebConsole@";
    private static final String DEFAULT_TRACE_FILE_PATH = Const.SEPARATOR_FILE + "log";
    private static final String DEFAULT_TRACE_FILE_PATH_PREFIX = Const.SEPARATOR_FILE + "WEB-INF";
    private static final int DEFAULT_TRACE_OUTPUT_LEVEL = 10;
    private static final int DEFAULT_TRACE_OUTPUT_SIZE = 4000000;
    private static final int DEFAULT_TRACE_OUTPUT_COUNT = 16;
    public static final int MIN_TRACE_FILE_COUNT = 1;
    public static final int MIN_TRACE_FILE_SIZE = 4096;
    public static final int MIN_TRACE_FILE_LEVEL = 0;
    public static final int MAX_TRACE_FILE_COUNT = 16;
    public static final int MAX_TRACE_FILE_SIZE = 0x1000000;
    public static final int MAX_TRACE_FILE_LEVEL = 20;
    private static final String APP_START_MSG_ID = "Start";
    private static final String APP_END_MSG_ID = "End";
    private static final String FT_ENTRY_MSG_ID = "Entry";
    private static final String FT_EXIT_MSG_ID = "Exit";
    private static final String FT_INFO_MSG_ID = "Information";
    private static final String FT_ERR_MSG_ID = "Error";
    private static final String FT_EXCP_MSG_ID = "Exception";
    private static final String FT_RET_MSG_ID = "Return";
    private static final String FT_ARG_MSG_ID = "Arguments";
    private static final String APP_START_MSG_TYPE = "AB";
    private static final String APP_END_MSG_TYPE = "AE";
    private static final String FT_ENTRY_MSG_TYPE = "FB";
    private static final String FT_EXIT_MSG_TYPE = "FE";
    private static final String FT_INFO_MSG_TYPE = "INFO";
    private static final String FT_RET_MSG_TYPE = "RET";
    private static final String FT_ARG_MSG_TYPE = "ARG";
    private static final String FT_ERR_MSG_TYPE = "ERR";
    private static final String FT_EXCP_MSG_TYPE = "EXCP";
    private static final int LV_0 = 0;
    private static final int LV_10 = 10;
    private static final int LV_20 = 20;
    private static final String APPLICATION_NAME = "WebConsole";
    private ArrayList m_alMessageList = new ArrayList();
    private static final String TRACE_FILE_PATH_INVALID_MSG = "The key value for log.file.storage.directory is invalid ";
    private static final String TRACE_FILE_COUNT_INVALID_MSG = "The key value for log.output.count is invalid ";
    private static final String TRACE_FILE_SIZE_INVALID_MSG = "The key value for log.output.size is invalid ";
    private static final String TRACE_FILE_LEVEL_INVALID_MSG = "The key value for log.output.level is invalid ";
    private static final String PROPERTY_FILE_PATH_INVALID_MSG = "The property file is not found";
    private static final String APPLICATION_START_MSG = "WebConsole Application started";
    private static final String APPLICATION_END_MSG = "WebConsole Application ended";
    private static final String ACTION_TYPE_ERROR = "The action specified for r_iAction is incorrect";

    private ErrorLog() {
        this.m_objHntrTrace = new HntrPureTrace();
    }

    public void init(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(DEFAULT_TRACE_FILE_PATH_PREFIX);
            stringBuffer.append(Const.SEPARATOR_FILE);
            stringBuffer.append(DEFAULT_TRACE_FILE_PATH);
            stringBuffer.append(Const.SEPARATOR_FILE);
            stringBuffer.append(TRACE_FILE_NAME);
            this.m_stTraceFilePath = stringBuffer.toString();
        } else {
            stringBuffer.append(DEFAULT_TRACE_FILE_PATH);
            stringBuffer.append(Const.SEPARATOR_FILE);
            stringBuffer.append(TRACE_FILE_NAME);
            this.m_stTraceFilePath = stringBuffer.toString();
        }
        this.setTraceInfo();
    }

    public static ErrorLog getErrorLog() {
        if (m_objErrorLogger == null) {
            m_objErrorLogger = new ErrorLog();
        }
        return m_objErrorLogger;
    }

    private void startTrace() {
        try {
            ErrorLog.m_objErrorLogger.m_objHntrTrace.setLogLevel(this.m_iTraceLevel);
            ErrorLog.m_objErrorLogger.m_objHntrTrace.setFileThreshold(0);
            ErrorLog.m_objErrorLogger.m_objHntrTrace.startTrace(APPLICATION_NAME, this.m_stTraceFilePath, this.m_iTracefileCount, this.m_iTracefileSize);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void endTrace() {
        ErrorLog.m_objErrorLogger.m_objHntrTrace.endTrace();
    }

    public synchronized void writeFunctionalTrace(int n) {
        String string = null;
        try {
            if (0 <= this.m_iTraceLevel) {
                if (n == 1) {
                    string = APPLICATION_START_MSG;
                    ErrorLog.m_objErrorLogger.m_objHntrTrace.putWithMsgTypeMb(0, APPLICATION_NAME, APP_START_MSG_ID, APP_START_MSG_TYPE, string);
                } else if (n == 2) {
                    string = APPLICATION_END_MSG;
                    ErrorLog.m_objErrorLogger.m_objHntrTrace.putWithMsgTypeMb(0, APPLICATION_NAME, APP_END_MSG_ID, APP_END_MSG_TYPE, string);
                } else {
                    string = ACTION_TYPE_ERROR;
                    ErrorLog.m_objErrorLogger.m_objHntrTrace.putWithMsgTypeMb(0, APPLICATION_NAME, FT_ERR_MSG_ID, FT_ERR_MSG_TYPE, string);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void writeFunctionalTrace(int n, String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Throwable throwable = new Throwable();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            if (10 <= this.m_iTraceLevel) {
                if (string == null) {
                    MessageResources messageResources = ResourceBundler.getResourceBundle("messageResources");
                    string4 = messageResources.getMessage("KASM18044-E");
                    this.writeTraceMessage(5, string4);
                    return;
                }
                string2 = stackTraceElementArray[1].getClassName();
                string3 = stackTraceElementArray[1].getMethodName();
                stringBuffer.append(string);
                stringBuffer.append(":");
                stringBuffer.append(string2);
                stringBuffer.append(":");
                stringBuffer.append(string3);
                string4 = stringBuffer.toString();
                if (n == 3) {
                    ErrorLog.m_objErrorLogger.m_objHntrTrace.putWithMsgTypeMb(10, APPLICATION_NAME, FT_ENTRY_MSG_ID, FT_ENTRY_MSG_TYPE, string4);
                } else if (n == 4) {
                    ErrorLog.m_objErrorLogger.m_objHntrTrace.putWithMsgTypeMb(10, APPLICATION_NAME, FT_EXIT_MSG_ID, FT_EXIT_MSG_TYPE, string4);
                } else {
                    string4 = null;
                    string4 = ACTION_TYPE_ERROR;
                    ErrorLog.m_objErrorLogger.m_objHntrTrace.putWithMsgTypeMb(10, APPLICATION_NAME, FT_ERR_MSG_ID, FT_ERR_MSG_TYPE, string4);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void writeErrorTrace(String string, String string2, String string3) {
        String string4 = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (0 <= this.m_iTraceLevel) {
                if (string == null || string3 == null || string2 == null) {
                    MessageResources messageResources = ResourceBundler.getResourceBundle("messageResources");
                    string4 = messageResources.getMessage("KASM18044-E");
                    this.writeTraceMessage(5, string4);
                    return;
                }
                stringBuffer.append(string3);
                stringBuffer.append(":");
                stringBuffer.append(string);
                stringBuffer.append("-");
                stringBuffer.append(string2);
                string4 = stringBuffer.toString();
                ErrorLog.m_objErrorLogger.m_objHntrTrace.putWithMsgTypeMb(0, APPLICATION_NAME, FT_ERR_MSG_ID, FT_ERR_MSG_TYPE, string4);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void writeErrorTrace(int n, String string, Object object) {
        String string2 = null;
        try {
            if (0 <= this.m_iTraceLevel) {
                if (object == null || string == null) {
                    MessageResources messageResources = ResourceBundler.getResourceBundle("messageResources");
                    string2 = messageResources.getMessage("KASM18044-E");
                    this.writeTraceMessage(5, string2);
                    return;
                }
                if (object instanceof WcException && n == 5) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(string);
                    stringBuffer.append(":");
                    stringBuffer.append(((WcException)object).getMessageId());
                    stringBuffer.append("-");
                    stringBuffer.append(((WcException)object).getMessage());
                    string2 = stringBuffer.toString();
                    ErrorLog.m_objErrorLogger.m_objHntrTrace.putWithMsgTypeMb(0, APPLICATION_NAME, FT_ERR_MSG_ID, FT_ERR_MSG_TYPE, string2);
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(string);
                    stringBuffer.append(":");
                    String string3 = null;
                    string3 = this.getStackInfo((Throwable)object);
                    stringBuffer.append(string3);
                    string3 = stringBuffer.toString();
                    ErrorLog.m_objErrorLogger.m_objHntrTrace.putWithMsgTypeMb(0, APPLICATION_NAME, FT_EXCP_MSG_ID, FT_EXCP_MSG_TYPE, string3);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getStackInfo(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        stringBuffer.append(throwable.toString());
        stringBuffer.append("\n");
        stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i <= stackTraceElementArray.length - 1; ++i) {
            stringBuffer.append(stackTraceElementArray[i]);
            if (i >= stackTraceElementArray.length - 1) continue;
            stringBuffer.append("\n");
        }
        string = stringBuffer.toString();
        return string;
    }

    public synchronized void writeDebugTrace(int n, String string, String string2) {
        String string3 = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (20 <= this.m_iTraceLevel) {
                if (string == null || string2 == null) {
                    MessageResources messageResources = ResourceBundler.getResourceBundle("messageResources");
                    string3 = messageResources.getMessage("KASM18044-E");
                    this.writeTraceMessage(5, string3);
                    return;
                }
                stringBuffer.append(string2);
                stringBuffer.append(":");
                stringBuffer.append(string);
                string3 = stringBuffer.toString();
                this.writeTraceMessage(n, string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setTraceInfo() {
        Object var2_1 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            MessageResources messageResources = ResourceBundler.getResourceBundle("internalResources");
            if (messageResources != null) {
                string = messageResources.getMessage("internal.log.output.count");
                this.setTraceFileCount(string);
                string2 = messageResources.getMessage("internal.log.output.size", (Object)messageResources);
                this.setTraceFileSize(string2);
                string3 = messageResources.getMessage("internal.log.output.level", (Object)messageResources);
                this.setTraceFileLevel(string3);
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(DEFAULT_TRACE_FILE_PATH);
                stringBuffer.append(Const.SEPARATOR_FILE);
                stringBuffer.append(TRACE_FILE_NAME);
                this.m_stTraceFilePath = stringBuffer.toString();
                this.m_iTracefileCount = 16;
                this.m_iTracefileSize = 4000000;
                this.m_iTraceLevel = 10;
                this.m_alMessageList.add(PROPERTY_FILE_PATH_INVALID_MSG);
            }
            this.startTrace();
            for (int i = 0; i < this.m_alMessageList.size(); ++i) {
                if (this.m_alMessageList.get(i) == null) continue;
                ErrorLog.m_objErrorLogger.m_objHntrTrace.putWithMsgTypeMb(10, APPLICATION_NAME, FT_ERR_MSG_ID, FT_ERR_MSG_TYPE, this.m_alMessageList.get(i).toString());
            }
            this.m_alMessageList = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setTraceFileCount(String string) {
        int n = 16;
        if (string == null || string.trim().length() == 0) {
            this.m_iTracefileCount = 16;
            this.m_alMessageList.add(TRACE_FILE_COUNT_INVALID_MSG);
        } else {
            n = Integer.parseInt(string.trim());
            if (n < 1 || n > 16) {
                this.m_iTracefileCount = 16;
                this.m_alMessageList.add(TRACE_FILE_COUNT_INVALID_MSG);
            } else {
                this.m_iTracefileCount = n;
            }
        }
    }

    private void setTraceFileSize(String string) {
        int n = 4000000;
        if (string == null || string.trim().length() == 0) {
            this.m_iTracefileSize = 4000000;
            this.m_alMessageList.add(TRACE_FILE_SIZE_INVALID_MSG);
        } else {
            n = Integer.parseInt(string.trim());
            if (n < 4096 || n > 0x1000000) {
                this.m_iTracefileSize = 4000000;
                this.m_alMessageList.add(TRACE_FILE_SIZE_INVALID_MSG);
            } else {
                this.m_iTracefileSize = n;
            }
        }
    }

    private void setTraceFileLevel(String string) {
        int n = 10;
        if (string == null || string.trim().length() == 0) {
            this.m_iTraceLevel = 10;
            this.m_alMessageList.add(TRACE_FILE_LEVEL_INVALID_MSG);
        } else {
            n = Integer.parseInt(string.trim());
            if (n < 0 || n > 20) {
                this.m_iTraceLevel = 10;
                this.m_alMessageList.add(TRACE_FILE_LEVEL_INVALID_MSG);
            } else {
                this.m_iTraceLevel = n;
            }
        }
    }

    private void writeTraceMessage(int n, String string) {
        String string2 = null;
        if (n == 7) {
            ErrorLog.m_objErrorLogger.m_objHntrTrace.putWithMsgTypeMb(20, APPLICATION_NAME, FT_INFO_MSG_ID, FT_INFO_MSG_TYPE, string);
        } else if (n == 8) {
            ErrorLog.m_objErrorLogger.m_objHntrTrace.putWithMsgTypeMb(20, APPLICATION_NAME, FT_ARG_MSG_ID, FT_ARG_MSG_TYPE, string);
        } else if (n == 9) {
            ErrorLog.m_objErrorLogger.m_objHntrTrace.putWithMsgTypeMb(20, APPLICATION_NAME, FT_RET_MSG_ID, FT_RET_MSG_TYPE, string);
        } else {
            string2 = ACTION_TYPE_ERROR;
            ErrorLog.m_objErrorLogger.m_objHntrTrace.putWithMsgTypeMb(20, APPLICATION_NAME, FT_ERR_MSG_ID, FT_ERR_MSG_TYPE, string);
        }
    }
}

