/*
 * Decompiled with CFR 0.152.
 */
package JP.co.Hitachi.soft.System_Manager.webconsole.controller;

import JP.co.Hitachi.soft.System_Manager.webconsole.common.CommonUtil;
import JP.co.Hitachi.soft.System_Manager.webconsole.common.Const;
import JP.co.Hitachi.soft.System_Manager.webconsole.common.ErrorLog;
import JP.co.Hitachi.soft.System_Manager.webconsole.common.WcException;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.bean.ErrorBean;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ConfigHelper;

public class ActionServlet
extends org.apache.struts.action.ActionServlet {
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        String string = null;
        string = servletConfig.getServletContext().getRealPath("");
        ErrorLog.getErrorLog().init(string);
        ErrorLog.getErrorLog().writeFunctionalTrace(1);
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            httpServletRequest.setCharacterEncoding("UTF-8");
            this.isValidRequest(httpServletRequest, httpServletResponse);
            super.service(httpServletRequest, httpServletResponse);
        }
        catch (WcException wcException) {
            this.forwardRequest(httpServletRequest, httpServletResponse, wcException);
        }
    }

    private void isValidRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, WcException {
        if (httpServletRequest == null || httpServletResponse == null) {
            throw new WcException("KASM18044-E");
        }
        if (this.isSessionCheckRequire(httpServletRequest, httpServletResponse)) {
            this.isValidSession(httpServletRequest);
            this.isValidUser(httpServletRequest);
        }
    }

    private boolean isSessionCheckRequire(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws WcException {
        if (httpServletRequest == null || httpServletResponse == null) {
            throw new WcException("KASM18044-E");
        }
        ConfigHelper configHelper = new ConfigHelper(this.getServletContext(), httpServletRequest, httpServletResponse);
        if (configHelper == null) {
            throw new WcException("KASM18044-E");
        }
        String string = configHelper.getActionMappingName(httpServletRequest.getServletPath());
        if (string == null) {
            throw new WcException("KASM18044-E");
        }
        ActionMapping actionMapping = configHelper.getActionMapping(string);
        if (actionMapping == null) {
            return false;
        }
        String string2 = actionMapping.getPath();
        if (string2 == null) {
            throw new WcException("KASM18044-E");
        }
        int n = Const.ACTION_PATHS_SESSION_IGNORED.length;
        for (int i = 0; i < n; ++i) {
            if (!string2.equals(Const.ACTION_PATHS_SESSION_IGNORED[i])) continue;
            return false;
        }
        return true;
    }

    private void isValidSession(HttpServletRequest httpServletRequest) throws WcException {
        if (httpServletRequest == null) {
            throw new WcException("KASM18044-E");
        }
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession == null) {
            throw new WcException("KASM18044-E");
        }
        if (httpServletRequest.isRequestedSessionIdValid() && httpSession.getAttribute("RequestProcessor") != null && httpSession.getAttribute("UserType") != null) {
            return;
        }
        ErrorLog.getErrorLog().writeDebugTrace(7, "Session is invalid", httpServletRequest.getRemoteAddr());
        WcException wcException = new WcException("KASM1802A-E");
        throw wcException;
    }

    private void isValidUser(HttpServletRequest httpServletRequest) throws WcException {
        if (httpServletRequest == null) {
            throw new WcException("KASM18044-E");
        }
        if (httpServletRequest.getSession().getAttribute("UserType") != null) {
            int n = (Integer)httpServletRequest.getSession().getAttribute("UserType");
            if (n == 1) {
                return;
            }
            if (n == 0) {
                return;
            }
        } else {
            throw new WcException("KASM18044-E");
        }
        ErrorLog.getErrorLog().writeDebugTrace(7, "User type is invalid", httpServletRequest.getRemoteAddr());
        WcException wcException = new WcException("KASM18029-E", CommonUtil.getCurrentDateTime(httpServletRequest.getLocale()));
        throw wcException;
    }

    private void forwardRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, WcException wcException) throws ServletException, IOException {
        if (httpServletRequest == null || httpServletResponse == null) {
            throw new ServletException();
        }
        ErrorBean errorBean = new ErrorBean();
        if (wcException == null) {
            wcException = new WcException("KASM18044-E");
        }
        errorBean.setErrorCode(wcException.getMessageId());
        errorBean.setErrorMessage(wcException.getMessage());
        httpServletRequest.setAttribute("ErrorBean", (Object)errorBean);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(errorBean.getErrorMessage());
        stringBuffer.append(": Requested URL is ");
        stringBuffer.append(httpServletRequest.getRequestURL());
        ErrorLog.getErrorLog().writeErrorTrace(errorBean.getErrorCode(), stringBuffer.toString(), httpServletRequest.getRemoteAddr());
        errorBean = null;
        ConfigHelper configHelper = new ConfigHelper(this.getServletContext(), httpServletRequest, httpServletResponse);
        if (configHelper == null) {
            throw new ServletException();
        }
        ActionForward actionForward = configHelper.getActionForward("SessionError");
        if (actionForward == null) {
            throw new ServletException();
        }
        String string = actionForward.getPath();
        if (string == null) {
            throw new ServletException();
        }
        httpServletRequest.getRequestDispatcher(string).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    public void destroy() {
        super.destroy();
        ErrorLog.getErrorLog().endTrace();
        ErrorLog.getErrorLog().writeFunctionalTrace(2);
    }
}

