/*
 * Decompiled with CFR 0.152.
 */
package JP.co.Hitachi.soft.System_Manager.webconsole.model;

import JP.co.Hitachi.soft.System_Manager.data.HsmAlertAttributeData;
import JP.co.Hitachi.soft.System_Manager.data.HsmHostNodeData;
import JP.co.Hitachi.soft.System_Manager.data.HsmNodeData;
import JP.co.Hitachi.soft.System_Manager.webconsole.common.ErrorLog;
import JP.co.Hitachi.soft.System_Manager.webconsole.common.GroupCommon;
import JP.co.Hitachi.soft.System_Manager.webconsole.common.WcException;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.cache.CacheManager;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.AgentAlertAttributeActionCommand;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.AgentAlertSettingActionCommand;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.AgentNetworkSettingActionCommand;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.AgentUsageRateSettingActionCommand;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.AlertLogDataAcquisitionCommand;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.AlertLogDelInfoAcquisitionCommand;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.AlertLogDeletionCommand;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.AlertLogInfoAcquisitionCommand;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.Command;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.ConnMgmtDeletionActionCommand;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.ConnMgmtRegistActionCommand;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.ConnectionCheckCommand;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.DisplayActionCommand;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.GroupCreateSetActionCommand;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.GroupEditSetActionCommand;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.GroupListActionCommand;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.GroupOrHostDeletionActionCommand;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.GroupPowerControlActionCommand;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.HostOperationActionCommand;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.InventoryDetailActionCommand;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.InventoryListActionCommand;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.LoginAuthActionCommand;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.LogoutActionCommand;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.MachineAdditionGetActionCommand;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.MachineAdditionSetActionCommand;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.ManagerNetworkSettingActionCommand;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.NotificationAlertConfirmationCommand;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.NotificationAlertDataAcquisitionCommand;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.NotificationAlertDeletionCommand;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.WebConsoleAlertSettingActionCommand;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.request.AgentAlertAttributeSettingSetActionRequest;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.request.DisplayActionRequest;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.request.DisplayDetailActionRequest;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.request.GroupCreateGetActionRequest;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.request.GroupDetailActionRequest;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.request.GroupEditGetActionRequest;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.request.GroupOrHostDeletionActionRequest;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.request.GroupPowerControlActionRequest;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.request.InventoryListActionRequest;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.request.MachineAdditionGetActionRequest;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.request.MachineAdditionSetActionRequest;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.request.Request;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.AgentAlertAttributeSettingGetActionResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.AlertLogDataAcquisitionResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.AlertLogDelInfoAcquisitionResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.AlertLogDeletionPageResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.AlertLogDeletionResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.AlertLogPageAcquisitionResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.DisplayActionResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.DisplayDetailActionResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.GroupCreateGetActionResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.GroupDetailActionResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.GroupEditGetActionResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.GroupListActionResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.GroupOrHostDeletionActionResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.GroupPowerControlActionResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.InventoryListActionResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.MachineAdditionGetActionResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.NotificationAlertConfirmationResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.NotificationAlertDataAcquisitionResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.NotificationAlertDeletionResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.NotificationAlertPageResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.Response;
import JP.co.Hitachi.soft.System_Manager.webconsole.remote.WebGatewayCommunicator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class RequestProcessor {
    private String m_stClientIp = null;
    private WebGatewayCommunicator m_objGatewayCommunicator = null;
    private CacheManager m_objCacheManager = new CacheManager();
    int m_Flag = 1;

    public RequestProcessor() {
        this.m_objGatewayCommunicator = new WebGatewayCommunicator();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response getResponse(Request request) throws WcException {
        this.m_stClientIp = this.m_objGatewayCommunicator.getClientIPAddress();
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_objGatewayCommunicator.getClientIPAddress());
        Response response = null;
        try {
            block26: {
                int n;
                int n2;
                Command command;
                block25: {
                    if (request == null) {
                        WcException wcException = new WcException("KASM18044-E");
                        throw wcException;
                    }
                    ErrorLog.getErrorLog().writeDebugTrace(8, request.toString(), this.m_stClientIp);
                    command = null;
                    n2 = request.getRequestId();
                    n = request.getCachePolicy();
                    if (n != 1) break block25;
                    if (n2 == 6) {
                        this.processConnectionCheck(request);
                    }
                    if ((response = this.checkCacheBefore(request)) != null) {
                        response = this.process(request, response);
                        break block26;
                    } else {
                        command = this.createCommand(request);
                        if (command == null) {
                            ErrorLog.getErrorLog().writeDebugTrace(7, "Command is null", this.m_stClientIp);
                            WcException wcException = new WcException("KASM18044-E");
                            throw wcException;
                        }
                        response = command.execute(request, this.m_objGatewayCommunicator);
                        if (response != null) {
                            this.writeCacheAfterFetch(request, response);
                        }
                    }
                    break block26;
                }
                if (n == 3) {
                    if (n2 == 21 || n2 == 24 || n2 == 23 || n2 == 5 && this.m_Flag == 1 || n2 == 37) {
                        this.processConnectionCheck(request);
                    }
                    this.m_Flag = 1;
                    command = this.createCommand(request);
                    if (command == null) {
                        ErrorLog.getErrorLog().writeDebugTrace(7, "Command is null", this.m_stClientIp);
                        WcException wcException = new WcException("KASM18044-E");
                        throw wcException;
                    }
                    response = command.execute(request, this.m_objGatewayCommunicator);
                    if (n2 == 5) {
                        this.m_objCacheManager.removeCache();
                    }
                    if (response != null) {
                        this.writeCacheAfterFetch(request, response);
                    }
                } else {
                    Object object;
                    if (n != 2) {
                        ErrorLog.getErrorLog().writeDebugTrace(7, "Cache policy is invalid", this.m_stClientIp);
                        WcException wcException = new WcException("KASM18044-E");
                        throw wcException;
                    }
                    if (n2 == 20 || n2 == 41 || n2 == 39 || n2 == 43 || n2 == 45) {
                        this.processConnectionCheck(request);
                    } else if (n2 == 38) {
                        object = new AgentAlertAttributeSettingGetActionResponse();
                        object = (AgentAlertAttributeSettingGetActionResponse)this.checkCacheBefore(request);
                        if (object == null) {
                            ErrorLog.getErrorLog().writeDebugTrace(7, "Cache is null. AlertAttribute setting failed", this.m_stClientIp);
                            WcException wcException = new WcException("KASM18044-E");
                            throw wcException;
                        }
                        AgentAlertAttributeSettingSetActionRequest agentAlertAttributeSettingSetActionRequest = this.processAlertAttributeSetting((AgentAlertAttributeSettingGetActionResponse)object, request);
                        request = agentAlertAttributeSettingSetActionRequest;
                    }
                    command = this.createCommand(request);
                    if (command == null) {
                        ErrorLog.getErrorLog().writeDebugTrace(7, "Command is null", this.m_stClientIp);
                        object = new WcException("KASM18044-E");
                        throw object;
                    }
                    response = command.execute(request, this.m_objGatewayCommunicator);
                }
            }
            if (response == null) return response;
            ErrorLog.getErrorLog().writeDebugTrace(9, response.toString(), this.m_stClientIp);
            return response;
        }
        catch (WcException wcException) {
            throw wcException;
        }
        catch (Exception exception) {
            ErrorLog.getErrorLog().writeErrorTrace(6, this.m_stClientIp, exception);
            WcException wcException = new WcException("KASM18044-E");
            throw wcException;
        }
        catch (Throwable throwable) {
            ErrorLog.getErrorLog().writeErrorTrace(6, this.m_stClientIp, throwable);
            WcException wcException = new WcException("KASM18044-E");
            throw wcException;
        }
        finally {
            ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
        }
    }

    private Response checkCacheBefore(Request request) {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIp);
        Response response = null;
        response = this.m_objCacheManager.checkCacheExists(request);
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
        return response;
    }

    private Command createCommand(Request request) throws WcException {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIp);
        Command command = null;
        int n = request.getRequestId();
        if (n == 1) {
            command = new LoginAuthActionCommand();
        } else if (n == 49) {
            command = new LogoutActionCommand();
        } else if (n == 7) {
            command = new GroupListActionCommand();
        } else if (n != 8 && n != 9) {
            if (n == 10) {
                command = new GroupCreateSetActionCommand();
            } else if (n != 11) {
                if (n == 12) {
                    command = new GroupEditSetActionCommand();
                } else if (n == 13) {
                    command = new MachineAdditionGetActionCommand();
                } else if (n == 14) {
                    command = new MachineAdditionSetActionCommand();
                } else if (n == 15) {
                    command = new GroupOrHostDeletionActionCommand();
                } else if (n == 16) {
                    command = new GroupPowerControlActionCommand();
                } else if (n == 17) {
                    command = new GroupPowerControlActionCommand();
                } else if (n == 18) {
                    command = new GroupPowerControlActionCommand();
                } else if (n == 19) {
                    command = new GroupPowerControlActionCommand();
                } else if (n == 2) {
                    command = new DisplayActionCommand();
                } else if (n == 26) {
                    command = new NotificationAlertDataAcquisitionCommand();
                } else if (n == 27) {
                    command = new NotificationAlertConfirmationCommand();
                } else if (n == 28) {
                    command = new NotificationAlertDeletionCommand();
                } else if (n == 20) {
                    command = new AlertLogInfoAcquisitionCommand();
                } else if (n == 21) {
                    command = new AlertLogDataAcquisitionCommand();
                } else if (n == 23) {
                    command = new AlertLogDelInfoAcquisitionCommand();
                } else if (n == 24) {
                    command = new AlertLogDeletionCommand();
                } else if (n != 25 && n != 22 && n != 29) {
                    if (n == 5) {
                        command = new InventoryListActionCommand();
                    } else if (n == 6) {
                        command = new InventoryDetailActionCommand();
                    } else if (n == 30) {
                        command = new HostOperationActionCommand();
                    } else if (n == 31) {
                        command = new HostOperationActionCommand();
                    } else if (n == 32) {
                        command = new HostOperationActionCommand();
                    } else if (n == 33) {
                        command = new HostOperationActionCommand();
                    } else if (n == 34) {
                        command = new HostOperationActionCommand();
                    } else if (n == 35) {
                        command = new ConnMgmtRegistActionCommand();
                    } else if (n == 36) {
                        command = new ConnMgmtDeletionActionCommand();
                    } else if (n == 39) {
                        command = new AgentAlertSettingActionCommand();
                    } else if (n == 40) {
                        command = new AgentAlertSettingActionCommand();
                    } else if (n == 37) {
                        command = new AgentAlertAttributeActionCommand();
                    } else if (n == 38) {
                        command = new AgentAlertAttributeActionCommand();
                    } else if (n == 41) {
                        command = new AgentNetworkSettingActionCommand();
                    } else if (n == 42) {
                        command = new AgentNetworkSettingActionCommand();
                    } else if (n == 43) {
                        command = new AgentUsageRateSettingActionCommand();
                    } else if (n == 44) {
                        command = new AgentUsageRateSettingActionCommand();
                    } else if (n == 45) {
                        command = new ManagerNetworkSettingActionCommand();
                    } else if (n == 46) {
                        command = new ManagerNetworkSettingActionCommand();
                    } else if (n == 47) {
                        command = new WebConsoleAlertSettingActionCommand();
                    } else if (n == 48) {
                        command = new WebConsoleAlertSettingActionCommand();
                    } else {
                        ErrorLog.getErrorLog().writeDebugTrace(7, "Invalid request id", this.m_stClientIp);
                        WcException wcException = new WcException("KASM18044-E");
                        throw wcException;
                    }
                }
            }
        }
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
        return command;
    }

    private void writeCacheAfterFetch(Request request, Response response) {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIp);
        this.m_objCacheManager.updateCache(request, response);
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
    }

    public void setGatewayCommunicator(WebGatewayCommunicator webGatewayCommunicator) {
        this.m_objGatewayCommunicator = webGatewayCommunicator;
    }

    private Response process(Request request, Response response) throws WcException {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIp);
        Response response2 = null;
        int n = request.getRequestId();
        if (n == 8) {
            GroupListActionResponse groupListActionResponse = (GroupListActionResponse)response;
            GroupDetailActionRequest groupDetailActionRequest = (GroupDetailActionRequest)request;
            response2 = this.processGroupDetailActionReq(groupListActionResponse, groupDetailActionRequest);
        } else if (n == 9) {
            GroupListActionResponse groupListActionResponse = (GroupListActionResponse)response;
            GroupCreateGetActionRequest groupCreateGetActionRequest = (GroupCreateGetActionRequest)request;
            response2 = this.processGroupCreateGetActionReq(groupListActionResponse, groupCreateGetActionRequest);
        } else if (n == 11) {
            GroupListActionResponse groupListActionResponse = (GroupListActionResponse)response;
            GroupEditGetActionRequest groupEditGetActionRequest = (GroupEditGetActionRequest)request;
            response2 = this.processGroupEditGetActionReq(groupListActionResponse, groupEditGetActionRequest);
        } else if (n == 14) {
            MachineAdditionGetActionResponse machineAdditionGetActionResponse = (MachineAdditionGetActionResponse)response;
            MachineAdditionSetActionRequest machineAdditionSetActionRequest = (MachineAdditionSetActionRequest)request;
            response2 = this.processMachineAddSetActionReq(machineAdditionGetActionResponse, machineAdditionSetActionRequest);
        } else if (n == 13) {
            GroupListActionResponse groupListActionResponse = (GroupListActionResponse)response;
            MachineAdditionGetActionRequest machineAdditionGetActionRequest = (MachineAdditionGetActionRequest)request;
            response2 = this.processMachineAddGetActionReq(groupListActionResponse, machineAdditionGetActionRequest);
        } else if (n == 15) {
            GroupOrHostDeletionActionRequest groupOrHostDeletionActionRequest = (GroupOrHostDeletionActionRequest)request;
            GroupListActionResponse groupListActionResponse = (GroupListActionResponse)response;
            response2 = this.processGroupOrHostDeletionReq(groupListActionResponse, groupOrHostDeletionActionRequest);
        } else if (n == 16) {
            GroupPowerControlActionRequest groupPowerControlActionRequest = (GroupPowerControlActionRequest)request;
            GroupListActionResponse groupListActionResponse = (GroupListActionResponse)response;
            response2 = this.processGroupPowerControlReq(groupListActionResponse, groupPowerControlActionRequest);
        } else if (n == 17) {
            GroupPowerControlActionRequest groupPowerControlActionRequest = (GroupPowerControlActionRequest)request;
            GroupListActionResponse groupListActionResponse = (GroupListActionResponse)response;
            response2 = this.processGroupPowerControlReq(groupListActionResponse, groupPowerControlActionRequest);
        } else if (n == 18) {
            GroupPowerControlActionRequest groupPowerControlActionRequest = (GroupPowerControlActionRequest)request;
            GroupListActionResponse groupListActionResponse = (GroupListActionResponse)response;
            response2 = this.processGroupPowerControlReq(groupListActionResponse, groupPowerControlActionRequest);
        } else if (n == 19) {
            GroupPowerControlActionRequest groupPowerControlActionRequest = (GroupPowerControlActionRequest)request;
            GroupListActionResponse groupListActionResponse = (GroupListActionResponse)response;
            response2 = this.processGroupPowerControlReq(groupListActionResponse, groupPowerControlActionRequest);
        } else if (n == 51) {
            DisplayDetailActionRequest displayDetailActionRequest = (DisplayDetailActionRequest)request;
            DisplayActionResponse displayActionResponse = (DisplayActionResponse)response;
            response2 = this.processHostMgmtDetailReq(displayDetailActionRequest, displayActionResponse);
        } else if (n == 5 || n == 6) {
            response2 = response;
        } else if (n == 29) {
            response2 = this.processNotificationAlertPageResponse(response);
        } else if (n == 22) {
            response2 = this.processAlertLogPageResponse((AlertLogDataAcquisitionResponse)response);
        } else if (n == 25) {
            response2 = this.processAlertLogFilePageResponse(response);
        } else if (n == 52) {
            response2 = response;
        } else {
            ErrorLog.getErrorLog().writeDebugTrace(7, "Invalid request id", this.m_stClientIp);
            WcException wcException = new WcException("KASM18044-E");
            throw wcException;
        }
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
        return response2;
    }

    private GroupDetailActionResponse processGroupDetailActionReq(GroupListActionResponse groupListActionResponse, GroupDetailActionRequest groupDetailActionRequest) {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIp);
        ArrayList arrayList = groupListActionResponse.getClimbTrailList();
        ArrayList arrayList2 = groupListActionResponse.getNodeList();
        String string = groupDetailActionRequest.getClimbTrail();
        GroupCommon groupCommon = new GroupCommon(this.m_stClientIp);
        Vector vector = groupCommon.convertToTokens(string, ",");
        Vector vector2 = null;
        GroupDetailActionResponse groupDetailActionResponse = new GroupDetailActionResponse();
        ArrayList arrayList3 = new ArrayList();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        String string2 = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            string2 = (String)arrayList.get(i);
            if (!string2.startsWith(string) || string2.equalsIgnoreCase(string) || (vector2 = groupCommon.convertToTokens(string2, ",")).size() - vector.size() != 1) continue;
            arrayList3.add(arrayList2.get(i));
            arrayList4.add(string2);
        }
        groupDetailActionResponse.setGroupInfo(arrayList3);
        groupDetailActionResponse.setClimbTrailInfo(arrayList4);
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
        return groupDetailActionResponse;
    }

    private Response processMachineAddSetActionReq(MachineAdditionGetActionResponse machineAdditionGetActionResponse, MachineAdditionSetActionRequest machineAdditionSetActionRequest) throws WcException {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIp);
        HsmHostNodeData[] hsmHostNodeDataArray = machineAdditionGetActionResponse.getNodeDataList();
        machineAdditionSetActionRequest.setNodeDataList(hsmHostNodeDataArray);
        Command command = null;
        Response response = null;
        command = this.createCommand(machineAdditionSetActionRequest);
        if (command == null) {
            ErrorLog.getErrorLog().writeDebugTrace(7, "Command is null", this.m_stClientIp);
            WcException wcException = new WcException("KASM18044-E");
            throw wcException;
        }
        response = command.execute(machineAdditionSetActionRequest, this.m_objGatewayCommunicator);
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
        return response;
    }

    private MachineAdditionGetActionResponse processMachineAddGetActionReq(GroupListActionResponse groupListActionResponse, MachineAdditionGetActionRequest machineAdditionGetActionRequest) throws WcException {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIp);
        Command command = null;
        MachineAdditionGetActionResponse machineAdditionGetActionResponse = null;
        String string = null;
        string = this.convertToFormattedClimbTrail(machineAdditionGetActionRequest.getClimbTrail(), groupListActionResponse);
        machineAdditionGetActionRequest.setClimbTrailFormatted(string);
        command = this.createCommand(machineAdditionGetActionRequest);
        if (command == null) {
            ErrorLog.getErrorLog().writeDebugTrace(7, "Command is null", this.m_stClientIp);
            WcException wcException = new WcException("KASM18044-E");
            throw wcException;
        }
        machineAdditionGetActionResponse = (MachineAdditionGetActionResponse)command.execute(machineAdditionGetActionRequest, this.m_objGatewayCommunicator);
        String string2 = null;
        string2 = this.convertToFormattedClimbTrail(machineAdditionGetActionRequest.getClimbTrail(), groupListActionResponse);
        machineAdditionGetActionResponse.setClimbTrailFormatted(string2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(13));
        stringBuffer.append(",");
        stringBuffer.append(machineAdditionGetActionRequest.getGroupId());
        machineAdditionGetActionRequest.setKeyValue(stringBuffer.toString());
        this.writeCacheAfterFetch(machineAdditionGetActionRequest, machineAdditionGetActionResponse);
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
        return machineAdditionGetActionResponse;
    }

    private void processConnectionCheck(Request request) throws WcException {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIp);
        ConnectionCheckCommand connectionCheckCommand = new ConnectionCheckCommand();
        connectionCheckCommand.execute(request, this.m_objGatewayCommunicator);
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
    }

    public WebGatewayCommunicator getWebGatewayCommunicator() {
        return this.m_objGatewayCommunicator;
    }

    private DisplayDetailActionResponse processHostMgmtDetailReq(DisplayDetailActionRequest displayDetailActionRequest, DisplayActionResponse displayActionResponse) {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIp);
        String string = displayDetailActionRequest.getClimbTrail();
        Hashtable hashtable = displayActionResponse.getDetailedData();
        Vector vector = (Vector)hashtable.get(string);
        DisplayDetailActionResponse displayDetailActionResponse = new DisplayDetailActionResponse();
        displayDetailActionResponse.setTableContent(vector);
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
        return displayDetailActionResponse;
    }

    private GroupCreateGetActionResponse processGroupCreateGetActionReq(GroupListActionResponse groupListActionResponse, GroupCreateGetActionRequest groupCreateGetActionRequest) throws WcException {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIp);
        try {
            String string = groupCreateGetActionRequest.getClimbTrail();
            String string2 = null;
            string2 = this.convertToFormattedClimbTrail(string, groupListActionResponse);
            GroupCreateGetActionResponse groupCreateGetActionResponse = new GroupCreateGetActionResponse();
            groupCreateGetActionResponse.setClimbTrailFormatted(string2);
            boolean bl = false;
            GroupCommon groupCommon = new GroupCommon(this.m_stClientIp);
            if (string.length() != 1) {
                bl = groupCommon.isGroupValid(this.m_objGatewayCommunicator, groupCreateGetActionRequest.getGroupId(), string, string2);
            }
            if (bl) {
                WcException wcException = new WcException("KASM180D3-E");
                ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
                throw wcException;
            }
            boolean bl2 = this.climbTrailCheck(string);
            if (bl2) {
                String string3 = "KASM18035-E";
                WcException wcException = new WcException(string3);
                throw wcException;
            }
            ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
            return groupCreateGetActionResponse;
        }
        catch (NumberFormatException numberFormatException) {
            ErrorLog.getErrorLog().writeErrorTrace(6, this.m_stClientIp, numberFormatException);
            WcException wcException = new WcException("KASM18044-E");
            ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
            throw wcException;
        }
    }

    private GroupEditGetActionResponse processGroupEditGetActionReq(GroupListActionResponse groupListActionResponse, GroupEditGetActionRequest groupEditGetActionRequest) throws WcException {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIp);
        try {
            String string = groupEditGetActionRequest.getClimbTrail();
            String string2 = null;
            string2 = this.convertToFormattedClimbTrail(string, groupListActionResponse);
            GroupEditGetActionResponse groupEditGetActionResponse = new GroupEditGetActionResponse();
            groupEditGetActionResponse.setClimbTrailFormatted(string2);
            boolean bl = false;
            GroupCommon groupCommon = new GroupCommon(this.m_stClientIp);
            if (string.length() != 1) {
                bl = groupCommon.isGroupValid(this.m_objGatewayCommunicator, groupEditGetActionRequest.getGroupId(), string, string2);
            }
            if (bl) {
                WcException wcException = new WcException("KASM180D3-E");
                ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
                throw wcException;
            }
            ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
            return groupEditGetActionResponse;
        }
        catch (NumberFormatException numberFormatException) {
            ErrorLog.getErrorLog().writeErrorTrace(6, this.m_stClientIp, numberFormatException);
            WcException wcException = new WcException("KASM18044-E");
            ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
            throw wcException;
        }
    }

    private NotificationAlertPageResponse processNotificationAlertPageResponse(Response response) throws WcException {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIp);
        NotificationAlertPageResponse notificationAlertPageResponse = new NotificationAlertPageResponse();
        if (response instanceof NotificationAlertDataAcquisitionResponse) {
            NotificationAlertDataAcquisitionResponse notificationAlertDataAcquisitionResponse = (NotificationAlertDataAcquisitionResponse)response;
            notificationAlertPageResponse.setAlertHeader(notificationAlertDataAcquisitionResponse.getAlertHeader());
            notificationAlertPageResponse.setAlertRowData(notificationAlertDataAcquisitionResponse.getAlertRowData());
            notificationAlertPageResponse.setOccurrenceHost(notificationAlertDataAcquisitionResponse.getOccurrenceHost());
            notificationAlertPageResponse.setOccurrenceHostFullList(notificationAlertDataAcquisitionResponse.getOccurrenceHostFullList());
        } else if (response instanceof NotificationAlertConfirmationResponse) {
            NotificationAlertConfirmationResponse notificationAlertConfirmationResponse = (NotificationAlertConfirmationResponse)response;
            notificationAlertPageResponse.setAlertHeader(notificationAlertConfirmationResponse.getAlertHeader());
            notificationAlertPageResponse.setAlertRowData(notificationAlertConfirmationResponse.getAlertRowData());
            notificationAlertPageResponse.setOccurrenceHost(notificationAlertConfirmationResponse.getOccurrenceHost());
            notificationAlertPageResponse.setOccurrenceHostFullList(notificationAlertConfirmationResponse.getOccurrenceHostFullList());
        } else if (response instanceof NotificationAlertDeletionResponse) {
            NotificationAlertDeletionResponse notificationAlertDeletionResponse = (NotificationAlertDeletionResponse)response;
            notificationAlertPageResponse.setAlertHeader(notificationAlertDeletionResponse.getAlertHeader());
            notificationAlertPageResponse.setAlertRowData(notificationAlertDeletionResponse.getAlertRowData());
            notificationAlertPageResponse.setOccurrenceHost(notificationAlertDeletionResponse.getOccurrenceHost());
            notificationAlertPageResponse.setOccurrenceHostFullList(notificationAlertDeletionResponse.getOccurrenceHostFullList());
        } else {
            ErrorLog.getErrorLog().writeDebugTrace(7, "Invalid response object", this.m_stClientIp);
            WcException wcException = new WcException("KASM18044-E");
            ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
            throw wcException;
        }
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
        return notificationAlertPageResponse;
    }

    private AlertLogPageAcquisitionResponse processAlertLogPageResponse(AlertLogDataAcquisitionResponse alertLogDataAcquisitionResponse) {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIp);
        AlertLogPageAcquisitionResponse alertLogPageAcquisitionResponse = new AlertLogPageAcquisitionResponse();
        alertLogPageAcquisitionResponse.setAlertHeader(alertLogDataAcquisitionResponse.getAlertHeader());
        alertLogPageAcquisitionResponse.setAlertRowData(alertLogDataAcquisitionResponse.getAlertRowData());
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
        return alertLogPageAcquisitionResponse;
    }

    private AlertLogDeletionPageResponse processAlertLogFilePageResponse(Response response) throws WcException {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIp);
        AlertLogDeletionPageResponse alertLogDeletionPageResponse = new AlertLogDeletionPageResponse();
        if (response instanceof AlertLogDelInfoAcquisitionResponse) {
            AlertLogDelInfoAcquisitionResponse alertLogDelInfoAcquisitionResponse = (AlertLogDelInfoAcquisitionResponse)response;
            alertLogDeletionPageResponse.setAlertFileHeader(alertLogDelInfoAcquisitionResponse.getAlertFileHeader());
            alertLogDeletionPageResponse.setAlertFileRowData(alertLogDelInfoAcquisitionResponse.getAlertFileRowData());
        } else if (response instanceof AlertLogDeletionResponse) {
            AlertLogDeletionResponse alertLogDeletionResponse = (AlertLogDeletionResponse)response;
            alertLogDeletionPageResponse.setAlertFileHeader(alertLogDeletionResponse.getAlertFileHeader());
            alertLogDeletionPageResponse.setAlertFileRowData(alertLogDeletionResponse.getAlertFileRowData());
        } else {
            ErrorLog.getErrorLog().writeDebugTrace(7, "Invalid response object", this.m_stClientIp);
            WcException wcException = new WcException("KASM18044-E");
            ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
            throw wcException;
        }
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
        return alertLogDeletionPageResponse;
    }

    private boolean climbTrailCheck(String string) throws NumberFormatException {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIp);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int[] nArray = new int[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
            ++n;
        }
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
        return nArray.length >= 9;
    }

    public Vector getClimbTrailKey(int n) throws WcException {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIp);
        DisplayActionRequest displayActionRequest = new DisplayActionRequest();
        InventoryListActionRequest inventoryListActionRequest = new InventoryListActionRequest();
        DisplayActionResponse displayActionResponse = new DisplayActionResponse();
        Hashtable hashtable = null;
        Vector vector = null;
        Vector vector2 = null;
        String string = null;
        Vector<String> vector3 = new Vector<String>();
        inventoryListActionRequest.setNodeId(n);
        this.processConnectionCheck(inventoryListActionRequest);
        this.m_Flag = 0;
        displayActionRequest.setKeyValue(String.valueOf(2));
        displayActionResponse = (DisplayActionResponse)this.m_objCacheManager.checkCacheExists(displayActionRequest);
        hashtable = displayActionResponse.getDetailedData();
        Enumeration enumeration = hashtable.keys();
        String string2 = null;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            vector = (Vector)hashtable.get(string);
            for (int i = 0; i < vector.size(); ++i) {
                vector2 = (Vector)vector.get(i);
                string2 = (String)vector2.get(0);
                if (Integer.parseInt(string2) != n) continue;
                ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
                vector3.add(0, string);
                vector3.add(1, (String)vector2.get(1));
                return vector3;
            }
        }
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
        return null;
    }

    public Vector getNodeDetailId(String string, int n) {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIp);
        InventoryListActionRequest inventoryListActionRequest = new InventoryListActionRequest();
        InventoryListActionResponse inventoryListActionResponse = new InventoryListActionResponse();
        Vector vector = null;
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        stringBuffer.append(5);
        inventoryListActionRequest.setKeyValue(stringBuffer.toString());
        inventoryListActionResponse = (InventoryListActionResponse)this.m_objCacheManager.checkCacheExists(inventoryListActionRequest);
        vector = inventoryListActionResponse.getListTree();
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2 = (Vector)vector.get(i);
            string2 = (String)vector2.get(0);
            if (!string2.equals(string)) continue;
            Vector vector3 = (Vector)vector2.get(4);
            ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
            return vector3;
        }
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
        return null;
    }

    private String convertToFormattedClimbTrail(String string, GroupListActionResponse groupListActionResponse) {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIp);
        ArrayList arrayList = groupListActionResponse.getClimbTrailList();
        ArrayList arrayList2 = groupListActionResponse.getNodeList();
        int n = 0;
        int n2 = 0;
        GroupCommon groupCommon = new GroupCommon(this.m_stClientIp);
        Vector vector = groupCommon.convertToTokens(string, ",");
        int n3 = vector.size();
        String string2 = null;
        String string3 = new String();
        String string4 = null;
        HsmNodeData hsmNodeData = null;
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            n = ((String)vector.get(i)).length();
            string2 = string.substring(0, n2 += n);
            n4 = arrayList.indexOf(string2);
            hsmNodeData = (HsmNodeData)arrayList2.get(n4);
            string4 = hsmNodeData.getName();
            string3 = string3.concat(string4);
            ++n2;
            if (i == n3 - 1) continue;
            string3 = string3.concat(">");
        }
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
        return string3;
    }

    private GroupOrHostDeletionActionResponse processGroupOrHostDeletionReq(GroupListActionResponse groupListActionResponse, GroupOrHostDeletionActionRequest groupOrHostDeletionActionRequest) throws WcException {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIp);
        String[] stringArray = groupOrHostDeletionActionRequest.getClimbTrailList();
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = this.convertToFormattedClimbTrail(stringArray[i], groupListActionResponse);
        }
        groupOrHostDeletionActionRequest.setFormattedClimbTrailList(stringArray2);
        Command command = null;
        Response response = null;
        command = this.createCommand(groupOrHostDeletionActionRequest);
        if (command != null) {
            response = command.execute(groupOrHostDeletionActionRequest, this.m_objGatewayCommunicator);
            if (response == null) {
                WcException wcException = new WcException("KASM18044-E");
                throw wcException;
            }
        } else {
            ErrorLog.getErrorLog().writeDebugTrace(7, "Command is null", this.m_stClientIp);
            WcException wcException = new WcException("KASM18044-E");
            throw wcException;
        }
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
        return (GroupOrHostDeletionActionResponse)response;
    }

    private GroupPowerControlActionResponse processGroupPowerControlReq(GroupListActionResponse groupListActionResponse, GroupPowerControlActionRequest groupPowerControlActionRequest) throws WcException {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIp);
        String[] stringArray = groupPowerControlActionRequest.getClimbTrailList();
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = this.convertToFormattedClimbTrail(stringArray[i], groupListActionResponse);
        }
        groupPowerControlActionRequest.setFormattedClimbTrailList(stringArray2);
        groupPowerControlActionRequest.setGroupCacheInfo(groupListActionResponse);
        Command command = null;
        Response response = null;
        command = this.createCommand(groupPowerControlActionRequest);
        if (command != null) {
            response = command.execute(groupPowerControlActionRequest, this.m_objGatewayCommunicator);
            if (response == null) {
                WcException wcException = new WcException("KASM18044-E");
                throw wcException;
            }
        } else {
            ErrorLog.getErrorLog().writeDebugTrace(7, "Command is null", this.m_stClientIp);
            WcException wcException = new WcException("KASM18044-E");
            throw wcException;
        }
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
        return (GroupPowerControlActionResponse)response;
    }

    private AgentAlertAttributeSettingSetActionRequest processAlertAttributeSetting(AgentAlertAttributeSettingGetActionResponse agentAlertAttributeSettingGetActionResponse, Request request) {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIp);
        AgentAlertAttributeSettingSetActionRequest agentAlertAttributeSettingSetActionRequest = (AgentAlertAttributeSettingSetActionRequest)request;
        Vector vector = new Vector();
        Vector<HsmAlertAttributeData> vector2 = new Vector<HsmAlertAttributeData>();
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        HsmAlertAttributeData hsmAlertAttributeData = null;
        vector = agentAlertAttributeSettingSetActionRequest.getAlertAttribute();
        arrayList = agentAlertAttributeSettingGetActionResponse.getAlertAttribute();
        StringBuffer stringBuffer = null;
        int n = 0;
        Iterator iterator = vector.iterator();
        for (int i = 0; i < arrayList.size(); ++i) {
            bl = true;
            ArrayList arrayList2 = (ArrayList)arrayList.get(i);
            while (iterator.hasNext()) {
                hsmAlertAttributeData = (HsmAlertAttributeData)iterator.next();
                stringBuffer = new StringBuffer();
                stringBuffer.append(hsmAlertAttributeData.getEventId());
                n = Integer.parseInt(arrayList2.get(1).toString().trim().substring(2), 16);
                if (n != Integer.parseInt(stringBuffer.toString())) continue;
                vector2.add(hsmAlertAttributeData);
                bl = false;
                break;
            }
            if (bl) {
                vector2.add(this.convertAlertAttributeArrayListToVector(arrayList2));
            }
            iterator = null;
            iterator = vector.iterator();
        }
        agentAlertAttributeSettingSetActionRequest.setAlertAttribute(vector2);
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
        return agentAlertAttributeSettingSetActionRequest;
    }

    private HsmAlertAttributeData convertAlertAttributeArrayListToVector(ArrayList arrayList) {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIp);
        HsmAlertAttributeData hsmAlertAttributeData = new HsmAlertAttributeData();
        hsmAlertAttributeData.setEventId(Integer.parseInt(arrayList.get(1).toString().substring(2), 16));
        hsmAlertAttributeData.setCategory(arrayList.get(2).toString());
        hsmAlertAttributeData.setLevel(arrayList.get(3).toString());
        hsmAlertAttributeData.setMessage(arrayList.get(4).toString());
        if (arrayList.get(5).toString().equalsIgnoreCase("true")) {
            hsmAlertAttributeData.setThresholdFlag(true);
        } else {
            hsmAlertAttributeData.setThresholdFlag(false);
        }
        hsmAlertAttributeData.setThreshold(Integer.parseInt(arrayList.get(6).toString()));
        if (arrayList.get(7).toString().equalsIgnoreCase("true")) {
            hsmAlertAttributeData.setPowerControlFlag(true);
        } else {
            hsmAlertAttributeData.setPowerControlFlag(false);
        }
        hsmAlertAttributeData.setPowerControlCode(this.extractPowerCode(arrayList.get(8).toString(), arrayList.get(9).toString()));
        if (arrayList.get(10).toString().equalsIgnoreCase("true")) {
            hsmAlertAttributeData.setFailoverFlag(true);
        } else {
            hsmAlertAttributeData.setFailoverFlag(false);
        }
        if (arrayList.get(11).toString().equalsIgnoreCase("true")) {
            hsmAlertAttributeData.setFailoverExecutionFlag(true);
        } else {
            hsmAlertAttributeData.setFailoverExecutionFlag(false);
        }
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
        return hsmAlertAttributeData;
    }

    private int extractPowerCode(String string, String string2) {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIp);
        int n = 0;
        n = string.equalsIgnoreCase("PowerOFF") && string2.equalsIgnoreCase("true") ? 131073 : (string.equalsIgnoreCase("PowerOFF") && string2.equalsIgnoreCase("false") ? 131072 : (string.equalsIgnoreCase("Reboot") && string2.equalsIgnoreCase("true") ? 196609 : (string.equalsIgnoreCase("Reboot") && string2.equalsIgnoreCase("false") ? 196608 : (string.equalsIgnoreCase("DoNothing") && string2.equalsIgnoreCase("true") ? 1 : 0))));
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIp);
        return n;
    }
}

