/*
 * Decompiled with CFR 0.152.
 */
package JP.co.Hitachi.soft.System_Manager.webconsole.model.command;

import JP.co.Hitachi.soft.System_Manager.data.HsmAgentSettingData;
import JP.co.Hitachi.soft.System_Manager.data.HsmException;
import JP.co.Hitachi.soft.System_Manager.data.HsmNetworkSettingData;
import JP.co.Hitachi.soft.System_Manager.webconsole.common.CommonUtil;
import JP.co.Hitachi.soft.System_Manager.webconsole.common.ErrorLog;
import JP.co.Hitachi.soft.System_Manager.webconsole.common.ResourceBundler;
import JP.co.Hitachi.soft.System_Manager.webconsole.common.WcException;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.Command;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.request.AgentNetworkSettingGetActionRequest;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.request.AgentNetworkSettingSetActionRequest;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.request.Request;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.AgentNetworkSettingGetActionResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.AgentNetworkSettingSetActionResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.Response;
import JP.co.Hitachi.soft.System_Manager.webconsole.remote.WebGatewayCommunicator;
import java.rmi.RemoteException;
import org.apache.struts.util.MessageResources;

public class AgentNetworkSettingActionCommand
implements Command {
    private HsmAgentSettingData m_objAgentNetworkSetting = null;
    private HsmNetworkSettingData m_objAgentNetwork = null;
    private MessageResources m_objMessageResources = null;
    private String m_stClientIPAddress = null;

    public Response execute(Request request, WebGatewayCommunicator webGatewayCommunicator) throws WcException {
        this.m_stClientIPAddress = webGatewayCommunicator.getClientIPAddress();
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIPAddress);
        Response response = null;
        WcException wcException = null;
        if (request == null) {
            wcException = new WcException("KASM18044-E");
            throw wcException;
        }
        this.m_objMessageResources = ResourceBundler.getResourceBundle("messageResources");
        if (request instanceof AgentNetworkSettingGetActionRequest) {
            response = this.getAgentNetworkData(request, webGatewayCommunicator);
        } else if (request instanceof AgentNetworkSettingSetActionRequest) {
            response = this.setAgentNetworkData(request, webGatewayCommunicator);
        } else {
            String string = "KASM18029-E";
            String string2 = this.m_objMessageResources.getMessage(string);
            String string3 = CommonUtil.getCurrentDateTime(webGatewayCommunicator.getLocale());
            wcException = new WcException(string, string3);
            ErrorLog.getErrorLog().writeErrorTrace(string, string2, this.m_stClientIPAddress);
        }
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response getAgentNetworkData(Request request, WebGatewayCommunicator webGatewayCommunicator) throws WcException {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIPAddress);
        WcException wcException = null;
        AgentNetworkSettingGetActionResponse agentNetworkSettingGetActionResponse = null;
        try {
            try {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                boolean bl = false;
                AgentNetworkSettingGetActionRequest agentNetworkSettingGetActionRequest = (AgentNetworkSettingGetActionRequest)request;
                agentNetworkSettingGetActionResponse = new AgentNetworkSettingGetActionResponse();
                n = agentNetworkSettingGetActionRequest.getNodeId();
                this.m_objAgentNetworkSetting = webGatewayCommunicator.getAgentSettingData(n);
                if (this.m_objAgentNetworkSetting != null) {
                    this.m_objAgentNetwork = this.m_objAgentNetworkSetting.getNetworkSettingData();
                    n2 = this.m_objAgentNetwork.getTimeOut();
                    n3 = this.m_objAgentNetwork.getKeepAliveInterval();
                    bl = this.m_objAgentNetwork.isKeeAliveEnable();
                } else {
                    String string = CommonUtil.getCurrentDateTime(webGatewayCommunicator.getLocale());
                    wcException = new WcException("KASM18029-E", string);
                }
                agentNetworkSettingGetActionResponse.setNodeId(agentNetworkSettingGetActionRequest.getNodeId());
                agentNetworkSettingGetActionResponse.setCmdTimeOut(n2);
                agentNetworkSettingGetActionResponse.setKeepAliveInterval(n3);
                agentNetworkSettingGetActionResponse.setKeepAliveFlag(bl);
            }
            catch (HsmException hsmException) {
                ErrorLog.getErrorLog().writeErrorTrace(6, this.m_stClientIPAddress, (Object)hsmException);
                wcException = new WcException("KASM18076-E");
                Object var12_16 = null;
                ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
                if (wcException == null) return agentNetworkSettingGetActionResponse;
                throw wcException;
            }
            catch (RemoteException remoteException) {
                ErrorLog.getErrorLog().writeErrorTrace(6, this.m_stClientIPAddress, remoteException);
                String string = CommonUtil.getCurrentDateTime(webGatewayCommunicator.getLocale());
                wcException = new WcException("KASM18029-E", string);
                wcException = CommonUtil.getGatewayConnectError(remoteException, wcException, this.m_stClientIPAddress);
                Object var12_17 = null;
                ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
                if (wcException == null) return agentNetworkSettingGetActionResponse;
                throw wcException;
            }
            catch (Exception exception) {
                ErrorLog.getErrorLog().writeErrorTrace(6, this.m_stClientIPAddress, exception);
                wcException = new WcException("KASM18044-E");
                Object var12_18 = null;
                ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
                if (wcException == null) return agentNetworkSettingGetActionResponse;
                throw wcException;
            }
            Object var12_15 = null;
            ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
            if (wcException == null) return agentNetworkSettingGetActionResponse;
            throw wcException;
        }
        catch (Throwable throwable) {
            Object var12_19 = null;
            ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
            if (wcException == null) throw throwable;
            throw wcException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response setAgentNetworkData(Request request, WebGatewayCommunicator webGatewayCommunicator) throws WcException {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIPAddress);
        WcException wcException = null;
        AgentNetworkSettingSetActionResponse agentNetworkSettingSetActionResponse = null;
        try {
            try {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                boolean bl = false;
                boolean bl2 = false;
                AgentNetworkSettingSetActionRequest agentNetworkSettingSetActionRequest = (AgentNetworkSettingSetActionRequest)request;
                agentNetworkSettingSetActionResponse = new AgentNetworkSettingSetActionResponse();
                n = agentNetworkSettingSetActionRequest.getNodeId();
                n2 = Integer.parseInt(agentNetworkSettingSetActionRequest.getCmdTimeOut());
                bl = agentNetworkSettingSetActionRequest.isKeepAliveFlag();
                this.m_objAgentNetworkSetting = webGatewayCommunicator.getAgentSettingData(n);
                if (this.m_objAgentNetworkSetting != null) {
                    this.m_objAgentNetwork = this.m_objAgentNetworkSetting.getNetworkSettingData();
                    this.m_objAgentNetwork.setTimeOut(n2);
                    this.m_objAgentNetwork.setKeeAliveFlag(bl);
                } else {
                    String string = CommonUtil.getCurrentDateTime(webGatewayCommunicator.getLocale());
                    wcException = new WcException("KASM18029-E", string);
                }
                n3 = Integer.parseInt(agentNetworkSettingSetActionRequest.getKeepAliveInterval());
                this.m_objAgentNetwork.setKeepAliveInterval(n3);
                bl2 = webGatewayCommunicator.setAgentSettingData(n, this.m_objAgentNetworkSetting);
                if (bl2) {
                    agentNetworkSettingSetActionResponse.setMessageId("KASM1804B-I");
                    agentNetworkSettingSetActionResponse.setMessage(this.m_objMessageResources.getMessage("KASM1804B-I"));
                } else {
                    wcException = new WcException("KASM18077-E");
                }
            }
            catch (HsmException hsmException) {
                ErrorLog.getErrorLog().writeErrorTrace(6, this.m_stClientIPAddress, (Object)hsmException);
                wcException = new WcException("KASM18077-E");
                Object var13_17 = null;
                ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
                if (wcException == null) return agentNetworkSettingSetActionResponse;
                throw wcException;
            }
            catch (RemoteException remoteException) {
                ErrorLog.getErrorLog().writeErrorTrace(6, this.m_stClientIPAddress, remoteException);
                String string = CommonUtil.getCurrentDateTime(webGatewayCommunicator.getLocale());
                wcException = new WcException("KASM18029-E", string);
                wcException = CommonUtil.getGatewayConnectError(remoteException, wcException, this.m_stClientIPAddress);
                Object var13_18 = null;
                ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
                if (wcException == null) return agentNetworkSettingSetActionResponse;
                throw wcException;
            }
            catch (Exception exception) {
                ErrorLog.getErrorLog().writeErrorTrace(6, this.m_stClientIPAddress, exception);
                wcException = new WcException("KASM18044-E");
                Object var13_19 = null;
                ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
                if (wcException == null) return agentNetworkSettingSetActionResponse;
                throw wcException;
            }
            Object var13_16 = null;
            ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
            if (wcException == null) return agentNetworkSettingSetActionResponse;
            throw wcException;
        }
        catch (Throwable throwable) {
            Object var13_20 = null;
            ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
            if (wcException == null) throw throwable;
            throw wcException;
        }
    }
}

