/*
 * Decompiled with CFR 0.152.
 */
package JP.co.Hitachi.soft.System_Manager.webconsole.model.command;

import JP.co.Hitachi.soft.System_Manager.data.HsmAgentSettingData;
import JP.co.Hitachi.soft.System_Manager.data.HsmException;
import JP.co.Hitachi.soft.System_Manager.data.HsmThresholdDeviceData;
import JP.co.Hitachi.soft.System_Manager.data.HsmThresholdParamData;
import JP.co.Hitachi.soft.System_Manager.data.HsmThresholdSettingData;
import JP.co.Hitachi.soft.System_Manager.webconsole.common.CommonUtil;
import JP.co.Hitachi.soft.System_Manager.webconsole.common.ErrorLog;
import JP.co.Hitachi.soft.System_Manager.webconsole.common.ResourceBundler;
import JP.co.Hitachi.soft.System_Manager.webconsole.common.WcException;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.command.Command;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.request.AgentUsageRateSettingGetActionRequest;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.request.AgentUsageRateSettingSetActionRequest;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.request.Request;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.AgentUsageRateSettingGetActionResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.AgentUsageRateSettingSetActionResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.Response;
import JP.co.Hitachi.soft.System_Manager.webconsole.remote.WebGatewayCommunicator;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.struts.util.MessageResources;

public class AgentUsageRateSettingActionCommand
implements Command {
    private String m_stClientIPAddress = null;
    private WcException m_objException = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response execute(Request request, WebGatewayCommunicator webGatewayCommunicator) throws WcException {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, webGatewayCommunicator.getClientIPAddress());
        if (request == null) {
            this.m_objException = new WcException("KASM18044-E");
            throw this.m_objException;
        }
        this.m_stClientIPAddress = webGatewayCommunicator.getClientIPAddress();
        Response response = null;
        try {
            block14: {
                try {
                    MessageResources messageResources = ResourceBundler.getResourceBundle("messageResources");
                    if (request instanceof AgentUsageRateSettingGetActionRequest) {
                        response = this.getUsageRateData(request, webGatewayCommunicator);
                        break block14;
                    }
                    if (request instanceof AgentUsageRateSettingSetActionRequest) {
                        response = this.setUsageRateData(request, webGatewayCommunicator);
                    } else {
                        String string = "KASM18029-E";
                        String string2 = messageResources.getMessage(string);
                        String string3 = CommonUtil.getCurrentDateTime(webGatewayCommunicator.getLocale());
                        this.m_objException = new WcException(string, string3);
                        ErrorLog.getErrorLog().writeErrorTrace(string, string2, this.m_stClientIPAddress);
                    }
                }
                catch (HsmException hsmException) {
                    ErrorLog.getErrorLog().writeErrorTrace(6, this.m_stClientIPAddress, (Object)hsmException);
                    this.m_objException = request instanceof AgentUsageRateSettingGetActionRequest ? new WcException("KASM18076-E") : new WcException("KASM1807A-E");
                    Object var9_14 = null;
                    ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
                    if (this.m_objException == null) return response;
                    throw this.m_objException;
                }
                catch (RemoteException remoteException) {
                    ErrorLog.getErrorLog().writeErrorTrace(6, this.m_stClientIPAddress, remoteException);
                    String string = "KASM18029-E";
                    String string4 = CommonUtil.getCurrentDateTime(webGatewayCommunicator.getLocale());
                    this.m_objException = new WcException(string, string4);
                    this.m_objException = CommonUtil.getGatewayConnectError(remoteException, this.m_objException, this.m_stClientIPAddress);
                    Object var9_15 = null;
                    ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
                    if (this.m_objException == null) return response;
                    throw this.m_objException;
                }
                catch (Exception exception) {
                    ErrorLog.getErrorLog().writeErrorTrace(6, this.m_stClientIPAddress, exception);
                    this.m_objException = new WcException("KASM18044-E");
                    Object var9_16 = null;
                    ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
                    if (this.m_objException == null) return response;
                    throw this.m_objException;
                }
            }
            Object var9_13 = null;
            ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
            if (this.m_objException == null) return response;
            throw this.m_objException;
        }
        catch (Throwable throwable) {
            Object var9_17 = null;
            ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
            if (this.m_objException == null) throw throwable;
            throw this.m_objException;
        }
    }

    private Response getUsageRateData(Request request, WebGatewayCommunicator webGatewayCommunicator) throws RemoteException, HsmException {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIPAddress);
        String string = null;
        AgentUsageRateSettingGetActionResponse agentUsageRateSettingGetActionResponse = null;
        string = "Get Usage Rate Data request";
        ErrorLog.getErrorLog().writeDebugTrace(7, string, this.m_stClientIPAddress);
        AgentUsageRateSettingGetActionRequest agentUsageRateSettingGetActionRequest = (AgentUsageRateSettingGetActionRequest)request;
        string = agentUsageRateSettingGetActionRequest.toString();
        ErrorLog.getErrorLog().writeDebugTrace(7, string, this.m_stClientIPAddress);
        HsmAgentSettingData hsmAgentSettingData = webGatewayCommunicator.getAgentSettingData(agentUsageRateSettingGetActionRequest.getNodeId());
        if (hsmAgentSettingData != null) {
            string = "getAgentSettingData success";
            ErrorLog.getErrorLog().writeDebugTrace(7, string, this.m_stClientIPAddress);
            HsmThresholdSettingData hsmThresholdSettingData = hsmAgentSettingData.getThresholdSettingData();
            string = "Populating Server data to Response";
            ErrorLog.getErrorLog().writeDebugTrace(7, string, this.m_stClientIPAddress);
            agentUsageRateSettingGetActionResponse = this.getResponseforGetRequest(hsmThresholdSettingData, agentUsageRateSettingGetActionRequest.getNodeId(), webGatewayCommunicator);
        } else {
            String string2 = CommonUtil.getCurrentDateTime(webGatewayCommunicator.getLocale());
            this.m_objException = new WcException("KASM18029-E", string2);
        }
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
        return agentUsageRateSettingGetActionResponse;
    }

    private Response setUsageRateData(Request request, WebGatewayCommunicator webGatewayCommunicator) throws RemoteException, HsmException {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIPAddress);
        MessageResources messageResources = ResourceBundler.getResourceBundle("messageResources");
        String string = null;
        AgentUsageRateSettingSetActionResponse agentUsageRateSettingSetActionResponse = null;
        string = "Set Usage Rate Data request";
        ErrorLog.getErrorLog().writeDebugTrace(7, string, this.m_stClientIPAddress);
        AgentUsageRateSettingSetActionRequest agentUsageRateSettingSetActionRequest = (AgentUsageRateSettingSetActionRequest)request;
        string = agentUsageRateSettingSetActionRequest.toString();
        ErrorLog.getErrorLog().writeDebugTrace(7, string, this.m_stClientIPAddress);
        string = "Populating User input to Server data Object";
        ErrorLog.getErrorLog().writeDebugTrace(7, string, this.m_stClientIPAddress);
        Vector vector = this.getThresholdDeviceData(agentUsageRateSettingSetActionRequest);
        int n = agentUsageRateSettingSetActionRequest.getNodeId();
        HsmAgentSettingData hsmAgentSettingData = webGatewayCommunicator.getAgentSettingData(n);
        if (hsmAgentSettingData != null) {
            string = "getAgentSettingData success";
            ErrorLog.getErrorLog().writeDebugTrace(7, string, this.m_stClientIPAddress);
            HsmThresholdSettingData hsmThresholdSettingData = hsmAgentSettingData.getThresholdSettingData();
            hsmThresholdSettingData.setThresholdDevice(vector);
            boolean bl = webGatewayCommunicator.setAgentSettingData(n, hsmAgentSettingData);
            if (bl) {
                string = "setAgentSettingData success";
                ErrorLog.getErrorLog().writeDebugTrace(7, string, this.m_stClientIPAddress);
                agentUsageRateSettingSetActionResponse = new AgentUsageRateSettingSetActionResponse();
                agentUsageRateSettingSetActionResponse.setMessageId("KASM1804B-I");
                agentUsageRateSettingSetActionResponse.setMessage(messageResources.getMessage("KASM1804B-I"));
            } else {
                String string2 = "KASM1807A-E";
                this.m_objException = new WcException(string2);
            }
        } else {
            String string3 = CommonUtil.getCurrentDateTime(webGatewayCommunicator.getLocale());
            this.m_objException = new WcException("KASM18029-E", string3);
        }
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
        return agentUsageRateSettingSetActionResponse;
    }

    private AgentUsageRateSettingGetActionResponse getResponseforGetRequest(HsmThresholdSettingData hsmThresholdSettingData, int n, WebGatewayCommunicator webGatewayCommunicator) {
        Object object;
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIPAddress);
        Vector<Integer> vector = new Vector<Integer>();
        Vector<String> vector2 = new Vector<String>();
        Vector<Boolean> vector3 = new Vector<Boolean>();
        Vector<Integer> vector4 = new Vector<Integer>();
        Vector<Integer> vector5 = new Vector<Integer>();
        Vector vector6 = new Vector();
        Vector vector7 = hsmThresholdSettingData.getThresholdDevice();
        Iterator iterator = vector7.iterator();
        Object object2 = null;
        Object object3 = null;
        Object object4 = null;
        while (iterator.hasNext()) {
            object = (HsmThresholdDeviceData)iterator.next();
            if (object.getDeviceId() == 196608) {
                object2 = object;
                continue;
            }
            if (object.getDeviceId() == 65536 || object.getDeviceId() == 262144) {
                object3 = object;
                continue;
            }
            if (object.getDeviceId() != 131072) continue;
            object4 = object;
        }
        object = new ArrayList();
        ((ArrayList)object).add(object2);
        ((ArrayList)object).add(object3);
        ((ArrayList)object).add(object4);
        for (int i = 0; i < vector7.size(); ++i) {
            HsmThresholdDeviceData hsmThresholdDeviceData = (HsmThresholdDeviceData)((ArrayList)object).get(i);
            if (hsmThresholdDeviceData == null) {
                String string = CommonUtil.getCurrentDateTime(webGatewayCommunicator.getLocale());
                this.m_objException = new WcException("KASM18029-E", string);
                break;
            }
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = hsmThresholdDeviceData.getDeviceId();
            vector.add(new Integer(hsmThresholdDeviceData.getDeviceId()));
            vector2.add(hsmThresholdDeviceData.getDeviceName());
            vector3.add(new Boolean(hsmThresholdDeviceData.isEnable()));
            n3 = hsmThresholdDeviceData.getPollInterval();
            if (!CommonUtil.isNumberInRange(String.valueOf(n3), 1, 86400)) {
                n3 = i == 0 ? 10 : (i == 1 && n5 == 65536 ? 60 : (i == 2 ? 10 : 60));
            }
            vector4.add(new Integer(n3));
            n4 = hsmThresholdDeviceData.getSamplingCount();
            if (!CommonUtil.isNumberInRange(String.valueOf(n4), 1, 1000)) {
                n4 = 10;
            }
            vector5.add(new Integer(n4));
            Vector vector8 = hsmThresholdDeviceData.getThresholdParam();
            StringBuffer stringBuffer = new StringBuffer();
            Vector<String> vector9 = new Vector<String>();
            for (int j = 0; j < vector8.size(); ++j) {
                HsmThresholdParamData hsmThresholdParamData = (HsmThresholdParamData)vector8.elementAt(j);
                stringBuffer.append(hsmThresholdParamData.getThresholdId() + "-");
                stringBuffer.append(hsmThresholdParamData.getName() + "-");
                n2 = hsmThresholdParamData.getThreshold();
                if (i == 0) {
                    if (!CommonUtil.isNumberInRange(String.valueOf(n2), 10, 100)) {
                        n2 = 30;
                    }
                } else if (i == 1 && n5 == 65536) {
                    if (!CommonUtil.isNumberInRange(String.valueOf(n2), 40, 100) && hsmThresholdParamData.isEnable()) {
                        n2 = 80;
                    }
                } else if (i == 2) {
                    if (!CommonUtil.isNumberInRange(String.valueOf(n2), 40, 100)) {
                        n2 = 80;
                    }
                } else if (!CommonUtil.isNumberInRange(String.valueOf(n2), 40, 100) && hsmThresholdParamData.isEnable()) {
                    n2 = 80;
                }
                stringBuffer.append(n2 + "-");
                stringBuffer.append(hsmThresholdParamData.isEnable());
                vector9.add(stringBuffer.toString());
                stringBuffer.delete(0, stringBuffer.length());
            }
            vector6.add(vector9);
        }
        ((ArrayList)object).clear();
        object2 = null;
        object3 = null;
        object4 = null;
        object = null;
        AgentUsageRateSettingGetActionResponse agentUsageRateSettingGetActionResponse = new AgentUsageRateSettingGetActionResponse();
        agentUsageRateSettingGetActionResponse.setNodeID(n);
        agentUsageRateSettingGetActionResponse.setDeviceID(vector);
        agentUsageRateSettingGetActionResponse.setDeviceName(vector2);
        agentUsageRateSettingGetActionResponse.setUsageRateCheck(vector3);
        agentUsageRateSettingGetActionResponse.setPollInterval(vector4);
        agentUsageRateSettingGetActionResponse.setSamplingCount(vector5);
        agentUsageRateSettingGetActionResponse.setThresholdParam(vector6);
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
        return agentUsageRateSettingGetActionResponse;
    }

    private Vector getThresholdDeviceData(AgentUsageRateSettingSetActionRequest agentUsageRateSettingSetActionRequest) {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIPAddress);
        Vector vector = agentUsageRateSettingSetActionRequest.getDeviceID();
        Vector vector2 = agentUsageRateSettingSetActionRequest.getDeviceName();
        Vector vector3 = agentUsageRateSettingSetActionRequest.getUsageRateCheck();
        Vector vector4 = agentUsageRateSettingSetActionRequest.getPollInterval();
        Vector vector5 = agentUsageRateSettingSetActionRequest.getSamplingCount();
        Vector vector6 = agentUsageRateSettingSetActionRequest.getThresholdParam();
        Vector<HsmThresholdDeviceData> vector7 = new Vector<HsmThresholdDeviceData>();
        for (int i = 0; i < vector.size(); ++i) {
            HsmThresholdDeviceData hsmThresholdDeviceData = new HsmThresholdDeviceData();
            hsmThresholdDeviceData.setDeviceId(((Integer)vector.elementAt(i)).intValue());
            hsmThresholdDeviceData.setDeviceName((String)vector2.elementAt(i));
            hsmThresholdDeviceData.setEnable(((Boolean)vector3.elementAt(i)).booleanValue());
            hsmThresholdDeviceData.setPollInterval(((Integer)vector4.elementAt(i)).intValue());
            hsmThresholdDeviceData.setSamplingCount(((Integer)vector5.elementAt(i)).intValue());
            Vector<HsmThresholdParamData> vector8 = new Vector<HsmThresholdParamData>();
            Vector vector9 = (Vector)vector6.elementAt(i);
            for (int j = 0; j < vector9.size(); ++j) {
                String string = (String)vector9.elementAt(j);
                String[] stringArray = string.split("-");
                HsmThresholdParamData hsmThresholdParamData = new HsmThresholdParamData();
                hsmThresholdParamData.setThresholdId(Integer.parseInt(stringArray[0].trim()));
                hsmThresholdParamData.setName(stringArray[1].trim());
                hsmThresholdParamData.setThreshold(Integer.parseInt(stringArray[2].trim()));
                Boolean bl = new Boolean(stringArray[3]);
                hsmThresholdParamData.setEnable(bl.booleanValue());
                vector8.add(hsmThresholdParamData);
            }
            hsmThresholdDeviceData.setThresholdParam(vector8);
            vector7.add(hsmThresholdDeviceData);
        }
        vector.clear();
        vector2.clear();
        vector3.clear();
        vector4.clear();
        vector5.clear();
        vector6.clear();
        vector = null;
        vector2 = null;
        vector3 = null;
        vector4 = null;
        vector5 = null;
        vector6 = null;
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
        return vector7;
    }
}

