/*
 * Decompiled with CFR 0.152.
 */
package JP.co.Hitachi.soft.System_Manager.webconsole.model.command;

import JP.co.Hitachi.soft.System_Manager.data.HsmAlert;
import JP.co.Hitachi.soft.System_Manager.data.HsmError;
import JP.co.Hitachi.soft.System_Manager.data.HsmException;
import JP.co.Hitachi.soft.System_Manager.data.HsmHostNodeData;
import JP.co.Hitachi.soft.System_Manager.data.HsmListData;
import JP.co.Hitachi.soft.System_Manager.data.HsmRowData;
import JP.co.Hitachi.soft.System_Manager.data.HsmServerAlertData;
import JP.co.Hitachi.soft.System_Manager.data.HsmTreeData;
import JP.co.Hitachi.soft.System_Manager.data.HsmUrlData;
import JP.co.Hitachi.soft.System_Manager.webconsole.common.CommonUtil;
import JP.co.Hitachi.soft.System_Manager.webconsole.common.ErrorLog;
import JP.co.Hitachi.soft.System_Manager.webconsole.common.WcException;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.request.AlertCommonRequest;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.request.AlertLogDataAcquisitionRequest;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.request.AlertLogDelInfoAcquisitionRequest;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.request.AlertLogDeletionRequest;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.request.AlertLogInfoAcquisitionRequest;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.request.NotificationAlertConfirmationRequest;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.request.NotificationAlertDataAcquisitionRequest;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.request.NotificationAlertDeletionRequest;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.AlertCommonResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.AlertLogDataAcquisitionResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.AlertLogDelInfoAcquisitionResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.AlertLogDeletionResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.AlertLogInfoAcquisitionResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.NotificationAlertConfirmationResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.NotificationAlertDataAcquisitionResponse;
import JP.co.Hitachi.soft.System_Manager.webconsole.model.response.NotificationAlertDeletionResponse;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;

public class AlertCommonCommand {
    protected String m_stClientIPAddress = null;

    protected AlertCommonResponse getAlertResponse(HsmTreeData hsmTreeData, HsmListData hsmListData, AlertCommonRequest alertCommonRequest) throws ParseException, WcException {
        CharSequence charSequence;
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIPAddress);
        WcException wcException = null;
        if (alertCommonRequest == null) {
            wcException = new WcException("KASM18044-E");
            throw wcException;
        }
        AlertCommonResponse alertCommonResponse = null;
        if (alertCommonRequest instanceof NotificationAlertDataAcquisitionRequest) {
            alertCommonResponse = new NotificationAlertDataAcquisitionResponse();
        } else if (alertCommonRequest instanceof NotificationAlertConfirmationRequest) {
            alertCommonResponse = new NotificationAlertConfirmationResponse();
        } else if (alertCommonRequest instanceof NotificationAlertDeletionRequest) {
            alertCommonResponse = new NotificationAlertDeletionResponse();
        } else if (alertCommonRequest instanceof AlertLogDataAcquisitionRequest) {
            alertCommonResponse = new AlertLogDataAcquisitionResponse();
        } else {
            if (alertCommonRequest instanceof AlertLogInfoAcquisitionRequest) {
                alertCommonResponse = new AlertLogInfoAcquisitionResponse();
                ArrayList arrayList = this.processAlertLogInfoResponse(hsmListData);
                if (arrayList == null) {
                    wcException = new WcException("KASM18044-E");
                    throw wcException;
                }
                Vector vector = hsmListData.getColHeader();
                ArrayList arrayList2 = this.getAlertHeader(vector);
                if (arrayList2 == null) {
                    wcException = new WcException("KASM18044-E");
                    throw wcException;
                }
                ArrayList arrayList3 = this.sort(arrayList2, arrayList, arrayList2.get(0).toString());
                alertCommonResponse.setAlertRowData(arrayList3);
                ArrayList arrayList4 = (ArrayList)arrayList3.get(0);
                ArrayList arrayList5 = (ArrayList)arrayList3.get(arrayList3.size() - 1);
                alertCommonResponse.setEndDate(arrayList5.get(0).toString());
                alertCommonResponse.setStartDate(arrayList4.get(0).toString());
                return alertCommonResponse;
            }
            if (alertCommonRequest instanceof AlertLogDeletionRequest) {
                alertCommonResponse = new AlertLogDeletionResponse();
                ArrayList arrayList = this.processAlertLogInfoResponse(hsmListData);
                if (arrayList == null) {
                    wcException = new WcException("KASM18044-E");
                    throw wcException;
                }
                Vector vector = hsmListData.getColHeader();
                ArrayList arrayList6 = this.getAlertHeader(vector);
                if (arrayList6 == null) {
                    wcException = new WcException("KASM18044-E");
                    throw wcException;
                }
                ArrayList arrayList7 = this.sort(arrayList6, arrayList, arrayList6.get(0).toString());
                alertCommonResponse.setAlertFileRowData(arrayList7);
                ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
                return alertCommonResponse;
            }
            if (alertCommonRequest instanceof AlertLogDelInfoAcquisitionRequest) {
                alertCommonResponse = new AlertLogDelInfoAcquisitionResponse();
                ArrayList arrayList = this.processAlertLogInfoResponse(hsmListData);
                if (arrayList == null) {
                    wcException = new WcException("KASM18044-E");
                    throw wcException;
                }
                Vector vector = hsmListData.getColHeader();
                ArrayList arrayList8 = this.getAlertHeader(vector);
                if (arrayList8 == null) {
                    wcException = new WcException("KASM18044-E");
                    throw wcException;
                }
                ArrayList arrayList9 = this.sort(arrayList8, arrayList, arrayList8.get(0).toString());
                alertCommonResponse.setAlertFileRowData(arrayList9);
                alertCommonResponse.setAlertFileRowData(arrayList9);
                ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
                return alertCommonResponse;
            }
            wcException = new WcException("KASM18044-E");
            throw wcException;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!(alertCommonRequest instanceof AlertLogDataAcquisitionRequest)) {
            if (alertCommonRequest.getConfirmationStatus() != null && alertCommonRequest.getConfirmationStatus().trim().equals("true")) {
                arrayList.add("&nbsp;");
            } else {
                arrayList.add(null);
            }
        }
        if (alertCommonRequest.getAlertLevel() != null && alertCommonRequest.getAlertLevel().trim().length() > 0) {
            arrayList.add(alertCommonRequest.getAlertLevel());
        } else {
            arrayList.add(null);
        }
        if (!(alertCommonRequest instanceof AlertLogDataAcquisitionRequest)) {
            if (alertCommonRequest.getOccurrenceHost() != null && alertCommonRequest.getOccurrenceHost().trim().length() > 0) {
                arrayList.add(alertCommonRequest.getOccurrenceHost());
            } else {
                arrayList.add(null);
            }
        }
        if (alertCommonRequest.getAlertID() != null && alertCommonRequest.getAlertID().trim().length() > 0) {
            charSequence = new StringBuffer();
            if (alertCommonRequest.getAlertID().trim().length() == 4) {
                ((StringBuffer)charSequence).append("0X");
            }
            ((StringBuffer)charSequence).append(alertCommonRequest.getAlertID());
            arrayList.add(((StringBuffer)charSequence).toString());
        } else {
            arrayList.add(null);
        }
        if (alertCommonRequest.getContent() != null && alertCommonRequest.getContent().trim().length() > 0) {
            arrayList.add(alertCommonRequest.getContent());
        } else {
            arrayList.add(null);
        }
        charSequence = null;
        charSequence = "Updating search parameters in arraylist success";
        ErrorLog.getErrorLog().writeDebugTrace(7, (String)charSequence, this.m_stClientIPAddress);
        ArrayList arrayList10 = null;
        ArrayList arrayList11 = null;
        ArrayList arrayList12 = new ArrayList();
        ArrayList arrayList13 = new ArrayList();
        ArrayList arrayList14 = null;
        try {
            Vector vector;
            if (!(alertCommonRequest instanceof AlertLogDataAcquisitionRequest)) {
                vector = hsmTreeData.searchHosts();
                arrayList10 = this.getHostList(vector);
                if (arrayList10 == null) {
                    wcException = new WcException("KASM18044-E");
                    throw wcException;
                }
                for (int i = 0; i < arrayList10.size(); ++i) {
                    arrayList11 = (ArrayList)arrayList10.get(i);
                    arrayList12.add(arrayList11.get(0));
                }
                alertCommonResponse.setOccurrenceHost(arrayList12);
                arrayList14 = this.processNotificationAlertResponse(hsmListData, arrayList13);
            } else {
                arrayList14 = this.processAlertLogDataResponse(hsmListData);
            }
            if (arrayList14 == null) {
                wcException = new WcException("KASM18044-E");
                throw wcException;
            }
            charSequence = "processNotificationAlertResponse success";
            ErrorLog.getErrorLog().writeDebugTrace(7, (String)charSequence, this.m_stClientIPAddress);
            vector = hsmListData.getColHeader();
            ArrayList arrayList15 = this.getAlertHeader(vector);
            if (arrayList15 == null) {
                wcException = new WcException("KASM18044-E");
                throw wcException;
            }
            if (!(alertCommonRequest instanceof AlertLogDataAcquisitionRequest)) {
                for (int i = 0; i < arrayList12.size(); ++i) {
                    if (arrayList13.contains(arrayList12.get(i))) continue;
                    arrayList13.add(arrayList12.get(i));
                }
                alertCommonResponse.setOccurrenceHostFullList(arrayList13);
                charSequence = "getHostList success";
                ErrorLog.getErrorLog().writeDebugTrace(7, (String)charSequence, this.m_stClientIPAddress);
                arrayList15.add("Alert Key");
                arrayList15.add("Node Id");
            }
            ArrayList arrayList16 = this.alertFilterBasedOnSerachParam(arrayList14, arrayList, alertCommonRequest, arrayList10);
            int n = 0;
            n = alertCommonRequest instanceof AlertLogDataAcquisitionRequest ? 1 : 2;
            ArrayList arrayList17 = this.sort(arrayList15, arrayList16, arrayList15.get(n).toString());
            Collections.reverse(arrayList17);
            alertCommonResponse.setAlertRowData(arrayList17);
            charSequence = "alertFilterBasedOnSerachParam success";
            ErrorLog.getErrorLog().writeDebugTrace(7, (String)charSequence, this.m_stClientIPAddress);
            charSequence = "getNotificationAlertHeader success";
            ErrorLog.getErrorLog().writeDebugTrace(7, (String)charSequence, this.m_stClientIPAddress);
            ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
        }
        catch (WcException wcException2) {
            if (wcException2.getMessageId().equals("KASM18111-W")) {
                alertCommonResponse.setWarningMessage("KASM18111-W");
            }
            if (wcException2.getMessageId().equals("KASM18061-W")) {
                alertCommonResponse.setWarningMessage("KASM18061-W");
                alertCommonResponse.setOccurrenceHostFullList(alertCommonResponse.getOccurrenceHost());
            }
            throw wcException2;
        }
        return alertCommonResponse;
    }

    private ArrayList processNotificationAlertResponse(HsmListData hsmListData, ArrayList arrayList) throws WcException {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIPAddress);
        if (hsmListData == null) {
            WcException wcException = new WcException("KASM18044-E");
            throw wcException;
        }
        Vector vector = hsmListData.getLogs();
        if (vector == null || vector.size() <= 0) {
            WcException wcException = new WcException("KASM18061-W");
            throw wcException;
        }
        ArrayList arrayList2 = new ArrayList();
        HsmAlert hsmAlert = null;
        for (int i = 0; i < vector.size(); ++i) {
            ArrayList<String> arrayList3 = new ArrayList<String>();
            hsmAlert = (HsmAlert)vector.get(i);
            Vector vector2 = hsmAlert.getDatas();
            String string = null;
            HsmUrlData hsmUrlData = (HsmUrlData)vector2.get(0);
            string = hsmUrlData.toString().equals("images/alert_check.gif") ? "Confirmed" : "&nbsp;";
            arrayList3.add(string);
            String string2 = null;
            HsmUrlData hsmUrlData2 = (HsmUrlData)vector2.get(1);
            if (hsmUrlData2.toString().equals("images/alert_lv_inf.gif")) {
                string2 = "Information";
            } else if (hsmUrlData2.toString().equals("images/alert_lv_cau.gif")) {
                string2 = "Caution";
            } else if (hsmUrlData2.toString().equals("images/alert_lv_wrn.gif")) {
                string2 = "Warning";
            } else if (hsmUrlData2.toString().equals("images/alert_lv_err.gif")) {
                string2 = "Failure";
            }
            arrayList3.add(string2);
            String string3 = vector2.get(2).toString();
            arrayList3.add(string3);
            arrayList3.add((String)vector2.get(3));
            if (!arrayList.contains(vector2.get(3))) {
                arrayList.add(vector2.get(3));
            }
            arrayList3.add((String)vector2.get(4));
            arrayList3.add(vector2.get(5).toString());
            arrayList3.add((String)vector2.get(6));
            arrayList3.add(new Integer(hsmAlert.getAlertKey()).toString());
            arrayList3.add(new Integer(hsmAlert.getNodeId()).toString());
            arrayList2.add(arrayList3);
        }
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
        return arrayList2;
    }

    private ArrayList processAlertLogDataResponse(HsmListData hsmListData) throws WcException {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIPAddress);
        if (hsmListData == null) {
            WcException wcException = new WcException("KASM18044-E");
            throw wcException;
        }
        Vector vector = hsmListData.getLogs();
        if (vector == null || vector.size() <= 0) {
            WcException wcException = new WcException("KASM18061-W");
            throw wcException;
        }
        ArrayList arrayList = new ArrayList();
        HsmRowData hsmRowData = null;
        for (int i = 0; i < vector.size(); ++i) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            hsmRowData = (HsmRowData)vector.get(i);
            Vector vector2 = hsmRowData.getDatas();
            String string = null;
            HsmUrlData hsmUrlData = (HsmUrlData)vector2.get(0);
            if (hsmUrlData.toString().equals("images/alert_lv_inf.gif")) {
                string = "Information";
            } else if (hsmUrlData.toString().equals("images/alert_lv_cau.gif")) {
                string = "Caution";
            } else if (hsmUrlData.toString().equals("images/alert_lv_wrn.gif")) {
                string = "Warning";
            } else if (hsmUrlData.toString().equals("images/alert_lv_err.gif")) {
                string = "Failure";
            }
            arrayList2.add(string);
            arrayList2.add((String)vector2.get(1));
            arrayList2.add((String)vector2.get(2));
            arrayList2.add((String)vector2.get(3));
            arrayList2.add(vector2.get(4).toString());
            arrayList2.add((String)vector2.get(5));
            arrayList.add(arrayList2);
        }
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
        return arrayList;
    }

    private ArrayList processAlertLogInfoResponse(HsmListData hsmListData) throws WcException {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIPAddress);
        if (hsmListData == null) {
            WcException wcException = new WcException("KASM18044-E");
            throw wcException;
        }
        Vector vector = hsmListData.getLogs();
        if (vector == null || vector.size() <= 0) {
            WcException wcException = new WcException("KASM18060-W");
            throw wcException;
        }
        ArrayList arrayList = new ArrayList();
        HsmServerAlertData hsmServerAlertData = null;
        for (int i = 0; i < vector.size(); ++i) {
            ArrayList arrayList2 = new ArrayList();
            hsmServerAlertData = (HsmServerAlertData)vector.get(i);
            Vector vector2 = hsmServerAlertData.getDatas();
            arrayList2.add(vector2.get(0));
            arrayList2.add(vector2.get(1));
            arrayList2.add(this.getFileNameFromDate(vector2.get(0).toString()));
            arrayList2.add(new Integer(hsmServerAlertData.getTime()).toString());
            arrayList.add(arrayList2);
        }
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
        return arrayList;
    }

    private ArrayList getHostList(Vector vector) throws WcException {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIPAddress);
        if (vector == null) {
            WcException wcException = new WcException("KASM18044-E");
            throw wcException;
        }
        HsmHostNodeData hsmHostNodeData = null;
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = null;
        for (int i = 0; i < vector.size(); ++i) {
            arrayList2 = new ArrayList<String>();
            hsmHostNodeData = (HsmHostNodeData)vector.get(i);
            if (!CommonUtil.isAllowableNode(hsmHostNodeData)) continue;
            arrayList2.add(hsmHostNodeData.getName());
            arrayList2.add(new Integer(hsmHostNodeData.getNodeId()).toString());
            arrayList.add(arrayList2);
        }
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
        return arrayList;
    }

    private ArrayList getAlertHeader(Vector vector) throws WcException {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIPAddress);
        if (vector == null) {
            WcException wcException = new WcException("KASM18044-E");
            throw wcException;
        }
        ArrayList arrayList = new ArrayList();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                arrayList.add(vector.get(i));
            }
        }
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
        return arrayList;
    }

    private ArrayList alertFilterBasedOnSerachParam(ArrayList arrayList, ArrayList arrayList2, AlertCommonRequest alertCommonRequest, ArrayList arrayList3) throws ParseException, WcException {
        Serializable serializable;
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIPAddress);
        ArrayList arrayList4 = new ArrayList();
        ArrayList<ArrayList> arrayList5 = new ArrayList<ArrayList>();
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList4 = (ArrayList)arrayList.get(i);
            serializable = null;
            serializable = !(alertCommonRequest instanceof AlertLogDataAcquisitionRequest) ? CommonUtil.convertDateToCalendar(arrayList4.get(2).toString(), "yyyy-MM-dd HH:mm:ss") : CommonUtil.convertDateToCalendar(arrayList4.get(1).toString(), "yyyy-MM-dd HH:mm:ss");
            Calendar calendar = null;
            if (alertCommonRequest.getStartDate() != null && alertCommonRequest.getStartDate().trim().length() > 0) {
                calendar = CommonUtil.convertDateToCalendar(alertCommonRequest.getStartDate().trim(), "yyyy-MM-dd HH:mm:ss");
            }
            Calendar calendar2 = null;
            if (alertCommonRequest.getEndDate() != null && alertCommonRequest.getEndDate().trim().length() > 0) {
                calendar2 = CommonUtil.convertDateToCalendar(alertCommonRequest.getEndDate().trim(), "yyyy-MM-dd HH:mm:ss");
            }
            if (calendar != null && calendar2 != null) {
                if (((Calendar)serializable).before(calendar) || ((Calendar)serializable).after(calendar2)) continue;
                arrayList5.add(arrayList4);
                continue;
            }
            if (calendar == null && calendar2 != null) {
                if (((Calendar)serializable).after(calendar2)) continue;
                arrayList5.add(arrayList4);
                continue;
            }
            if (calendar2 == null && calendar != null) {
                if (((Calendar)serializable).before(calendar)) continue;
                arrayList5.add(arrayList4);
                continue;
            }
            arrayList5.add(arrayList4);
        }
        ArrayList arrayList6 = null;
        if (arrayList5 != null && arrayList5.size() > 0 && arrayList2 != null) {
            arrayList6 = !(alertCommonRequest instanceof AlertLogDataAcquisitionRequest) ? this.searchNotificationAlertsBasedOnOtherParams(arrayList5, arrayList2, arrayList3) : this.searchAlertLogDataBasedOnOtherParams(arrayList5, arrayList2);
        } else {
            if (arrayList5 == null || arrayList5.size() == 0) {
                serializable = new WcException("KASM18111-W");
                ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
                throw serializable;
            }
            ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
            return arrayList5;
        }
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
        if (arrayList6 == null || arrayList6.size() == 0) {
            serializable = new WcException("KASM18111-W");
            throw serializable;
        }
        return arrayList6;
    }

    private ArrayList searchNotificationAlertsBasedOnOtherParams(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) throws WcException {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIPAddress);
        boolean bl = false;
        ArrayList arrayList4 = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            List list = (List)arrayList.get(i);
            bl = false;
            if (arrayList2.get(0) != null && arrayList2.get(0).toString().trim().length() > 0 && !arrayList2.get(0).toString().equalsIgnoreCase(list.get(0).toString())) {
                bl = true;
            }
            if (!(bl || arrayList2.get(1) == null || arrayList2.get(1).toString().trim().length() <= 0 || bl || arrayList2.get(1).toString().equalsIgnoreCase(list.get(1).toString()))) {
                bl = true;
            }
            if (!(bl || arrayList2.get(2) == null || arrayList2.get(2).toString().trim().length() <= 0 || bl || arrayList2.get(2).toString().equalsIgnoreCase(list.get(3).toString()))) {
                bl = true;
            }
            if (!(bl || arrayList2.get(3) == null || arrayList2.get(3).toString().trim().length() <= 0 || bl || arrayList2.get(3).toString().equalsIgnoreCase(list.get(4).toString()))) {
                bl = true;
            }
            if (!bl && arrayList2.get(4) != null && arrayList2.get(4).toString().trim().length() > 0 && !bl && list.get(5).toString().indexOf(arrayList2.get(4).toString()) < 0) {
                bl = true;
            }
            if (bl) continue;
            arrayList4.add(arrayList.get(i));
        }
        if (arrayList4.size() == 0) {
            WcException wcException = new WcException("KASM18111-W");
            ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
            throw wcException;
        }
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
        return arrayList4;
    }

    private ArrayList searchAlertLogDataBasedOnOtherParams(ArrayList arrayList, ArrayList arrayList2) {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIPAddress);
        boolean bl = false;
        ArrayList arrayList3 = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            List list = (List)arrayList.get(i);
            bl = false;
            if (arrayList2.get(0) != null && arrayList2.get(0).toString().trim().length() > 0 && !arrayList2.get(0).toString().equalsIgnoreCase(list.get(0).toString())) {
                bl = true;
            }
            if (!(bl || arrayList2.get(1) == null || arrayList2.get(1).toString().trim().length() <= 0 || bl || arrayList2.get(1).toString().equalsIgnoreCase(list.get(3).toString()))) {
                bl = true;
            }
            if (!bl && arrayList2.get(2) != null && arrayList2.get(2).toString().trim().length() > 0 && !bl && list.get(4).toString().indexOf(arrayList2.get(2).toString()) < 0) {
                bl = true;
            }
            if (bl) continue;
            arrayList3.add(arrayList.get(i));
        }
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
        return arrayList3;
    }

    private String getFileNameFromDate(String string) {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIPAddress);
        if (string == null) {
            return null;
        }
        string = string.replaceAll("-", "");
        string = string.trim() + ".log";
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
        return string;
    }

    private ArrayList sort(List list, List list2, String string) {
        ErrorLog.getErrorLog().writeFunctionalTrace(3, this.m_stClientIPAddress);
        TreeMap<String, List> treeMap = new TreeMap<String, List>();
        int n = list.indexOf(string);
        for (int i = 0; i < list2.size(); ++i) {
            List list3 = (List)list2.get(i);
            treeMap.put("" + list3.get(n) + i, list3);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(treeMap.values());
        ErrorLog.getErrorLog().writeFunctionalTrace(4, this.m_stClientIPAddress);
        return arrayList;
    }

    protected String getWcErrorCode(HsmException hsmException, int n) {
        if (hsmException == null) {
            return null;
        }
        int n2 = hsmException.getErrorCode();
        if ((n2 & 0xFC00FFFF) == 335544325) {
            return "KASM180D0-E";
        }
        if ((n2 & 0xFC00FFFF) == 402653449) {
            return "KASM18060-W";
        }
        if ((n2 & 0xF0000000) != 0x10000000) {
            return "KASM18028-E";
        }
        HsmError hsmError = hsmException.getError();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Error ID mapping not found: ");
        stringBuffer.append(hsmError.getCodeStr());
        stringBuffer.append(":");
        stringBuffer.append(" ");
        stringBuffer.append(hsmError.toLoggingString());
        ErrorLog.getErrorLog().writeDebugTrace(7, stringBuffer.toString(), this.m_stClientIPAddress);
        if (n == 1) {
            return "KASM18094-E";
        }
        if (n == 2) {
            return "KASM18070-E";
        }
        if (n == 4) {
            return "KASM18092-E";
        }
        return "KASM18029-E";
    }
}

