/**
 * Copyright : All Rights Reserved. Copyright (C) 2006, Hitachi, Ltd.
 * Title     : ServerConductor WebConsole
 * Version   : 08-00
 * Name      : envSet.js
 * Date      : 2006/04/17
 * Author    : Raman.V
 */
 
var m_ArrDeviceID = new Array();      // Array used for DeviceIds
var m_ArrDeviceNames = new Array();   // Array used for DeviceNames
var m_iThresholdValue = 0;            // Array used for Threshold Value Storage
var m_iPollIntervalValue = 0;         // Array used for PollInterval Storage
var m_iSamplingCountValue = 0;        // Array used for SamplingCount Storage
var m_ArrDriveId = new Array();       // Array used for DriveIds
var m_ArrDriveName = new Array();     // Array used for DriveNames
var m_ArrThreshold = new Array();     // Array used for ThresholdValues
var m_ArrFlag = new Array();          // Array used for enableFlag(True/False)	
var m_CPUArr = new Array();           // Array used for CPU details
var m_MemoryArr = new Array();        // Array used for Memory details
var m_CheckValidation = true;         // Variable used to check Vaildation

// Flag used for Excess Usage Rate Confimation Dialog 
var m_valueChangeFlag = false;			

// Array used for UsageRage Checkbox checked/unchecked 
var m_blCheckBoxValue;					

// Array that holds (DeviceId"-"DeviceName"-"ThresholdValue"-"enableFlag)
var m_ArrThresholdParam = new Array(); 

var m_menuArray = [
				 	"network",
					"alert",
					"alertAttribute",
					"excessUsage",
					"help"
				  ];
// Array used for Confirmation Dialog			  
var confirmationProperties = new Array();                                       // 800WA_WEBCONSOLE261

// Var to indicate wheteher the Selection is present in the drive list
var m_SelIndexDriveList = -1;                                                   // 800WA_WEBCONSOLE397

/**
 * Processing when device combobox is changed
 * @since 08-00
 */
function deviceChange()
{
	 m_iCount = 0;                                                              // 800WA_WEBCONSOLE281
     m_CheckValidation = true;                                                  // 800WA_WEBCONSOLE281
	 var l_Index = document.forms[0].thresholdDevice.selectedIndex;
	 // Default value change
		document.forms[0].thresholdParam.value = m_iThresholdValue[l_Index];
		document.forms[0].pollInterval.value = m_iPollIntervalValue[l_Index];
		document.forms[0].samplingCount.value = m_iSamplingCountValue[l_Index];

		// If selected index is drive or filesystem
		if(l_Index == "1"){
			DriveAdd();
		}else{
			DriveDel();	
		} 
		
		if(m_blCheckBoxValue[l_Index] == "true")
		{
			document.forms[0].usageRateCheck.checked = true;
		}
		if(m_blCheckBoxValue[l_Index] == "false")
		{
			document.forms[0].usageRateCheck.checked = false;
		}
		setLoadEnabled(m_blCheckBoxValue[l_Index]);
		setLoad(l_Index);
} 

 /**
 * Drive/FileSystem values adds to the Drivelist. 
 * @since 08-00
 */
function DriveAdd(){
	var l_stListvalue = null;

	// Selection box element save
	var l_objSel = document.forms[0].driveList.options;
	
	for(i = 0; i < m_ArrDriveName.length; i++){
		if(m_ArrFlag[i] == "true"){
			l_stListvalue = m_ArrDriveName[i] + ": " + m_ArrThreshold[i] + "%";
		}else{
			l_stListvalue = m_ArrDriveName[i] + ": " + USAGE_RATE_DONOTSET;     // 800WA_WEBCONSOLE355
		}
    	// Selection box addition		
		l_objSel[i] = new Option(l_stListvalue,m_ArrDriveName[i]);
	}
	
	return true;
}

/**
 * Drive/FileSystem deletes from Drivelist
 * @since 08-00
 */
function DriveDel(){

	// Selection box element save
	var l_objSel = document.forms[0].driveList.options;
	var l_iLen = l_objSel.length;
	
	for(var l_iIdx = 0; l_iIdx < l_iLen; l_iIdx++){
		l_objSel[0] = null;	
	}
}

/**
 * When Drivelist box is single clicked
 * @param r_Index is a numeric value
 * @since 08-00
 */
function setClick(r_Index){
	if(r_Index >= 0){
		if(m_ArrFlag[r_Index] == "true")
		{
	 		document.forms[0].thresholdParam.disabled = false;
		}else
		{
	 		document.forms[0].thresholdParam.disabled = true;
		}
		document.forms[0].thresholdParam.value = m_ArrThreshold[r_Index];
	}
	m_SelIndexDriveList = r_Index;                                              // 800WA_WEBCONSOLE397
}

/**
 * Processing when Drivelist box is double-clicked
 * @param r_Index is a numeric value
 * @since 08-00
 */
function setDblClick(r_Index){
	var l_stListvalue = null;  

	var l_objSel = document.forms[0].driveList.options;

	parent.main.m_valueChangeFlag = true;

	// A set flag is changed.
	if(m_ArrFlag[r_Index] == "true")
	{
	 	m_ArrFlag[r_Index]= "false";
	}else
	{
	 	m_ArrFlag[r_Index]= "true";
	}
	
	if(m_ArrFlag[r_Index] == "true"){
	    m_ArrThreshold[r_Index] = m_iThresholdValue[1];
		l_stListvalue 
		      = m_ArrDriveName[r_Index] + ": " + m_ArrThreshold[r_Index]+"%";
		document.forms[0].thresholdParam.disabled = false;
	}else{
		l_stListvalue = m_ArrDriveName[r_Index] + ": "+ USAGE_RATE_DONOTSET;    // 800WA_WEBCONSOLE355
		document.forms[0].thresholdParam.disabled = true;
		m_ArrThreshold[r_Index] = 0;
	}
	// The value of the list is changed. 
	//l_objSel[r_Index] = new Option(l_stListvalue,m_ArrDriveName[r_Index]);    // 800WA_WEBCONSOLE310
	document.forms[0].driveList.options[r_Index].text = l_stListvalue;          // 800WA_WEBCONSOLE310
	document.forms[0].thresholdParam.value = m_ArrThreshold[r_Index];
	document.forms[0].driveList.options[r_Index].selected = true;
	m_SelIndexDriveList = r_Index;                                              // 800WA_WEBCONSOLE397
}

/**
 * When space, down and up arrow keys are pressed
 * @since 08-00
 */
function setKeydown(){
	var l_Index = document.forms[0].driveList.selectedIndex;
	var l_objCode = window.event.keyCode;

	switch(l_objCode){
	case 32: // When space key is pressed
		setDblClick(l_Index);
		break;
	case 38: // When up arrow key is pressed
		if(l_Index > 0){
			setClick(l_Index - 1);
		}	
		break;
	case 40: // When down arrow key is pressed
		if(l_Index < document.forms[0].driveList.length - 1){
			setClick(l_Index + 1);
		}	
		break;	
	default:
		break;
	}
	m_SelIndexDriveList = l_Index;                                              // 800WA_WEBCONSOLE397
}

/**
 * Processing when thresholdParam value text is changed
 * @param r_Name is the component name
 * @since 08-00
 */
 
function setonChange(r_Name){
	var l_stListvalue = null;
	var l_iThresholdValue = 0;
	var l_objSel = document.forms[0].driveList.options;
	var l_Index = document.forms[0].thresholdDevice.selectedIndex;
	//parent.main.m_valueChangeFlag = true;                                     // 800WA_WEBCONSOLE448

	// Input check
	if(isUseCheck(r_Name) == false)
	{
		m_CheckValidation = false;
		return false;
	}

	switch(r_Name)
	{
	case "thresholdParam":
		{
		l_iThresholdValue = document.forms[0].thresholdParam.value;
		
		// When drive/filesystem is selected
		if(l_Index == "1")
		{
			var l_SelIdx = document.forms[0].driveList.selectedIndex;
			if(l_SelIdx >= 0)                                                   // 800WA_WEBCONSOLE323
			{                                                                   // 800WA_WEBCONSOLE323
			m_ArrThreshold[l_SelIdx] = l_iThresholdValue;
			if(l_iThresholdValue > 0)                                           // 800WA_WEBCONSOLE448
			{                                                                   // 800WA_WEBCONSOLE448
			l_stListvalue 
			   = m_ArrDriveName[l_SelIdx] + ": " + m_ArrThreshold[l_SelIdx]+"%";			
			//l_objSel[l_SelIdx]                                                // 800WA_WEBCONSOLE310
			//        = new Option(l_stListvalue,m_ArrDriveName[l_SelIdx]);     // 800WA_WEBCONSOLE310
			document.forms[0].driveList.options[l_SelIdx].text = l_stListvalue; // 800WA_WEBCONSOLE310
			}                                                                   // 800WA_WEBCONSOLE448
			document.forms[0].driveList.options[l_SelIdx].selected = true;
		    }                                                                   // 800WA_WEBCONSOLE323
		// Others	
		}else
		{
			m_iThresholdValue[l_Index] = l_iThresholdValue;			
		}
		break;
		}
	case "pollInterval":
		{
		l_iThresholdValue = document.forms[0].pollInterval.value;
		m_iPollIntervalValue[l_Index] = l_iThresholdValue;
		break;	
		}
	default:
		{
		l_iThresholdValue = document.forms[0].samplingCount.value;
		m_iSamplingCountValue[l_Index] = l_iThresholdValue;	
		break;	
		}
	}
	return true;
}

/**
 * Validation checks which returns boolean
 * @param r_Name is the component name
 * @return true or false
 * @since 08-00
 */
 function isUseCheck(r_Name){
 	var l_Min = 0;
 	var l_Max = 0;
	var l_arrArgs = new Array();
	var l_TextFieldName = "";	

	l_arrArgs = document.all.tags("input")
	for(i = 0; i < l_arrArgs.length; i++){
		if((l_arrArgs[i].type == "text") && !(l_arrArgs[i].disabled)
		    && l_arrArgs[i].name == r_Name){	

			//Null check
			if(isNodata(l_arrArgs[i].value,l_arrArgs[i].name) == false)
			{
				m_iCount = 1;
				return false;
			}

			// Range check
			switch(l_arrArgs[i].name){
				// Use rate
				case "thresholdParam":
					l_TextFieldName = USAGE_RATE;
					if(document.forms[0].thresholdDevice.selectedIndex == "0"){
						l_Min = CPU_VAL_MIN;	
					}else{
						l_Min = DRIVE_VAL_MIN;
					}
					l_Max = CPU_VAL_MAX;
					break;
				case "pollInterval":
					l_Min = POLLINTERVAL_VAL_MIN;
					l_Max = POLLINTERVAL_VAL_MAX;
					l_TextFieldName = USAGE_RATE_INTERVAL;
					break;
				default:
					l_Min = SAMPLINGCOUNT_VAL_MIN;
					l_Max = SAMPLINGCOUNT_VAL_MAX;
					l_TextFieldName = USAGE_RATE_SAMPLING_COUNT;				
					break;
			}

			// Numeric check
			if(isNumeric(l_arrArgs[i].value,
								l_arrArgs[i].name,l_TextFieldName) == false){ 
				m_iCount = 1;
				return false;
			}
		
			// Minus check
			if(isPositiveVal(l_arrArgs[i].value,
								l_arrArgs[i].name,l_TextFieldName) == false){
				m_iCount = 1;								
				return false;
			}
			
			if(isRange( l_arrArgs[i].value,l_arrArgs[i].name,l_TextFieldName,
 			            l_Min,l_Max,MSG_COMMON_RANGE_CHECK) == false)
			{
					m_iCount = 1;
					return false;
			}
		}
	}
	return true;
 }
 
/**
 * Check for decimal value
 * @param r_Num is a numeric value
 * @return true or false
 * @since 08-00
 */
function isDecimal(r_Num){                                                      // 800WA_WEBCONSOLE366
  for (var l_iIdx = 0; l_iIdx < r_Num.length; l_iIdx++) {                       // 800WA_WEBCONSOLE366
  	if(r_Num.charAt(l_iIdx) == "." )                                            // 800WA_WEBCONSOLE366
  	{                                                                           // 800WA_WEBCONSOLE366
  	 return true;                                                               // 800WA_WEBCONSOLE366
  	}                                                                           // 800WA_WEBCONSOLE366
  }                                                                             // 800WA_WEBCONSOLE366
  return false;                                                                 // 800WA_WEBCONSOLE366
}                                                                               // 800WA_WEBCONSOLE366

/**
 * Check for numerical value
 * @param r_Num is a numeric value
 * @param r_Id is the component name
 * @param r_DispName is the Display name
 * @return true or false
 * @since 08-00
 */
function isNumeric(r_Num,r_Id,r_DispName){
 	if (isNaN(r_Num) || isDecimal(r_Num) || (r_Num.indexOf('+') == 0)){         // 800WA_WEBCONSOLE366 //800WA_WEBCONSOLE419
	alertMsg(MSG_COMMON_POSITIVE_INTEGER_CHECK , r_DispName);		// KASM1801F-E
	document.all(r_Id).select();			        
 	document.all(r_Id).focus();	
    obj = document.forms[0][r_Id];                                              // 800WA_WEBCONSOLE448
	return false;
    }
 	return true;
}

/**
 * check for null validation
 * @param r_Num is a numeric value
 * @param r_Id is the component name
 * @return true or false
 * @since 08-00
 */
var obj; 
function isNodata(r_Num,r_Id){
	 if (trim(r_Num) == '') {                                                   // 800WA_WEBCONSOLE213  
	 	switch(r_Id)
	 	{
			case "thresholdParam":
				l_stErrorCode = MSG_USAGERATE_CHECK ;  		// KASM1808A-E
				break;
			case "pollInterval":
				l_stErrorCode = MSG_USAGEINTERVAL_CHECK ; 	// KASM1808B-E
				break;
			default:
				l_stErrorCode = MSG_SAMPLING_CHECK ; 		// KASM1808C-E
			}
	 alertMsg(l_stErrorCode);
	 //document.all(r_Id).value = "";                                           // 800WA_WEBCONSOLE371
	 //document.all(r_Id).select();                                             // 800WA_WEBCONSOLE371
	 document.all(r_Id).value = "";                                             // 800WA_WEBCONSOLE448
	 obj = document.forms[0][r_Id];
	 obj.focus();	
	 return false;
	 }
	 return true;
	 
}

/**
 * Positive value check validation
 * @param r_Num is a numeric value
 * @param r_Id is the component name
 * @param r_DispName is the Display name
 * @return true if value is positive ,false otherwise
 * @since 08-00
 */
function isPositiveVal(r_Num,r_Id,r_DispName){
	 if (r_Num < 0) {
	 alertMsg(MSG_COMMON_POSITIVE_INTEGER_CHECK , r_DispName);		// KASM1801F-E
	 document.all(r_Id).select();			        
	 obj = document.forms[0][r_Id];                                             // 800WA_WEBCONSOLE448
	 document.all(r_Id).focus();	
	 return false;
	 }
	 return true;
}

/**
 * Range check Validation
 * @param r_Num is a numeric value
 * @param r_Id is the component name
 * @param r_DispName is the Display name
 * @param r_Min is minimum value
 * @param r_Max is maximum value
 * @return true or false
 * @since 08-00
 */
function isRange(r_Num,r_Id,r_DispName,r_Min,r_Max,r_MessageID)
{
	r_Num = parseInt(r_Num , 10);                                               // 800WA_WEBCONSOLE422
	r_Min = parseInt(r_Min , 10);                                               // 800WA_WEBCONSOLE422
	r_Max = parseInt(r_Max , 10);                                               // 800WA_WEBCONSOLE422
	
	//if ((eval(r_Num) < eval(r_Min)) || (eval(r_Num) > eval(r_Max)))           // 800WA_WEBCONSOLE422
	if ((r_Num < r_Min) || (r_Num > r_Max))                                     // 800WA_WEBCONSOLE422
	{
		 alertMsg(r_MessageID,r_DispName,r_Min,r_Max);		// KASM1802D-E
		 document.all(r_Id).select();			        
		 document.all(r_Id).focus();	
		 obj = document.forms[0][r_Id];                                         // 800WA_WEBCONSOLE448
		 return false;
	}
	
	return true;
}

/**
 * Calls when jsp page OnLoad
 * @param r_Index is a numeric value
 * @since 08-00
 */
function setLoad(r_Index)
{
	if (m_blCheckBoxValue[r_Index] == "true" || 
	    m_blCheckBoxValue[r_Index] == true)
	{
		document.forms[0].pollInterval.disabled = false;
		document.forms[0].samplingCount.disabled = false;
		if(r_Index != 1)
		{
		    document.forms[0].thresholdParam.disabled = false;
		    document.forms[0].driveList.disabled = true;                        // 800WA_WEBCONSOLE282
		}		
		else                                                                    // 800WA_WEBCONSOLE397
		{                                                                       // 800WA_WEBCONSOLE397
		    if(m_SelIndexDriveList >= 0)                                        // 800WA_WEBCONSOLE397
		    {                                                                   // 800WA_WEBCONSOLE397
		        document.forms[0].driveList.selectedIndex = m_SelIndexDriveList;// 800WA_WEBCONSOLE397
		        if(m_ArrFlag[m_SelIndexDriveList] == "true")                    // 800WA_WEBCONSOLE397
		        {                                                               // 800WA_WEBCONSOLE397
		            document.forms[0].thresholdParam.disabled = false;          // 800WA_WEBCONSOLE397
		            document.forms[0].thresholdParam.value = 
		                          m_ArrThreshold[m_SelIndexDriveList];          // 800WA_WEBCONSOLE397
		        }                                                               // 800WA_WEBCONSOLE397
		        else                                                            // 800WA_WEBCONSOLE397
		        {                                                               // 800WA_WEBCONSOLE397
		            document.forms[0].thresholdParam.value = 
		                          m_ArrThreshold[m_SelIndexDriveList];          // 800WA_WEBCONSOLE448
		            document.forms[0].thresholdParam.disabled = true;           // 800WA_WEBCONSOLE397
		        }                                                               // 800WA_WEBCONSOLE397
		    }                                                                   // 800WA_WEBCONSOLE397
		}                                                                       // 800WA_WEBCONSOLE397
		document.forms[0].usageRateCheck.checked = true;
	}	
	else
	{
		document.forms[0].pollInterval.disabled = true;
		document.forms[0].samplingCount.disabled = true;
		if(m_SelIndexDriveList >= 0 && r_Index == 1)                            // 800WA_WEBCONSOLE397
		{                                                                       // 800WA_WEBCONSOLE397
		    document.forms[0].driveList.disabled = false;                       // 800WA_WEBCONSOLE397
		    document.forms[0].thresholdParam.value = 
		                                    m_ArrThreshold[m_SelIndexDriveList];// 800WA_WEBCONSOLE397
		    document.forms[0].driveList.selectedIndex = m_SelIndexDriveList;    // 800WA_WEBCONSOLE397
		}                                                                       // 800WA_WEBCONSOLE397
		document.forms[0].thresholdParam.disabled = true;
		document.forms[0].driveList.disabled = true;
		document.forms[0].usageRateCheck.checked = false;
	}
}

/**
 * This is called when device is changed 
 * @param r_Flg is a boolean value
 * @since 08-00
 */
function setLoadEnabled(r_Flg){
	
	var l_Index = 0;
	
	l_Index = document.forms[0].thresholdDevice.selectedIndex;
	
	if(l_Index == "1"){
		document.forms[0].pollInterval.disabled = !(r_Flg);
		document.forms[0].samplingCount.disabled = !(r_Flg);
		document.forms[0].thresholdParam.disabled = true;
		document.forms[0].driveList.disabled = !(r_Flg);
	}else{
		document.forms[0].pollInterval.disabled = !(r_Flg);
		document.forms[0].samplingCount.disabled = !(r_Flg);
		document.forms[0].thresholdParam.disabled = !(r_Flg);
		document.forms[0].driveList.disabled = true;			
	}
	m_blCheckBoxValue[l_Index] = r_Flg;
}

/**
 * When UsageRate checkbox is clicked(Checked/Unchecked)
 * @param r_Flg is a boolean value
 * @since 08-00
 */
function setEnabled(r_Flg){
	var l_Index = 0;
	
	parent.main.m_valueChangeFlag = true;
	var l_varValid = true;                                                      // 800WA_WEBCONSOLE448
	if(!r_Flg)                                                                  // 800WA_WEBCONSOLE448
	{                                                                           // 800WA_WEBCONSOLE448
	    l_varValid = validateExcessVal();                                       // 800WA_WEBCONSOLE448
	}                                                                           // 800WA_WEBCONSOLE448
	if(l_varValid)                                                              // 800WA_WEBCONSOLE448
	{	                                                                        // 800WA_WEBCONSOLE448
	l_Index = document.forms[0].thresholdDevice.selectedIndex;
	
	if(l_Index == "1"){
		document.forms[0].pollInterval.disabled = !(r_Flg);
		document.forms[0].samplingCount.disabled = !(r_Flg);
		var l_DriveIndex = document.forms[0].driveList.selectedIndex;           // 800WA_WEBCONSOLE392
		if(l_DriveIndex >= 0)                                                   // 800WA_WEBCONSOLE392
		{                                                                       // 800WA_WEBCONSOLE392
		    if(m_ArrFlag[l_DriveIndex] == "true" && r_Flg)                      // 800WA_WEBCONSOLE392
		    {                                                                   // 800WA_WEBCONSOLE392
		        document.forms[0].thresholdParam.disabled = false;              // 800WA_WEBCONSOLE392
		    }                                                                   // 800WA_WEBCONSOLE392
		    else                                                                // 800WA_WEBCONSOLE392
		    {                                                                   // 800WA_WEBCONSOLE392
		        document.forms[0].thresholdParam.disabled = true;               // 800WA_WEBCONSOLE392
		    }                                                                   // 800WA_WEBCONSOLE392
		}                                                                       // 800WA_WEBCONSOLE392
		else                                                                    // 800WA_WEBCONSOLE392
		{                                                                       // 800WA_WEBCONSOLE392
		document.forms[0].thresholdParam.disabled = true;
		}                                                                       // 800WA_WEBCONSOLE392
		document.forms[0].driveList.disabled = !(r_Flg);
	}else{
		document.forms[0].pollInterval.disabled = !(r_Flg);
		document.forms[0].samplingCount.disabled = !(r_Flg);
		document.forms[0].thresholdParam.disabled = !(r_Flg);
		document.forms[0].driveList.disabled = true;			
	}
	m_blCheckBoxValue[l_Index] = r_Flg;
	}                                                                           // 800WA_WEBCONSOLE448
	else                                                                        // 800WA_WEBCONSOLE448
	{                                                                           // 800WA_WEBCONSOLE448
	    document.forms[0].usageRateCheck.checked = true;                        // 800WA_WEBCONSOLE448
	}                                                                           // 800WA_WEBCONSOLE448
}

/**
 * When submit button is clicked, post the values to server
 * @since 08-00
 */
var m_iCount = 0;
function postValues()
{
//if(m_iCount > 0)                                                              // 800WA_WEBCONSOLE448
//{                                                                             // 800WA_WEBCONSOLE448
if(document.forms[0].setup != null) {                                           // 800WA_WEBCONSOLE451
    if(document.forms[0].setup.disabled == true){                               // 800WA_WEBCONSOLE451
        return false;                                                           // 800WA_WEBCONSOLE451
    }                                                                           // 800WA_WEBCONSOLE451
}                                                                               // 800WA_WEBCONSOLE451
if(
	setonChange('thresholdParam') && 
	setonChange('pollInterval') && 
	setonChange('samplingCount')
  )
  {
	m_CheckValidation = true;
  }
  else
  {
	m_CheckValidation = false;
  }
//}                                                                             // 800WA_WEBCONSOLE448
m_iCount = 1;

	if(!m_CheckValidation)
	{
	obj.focus();
	return false;
	}
	
	if(m_CheckValidation)
	{
	for(var l_iCnt=0;l_iCnt < m_ArrDriveId.length;l_iCnt++) {
		m_ArrThresholdParam[l_iCnt] 
		  = m_ArrDriveId[l_iCnt]+"-"+m_ArrDriveName[l_iCnt]
			 	+"-"+m_ArrThreshold[l_iCnt]+"-"+m_ArrFlag[l_iCnt];
		}
	m_CPUArr[0] = CPUDeviceID+"-"+CPUDeviceName+"-"+m_iThresholdValue[0]
										+"-"+m_blCheckBoxValue[0];
	m_MemoryArr[0] = MemoryDeviceID+"-"+MemoryDeviceName+"-"
								+m_iThresholdValue[2]+"-"+m_blCheckBoxValue[2];
	//variables and Arrays are assigned into hidden fields
	document.forms[0].hdnNodeId.value	= NodeID;
	document.forms[0].hdnDeviceID.value	= m_ArrDeviceID;
	document.forms[0].hdnThresholdDeviceNames.value = m_ArrDeviceNames;
	document.forms[0].hdnThresholdValues.value = m_iThresholdValue;
	document.forms[0].hdnUsageRateCheckBoxValues.value = m_blCheckBoxValue;
	document.forms[0].hdnPollIntervalValues.value = m_iPollIntervalValue;
	document.forms[0].hdnSamplingCountValues.value = m_iSamplingCountValue;
	document.forms[0].hdnDriveParamValues.value = m_ArrThresholdParam;
	document.forms[0].hdnCpuParamValues.value = m_CPUArr;
	document.forms[0].hdnMemoryParamValues.value = m_MemoryArr;
	document.forms[0].thresholdParam.readOnly = true;                           // 800WA_WEBCONSOLE451
	document.forms[0].pollInterval.readOnly = true;                             // 800WA_WEBCONSOLE451
	document.forms[0].samplingCount.readOnly = true;                            // 800WA_WEBCONSOLE451
	document.forms[0].setup.disabled = true;                                    // 800WA_WEBCONSOLE451
	return true;
	}	
}
//  Variable that will hold the id for last selected menu item
  var m_varPreviousId = '';                                                     // 800WA_WEBCONSOLE335
  
/**
 * Checking with the Confirmation Dialog whether the data is changed or not. 
 * (for All the screens of Agent Setup Module)
 * @param r_stStyleId is form element name
 * @since 08-00
 */
function confirmCheck(r_stStyleId)
{   
	if(m_varPreviousId=='')                                                     // 800WA_WEBCONSOLE335
	{                                                                           // 800WA_WEBCONSOLE335
	     m_varPreviousId = r_stStyleId;                                         // 800WA_WEBCONSOLE335
	}                                                                           // 800WA_WEBCONSOLE335
	if(!parent.main.m_valueChangeFlag)                                          // 800WA_WEBCONSOLE335
	{	                                                                        // 800WA_WEBCONSOLE335
	    m_varPreviousId = r_stStyleId;                                          // 800WA_WEBCONSOLE335
	}                                                                           // 800WA_WEBCONSOLE335
	activeLink(r_stStyleId,m_menuArray);
	if(parent.main.m_valueChangeFlag)
	{
		var l_varConfirmDialogProp = new confirmationDialog(                    // 800WA_WEBCONSOLE261
				 					confirmationProperties[0],
				 					confirmationProperties[1],
				 					MSG_COMMON_CONFIRM_CHANGED,
				 					l_arrConfirmMsg[MSG_COMMON_CONFIRM_CHANGED],
				 					confirmationProperties[2],
				 					confirmationProperties[3],
				 					confirmationProperties[4],
				 					confirmationProperties[5]);                 // 800WA_WEBCONSOLE261                          
  	 var confirmMessage = confirmDialog(l_varConfirmDialogProp);                // 800WA_WEBCONSOLE261
		if(confirmMessage)                                                      // 800WA_WEBCONSOLE261 
		{                                                                       // 800WA_WEBCONSOLE261
			parent.main.m_valueChangeFlag = false;                              // 800WA_WEBCONSOLE261
			m_varPreviousId = r_stStyleId;                                      // 800WA_WEBCONSOLE335
			document.getElementById('page_title').innerHTML =
			                                  m_headingArray[m_varPreviousId];  //800WA_WEBCONSOLE454
		}                                                                       // 800WA_WEBCONSOLE261
		else                                                                    // 800WA_WEBCONSOLE335   
		{                                                                       // 800WA_WEBCONSOLE335
			document.getElementById(r_stStyleId).style.background = '#ffffff';  // 800WA_WEBCONSOLE335
			document.getElementById(m_varPreviousId).focus();                   // 800WA_WEBCONSOLE335
			//document.getElementById(m_varPreviousId).style.background = 'gray'; // 800WA_WEBCONSOLE335	// 800WA_WEBCONSOLE445
			document.getElementById(m_varPreviousId).style.background = 'white';// 800WA_WEBCONSOLE445
			if(parent.main.m_varGlobal != null)                                 // 800WA_WEBCONSOLE448
			{                                                                   // 800WA_WEBCONSOLE448
			if(!parent.main.m_varGlobal.disabled)                               // 800WA_WEBCONSOLE371
			{                                                                   // 800WA_WEBCONSOLE371
			  parent.main.m_varGlobal.focus();                                  // 800WA_WEBCONSOLE371
			}                                                                   // 800WA_WEBCONSOLE371
			}                                                                   // 800WA_WEBCONSOLE448
		}                                                                       // 800WA_WEBCONSOLE335 
		return confirmMessage;                                                  // 800WA_WEBCONSOLE261
 	}
 	document.getElementById('page_title').innerHTML = 
 	                                         m_headingArray[r_stStyleId];       //800WA_WEBCONSOLE454
}

/**
 * This function is used to display the Default Header Screen Name if the 
 * Detailed block is blank.
 * @since 08-00
 */
// function clearHeader()                                                       //800WA_WEBCONSOLE454 //800WA_WEBCONSOLE487
// {                                                                            //800WA_WEBCONSOLE454 //800WA_WEBCONSOLE487
  
//      if(parent.webconSetupValue != null)                                     // 800WA_WEBCONSOLE484 //800WA_WEBCONSOLE487
//      {                                                                       // 800WA_WEBCONSOLE484 //800WA_WEBCONSOLE487
//         parent.webconSetupValue = false;                                     // 800WA_WEBCONSOLE484 //800WA_WEBCONSOLE487
//      }                                                                       // 800WA_WEBCONSOLE484 //800WA_WEBCONSOLE487  
//      if(parent.main!= null)                                                  //800WA_WEBCONSOLE484 //800WA_WEBCONSOLE487
//      {                                                                       //800WA_WEBCONSOLE484 //800WA_WEBCONSOLE487
//         if(parent.main.m_valueChangeFlag != null)                            // 800WA_WEBCONSOLE484 //800WA_WEBCONSOLE487
//        {                                                                     // 800WA_WEBCONSOLE484 //800WA_WEBCONSOLE487
//            parent.main.m_valueChangeFlag = false;                            // 800WA_WEBCONSOLE484 //800WA_WEBCONSOLE487
//         }                                                                    // 800WA_WEBCONSOLE484 //800WA_WEBCONSOLE487
//      }                                                                       // 800WA_WEBCONSOLE484 //800WA_WEBCONSOLE487   
//      if(parent.cmdTimeOutSetupValue != null)                                 // 800WA_WEBCONSOLE484 //800WA_WEBCONSOLE487
//      {                                                                       // 800WA_WEBCONSOLE484 //800WA_WEBCONSOLE487
//         parent.cmdTimeOutSetupValue = false;                                 // 800WA_WEBCONSOLE484 //800WA_WEBCONSOLE487
//      }                                                                       // 800WA_WEBCONSOLE484 //800WA_WEBCONSOLE487  
//    if(parent.frames[0]!= null)                                               //800WA_WEBCONSOLE454 //800WA_WEBCONSOLE487
//    {                                                                         //800WA_WEBCONSOLE454 //800WA_WEBCONSOLE487
//      if(parent.frames[0].document != null)                                   //800WA_WEBCONSOLE454 //800WA_WEBCONSOLE487
//      {                                                                       //800WA_WEBCONSOLE454 //800WA_WEBCONSOLE487
//         if(parent.frames[0].document.getElementById('page_title') != null)   //800WA_WEBCONSOLE454 //800WA_WEBCONSOLE487
//         {                                                                    //800WA_WEBCONSOLE454 //800WA_WEBCONSOLE487  
//            parent.frames[0].document.getElementById('page_title').innerHTML =//800WA_WEBCONSOLE454 //800WA_WEBCONSOLE487 
//                               parent.frames[0].m_headingArray["default"];    //800WA_WEBCONSOLE454 //800WA_WEBCONSOLE487 
//        }                                                                     //800WA_WEBCONSOLE454 //800WA_WEBCONSOLE487 
//      }                                                                       //800WA_WEBCONSOLE454 //800WA_WEBCONSOLE487 
//   }                                                                          //800WA_WEBCONSOLE454 //800WA_WEBCONSOLE487 
// }                                                                            //800WA_WEBCONSOLE454 //800WA_WEBCONSOLE487 

/**
 * This function is used to display the Validation Messages
 * @param r_varKey is ErrorMessage Array index key
 * @param r_varArg0 is argument0
 * @param r_varArg1 is argument1
 * @param r_varArg2 is argument2
 * @param r_varArg3 is argument3
 * @param r_varArg4 is argument4
 * @since 08-00
*/
function alertMsg(r_varKey,r_varArg0,r_varArg1,r_varArg2,r_varArg3,r_varArg4)
{
 	l_stAlertMessages = new String(errorMsgArr[r_varKey]);
 	
	var l_varExpression0 = /\{0\}/gi;
	var l_varExpression1 = /\{1\}/gi;
	var l_varExpression2 = /\{2\}/gi;
	var l_varExpression3 = /\{3\}/gi;
	var l_varExpression4 = /\{4\}/gi;
	
	l_stAlertMessages = l_stAlertMessages.replace(l_varExpression0, r_varArg0);
	l_stAlertMessages = l_stAlertMessages.replace(l_varExpression1, r_varArg1);
	l_stAlertMessages = l_stAlertMessages.replace(l_varExpression2, r_varArg2);
	l_stAlertMessages = l_stAlertMessages.replace(l_varExpression3, r_varArg3);
	l_stAlertMessages = l_stAlertMessages.replace(l_varExpression4, r_varArg4);
	
	alert(r_varKey + "\n" + l_stAlertMessages);                                 // 800WA_WEBCONSOLE191
}

/**
  * This function is used to handle the Enter key press in Selection boxes
  * @since 08-00
  */
function checkEnter()
{
    if(event.keyCode == 13)
    {    
        postValues();
        document.forms[0].submit();
    }
}

/**
  * This function is used to validate the Usage rate field in Excess usage rate 
  * screen
  * @since 08-00
  */
function validateUsagerate()                                                    // 800WA_WEBCONSOLE448
{                                                                               // 800WA_WEBCONSOLE448
    var l_varUsagerateStat = document.forms[0].thresholdParam.disabled;         // 800WA_WEBCONSOLE448
    if(!l_varUsagerateStat)                                                     // 800WA_WEBCONSOLE448
    {                                                                           // 800WA_WEBCONSOLE448
	    if(isUseCheck('thresholdParam') == false)                               // 800WA_WEBCONSOLE448
	    {                                                                       // 800WA_WEBCONSOLE448
		    document.forms[0].driveList.options[m_SelIndexDriveList].selected =
		                                                                   true;// 800WA_WEBCONSOLE448
	    }                                                                       // 800WA_WEBCONSOLE448
        else                                                                    // 800WA_WEBCONSOLE448
        {                                                                       // 800WA_WEBCONSOLE448
            m_ArrThreshold[m_SelIndexDriveList] = 
                            parseInt(document.forms[0].thresholdParam.value,10);// 800WA_WEBCONSOLE448
            var l_stListvalue = 
            m_ArrDriveName[m_SelIndexDriveList] + ": " + m_ArrThreshold[m_SelIndexDriveList]+"%";// 800WA_WEBCONSOLE448
            document.forms[0].driveList.options[m_SelIndexDriveList].text = 
                                                                 l_stListvalue; // 800WA_WEBCONSOLE448
        }                                                                       // 800WA_WEBCONSOLE448
    }                                                                           // 800WA_WEBCONSOLE448
}                                                                               // 800WA_WEBCONSOLE448

/**
  * This function is used to validate the three textfields in Excess usage rate 
  * screen
  * @since 08-00
  */
function validateExcessVal()                                                    // 800WA_WEBCONSOLE448
{                                                                               // 800WA_WEBCONSOLE448
    var l_varUsagerateStat = document.forms[0].thresholdParam.disabled;         // 800WA_WEBCONSOLE448
    var l_varReturn = false;                                                    // 800WA_WEBCONSOLE448
    if(!l_varUsagerateStat) {                                                   // 800WA_WEBCONSOLE448
        if (setonChange('thresholdParam') && setonChange('pollInterval') && 
	        setonChange('samplingCount') )                                      // 800WA_WEBCONSOLE448
        {                                                                       // 800WA_WEBCONSOLE448
	        l_varReturn = true;                                                 // 800WA_WEBCONSOLE448
        }                                                                       // 800WA_WEBCONSOLE448
    }                                                                           // 800WA_WEBCONSOLE448
    else {                                                                      // 800WA_WEBCONSOLE448
        if (setonChange('pollInterval') && setonChange('samplingCount') )       // 800WA_WEBCONSOLE448
        {                                                                       // 800WA_WEBCONSOLE448
	        l_varReturn = true;                                                 // 800WA_WEBCONSOLE448
        }                                                                       // 800WA_WEBCONSOLE448
    }                                                                           // 800WA_WEBCONSOLE448
    return l_varReturn;                                                         // 800WA_WEBCONSOLE448
}                                                                               // 800WA_WEBCONSOLE448

/**
  * This function is used to set the value changed bollean for three text fields 
  * of Excess usage rate setting screen
  * @since 08-00
  */
function setExcessHasChanged()                                                  // 800WA_WEBCONSOLE452
{                                                                               // 800WA_WEBCONSOLE452
    var l_iDevIndex = document.forms[0].thresholdDevice.selectedIndex;          // 800WA_WEBCONSOLE452
    var l_iUsageRate = document.forms[0].thresholdParam.value;                  // 800WA_WEBCONSOLE452
    var l_iPollInt = document.forms[0].pollInterval.value;                      // 800WA_WEBCONSOLE452
    var l_iSampCnt = document.forms[0].samplingCount.value;                     // 800WA_WEBCONSOLE452
    if(l_iDevIndex == 0 || l_iDevIndex == 2)                                    // 800WA_WEBCONSOLE452
    {                                                                           // 800WA_WEBCONSOLE452
        if(l_iUsageRate != m_iThresholdValue[l_iDevIndex])                      // 800WA_WEBCONSOLE452
        {                                                                       // 800WA_WEBCONSOLE452
            parent.main.m_valueChangeFlag = true;                               // 800WA_WEBCONSOLE452
        }                                                                       // 800WA_WEBCONSOLE452
    }                                                                           // 800WA_WEBCONSOLE452
    else if(l_iDevIndex == 1)                                                   // 800WA_WEBCONSOLE452
    {                                                                           // 800WA_WEBCONSOLE452
        var l_iDriveIndex = document.forms[0].driveList.selectedIndex;          // 800WA_WEBCONSOLE452
        if(l_iDriveIndex >=0 && l_iUsageRate != m_ArrThreshold[l_iDriveIndex])  // 800WA_WEBCONSOLE452
        {                                                                       // 800WA_WEBCONSOLE452
            parent.main.m_valueChangeFlag = true;                               // 800WA_WEBCONSOLE452
        }                                                                       // 800WA_WEBCONSOLE452
    }                                                                           // 800WA_WEBCONSOLE452
    if(l_iPollInt != m_iPollIntervalValue[l_iDevIndex]                          // 800WA_WEBCONSOLE452
    || l_iSampCnt != m_iSamplingCountValue[l_iDevIndex])                        // 800WA_WEBCONSOLE452
    {                                                                           // 800WA_WEBCONSOLE452
        parent.main.m_valueChangeFlag = true;                                   // 800WA_WEBCONSOLE452
    }                                                                           // 800WA_WEBCONSOLE452
}                                                                               // 800WA_WEBCONSOLE452

//////////////Start - These functions are used for Network Module

/**
 * Calls when page Loads(Agent notification setting)
 * @since 08-00
 */
function setLoadAgtNet()
{
      // Variable initialization
      document.forms[0].cmdTimeOut.value = CmdTimeOutGet;
	  document.forms[0].keepAliveInterval.value = KeepAliveIntervalGet;
	  document.forms[0].hdnKeepAlive.value = 
	                         document.forms[0].keepAliveInterval.value;         // 800WA_WEBCONSOLE203
	  document.forms[0].hdnCmdTimeOut.value = document.forms[0].cmdTimeOut.value;// 800WA_WEBCONSOLE452
	  if(KeepAliveIntervalFlagGet == true || KeepAliveIntervalFlagGet == "true")
	  {
	      document.forms[0].keepAliveFlag.checked = true;
	      document.forms[0].keepAliveInterval.disabled = false;
	  }else
	  {
	  	    document.forms[0].keepAliveFlag.checked = false;
	  	    document.forms[0].keepAliveInterval.disabled = true;
	  }
}

/**
 * Sets the check box values (Network setting)
 * @param flg is boolean value
 * @since 08-00
*/
function setEnabledAgtNet(r_flg){

	if(r_flg)
	{
		document.forms[0].keepAliveInterval.disabled =false;
	}
 	else
 	{
		document.forms[0].keepAliveInterval.disabled = true;
	}
	parent.main.m_valueChangeFlag = true;
}	

/**
 * Input check(Agent Network setting)
 * @return true or false
 * @since 08-00
 */
function validateAgtNetForm()
{ 
    if(document.forms[0].submit != null) {                                      // 800WA_WEBCONSOLE451
        if(document.forms[0].submit.disabled == true){                          // 800WA_WEBCONSOLE451
            return false;                                                       // 800WA_WEBCONSOLE451
        }                                                                       // 800WA_WEBCONSOLE451
    }                                                                           // 800WA_WEBCONSOLE451
		var l_objAgentTimeOut = trim(document.forms[0].cmdTimeOut.value);       // 800WA_WEBCONSOLE213 
		var l_objKeepAlive =  trim(document.forms[0].hdnKeepAlive.value);       // 800WA_WEBCONSOLE203 // 800WA_WEBCONSOLE213
		document.forms[0].hdnNodeId.value=nodeId;
		 if(l_objAgentTimeOut.length == 0 || l_objAgentTimeOut == " " ) 
		{
			alertNetMsgs(MSG_AGENT_TIMEOUT_CHECK);
			document.forms[0].cmdTimeOut.value = "";
			document.forms[0].cmdTimeOut.focus();
			return false;
		}

 	// Check for Minus Validation

		if((document.forms[0].cmdTimeOut.value < 0) )
		 {
			alertNetMsgs(MSG_COMMON_POSITIVE_INTEGER_CHECK,
						 AGENT_NETWORK_CMDTIMEOUT_TEXT_NAME);
			document.forms[0].cmdTimeOut.select();
			document.forms[0].cmdTimeOut.focus();
			return false;
		 } 	  

 	// Range check for command Time out

		 //if((document.forms[0].cmdTimeOut.value < 1)  ||                      // 800WA_WEBCONSOLE424
		 //						(document.forms[0].cmdTimeOut.value >600))      // 800WA_WEBCONSOLE424
         if((parseInt(document.forms[0].cmdTimeOut.value,10) < AGENT_NETWORK_CMDTIMEOUT_MIN_VALUE)  // 800WA_WEBCONSOLE424
         || (parseInt(document.forms[0].cmdTimeOut.value,10) > AGENT_NETWORK_CMDTIMEOUT_MAX_VALUE)) // 800WA_WEBCONSOLE424
		 {
					
		 alertNetMsgs(MSG_COMMON_RANGE_CHECK,AGENT_NETWORK_CMDTIMEOUT_TEXT_NAME,
		 			  AGENT_NETWORK_CMDTIMEOUT_MIN_VALUE,
		 			  AGENT_NETWORK_CMDTIMEOUT_MAX_VALUE);
			document.forms[0].cmdTimeOut.select();
			document.forms[0].cmdTimeOut.focus();
			return false;
		 } 	  	
	
 	// Check for numerical value

		if(isNaN(l_objAgentTimeOut) || isDecimal(l_objAgentTimeOut) 
								|| (l_objAgentTimeOut.indexOf('+') == 0))       // 800WA_WEBCONSOLE366 //800WA_WEBCONSOLE419
		 {
		
			alertNetMsgs(MSG_COMMON_POSITIVE_INTEGER_CHECK,
				AGENT_NETWORK_CMDTIMEOUT_TEXT_NAME );
		   	document.forms[0].cmdTimeOut.select();
		   	document.forms[0].cmdTimeOut.focus();		
			return false;
		 }
	
	// Check for keep alive interval
	// If the KeepAliveInterval Textbox is disabled , no validation is required
	
//	if(document.forms[0].keepAliveInterval.disabled == false)                   // 800WA_WEBCONSOLE203
//	{                                                                           // 800WA_WEBCONSOLE203
		  if(l_objKeepAlive.length == 0 || l_objKeepAlive == " " ) 
		{
				alertNetMsgs(MSG_KEEPALIVE_CHECK);
				if(document.forms[0].keepAliveInterval.disabled == false) {     // 800WA_WEBCONSOLE203
				   document.forms[0].keepAliveInterval.value = "";
				   document.forms[0].keepAliveInterval.focus();
			    }
			    else{                                                           // 800WA_WEBCONSOLE203
			        //document.forms[0].keepAliveFlag.select();                 // 800WA_WEBCONSOLE368
			        document.forms[0].keepAliveInterval.value = "";             // 800WA_WEBCONSOLE368
			        document.forms[0].keepAliveFlag.focus();                    // 800WA_WEBCONSOLE203
			    }								
				return false;
		}

    // Check for Minus validation

	if((document.forms[0].keepAliveInterval.value < 0) )
	 {
			
		 alertNetMsgs(MSG_COMMON_POSITIVE_INTEGER_CHECK,
		 	AGENT_NETWORK_KEEPALIVE_TEXT_NAME);
		 	if(document.forms[0].keepAliveInterval.disabled == false) {         // 800WA_WEBCONSOLE203
			    document.forms[0].keepAliveInterval.select();
			    document.forms[0].keepAliveInterval.focus();
			}
		    else{                                                               // 800WA_WEBCONSOLE203
			    //document.forms[0].keepAliveFlag.select();                     // 800WA_WEBCONSOLE368
		    	document.forms[0].keepAliveInterval.disabled = false;           // 800WA_WEBCONSOLE368
		        document.forms[0].keepAliveInterval.select();                   // 800WA_WEBCONSOLE368
		        document.forms[0].keepAliveInterval.disabled = true;            // 800WA_WEBCONSOLE368
			    document.forms[0].keepAliveFlag.focus();                        // 800WA_WEBCONSOLE203	
     	    }							
		 return false;
	 } 	  	
	
	// Range check for keepAliveInterval
	
	 //if((document.forms[0].keepAliveInterval.value < 1)  ||                   // 800WA_WEBCONSOLE424
	 //			 (document.forms[0].keepAliveInterval.value >3600))             // 800WA_WEBCONSOLE424
	 if((parseInt(document.forms[0].keepAliveInterval.value,10) < AGENT_NETWORK_KEEPALIVE_MIN_VALUE)   // 800WA_WEBCONSOLE424
	  || (parseInt(document.forms[0].keepAliveInterval.value,10) > AGENT_NETWORK_KEEPALIVE_MAX_VALUE)) // 800WA_WEBCONSOLE424
	 {
		alertNetMsgs(MSG_COMMON_RANGE_CHECK,AGENT_NETWORK_KEEPALIVE_TEXT_NAME,
		AGENT_NETWORK_KEEPALIVE_MIN_VALUE,AGENT_NETWORK_KEEPALIVE_MAX_VALUE);
		if(document.forms[0].keepAliveInterval.disabled == false) {             // 800WA_WEBCONSOLE203
		    document.forms[0].keepAliveInterval.select();
		    document.forms[0].keepAliveInterval.focus();
	    }
		else{                                                                   // 800WA_WEBCONSOLE203
			  //document.forms[0].keepAliveFlag.select();                       // 800WA_WEBCONSOLE368
		      document.forms[0].keepAliveInterval.disabled = false;             // 800WA_WEBCONSOLE368
		      document.forms[0].keepAliveInterval.select();                     // 800WA_WEBCONSOLE368
		      document.forms[0].keepAliveInterval.disabled = true;              // 800WA_WEBCONSOLE368
			  document.forms[0].keepAliveFlag.focus();                          // 800WA_WEBCONSOLE203	
     	}						
		return false;
	 } 	  	

	// Check on numerical value
 
 	if(isNaN(l_objKeepAlive) || isDecimal(l_objKeepAlive) 
 	              || (l_objKeepAlive.indexOf('+') == 0))                        // 800WA_WEBCONSOLE366 //800WA_WEBCONSOLE419
	{
		alertNetMsgs(MSG_COMMON_POSITIVE_INTEGER_CHECK,
			AGENT_NETWORK_KEEPALIVE_TEXT_NAME);
	    if(document.forms[0].keepAliveInterval.disabled == false) {             // 800WA_WEBCONSOLE203
		   document.forms[0].keepAliveInterval.select();
		   document.forms[0].keepAliveInterval.focus();
	    }
		else{                                                                   // 800WA_WEBCONSOLE203
		    //document.forms[0].keepAliveFlag.select();                         // 800WA_WEBCONSOLE368
		    document.forms[0].keepAliveInterval.disabled = false;               // 800WA_WEBCONSOLE368
		    document.forms[0].keepAliveInterval.select();                       // 800WA_WEBCONSOLE368
		    document.forms[0].keepAliveInterval.disabled = true;                // 800WA_WEBCONSOLE368
		    document.forms[0].keepAliveFlag.focus();                            // 800WA_WEBCONSOLE203	
     	}     
		return false;
	}
//	}                                                                           // 800WA_WEBCONSOLE203
    document.forms[0].cmdTimeOut.readOnly = true;                               // 800WA_WEBCONSOLE451
    document.forms[0].keepAliveInterval.readOnly = true;                        // 800WA_WEBCONSOLE451
    document.forms[0].submit.disabled = true;                                   // 800WA_WEBCONSOLE451
     return true;
}

/**
 * When data is changed this is called.
 * @since 08-00
*/
function isNetValueChanged()
{
	parent.main.m_valueChangeFlag = true;
	document.forms[0].hdnKeepAlive.value = 
	                  document.forms[0].keepAliveInterval.value;                // 800WA_WEBCONSOLE203
}

/**
  * This function is used to set the value changed bollean for Command timeout 
  * text field of Network setting screen
  * @since 08-00
  */
function setNetHasChanged()                                                     // 800WA_WEBCONSOLE452
{                                                                               // 800WA_WEBCONSOLE452
    if(document.forms[0].hdnCmdTimeOut.value != 
                                             document.forms[0].cmdTimeOut.value)// 800WA_WEBCONSOLE452
    {                                                                           // 800WA_WEBCONSOLE452
        parent.main.m_valueChangeFlag = true;                                   // 800WA_WEBCONSOLE452
    }                                                                           // 800WA_WEBCONSOLE452
}                                                                               // 800WA_WEBCONSOLE452

/**
 * This method is used for formatting the message and displaying it
 * @param r_key is the Error Message Array index 
 * @param r_arg0 is argument1
 * @param r_arg1 is argument2
 * @param r_arg2 is argument3
 * @since 08-00
 */
function alertNetMsgs(r_key,r_arg0,r_arg1,r_arg2)
{
	l_stMessage = new String(errorMsg[r_key]);
	
	var l_exp0 = /\{0\}/gi;
	var l_exp1 = /\{1\}/gi;
	var l_exp2 = /\{2\}/gi;
	
	
	l_stMessage = l_stMessage.replace(l_exp0, r_arg0);
	l_stMessage = l_stMessage.replace(l_exp1, r_arg1);
	l_stMessage = l_stMessage.replace(l_exp2, r_arg2);
	
	
	alert(r_key + "\n" + l_stMessage);                                          // 800WA_WEBCONSOLE191
}

//////////End of Network Module

//////////Start - These functions are used for Alert Module


// variables used for Agent Usuage Settings
var AlertArray ;
var ApplLog;
var NodeType;                                                                   // 800WA_WEBCONSOLE363
var HOST_LINUX;                                                                 // 800WA_WEBCONSOLE363
var HOST_HPUX;                                                                  // 800WA_WEBCONSOLE363

/*
* This function is called when page is loaded
* @since 08-00
*/

function initialize()
{
	document.forms[0].chk1.focus();
	if(AlertArray[0] == "true" ||AlertArray[0] == true )
	{
    	document.forms[0].chk1.checked = true;		
    }
    if(AlertArray[1] == "true" ||AlertArray[1] == true )
	{
	    document.forms[0].chk2.checked = true;
    }
    if(AlertArray[2] == "true" ||AlertArray[2] == true )
	{
    	document.forms[0].chk3.checked = true;
    }
    if(AlertArray[3] == "true" ||AlertArray[3] == true )
	{
    	document.forms[0].chk4.checked = true;
    }
    if(!(NodeType == HOST_LINUX || NodeType == HOST_HPUX))                      // 800WA_WEBCONSOLE363
    {                                                                           // 800WA_WEBCONSOLE363
    if(ApplLog == "true" || ApplLog == true)
    {
    	document.forms[0].appLogFlag.checked = true;
    }
    }                                                                           // 800WA_WEBCONSOLE363
    else                                                                        // 800WA_WEBCONSOLE363
    {                                                                           // 800WA_WEBCONSOLE363
        document.forms[0].appLogFlag.disabled = true;                           // 800WA_WEBCONSOLE363
    }                                                                           // 800WA_WEBCONSOLE363
    document.forms[0].hdnSaveDay.value = document.forms[0].logFileDays.value;   // 800WA_WEBCONSOLE452
    document.forms[0].hdnWarnThrsh.value = document.forms[0].logFileSize.value; // 800WA_WEBCONSOLE452
}

/**
  * This function is used to set the value changed bollean for the two text 
  * fields of Alert setting screen
  * @since 08-00
  */
function setAltHasChanged()                                                     // 800WA_WEBCONSOLE452
{                                                                               // 800WA_WEBCONSOLE452
    if(document.forms[0].hdnSaveDay.value != document.forms[0].logFileDays.value
    || document.forms[0].hdnWarnThrsh.value != document.forms[0].logFileSize.value)// 800WA_WEBCONSOLE452
    {                                                                           // 800WA_WEBCONSOLE452
        parent.main.m_valueChangeFlag = true;                                   // 800WA_WEBCONSOLE452
    }                                                                           // 800WA_WEBCONSOLE452
}                                                                               // 800WA_WEBCONSOLE452

/*
 * This function is called when the setup button is clicked
 * @return true or false
 * @since 08-00
*/
function ValidateAlertSetting()
{
    if(document.forms[0].submit != null) {                                      // 800WA_WEBCONSOLE451
    if(document.forms[0].submit.disabled == true){                              // 800WA_WEBCONSOLE451
        return false;                                                           // 800WA_WEBCONSOLE451
    }                                                                           // 800WA_WEBCONSOLE451
    }                                                                           // 800WA_WEBCONSOLE451
	var l_ilogFileDays = trim(document.forms[0].logFileDays.value);             // 800WA_WEBCONSOLE213
	var l_ilogFileSize = trim(document.forms[0].logFileSize.value);             // 800WA_WEBCONSOLE213
	
	// Null Check for logFileDays
	if(l_ilogFileDays == '')
		{
			alertMsgs(MSG_KEEPTIME_CHECK ,SAVE_DAYS);
			document.forms[0].logFileDays.value = "";
			document.forms[0].logFileDays.focus();
			return false;
		}
	
	// Numeric Check and Minus Check for logFileDays
	if(isNaN(l_ilogFileDays) || (l_ilogFileDays < 0 ) || 
			isDecimal(l_ilogFileDays) || (l_ilogFileDays.indexOf('-') == 0) 
			|| (l_ilogFileDays.indexOf('+') == 0))    							// 800WA_WEBCONSOLE360 // 800WA_WEBCONSOLE366 //800WA_WEBCONSOLE419
		{
			alertMsgs(MSG_COMMON_ZERO_OR_POSITIVE_INTEGER_CHECK ,SAVE_DAYS);
			document.forms[0].logFileDays.select();
			document.forms[0].logFileDays.focus();
			return false;
		}
	
	// Range Check for logFileDays
	if (!isRange(l_ilogFileDays, document.forms[0].logFileDays.name, SAVE_DAYS,
	              MSG_AGENT_SETTING_RANGE_RETENTION_DAYS_MIN,
	              MSG_AGENT_SETTING_RANGE_RETENTION_DAYS_MAX,
	              MSG_COMMON_RANGE_CHECK)) {
	       return false;
	}
	
	// Null Check for logFileSize
	if(l_ilogFileSize == '')
	{
	 	alertMsgs(MSG_DISKVOL_CHECK ,USED_DISK_CAPACITY); 
		document.forms[0].logFileSize.value = "";
		document.forms[0].logFileSize.focus();
		return false;
	}

	// Numeric Check and Minus Check for logFileSize
	if(isNaN(l_ilogFileSize) || (l_ilogFileSize < 0 ) || 
			   isDecimal(l_ilogFileSize) || (l_ilogFileSize.indexOf('-') == 0) 
			   || (l_ilogFileSize.indexOf('+') == 0))                           // 800WA_WEBCONSOLE360 // 800WA_WEBCONSOLE366 //800WA_WEBCONSOLE419
	{
		alertMsgs(MSG_COMMON_ZERO_OR_POSITIVE_INTEGER_CHECK,USED_DISK_CAPACITY);// 800WA_WEBCONSOLE409
		document.forms[0].logFileSize.select();
		document.forms[0].logFileSize.focus();
		//alertMsgs(MSG_COMMON_ZERO_OR_POSITIVE_INTEGER_CHECK,                  // 800WA_WEBCONSOLE409
		//USED_DISK_CAPACITY);                                                  // 800WA_WEBCONSOLE409
		return false;
	}
	
	// Range Check for logFileSize
	if (!isRange(l_ilogFileSize, document.forms[0].logFileSize.name,
	              USED_DISK_CAPACITY,
	              MSG_AGENT_SETTING_RANGE_DISK_CAPACITY_MIN,
	              MSG_AGENT_SETTING_RANGE_DISK_CAPACITY_MAX,
	              MSG_COMMON_RANGE_CHECK)) {
	       return false;
	}
	
	// Setting the Alert value based upon the checkbox values
	var l_iAlertValue = 0;
	if(document.forms[0].chk1.checked == true)
	{
	    l_iAlertValue = l_iAlertValue + 16;
	}
	if(document.forms[0].chk2.checked == true)
	{
	    l_iAlertValue = l_iAlertValue + 4;
	}
	if(document.forms[0].chk3.checked == true)
	{
	    l_iAlertValue = l_iAlertValue + 2;
	}
	if(document.forms[0].chk4.checked == true)
	{
	    l_iAlertValue = l_iAlertValue + 1;
	}
	document.forms[0].hdnAlertLev.value = l_iAlertValue;
	document.forms[0].hdnNodeId.value = nodeId;
    document.forms[0].logFileDays.readOnly = true;                              // 800WA_WEBCONSOLE451
    document.forms[0].logFileSize.readOnly = true;                              // 800WA_WEBCONSOLE451
    document.forms[0].submit.disabled = true;                                   // 800WA_WEBCONSOLE451
    return true;
}

/*
 * This function displays the validation messages
 * @param r_key is ErrorMessage Array index key
 * @param r_arg0 is argument0
 * @param r_arg1 is argument1
 * @param r_arg2 is argument2
 * @param r_arg3 is argument3
 * @param r_arg4 is argument4
 * @since 08-00
 */
function alertMsgs(r_key,r_arg0,r_arg1,r_arg2,r_arg3,r_arg4)
{
	var l_stMessage = new String(errorMsgArr[r_key]);
	var l_exp0 = /\{0\}/gi;
	var l_exp1 = /\{1\}/gi;
	var l_exp2 = /\{2\}/gi;
	var l_exp3 = /\{3\}/gi;
	var l_exp4 = /\{4\}/gi;
	
	l_stMessage = l_stMessage.replace(l_exp0, r_arg0);
	l_stMessage = l_stMessage.replace(l_exp1, r_arg1);
	l_stMessage = l_stMessage.replace(l_exp2, r_arg2);
	l_stMessage = l_stMessage.replace(l_exp3, r_arg3);
	l_stMessage = l_stMessage.replace(l_exp4, r_arg4);

	alert(r_key + "\n" + l_stMessage);                                          // 800WA_WEBCONSOLE191
}

/**
 * When data is changed this is called.
 * @since 08-00
 */
function isValueChanged()
{
	 parent.main.m_valueChangeFlag = true;
}

////////End of Alert Module

var m_varGlobal ;                                                               // 800WA_WEBCONSOLE371

/**
 * This method gets the object argument and stores in member variable
 * @param r_obj is the component object name
 * @since 08-00
 */
function setObject(r_obj)                                                       // 800WA_WEBCONSOLE371
{                                                                               // 800WA_WEBCONSOLE371
 m_varGlobal = r_obj;                                                           // 800WA_WEBCONSOLE371
}                                                                               // 800WA_WEBCONSOLE371

//////// Start of Manager network setting

/**
 * Check for all validations(Manager Network setting)
 * @return true or false
 * @since 08-00
 */
function validateMngNetForm()
{ 
    if(document.forms[0].submit != null) {                                      // 800WA_WEBCONSOLE451
        if(document.forms[0].submit.disabled == true){                          // 800WA_WEBCONSOLE451
            return false;                                                       // 800WA_WEBCONSOLE451
        }                                                                       // 800WA_WEBCONSOLE451
    }                                                                           // 800WA_WEBCONSOLE451
		parent.cmdTimeOutSetupValue = true;                       			    // 800WA_WEBCONSOLE371
		var l_objManagerTimeOut = trim(document.forms[0].cmdTimeOut.value);     // 800WA_WEBCONSOLE213
		var l_iMinValue = MANAGER_NETWORK_CMDTIMEOUT_MIN_VALUE;
		var l_iMaxValue = MANAGER_NETWORK_CMDTIMEOUT_MAX_VALUE;
		document.forms[0].hdnNodeId.value=nodeId;
		 if(l_objManagerTimeOut.length == 0 || l_objManagerTimeOut == " " ) 
		{
			alertMsgs(MSG_MANAGER_TIMEOUT_CHECK);
			document.forms[0].cmdTimeOut.value = "";
			document.forms[0].cmdTimeOut.focus();
			return false;
		}

	   // Check on numerical value

		else if((document.forms[0].cmdTimeOut.value < 0) )
		{
			alertMsgs(MSG_COMMON_POSITIVE_INTEGER_CHECK,
				MANAGER_NETWORK_CMDTIMEOUT_TEXT_NAME);
			document.forms[0].cmdTimeOut.select();	
			document.forms[0].cmdTimeOut.focus();
			return false;
		 } 	  

	  // Range check

//		else  if((document.forms[0].cmdTimeOut.value < 1) ||                    // 800WA_WEBCONSOLE424
//									(document.forms[0].cmdTimeOut.value >600))  // 800WA_WEBCONSOLE424
		else if((parseInt(document.forms[0].cmdTimeOut.value,10) < l_iMinValue) 
		 || (parseInt(document.forms[0].cmdTimeOut.value,10) > l_iMaxValue))    // 800WA_WEBCONSOLE424
		{
			alertMsgs(MSG_COMMON_RANGE_CHECK,
				MANAGER_NETWORK_CMDTIMEOUT_TEXT_NAME,
				MANAGER_NETWORK_CMDTIMEOUT_MIN_VALUE,
				MANAGER_NETWORK_CMDTIMEOUT_MAX_VALUE);
			document.forms[0].cmdTimeOut.select();
			document.forms[0].cmdTimeOut.focus();
			return false;
		 } 	  	
	
	 // Check on numerical value

		else if(isNaN(l_objManagerTimeOut) || isDecimal(l_objManagerTimeOut) 
		                          || (l_objManagerTimeOut.indexOf('+') == 0))   // 800WA_WEBCONSOLE366 //800WA_WEBCONSOLE419
		{
		   alertMsgs(MSG_COMMON_POSITIVE_INTEGER_CHECK,
		  				MANAGER_NETWORK_CMDTIMEOUT_TEXT_NAME);
	   	   document.forms[0].cmdTimeOut.select();
	   	   document.forms[0].cmdTimeOut.focus();		
		   return false;
		}
		 else 
	{
           parent.cmdTimeOutSetupValue = false;
	}
    document.forms[0].cmdTimeOut.readOnly = true;                               // 800WA_WEBCONSOLE451
	document.forms[0].submit.disabled = true;                                   // 800WA_WEBCONSOLE451
	return true;
}

/**
 * This method is to checked  whether any changes made in Commandtimeout 
 * @since 08-00
 */
function setupFlag()
{
	parent.cmdTimeOutSetupValue=true;

}

/**
 * This method is to check during confirm action
 * @since 08-00
 */
function confirmMngSetupCheck(r_stStyleId)
{
   document.getElementById('page_title').innerHTML = m_headingArray[r_stStyleId];//800WA_WEBCONSOLE454
	activeLink('network',m_managerMenuArray);                                   //800WA_WEBCONSOLE335
	//document.getElementById(r_stStyleId).style.background="gray";             // 800WA_WEBCONSOLE445
	if(parent.cmdTimeOutSetupValue)
	{
		var l_varConfirmDialogProp = new confirmationDialog(                    // 800WA_WEBCONSOLE261
				 					confirmationProperties[0],
				 					confirmationProperties[1],
				 					MSG_COMMON_CONFIRM_CHANGED,
				 					l_arrConfirmMsg[MSG_COMMON_CONFIRM_CHANGED],
				 					confirmationProperties[2],
				 					confirmationProperties[3],
				 					confirmationProperties[4],
				 					confirmationProperties[5]);                 // 800WA_WEBCONSOLE261                          
  	 var confirmMessage = confirmDialog(l_varConfirmDialogProp);                // 800WA_WEBCONSOLE261
		if(confirmMessage)                                                      // 800WA_WEBCONSOLE261 
		{                                                                       // 800WA_WEBCONSOLE261
			parent.cmdTimeOutSetupValue = false;                                // 800WA_WEBCONSOLE261
		}                                                                       // 800WA_WEBCONSOLE261
		else                                                                    // 800WA_WEBCONSOLE371
		{                                                                       // 800WA_WEBCONSOLE371    
		    parent.main.m_varGlobal.focus();                                    // 800WA_WEBCONSOLE371
		}                                                                       // 800WA_WEBCONSOLE371
		return confirmMessage;                                                  // 800WA_WEBCONSOLE261
 	}
}
var m_managerMenuArray = [                                                      // 800WA_WEBCONSOLE335
				 	      "network",                                            // 800WA_WEBCONSOLE335
					      "help"                                                // 800WA_WEBCONSOLE335
				         ];                                                     // 800WA_WEBCONSOLE335

////////End of Manager Network Module


//////// Start of Agent Alert Attribute setting

// Global variables
var m_alertAttributes = new Array();
var m_currentId = null;
var selectedIds = new Array();
var m_arrAlertId = new Array();
var m_isLinux = false;
var m_stFrequency = null;                                                       // 800WA_WEBCONSOLE250
var m_arrInputNames = new Array("RadioNotify", "RadioOperation",
                            "RadioProcess", "RadioFailover", "TextFrequency");
                            
/**
 * This method sets the values into the variables
 * @param r_varRowId The row ID (it is nothing but alert ID)
 * @param r_varAlertId The alert ID
 * @param r_varPart The occurrence part
 * @param r_varAlertLevel The alert level
 * @param r_varContent The description about the alert
 * @param r_varNotify The flag on alert notification
 * @param r_varTimes The count 
 * @param r_varEnableOperation The flag on server operation panel
 * @param r_varOperation Contains the server operaion
 * @param r_varProcess The flag on forced process termination
 * @param r_varEnableFailOver The flag on failover panel
 * @param r_varFailOver The flag on failover
 * @since 08-00
 */
function AlertAttributeDetails(
    r_varRowId, r_varAlertId, r_varPart, r_varAlertLevel, r_varContent,
    r_varNotify, r_varTimes, 
    r_varEnableOperation, r_varOperation, r_varProcess,
    r_varEnableFailOver, r_varFailOver) {

    if (r_varRowId == null || r_varAlertId == null ||
        r_varPart == null || r_varAlertLevel == null ||
        r_varContent == null || r_varNotify == null ||
        r_varTimes == null || r_varEnableOperation == null ||
        r_varOperation == null || r_varProcess == null ||
        r_varEnableFailOver == null || r_varFailOver == null) {
         return;
    }
    
    this.r_varRowId = r_varRowId;
    this.r_varAlertId = r_varAlertId;
    this.r_varPart = r_varPart;
    this.r_varAlertLevel = r_varAlertLevel;
    this.r_varContent = r_varContent;
    
    this.r_varNotify = r_varNotify;
    this.r_varTimes = r_varTimes;

    this.r_varEnableOperation = r_varEnableOperation;
    this.r_varOperation = r_varOperation;
    this.r_varProcess = r_varProcess;
    
    this.r_varEnableFailOver = r_varEnableFailOver;
    this.r_varFailOver = r_varFailOver;
}

/**
 * This method is called when the user select the alert in the list.
 * It controls the radio buttuns' status.
 * @param r_AlertId The alert ID 
 * @since 08-00
 */
function getAlertAttribute(r_AlertId) {
    
    if (r_AlertId == null) {
        return;
    }
    
    if (m_currentId != null) {
        if (!setRetainLocalValues(m_currentId)) {
            setSelected();
            return;
        }
    }
    
    m_currentId = r_AlertId;   
    
    selectedIds[0] = m_currentId;
    
    var l_objAlert = m_alertAttributes[r_AlertId];
    
    // Notification radio button
    // If times is zero, this means "Do not notify"
    selectRadioBox(m_arrInputNames[0], l_objAlert.r_varNotify,
                                  l_objAlert.r_varTimes=="0"?"false":"true");

    // Notification occurrence count's text box
    document.forms[0][m_arrInputNames[4]].value 
                  = l_objAlert.r_varTimes=="0"?"1":l_objAlert.r_varTimes;
    
    // Server Action radio button
    selectRadioBox(m_arrInputNames[1],
              l_objAlert.r_varEnableOperation, l_objAlert.r_varOperation);

    // Process termination radio button    
    if (l_objAlert.r_varOperation == "DoNothing" || m_isLinux) {
        selectRadioBox(m_arrInputNames[2],
                    "false", l_objAlert.r_varProcess);
    }
    else {
        selectRadioBox(m_arrInputNames[2],
                l_objAlert.r_varEnableOperation, l_objAlert.r_varProcess);
    }
    
    // Fail over radio button
    if (m_isLinux) {
        selectRadioBox(m_arrInputNames[3],
                    "false", l_objAlert.r_varFailOver);
    } else {
        selectRadioBox(m_arrInputNames[3],
                    l_objAlert.r_varEnableFailOver, l_objAlert.r_varFailOver);
    }
}

/**
 * This method changes the selection of each radio button and set the status
 * @param r_stRadioBoxName The name of the radio button group
 * @param r_stFlag The flag contains true of false
 * @param r_varValue The value which should be selected
 * @since 08-00
 */
function selectRadioBox(r_stRadioBoxName, r_stFlag, r_varValue) {

    if (r_stRadioBoxName == null || r_stFlag == null || r_varValue == null) {
        return;
    }

    var l_blFlag = r_stFlag == "true"?false:true;
    
    var l_objRadioBox = document.forms[0][r_stRadioBoxName];
    
    for (var l_iIdx = 0; l_iIdx < l_objRadioBox.length; l_iIdx++) {
    
        l_objRadioBox[l_iIdx].disabled = l_blFlag
        
        // If the value and the third parameter matches, it is chekced.
        if (l_objRadioBox[l_iIdx].value == r_varValue) {
            l_objRadioBox[l_iIdx].checked = true;
        }
    }
    
    // Change the text box's status     
    if (r_stRadioBoxName == m_arrInputNames[0]) {
        if (r_varValue == "false") {
            setDisable(m_arrInputNames[4], true);
        }
        else {
            setDisable(m_arrInputNames[4], l_blFlag);
        }
    }
}

/**
 * Stores the data which the user changed
 * @since 08-00
 */
function setRetainLocalValues(r_stPreviousId) {

    if (r_stPreviousId == null) {
        return false;
    }

    var l_arrNames = new Array("r_varNotify", "r_varOperation",
                                 "r_varProcess", "r_varFailOver", "r_varTimes");
    
    var l_objAlert = m_alertAttributes[r_stPreviousId];
    var l_blNotify = true;
    
    // Get the value from the radio buttons
    for (var l_iIdx = 0; l_iIdx < m_arrInputNames.length - 1; l_iIdx++ ) {
      
        var l_objRadioBtn = document.forms[0][m_arrInputNames[l_iIdx]];

        for (var l_iCnt = 0; l_iCnt < l_objRadioBtn.length; l_iCnt++) {
        
            if (l_objRadioBtn[l_iCnt].checked) {
                if (l_objRadioBtn[l_iCnt].name == m_arrInputNames[0]) {
                    if (l_objRadioBtn[l_iCnt].value == "false") {
                        l_blNotify = false;                    
                    }
                }
                else {
                    l_objAlert[l_arrNames[l_iIdx]] 
                                            = l_objRadioBtn[l_iCnt].value;
                }
                break;
            }
        }
    }
    
    if (!validateFrequency()) {
        return false;    
    }
    else {
        if (l_blNotify) {
            l_objAlert.r_varTimes 
                          = trim(document.forms[0][m_arrInputNames[4]].value);  // 800WA_WEBCONSOLE271
        }
        else {
            l_objAlert.r_varTimes = 0;
            l_blNotify = true;
        }
    }
    return true;
}

/**
 * This method sets the changed flag into true.
 * @since 08-00
 */
function setChangeFlag() {
    parent.main.m_valueChangeFlag = true;
}

/**
 * This method is called when the user selects "Do not notify"
 * @since 08-00
 */
function checkFrequency() {
    
    // chech the value
    if (validateFrequency()) {
        setDisable(m_arrInputNames[4], true);
    }
    else {
        // reset the radio button
        document.forms[0][m_arrInputNames[0]][0].checked = true;
    }
}

/**
 * This method validates the frequency
 * @since 08-00
 */
function validateFrequency() {

    // Get the value from the text box and checks if it is valid
    var l_objTimes = document.forms[0][m_arrInputNames[4]];
    var l_iTimes = trim(l_objTimes.value);                                      //800WA_WEBCONSOLE419
    if (trim(l_objTimes.value).length <= 0) {
        alertMsg(MSG_ALERTTRIGER_CHECK);
        l_objTimes.focus();
        l_objTimes.select();                                                    // 800WA_WEBCONSOLE341
        return false;
    }
    //else if (l_objTimes.value <= 0 || isNaN(l_objTimes.value) ||              // 800WA_WEBCONSOLE366 // 800WA_WEBCONSOLE495
    else if (l_objTimes.value < 0 || isNaN(l_objTimes.value) ||                 // 800WA_WEBCONSOLE495
             isDecimal(l_objTimes.value) || (l_iTimes.indexOf('+') == 0)){      // 800WA_WEBCONSOLE366 //800WA_WEBCONSOLE419
        alertMsg(MSG_COMMON_POSITIVE_INTEGER_CHECK, m_stFrequency);             // 800WA_WEBCONSOLE250
        l_objTimes.focus();
        l_objTimes.select();                                                    // 800WA_WEBCONSOLE341
        return false;
    }
    //else if (!isRange(l_objTimes.value, m_arrInputNames[4], m_stFrequency, 1, // 800WA_WEBCONSOLE250 // 800WA_WEBCONSOLE424
    //                   65535, MSG_COMMON_RANGE_CHECK)) {                      // 800WA_WEBCONSOLE424
    else if (!isRange(l_objTimes.value, m_arrInputNames[4], m_stFrequency,      // 800WA_WEBCONSOLE424
    					ALERT_ATTRIBUTE_MIN_NOTIFY_COUNT,                       // 800WA_WEBCONSOLE424
    					ALERT_ATTRIBUTE_MAX_NOTIFY_COUNT,                       // 800WA_WEBCONSOLE424 
    					MSG_COMMON_RANGE_CHECK)) {                              // 800WA_WEBCONSOLE424
        return false;
    }
    
    return true;
}

/**
 * This method disables the radio buttons about process termination
 * @param r_blFlag The flag contains true of false
 * @since 08-00
 */
function setProcessDisable(r_blFlag) {

    if (r_blFlag == null) {
        return;
    }
    
    // If the agent is linux the buttons are always disable
    if (m_isLinux) {
        r_blFlag = true;
    }
    
    var l_objRadioBtn = document.forms[0][m_arrInputNames[2]];
    
    for (var l_iIdx = 0; l_iIdx < l_objRadioBtn.length; l_iIdx++) {
        l_objRadioBtn[l_iIdx].disabled = r_blFlag;
    }
}

/**
 * This method changes the status of the control
 * @param r_stName The name of the control
 * @param r_blFlag The flag contains true of false
 * @since 08-00
 */
function setDisable(r_stName, r_blFlag) {

    if (r_stName == null || r_blFlag == null) {
        return;
    }
    
    if (document.forms[0][r_stName] == null) {
        return;
    } 
    
    document.forms[0][r_stName].disabled = r_blFlag;
}

/**
 * This method is used for initialize controls.
 * @param r_stFucusId The ID of control which should be focused
 * @since 08-00
 */
function setInitialState(r_stFucusId) {

    // Set default focus
    if (r_stFucusId != null) {
        document.getElementById(r_stFucusId).focus();
    }
    
    // disable radio buttons
    for (var l_iIdx = 0; l_iIdx < m_arrInputNames.length - 1; l_iIdx++ ) {
                      
        var l_varRadioBoxObj = document.forms[0][m_arrInputNames[l_iIdx]];
        if(l_varRadioBoxObj != null) {                                          // 800WA_WEBCONSOLE388
             for (var l_iCnt = 0; l_iCnt < l_varRadioBoxObj.length; l_iCnt++) {
                  l_varRadioBoxObj[l_iCnt].disabled = true;
             }
        }                                                                       // 800WA_WEBCONSOLE388
    }
    // disable text box
    setDisable(m_arrInputNames[4], true);
}

/**
 * This method is called when the user clicks the "Set" button.
 * And the form is submitted.
 * @param r_stURL The destination for submitting
 * @since 08-00
 */
function setUpdatedValues(r_stURL, r_stDelimiter) {

    if (r_stURL == null || r_stDelimiter == null) {
        return false;
    }

    if (m_arrAlertId.length <= 0) {
        return false;
    }
    
    if (m_currentId != null) {
        if (!setRetainLocalValues(m_currentId)) {
            return false;
        }
    }
    
    var l_objForm = document.forms[0];
    
    if (l_objForm == null) {
        return false;
    }
    
    var l_objSelect = l_objForm["alertAttribute"].options;
    
    for (var l_iIdx = 0; l_iIdx < m_arrAlertId.length; l_iIdx++) {
        l_objSelect[l_iIdx] = null;
    }
    
    for (var l_iCnt = 0; l_iCnt < m_arrAlertId.length; l_iCnt++) {
        
        var l_objAttribute = m_alertAttributes[m_arrAlertId[l_iCnt]];
        
        var l_OptionValue =
                    l_objAttribute.r_varAlertId + r_stDelimiter + 
                    l_objAttribute.r_varPart + r_stDelimiter +
                    l_objAttribute.r_varAlertLevel + r_stDelimiter + 
                    l_objAttribute.r_varContent + r_stDelimiter + 
                    l_objAttribute.r_varNotify + r_stDelimiter + 
                    l_objAttribute.r_varTimes + r_stDelimiter + 
                    l_objAttribute.r_varEnableOperation + r_stDelimiter + 
                    l_objAttribute.r_varOperation + r_stDelimiter + 
                    l_objAttribute.r_varProcess + r_stDelimiter + 
                    l_objAttribute.r_varEnableFailOver + r_stDelimiter + 
                    l_objAttribute.r_varFailOver;
        
        l_objSelect[l_objSelect.length] 
                                    = new Option(l_OptionValue,l_OptionValue);
        l_objSelect[l_iCnt].selected = true;
    }

    l_objForm["hdnSearchFlag"].value = "false";
    l_objForm["isPagination"].value = "false";
    // set the destination and then submit.
    l_objForm.action = r_stURL;
    l_objForm.TextFrequency.readOnly = true;                                    // 800WA_WEBCONSOLE451
    l_objForm.Set.disabled = true;                                              // 800WA_WEBCONSOLE451
    l_objForm.submit();
}

/**
 * This method checks if the search condition is valid or not.
 * And the form is submitted.
 * @param r_getActionUrl  the URL for get action
 * @param r_paginationUrl the URL for pagination
 * @return true or false
 * @since 08-00
 */
function validateSearchCondition(r_getActionUrl, r_paginationUrl) {

    if (r_getActionUrl == null || r_paginationUrl == null) {
        return false;
    }

    var l_objForm = document.forms[0];

    // When the user attempts to chaneg the page
    if (l_globalFlag == "navigation" || l_globalFlag == "go") {
 
        if (l_globalFlag == "navigation") {

            l_globalFlag = false;
            
            if (!showConfirmation()) {
                l_objForm.action = r_getActionUrl;
                return false;
            }
        } 
        else {
            l_globalFlag = false;
            
            if (!validatePageNumber()) {
                l_objForm.action = r_getActionUrl;
                return false;
            }
            document.getElementById("pageNumber").value 
                                  = document.getElementById("page").value;
        }
        
        l_objForm["hdnSearchFlag"].value = "false";
        l_objForm["isPagination"].value = "true";
        l_objForm.action = r_paginationUrl;
        return true;
    }

    var l_stAlertId = trim(l_objForm["alertID"].value);
    var l_stLevel = trim(l_objForm["alertLevel"].value);
    var l_stContents = trim(l_objForm["alertContent"].value);
 
     // If all the condition is empty the request is sent ot the server
    if (l_stAlertId.length <= 0 && l_stLevel.length <= 0 && 
                                                   l_stContents.length <= 0) {
        // Check if the user has been modified data or not
        if (!showConfirmation()) {
            return false;
        }
        
        setParameterForSearch();                                                // 800WA_WEBCONSOLE311
        return true;
    }
 
    // Check the alert ID
    if (l_stAlertId.length > 0) {
    
        if (l_stAlertId.indexOf("0x") == 0 || l_stAlertId.indexOf("0X") == 0) {
            if (l_stAlertId.length != 6) {
                return showAlertIDError(l_objForm);            
            }
            l_stAlertId = l_stAlertId.substring(2); 
        }
        else {
            if (l_stAlertId.length != 4) {
                return showAlertIDError(l_objForm);
            }
        }
        
        var l_stAlertIDUpperCase = l_stAlertId.toUpperCase();
        var l_stHexSeries = "01234567890ABCDEF";
        var l_blIsValid = true;
        for (var l_iIdx = 0; l_iIdx < 4; l_iIdx++) {
           if (l_stHexSeries.indexOf(
                 new String(l_stAlertIDUpperCase.charAt(l_iIdx))) == -1) {
                 l_blIsValid = false;                                             
                break;
            }
        }

        if (!l_blIsValid) {
            return showAlertIDError(l_objForm);
        }
    }        

      // Check the content
    if (l_stContents.length > 0) {
        if (l_stContents.length > 150) {
            alertMsg(MSG_COMMON_RANGE_CHARACTER_CHECK, "content", 150);
            l_objForm["alertContent"].focus();
            l_objForm["alertContent"].select();                                 // 800WA_WEBCONSOLE341
            return false;
        }
    }
      
    // Check if the user has been modified data or not
    if (!showConfirmation()) {
        return false;
    }
    
    //l_objForm["isPagination"].value = "false";                                // 800WA_WEBCONSOLE311
    setParameterForSearch();                                                    // 800WA_WEBCONSOLE311
    return true;
}

/**
 * This method sets the parameters for search operation
 * @since 08-00
 */
function setParameterForSearch() {                                              // 800WA_WEBCONSOLE311

    var l_objForm = document.forms[0];                                          // 800WA_WEBCONSOLE311
                                                                                
    if ( l_objForm == null) {                                                   // 800WA_WEBCONSOLE311
        return;                                                                 // 800WA_WEBCONSOLE311
    }                                                                           // 800WA_WEBCONSOLE311
    if(l_objForm["pageNumber"] != null) {                                       // 800WA_WEBCONSOLE388
       l_objForm["pageNumber"].value = "0";                                     // 800WA_WEBCONSOLE311
    }                                                                           // 800WA_WEBCONSOLE388
    l_objForm["hdnSearchFlag"].value = "true";                                  // 800WA_WEBCONSOLE311
    l_objForm["isPagination"].value = "false";                                  // 800WA_WEBCONSOLE311
//  l_objForm["order"].value = "";                                              // 800WA_WEBCONSOLE311// 800WA_WEBCONSOLE390
    if(document.forms[0]["order"] != null) {                                    // 800WA_WEBCONSOLE388
        l_objForm["order"].value = "a";                                         // 800WA_WEBCONSOLE390
        l_objForm["currentSortedColumn"].value = "";                            // 800WA_WEBCONSOLE311
    }                                                                           // 800WA_WEBCONSOLE388
    
    l_objForm["hdnAlertID"].value = l_objForm["alertID"].value;                 // 800WA_WEBCONSOLE313
    l_objForm["hdnContent"].value = l_objForm["alertContent"].value;            // 800WA_WEBCONSOLE313
    l_objForm["hdnAlertLevel"].value = l_objForm["alertLevel"].value;           // 800WA_WEBCONSOLE313
    
}                                                                               // 800WA_WEBCONSOLE311


/**
 * This method shows the confirmation dialog when the user has changed the data.
 * @return true when the user selects "OK", false when the user selects "Cancel"
 * @since 08-00
 */
function showConfirmation() {
    var l_objHeader = parent.frames[0];                                         // 800WA_WEBCONSOLE261
    if (l_objHeader == null) {                                                  // 800WA_WEBCONSOLE261
        return false;                                                           // 800WA_WEBCONSOLE261
    }                                                                           // 800WA_WEBCONSOLE261
    
    if(parent.main.m_valueChangeFlag) {                                         // 800WA_WEBCONSOLE261
    
        var l_objConfirmDialogProp = new confirmationDialog(                    // 800WA_WEBCONSOLE261
                     l_objHeader.confirmationProperties[0],
                     l_objHeader.confirmationProperties[1],
                     MSG_COMMON_CONFIRM_CHANGED,
                     l_objHeader.l_arrConfirmMsg[MSG_COMMON_CONFIRM_CHANGED],
                     l_objHeader.confirmationProperties[2],
                     l_objHeader.confirmationProperties[3],
                     l_objHeader.confirmationProperties[4],
                     l_objHeader.confirmationProperties[5]);                    // 800WA_WEBCONSOLE261
        var l_blAnswer = confirmDialog(l_objConfirmDialogProp);                 // 800WA_WEBCONSOLE261

        if (l_blAnswer) {
            parent.main.m_valueChangeFlag = false;
        }
        else {
             if (parent.main.m_varGlobal != null) {                             // 800WA_WEBCONSOLE479 
                parent.main.m_varGlobal.focus();                                // 800WA_WEBCONSOLE479 
            }                                                                   // 800WA_WEBCONSOLE479 
            return false;
        }
    }
    return true;
}

/**
 * This method is show alert ID error
 * @param r_ObjForm The form to be validated
 * @since 08-00
 */
function showAlertIDError(r_ObjForm) {

    if (r_ObjForm == null) {
        return false;
    }
    
//    alertMsg(MSG_COMMON_FORMAT_CHECK);                                        // 800WA_WEBCONSOLE372
      alert(trim(MSG_COMMON_FORMAT_CHECK) + "\n"                                // 800WA_WEBCONSOLE372 
                        + trim(errorMsgArr[MSG_COMMON_FORMAT_CHECK]));          // 800WA_WEBCONSOLE372
    r_ObjForm['alertID'].focus();
    r_ObjForm['alertID'].select();                                              // 800WA_WEBCONSOLE341
    return false;
}

/**
 * This method disables enter key
 * @return true or false
 * @since 08-00
 */
function disableEnter()  {

    if (event.keyCode == 13) { 
        return false;
    }
    return true;
}

/**
 * This method is called when the user attempts to change the page number
 * @return true or false
 * @since 08-00
 */
 function validatePageNumber() {
 
    var l_objPage = document.getElementById("page");
    var l_stCurrentPage = trim(l_objPage.value);
    var l_stTotalPage = document.getElementById("totalpage").value;
 
    // When there is no data
     if (l_stTotalPage == "0") {
         l_stTotalPage = "1" ;
         document.getElementById("totalpage").value = "1";
     }
 
    // blank check
    if (l_stCurrentPage.length <= 0) {
        alertMsg(MSG_PAGE_CHECK);
        l_objPage.focus();
        l_objPage.select();                                                     // 800WA_WEBCONSOLE341
        return false;
    }
     
     // Positvive integer check
    //if (isNaN(l_stCurrentPage) || parseInt(l_stCurrentPage,10) <= 0 ||        // 800WA_WEBCONSOLE366 // 800WA_WEBCONSOLE422 // 800WA_WEBCONSOLE466
    if (isNaN(l_stCurrentPage) || parseInt(l_stCurrentPage,10) < 0 ||           // 800WA_WEBCONSOLE466
        isDecimal(l_stCurrentPage) || (l_stCurrentPage.indexOf('+') == 0)) {    // 800WA_WEBCONSOLE366 //800WA_WEBCONSOLE419
        alertMsg(MSG_COMMON_POSITIVE_INTEGER_CHECK, "current page");
        l_objPage.focus();
        l_objPage.select();                                                     // 800WA_WEBCONSOLE341
        return false;
    }
     
    // Range check
    if (!isRange(l_stCurrentPage, "page", "current page", 1,
                              l_stTotalPage, MSG_COMMON_RANGE_CHECK)) {         // 800WA_WEBCONSOLE422
        return false;
    }

    // Check if the user has been modified data or not
    if (!showConfirmation()) {
        return false;
    }
    return true;
}

/**
 * This method to maintain the check box selection after sorting
 * @since 08-00
 */
function setSelected() {
   setChecked('radio');
}                                                                      
////////End of Agent Alert Attribute setting

