/*
 * Copyright : All Rights Reserved. Copyright (C) 2006, Hitachi, Ltd.
 * Title     : ServerConductor WebConsole
 * Version   : 08-00
 * Name      : header.js
 * Date      : 2006/04/12
 */

/**
 * This javascript contains methods for operations in the header of all screens, with respect to menus and child windows.
 * @version 08-00
 * @since 08-00
 * @author Kavitha KJ
 */
/*
var m_objIdPrev = "";                                                                                  // 800WA_WEBCONSOLE091   
var m_objElmPrev = null;                                                                               // 800WA_WEBCONSOLE091
*/
/**
 * The block of specified ID is opened and shut, and the background color of the anchor which is clicked changed. 
 * @param r_objId ID of opening and shutting block
 * @since 08-00
 *//*
function fnOpen(r_objId) {                                                                             // 800WA_WEBCONSOLE091
	
	
	if (r_objId != null && r_objId.length != 0) {                                                      // 800WA_WEBCONSOLE091
	
		if (document.all.item(r_objId).style.display == "block") {                                     // 800WA_WEBCONSOLE091
			
			//If the block is open, it is closed.                                                      // 800WA_WEBCONSOLE091 
			document.all.item(r_objId).style.display = "none";                                         // 800WA_WEBCONSOLE091
			
		} else {                                                                                       // 800WA_WEBCONSOLE091
						
			//If the block is closed, it is opened.                                                    // 800WA_WEBCONSOLE091
			document.all.item(r_objId).style.display = "block";                                        // 800WA_WEBCONSOLE091  
		}                                                                                              // 800WA_WEBCONSOLE091  
	}                                                                                                  // 800WA_WEBCONSOLE091 
	
	if (r_objId != m_objIdPrev) {                                                                      // 800WA_WEBCONSOLE091
		//When the current menu clicked is not equal to previous menu, then the previous menu is closed.
        //When the current menu is not alert log and the previous menu is alert log
		if(r_objId != "dropAlertLog" && m_objIdPrev == "dropAlertLog") {                               // 800WA_WEBCONSOLE091
			fnClose("dropAlertLog");                                                                   // 800WA_WEBCONSOLE091
			fnClose("dropHostMgmt");                                                                   // 800WA_WEBCONSOLE091
		}                                                                                              // 800WA_WEBCONSOLE091
       //When the current menu is alert log 
		if(r_objId != "dropAlertLog") {                                                                // 800WA_WEBCONSOLE091  
			fnClose(m_objIdPrev);                                                                      // 800WA_WEBCONSOLE091 
		}                                                                                              // 800WA_WEBCONSOLE091
	}                                                                                                  // 800WA_WEBCONSOLE091 
	
	//The background color is changed. 
	if( m_objElmPrev != null ){                                                                        // 800WA_WEBCONSOLE091   
	//background of unclicked menu item is set to white                                                // 800WA_WEBCONSOLE091 
		m_objElmPrev.style.backgroundColor = "white";                                                  // 800WA_WEBCONSOLE091
	}                                                                                                  // 800WA_WEBCONSOLE091  
	//clicked menu item color
	window.event.srcElement.style.backgroundColor = "gray";                                            // 800WA_WEBCONSOLE091

	//ID and the element are saved. 
	m_objIdPrev = r_objId;                                                                             // 800WA_WEBCONSOLE091 
	m_objElmPrev = window.event.srcElement;	                                                           // 800WA_WEBCONSOLE091
}
*/
/**
 * This method is used to close the menu.
 * @param r_objId ID of closing block
 * @since 08-00
 *//*
function fnClose(r_objId){                                                                             // 800WA_WEBCONSOLE091                                                            
	
	if(r_objId==null)                                                           // 800WA_WEBCONSOLE029 // 800WA_WEBCONSOLE091
	{                                                                           // 800WA_WEBCONSOLE029 // 800WA_WEBCONSOLE091
	     return;                                                                // 800WA_WEBCONSOLE029 // 800WA_WEBCONSOLE091
	}                                                                           // 800WA_WEBCONSOLE029 // 800WA_WEBCONSOLE091 
	
	if( r_objId.length != 0 ){                                                                         // 800WA_WEBCONSOLE091    
		//If ID is specified, the corresponding block is closed.                                       // 800WA_WEBCONSOLE091 
		document.all.item(r_objId).style.display = "none";                                             // 800WA_WEBCONSOLE091 
	    }                                                                                              // 800WA_WEBCONSOLE091 
	}                                                                                                  // 800WA_WEBCONSOLE091 
*/

/** 
 * Array table that stroes the html ids
 * 
 * [ clicked link/div , div to be operated, selected link]
 * 
 */
/* main menu */                                                                                        // 800WA_WEBCONSOLE091                                                 
var m_arrMenuTable = [                                                                                 
    ["dropHostMgmt", "dropHostMgmtSub", "dropHostMgmtlink"],                                           
    ["dropAlert", "dropAlertSub", "dropAlertlink"],                                                    
    ["dropHostOp", "dropHostOpSub", "dropHostOplink"],                                                 
    ["dropGroup", "dropGroupSub", "dropGrouplink"],                                                    
    ["dropConMgmt", "dropConMgmtSub", "dropConMgmtlink"],                                              
    ["dropSet", "dropSetSub", "dropSetlink"],                                                          
	["dropView", "dropViewSub", "dropViewlink"],                                                       
	["dropHelp", "dropHelpSub", "dropHelplink"]                                                        
];                                                                                                     // 800WA_WEBCONSOLE091 
/* sub menu */                                                                                         // 800WA_WEBCONSOLE091  
var m_arrSubMenuTable = [                                                                              
    ["dropHostMgmtSub", "dropAlertLogSubSub", "dropAlertLogSublink"]                                   
	  ];                                                                                               // 800WA_WEBCONSOLE091 


/**
 * This method should be called when the menu is clicked (or mouse over etc)
 * to change the menu.
 * @param r_menuId the id that is clicked
 * @param r_blSubFlag if it is true, this means sub menu is selected
 * @since 08-00
 */
function fnOpen(r_menuId, r_blSubFlag) {                                                               // 800WA_WEBCONSOLE091           

    // Check the input parameters
    if(r_menuId == null) {                                                                             // 800WA_WEBCONSOLE091
        return ;                                                                                       // 800WA_WEBCONSOLE091 
    }                                                                                                  // 800WA_WEBCONSOLE091 
    if(r_blSubFlag == null) {                                                                          // 800WA_WEBCONSOLE091 
        r_blSubFlag = false ;                                                                          // 800WA_WEBCONSOLE091
    }                                                                                                  // 800WA_WEBCONSOLE091 

    // variable to store table
    var l_arrTable = null;                                                                             // 800WA_WEBCONSOLE091 


    // Check flag
    if(r_blSubFlag) {                                                                                  // 800WA_WEBCONSOLE091 
             
        l_arrTable = m_arrSubMenuTable;                                                                // 800WA_WEBCONSOLE091  

    }                                                                                                  // 800WA_WEBCONSOLE091    
    else {                                                                                             // 800WA_WEBCONSOLE091
        
        l_arrTable = m_arrMenuTable;                                                                   // 800WA_WEBCONSOLE091

        // when the parent menu is operated, sub menu should be closed
        clearSubMenu();                                                                                // 800WA_WEBCONSOLE091  
    }                                                                                                  // 800WA_WEBCONSOLE091
	document.getElementById("logout").style.backgroundColor = '#ffffff' ;                              // 800WA_WEBCONSOLE148
    for(var l_iIdx = 0; l_iIdx < l_arrTable.length; l_iIdx++) {                                        // 800WA_WEBCONSOLE091

        var l_objSubMenu = document.getElementById(l_arrTable[l_iIdx][1]) ;                            // 800WA_WEBCONSOLE091 
        var l_objLink    = document.getElementById(l_arrTable[l_iIdx][2]) ;                            // 800WA_WEBCONSOLE091
    
       if(r_menuId == l_arrTable[l_iIdx][0]) {                                                         // 800WA_WEBCONSOLE091 
            
            // the selected menu 
            // l_objLink.style.backgroundColor =  "gray";                                              // 800WA_WEBCONSOLE091  // 800WA_WEBCONSOLE445

            if(l_objSubMenu.style.display == "block") {                                                // 800WA_WEBCONSOLE091 
                
                // open -> close 
                l_objSubMenu.style.display = "none";                                                   // 800WA_WEBCONSOLE091
                l_objLink.style.backgroundColor = "white";                      // 800WA_WEBCONSOLE445
                
            }                                                                                          // 800WA_WEBCONSOLE091
            else {                                                                                     // 800WA_WEBCONSOLE091 

                // close -> open
                l_objSubMenu.style.display = "block";                                                  // 800WA_WEBCONSOLE091
                l_objLink.style.backgroundColor = "gray";                       // 800WA_WEBCONSOLE445
            }                                                                                          // 800WA_WEBCONSOLE091  

        }
        else {                                                                                         // 800WA_WEBCONSOLE091 

            //all the  non selected menus should be closed
            l_objLink.style.backgroundColor = "white";                                                 // 800WA_WEBCONSOLE091
            l_objSubMenu.style.display = "none";                                                       // 800WA_WEBCONSOLE091 
        }                                                                                              // 800WA_WEBCONSOLE091
    }                                                                                                  // 800WA_WEBCONSOLE091 
}                                                                                                      // 800WA_WEBCONSOLE091

/**
 * This method clears all the menus
 * @since 08-00
 */
function clearMenu() {                                                          // 800WA_WEBCONSOLE445
    clearSubMenu();                                                             // 800WA_WEBCONSOLE445
    for(var l_iIdx = 0; l_iIdx < m_arrMenuTable.length; l_iIdx++) {             // 800WA_WEBCONSOLE445
        var l_objMenu                                                           // 800WA_WEBCONSOLE445
			   = document.getElementById(m_arrMenuTable[l_iIdx][1]) ;           // 800WA_WEBCONSOLE445
        var l_objLink                                                           // 800WA_WEBCONSOLE445
			   = document.getElementById(m_arrMenuTable[l_iIdx][2]) ;           // 800WA_WEBCONSOLE445
		if (l_objMenu != null && l_objLink != null) {                           // 800WA_WEBCONSOLE445
            l_objMenu.style.display = "none";                                   // 800WA_WEBCONSOLE445
            if (l_objLink.style.backgroundColor == "gray") {                    // 800WA_WEBCONSOLE445
                l_objLink.focus();                                              // 800WA_WEBCONSOLE445
            }                                                                   // 800WA_WEBCONSOLE445
            l_objLink.style.backgroundColor = "white";                          // 800WA_WEBCONSOLE445
		}	                                                                    // 800WA_WEBCONSOLE445
    }                                                                           // 800WA_WEBCONSOLE445
}                                                                               // 800WA_WEBCONSOLE445

/**
 * This method clears all the sub menus
 * @since 08-00
 */
function clearSubMenu() {                                                                              // 800WA_WEBCONSOLE091 

    for(var l_iIdx = 0; l_iIdx < m_arrSubMenuTable.length; l_iIdx++) {                                 // 800WA_WEBCONSOLE091
        
        var l_objSubMenu                                                                               // 800WA_WEBCONSOLE091 
			   = document.getElementById(m_arrSubMenuTable[l_iIdx][1]) ;                               // 800WA_WEBCONSOLE091
        var l_objLink                                                                                  // 800WA_WEBCONSOLE091
			   = document.getElementById(m_arrSubMenuTable[l_iIdx][2]) ;                               // 800WA_WEBCONSOLE091
        if (l_objSubMenu!=null && l_objLink!=null) {                            // 800WA_WEBCONSOLE445
        l_objSubMenu.style.display = "none";                                                           // 800WA_WEBCONSOLE091 
        l_objLink.style.backgroundColor = "white";                                                     // 800WA_WEBCONSOLE091
        }                                                                       // 800WA_WEBCONSOLE445
    }                                                                                                  // 800WA_WEBCONSOLE091 
}                                                                                                      // 800WA_WEBCONSOLE091 
/**
 * This method opens the help file.
 * @param r_stHelpActionURL The URL of action to open help.jsp.
 * @param r_stHelpHtmlURL The URL of help file acquired from property file.
 * @param r_stParamKey The parameter key that is used by help.jsp
 * @return The result of the check
 * @since 08-00
 */ 
function openHelp(r_stHelpActionURL,r_stHelpHtmlURL,r_stParamKey,r_stId)
{
    clearMenu();                                                                // 800WA_WEBCONSOLE445
	// var l_stWindowName="help";                                                                      // 800WA_WEBCONSOLE158
	var l_stWindowName=r_stId;                                                                         // 800WA_WEBCONSOLE158
 // var l_stURL = r_stHelpActionURL + "?" + r_stParamKey + "=" + r_stHelpHtmlURL; // 800WA_WEBCONSOLE429
	var l_stURL = r_stHelpActionURL + "?" + r_stParamKey + "=" 					// 800WA_WEBCONSOLE429
						+ escape(r_stHelpHtmlURL);                               // 800WA_WEBCONSOLE429
	window.open(l_stURL,l_stWindowName,"menubar=no,toolbar=no,scrollbars=yes,status=no,location=no,width=800px,height=600px,resizable=yes");
}


/**
 * This method is used for the check image switch over in view menu.
 * @param viewID The Id for different views
 * @since 08-00
 */
function changeCheckImage(viewID) {
	
   if(viewID==null)                                                             // 800WA_WEBCONSOLE029
    {                                                                           // 800WA_WEBCONSOLE029  
        return;                                                                 // 800WA_WEBCONSOLE029
    }                                                                           // 800WA_WEBCONSOLE029 

	setDefault();
	
	if(viewID=="site") {
		document.images["site"].src    = IMG_CHECK_GIF;
        document.forms[0]["selectedView"].value = "site";                       // 800WA_WEBCONSOLE449
	} else if(viewID=="domain") {
		document.images["domain"].src  = IMG_CHECK_GIF;
        document.forms[0]["selectedView"].value = "domain";                     // 800WA_WEBCONSOLE449
	} else if(viewID=="service") {
		document.images["service"].src = IMG_CHECK_GIF;
		document.forms[0]["selectedView"].value = "service";                    // 800WA_WEBCONSOLE449
	} 
	clearMenu();                                                                // 800WA_WEBCONSOLE445
}

function setDefault()
{
	    // parent.hostDetail.location = "jsp/default.html";                     // 800WA_WEBCONSOLE186                      
		document.images["site"].src    = IMG_UNCHECK_GIF;
		document.images["domain"].src  = IMG_UNCHECK_GIF;
		document.images["service"].src = IMG_UNCHECK_GIF;
}


/**
 * This method closes the menu when clicked outside the link. 
 * @param evt the event for the click
 * @since 08-00
 */

function bodyclick(evt)                                                         // 800WA_WEBCONSOLE183                                  
{	                                                                            // 800WA_WEBCONSOLE183
var targ;                                                                       // 800WA_WEBCONSOLE183
if (!evt) var evt = window.event;                                               // 800WA_WEBCONSOLE183 
if (evt.target) targ = evt.target;                                              // 800WA_WEBCONSOLE183
else if (evt.srcElement) targ = evt.srcElement;                                 // 800WA_WEBCONSOLE183 
var tname;                                                                      // 800WA_WEBCONSOLE183
tname=targ.tagName;                                                             // 800WA_WEBCONSOLE183
	// if(tname == "A") {                                                       // 800WA_WEBCONSOLE183 // 800WA_WEBCONSOLE200
	// if(tname == "A" || tname == "IMG") {                                     // 800WA_WEBCONSOLE200 // 800WA_WEBCONSOLE445
	if(tname == "A" || tname == "IMG" ||                                        // 800WA_WEBCONSOLE445
      (tname == "DIV" && evt.srcElement.className == "item_sub")) {             // 800WA_WEBCONSOLE445
         return;                                                                // 800WA_WEBCONSOLE183
	}                                                                           // 800WA_WEBCONSOLE183
	else{                                                                       // 800WA_WEBCONSOLE183
     clearMenu();                                                               // 800WA_WEBCONSOLE445
     document.body.focus();                                                     // 800WA_WEBCONSOLE445
     clearSubMenu();                                                            // 800WA_WEBCONSOLE183  
     l_arrTable = m_arrMenuTable;                                               // 800WA_WEBCONSOLE183 
     for(var l_iIdx = 0; l_iIdx < l_arrTable.length; l_iIdx++)                  // 800WA_WEBCONSOLE183 
      {                                                                         // 800WA_WEBCONSOLE183
           var l_objSubMenu = document.getElementById(l_arrTable[l_iIdx][1]) ;  // 800WA_WEBCONSOLE183
           var l_objLink    = document.getElementById(l_arrTable[l_iIdx][2]) ;  // 800WA_WEBCONSOLE183
            if(l_objSubMenu.style.display == "block")                           // 800WA_WEBCONSOLE183
                 {                                                              // 800WA_WEBCONSOLE183
                        l_objSubMenu.style.display = "none";                    // 800WA_WEBCONSOLE183  
                        l_objLink.style.backgroundColor = "white";              // 800WA_WEBCONSOLE183
	             }                                                              // 800WA_WEBCONSOLE183   
     }                                                                          // 800WA_WEBCONSOLE183
   }
   releaseSelection();                                                          // 800WA_WEBCONSOLE445 
}                                                                               // 800WA_WEBCONSOLE183 
